# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['redis_benchmarks_specification',
 'redis_benchmarks_specification.__api__',
 'redis_benchmarks_specification.__builder__',
 'redis_benchmarks_specification.__cli__',
 'redis_benchmarks_specification.__common__',
 'redis_benchmarks_specification.__self_contained_coordinator__',
 'redis_benchmarks_specification.__setups__']

package_data = \
{'': ['*'],
 'redis_benchmarks_specification': ['setups/builders/*',
                                    'setups/platforms/*',
                                    'setups/topologies/*',
                                    'test-suites/*']}

install_requires = \
['Flask-HTTPAuth>=4.4.0,<5.0.0',
 'Flask>=2.0.1,<3.0.0',
 'GitPython>=3.1.20,<4.0.0',
 'PyGithub>=1.55,<2.0',
 'PyYAML>=5.4.1,<6.0.0',
 'Werkzeug>=2.0.1,<3.0.0',
 'argparse>=1.4.0,<2.0.0',
 'docker>=4.4.4,<5.0.0',
 'flask-restx>=0.5.0,<0.6.0',
 'marshmallow>=3.12.2,<4.0.0',
 'psutil>=5.8.0,<6.0.0',
 'redis>=3.5.3,<4.0.0',
 'redisbench-admin>=0.4.16,<0.5.0',
 'tox-docker>=3.0.0,<4.0.0']

entry_points = \
{'console_scripts': ['redis-benchmarks-spec-api = '
                     'redis_benchmarks_specification.__api__.api:main',
                     'redis-benchmarks-spec-builder = '
                     'redis_benchmarks_specification.__builder__.builder:main',
                     'redis-benchmarks-spec-cli = '
                     'redis_benchmarks_specification.__cli__.cli:main',
                     'redis-benchmarks-spec-sc-coordinator = '
                     'redis_benchmarks_specification.__self_contained_coordinator__.self_contained_coordinator:main']}

setup_kwargs = {
    'name': 'redis-benchmarks-specification',
    'version': '0.1.9',
    'description': 'The Redis benchmarks specification describes the cross-language/tools requirements and expectations to foster performance and observability standards around redis related technologies. Members from both industry and academia, including organizations and individuals are encouraged to contribute.',
    'long_description': "\n[![codecov](https://codecov.io/gh/filipecosta90/redis-benchmarks-specification/branch/main/graph/badge.svg?token=GS64MV1H4W)](https://codecov.io/gh/filipecosta90/redis-benchmarks-specification)\n[![CI tests](https://github.com/filipecosta90/redis-benchmarks-specification/actions/workflows/tox.yml/badge.svg)](https://github.com/filipecosta90/redis-benchmarks-specification/actions/workflows/tox.yml)\n[![PyPI version](https://badge.fury.io/py/redis-benchmarks-specification.svg)](https://badge.fury.io/py/redis-benchmarks-specification)\n## Benchmark specifications goal\n\nThe Redis benchmarks specification describes the cross-language/tools requirements and expectations to foster performance and observability standards around redis related technologies. \n\nMembers from both industry and academia, including organizations and individuals are encouraged to contribute. \n\nCurrently, the following members actively support this project:\n\n- [Redis Ltd.](https://redis.com/): providing steady-stable infrastructure platform to run the benchmark suite. Supporting the active development of this project within the company.\n\n\n## Scope \n\nThis repo aims to provide Redis related benchmark standards and methodologies for:\n\n- Management of benchmark data and specifications across different setups\n\n- Running benchmarks and recording results\n\n- Exporting performance results in several formats (CSV, RedisTimeSeries, JSON)\n\n- **[SOON]** Finding on-cpu, off-cpu, io, and threading performance problems by attaching profiling tools/probers ( perf (a.k.a. perf_events), bpf tooling, vtune )\n\n- **[SOON]** Finding performance problems by attaching telemetry probes\n\nCurrent supported benchmark tools:\n\n- [redis-benchmark](https://github.com/redis/redis)\n- [SOON][memtier_benchmark](https://github.com/RedisLabs/memtier_benchmark)\n- [SOON][redis-benchmark-go](https://github.com/filipecosta90/redis-benchmark-go)\n\n## Architecture diagram\n\n```                                                                                    \n                                                                                      \n                                                                                      \n┌──────────────────────────────────────┐                                              \n│1) gh.com/redis/redis update          │                                              \n│   - git_repo: github.com/redis/redis │                                              \n│   - git_hash: 459c3a                 │                                              \n│   - git_branch: unstable             │                                              \n└─────────────────┬────────────────────┘                                              \n                  │                                                                   \n                  │      ┌───────────────────────────────────┐                        \n                  │      │HTTP POST                          │                        \n                  └──────┤<domain>/api/gh/redis/redis/commit │──┐                     \n                         └───────────────────────────────────┘  │                     \n                                                                │                     \n                                                                ▼                     \n                                          ┌──────────────────────────────────────────┐\n                                          │2) api                                    │\n                                          │  - Converts the HTTP info into an stream │\n                                          │entry                                     │\n                                          │  - XADD stream:redis:redis:commit <...>  │\n                                          │                                          │\n                                          └─────────────────────┬────────────────────┘\n                                                                │                     \n                                                                │                     \n                                                                │                     \n                                                                │ ┌────┐              \n                    .─────────────────────────────────────.     │ │push│              \n        ┌─────┐ ┌ ▶(  2.1 ) stream of build events         )◀───┘ └────┘              \n        │pull │     `─────────────────────────────────────'                           \n        └─────┘ │                                                                     \n                                                                                      \n                │                       ┌────────────────────────────────────────────┐\n                 ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─│2.2) build_agent                            │\n                                        │   - based on setup platforms               │\n                                        │   - build different required redis         │\n                                        │artifacts                                   │\n                                        └───────────────────────┬────────────────────┘\n                                                                │                     \n                                                                │                     \n                                                                │ ┌────┐              \n                   .─────────────────────────────────────.      │ │push│              \n        ┌─────┐ ─▶(   2.3 ) stream of artifact benchmarks )◀────┘ └────┘              \n        │pull ││   `─────────────────────────────────────'                            \n        └─────┘                                                                       \n               │                                                                      \n                                        ┌────────────────────────────────────────────┐\n               │                        │                                            │\n                                        │3) benchmark_coordinator                    │\n               │                        │   - based on test-suites and setups:       │\n                                        │      - Trigger env setup                   │\n               └ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─│      - 3.1 ) Trigger topology setup        │\n                                        │      - 3.2 ) Run benchmarks                │\n                                        │      - Record results into datasinks       │\n                                        │                                            │\n                                        └────────────────────────────────────────────┘\n```                                              \n\nIn a very brief description, github.com/redis/redis upstream changes trigger an HTTP API call containing the\nrelevant git information. \n\nThe HTTP request is then converted into an event ( tracked within redis ) that will trigger multiple build variants requests based upon the distinct platforms described in [`platforms`](redis_benchmarks_specification/setups/platforms/). \n\nAs soon as a new build variant request is received, the build agent ([`redis-benchmarks-spec-builder`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__builder__/)) prepares the artifact(s) and proceeds into adding an artifact benchmark event so that the benchmark coordinator ([`redis-benchmarks-spec-sc-coordinator`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__self_contained_coordinator__/))  can deploy/manage the required infrastructure and DB topologies, run the benchmark, and export the performance results.\n## Directory layout\n\n### Specifications \n\n  The following is a high level status report for currently available specs.\n\n* `redis_benchmarks_specification`\n  * [`test-suites`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/test-suites/): contains the benchmark suites definitions, specifying the target redis topology, the tested commands, the benchmark utility to use (the client), and if required the preloading dataset steps.\n  \n* `redis_benchmarks_specification/setups`\n  * [`platforms`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/setups/platforms/): contains the standard platforms considered to provide steady stable results, and to represent common deployment targets.\n  * [`topologies`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/setups/topologies/): contains the standard deployment topologies definition with the associated minimum specs to enable the topology definition.\n  * [`builders`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/setups/builders/): contains the build environment variations, that enable to build Redis with different compilers, compiler flags, libraries, etc...\n\n### Spec tool implementations\n\n  The following is a high level status report for currently available spec implementations.\n\n* **STATUS: Experimental** [`redis-benchmarks-spec-api`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__api__/) : contains the API that translates the POST HTTP request that was triggered by github.com/redis/redis upstream changes, and fetches the relevant git/source info and coverts it into an event ( tracked within redis ).\n\n* **STATUS: Experimental** [`redis-benchmarks-spec-builder`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__builder__/): contains the benchmark build agent utility that receives an event indicating a new build variant, generates the required redis binaries to test, and triggers the benchmark run on the listening agents.\n* **STATUS: Experimental** [`redis-benchmarks-spec-sc-coordinator`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__self_contained_coordinator__/): contains the coordinator utility that listens for benchmark suite run requests and setups the required steps to spin the actual benchmark topologies and to trigger the actual benchmarks.\n\n\n## Contributing guidelines\n\n### Adding new test suites\n\nTBD\n\n### Adding new topologies\n\nTBD\n\n### Adding new test platforms\n\nTBD\n\n## License\n\nredis-benchmark-specifications is distributed under the Apache 2 license - see [LICENSE](LICENSE)",
    'author': 'filipecosta90',
    'author_email': 'filipecosta.90@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
