"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDomain = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-04-07T10:31:22.255Z","fingerprint":"sLiTMtDznqHUN3Oi+etRH0sSJDeeVBFJXUbxkvKUsfI="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnDomainProps`
 *
 * @param properties - the TypeScript properties of a `CfnDomainProps`
 *
 * @returns the result of the validation.
 */
function CfnDomainPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessPolicies', cdk.validateObject)(properties.accessPolicies));
    errors.collect(cdk.propertyValidator('advancedOptions', cdk.hashValidator(cdk.validateString))(properties.advancedOptions));
    errors.collect(cdk.propertyValidator('advancedSecurityOptions', CfnDomain_AdvancedSecurityOptionsInputPropertyValidator)(properties.advancedSecurityOptions));
    errors.collect(cdk.propertyValidator('cognitoOptions', CfnDomain_CognitoOptionsPropertyValidator)(properties.cognitoOptions));
    errors.collect(cdk.propertyValidator('domainEndpointOptions', CfnDomain_DomainEndpointOptionsPropertyValidator)(properties.domainEndpointOptions));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('ebsOptions', CfnDomain_EBSOptionsPropertyValidator)(properties.ebsOptions));
    errors.collect(cdk.propertyValidator('elasticsearchClusterConfig', CfnDomain_ElasticsearchClusterConfigPropertyValidator)(properties.elasticsearchClusterConfig));
    errors.collect(cdk.propertyValidator('elasticsearchVersion', cdk.validateString)(properties.elasticsearchVersion));
    errors.collect(cdk.propertyValidator('encryptionAtRestOptions', CfnDomain_EncryptionAtRestOptionsPropertyValidator)(properties.encryptionAtRestOptions));
    errors.collect(cdk.propertyValidator('logPublishingOptions', cdk.hashValidator(CfnDomain_LogPublishingOptionPropertyValidator))(properties.logPublishingOptions));
    errors.collect(cdk.propertyValidator('nodeToNodeEncryptionOptions', CfnDomain_NodeToNodeEncryptionOptionsPropertyValidator)(properties.nodeToNodeEncryptionOptions));
    errors.collect(cdk.propertyValidator('snapshotOptions', CfnDomain_SnapshotOptionsPropertyValidator)(properties.snapshotOptions));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcOptions', CfnDomain_VPCOptionsPropertyValidator)(properties.vpcOptions));
    return errors.wrap('supplied properties not correct for "CfnDomainProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain` resource
 *
 * @param properties - the TypeScript properties of a `CfnDomainProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain` resource.
 */
// @ts-ignore TS6133
function cfnDomainPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomainPropsValidator(properties).assertSuccess();
    return {
        AccessPolicies: cdk.objectToCloudFormation(properties.accessPolicies),
        AdvancedOptions: cdk.hashMapper(cdk.stringToCloudFormation)(properties.advancedOptions),
        AdvancedSecurityOptions: cfnDomainAdvancedSecurityOptionsInputPropertyToCloudFormation(properties.advancedSecurityOptions),
        CognitoOptions: cfnDomainCognitoOptionsPropertyToCloudFormation(properties.cognitoOptions),
        DomainEndpointOptions: cfnDomainDomainEndpointOptionsPropertyToCloudFormation(properties.domainEndpointOptions),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        EBSOptions: cfnDomainEBSOptionsPropertyToCloudFormation(properties.ebsOptions),
        ElasticsearchClusterConfig: cfnDomainElasticsearchClusterConfigPropertyToCloudFormation(properties.elasticsearchClusterConfig),
        ElasticsearchVersion: cdk.stringToCloudFormation(properties.elasticsearchVersion),
        EncryptionAtRestOptions: cfnDomainEncryptionAtRestOptionsPropertyToCloudFormation(properties.encryptionAtRestOptions),
        LogPublishingOptions: cdk.hashMapper(cfnDomainLogPublishingOptionPropertyToCloudFormation)(properties.logPublishingOptions),
        NodeToNodeEncryptionOptions: cfnDomainNodeToNodeEncryptionOptionsPropertyToCloudFormation(properties.nodeToNodeEncryptionOptions),
        SnapshotOptions: cfnDomainSnapshotOptionsPropertyToCloudFormation(properties.snapshotOptions),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VPCOptions: cfnDomainVPCOptionsPropertyToCloudFormation(properties.vpcOptions),
    };
}
// @ts-ignore TS6133
function CfnDomainPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessPolicies', 'AccessPolicies', properties.AccessPolicies != null ? cfn_parse.FromCloudFormation.getAny(properties.AccessPolicies) : undefined);
    ret.addPropertyResult('advancedOptions', 'AdvancedOptions', properties.AdvancedOptions != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.AdvancedOptions) : undefined);
    ret.addPropertyResult('advancedSecurityOptions', 'AdvancedSecurityOptions', properties.AdvancedSecurityOptions != null ? CfnDomainAdvancedSecurityOptionsInputPropertyFromCloudFormation(properties.AdvancedSecurityOptions) : undefined);
    ret.addPropertyResult('cognitoOptions', 'CognitoOptions', properties.CognitoOptions != null ? CfnDomainCognitoOptionsPropertyFromCloudFormation(properties.CognitoOptions) : undefined);
    ret.addPropertyResult('domainEndpointOptions', 'DomainEndpointOptions', properties.DomainEndpointOptions != null ? CfnDomainDomainEndpointOptionsPropertyFromCloudFormation(properties.DomainEndpointOptions) : undefined);
    ret.addPropertyResult('domainName', 'DomainName', properties.DomainName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainName) : undefined);
    ret.addPropertyResult('ebsOptions', 'EBSOptions', properties.EBSOptions != null ? CfnDomainEBSOptionsPropertyFromCloudFormation(properties.EBSOptions) : undefined);
    ret.addPropertyResult('elasticsearchClusterConfig', 'ElasticsearchClusterConfig', properties.ElasticsearchClusterConfig != null ? CfnDomainElasticsearchClusterConfigPropertyFromCloudFormation(properties.ElasticsearchClusterConfig) : undefined);
    ret.addPropertyResult('elasticsearchVersion', 'ElasticsearchVersion', properties.ElasticsearchVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ElasticsearchVersion) : undefined);
    ret.addPropertyResult('encryptionAtRestOptions', 'EncryptionAtRestOptions', properties.EncryptionAtRestOptions != null ? CfnDomainEncryptionAtRestOptionsPropertyFromCloudFormation(properties.EncryptionAtRestOptions) : undefined);
    ret.addPropertyResult('logPublishingOptions', 'LogPublishingOptions', properties.LogPublishingOptions != null ? cfn_parse.FromCloudFormation.getMap(CfnDomainLogPublishingOptionPropertyFromCloudFormation)(properties.LogPublishingOptions) : undefined);
    ret.addPropertyResult('nodeToNodeEncryptionOptions', 'NodeToNodeEncryptionOptions', properties.NodeToNodeEncryptionOptions != null ? CfnDomainNodeToNodeEncryptionOptionsPropertyFromCloudFormation(properties.NodeToNodeEncryptionOptions) : undefined);
    ret.addPropertyResult('snapshotOptions', 'SnapshotOptions', properties.SnapshotOptions != null ? CfnDomainSnapshotOptionsPropertyFromCloudFormation(properties.SnapshotOptions) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcOptions', 'VPCOptions', properties.VPCOptions != null ? CfnDomainVPCOptionsPropertyFromCloudFormation(properties.VPCOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`
 *
 * The AWS::Elasticsearch::Domain resource creates an Amazon OpenSearch Service (successor to Amazon Elasticsearch Service) domain.
 *
 * > The `AWS::Elasticsearch::Domain` resource is being replaced by the [AWS::OpenSearchService::Domain](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html) resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and legacy Elasticsearch. For instructions to upgrade domains defined within CloudFormation from Elasticsearch to OpenSearch, see [Remarks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--remarks) .
 *
 * @cloudformationResource AWS::Elasticsearch::Domain
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 */
class CfnDomain extends cdk.CfnResource {
    /**
     * Create a new `AWS::Elasticsearch::Domain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDomain.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings._aws_cdk_aws_elasticsearch_CfnDomainProps(props);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrDomainEndpoint = cdk.Token.asString(this.getAtt('DomainEndpoint'));
        this.accessPolicies = props.accessPolicies;
        this.advancedOptions = props.advancedOptions;
        this.advancedSecurityOptions = props.advancedSecurityOptions;
        this.cognitoOptions = props.cognitoOptions;
        this.domainEndpointOptions = props.domainEndpointOptions;
        this.domainName = props.domainName;
        this.ebsOptions = props.ebsOptions;
        this.elasticsearchClusterConfig = props.elasticsearchClusterConfig;
        this.elasticsearchVersion = props.elasticsearchVersion;
        this.encryptionAtRestOptions = props.encryptionAtRestOptions;
        this.logPublishingOptions = props.logPublishingOptions;
        this.nodeToNodeEncryptionOptions = props.nodeToNodeEncryptionOptions;
        this.snapshotOptions = props.snapshotOptions;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Elasticsearch::Domain", props.tags, { tagPropertyName: 'tags' });
        this.vpcOptions = props.vpcOptions;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::Elasticsearch::Domain\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDomainPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDomain(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDomain.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            accessPolicies: this.accessPolicies,
            advancedOptions: this.advancedOptions,
            advancedSecurityOptions: this.advancedSecurityOptions,
            cognitoOptions: this.cognitoOptions,
            domainEndpointOptions: this.domainEndpointOptions,
            domainName: this.domainName,
            ebsOptions: this.ebsOptions,
            elasticsearchClusterConfig: this.elasticsearchClusterConfig,
            elasticsearchVersion: this.elasticsearchVersion,
            encryptionAtRestOptions: this.encryptionAtRestOptions,
            logPublishingOptions: this.logPublishingOptions,
            nodeToNodeEncryptionOptions: this.nodeToNodeEncryptionOptions,
            snapshotOptions: this.snapshotOptions,
            tags: this.tags.renderTags(),
            vpcOptions: this.vpcOptions,
        };
    }
    renderProperties(props) {
        return cfnDomainPropsToCloudFormation(props);
    }
}
exports.CfnDomain = CfnDomain;
_a = JSII_RTTI_SYMBOL_1;
CfnDomain[_a] = { fqn: "@aws-cdk/aws-elasticsearch.CfnDomain", version: "1.152.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDomain.CFN_RESOURCE_TYPE_NAME = "AWS::Elasticsearch::Domain";
/**
 * Determine whether the given properties match those of a `AdvancedSecurityOptionsInputProperty`
 *
 * @param properties - the TypeScript properties of a `AdvancedSecurityOptionsInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_AdvancedSecurityOptionsInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('internalUserDatabaseEnabled', cdk.validateBoolean)(properties.internalUserDatabaseEnabled));
    errors.collect(cdk.propertyValidator('masterUserOptions', CfnDomain_MasterUserOptionsPropertyValidator)(properties.masterUserOptions));
    return errors.wrap('supplied properties not correct for "AdvancedSecurityOptionsInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.AdvancedSecurityOptionsInput` resource
 *
 * @param properties - the TypeScript properties of a `AdvancedSecurityOptionsInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.AdvancedSecurityOptionsInput` resource.
 */
// @ts-ignore TS6133
function cfnDomainAdvancedSecurityOptionsInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_AdvancedSecurityOptionsInputPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        InternalUserDatabaseEnabled: cdk.booleanToCloudFormation(properties.internalUserDatabaseEnabled),
        MasterUserOptions: cfnDomainMasterUserOptionsPropertyToCloudFormation(properties.masterUserOptions),
    };
}
// @ts-ignore TS6133
function CfnDomainAdvancedSecurityOptionsInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('internalUserDatabaseEnabled', 'InternalUserDatabaseEnabled', properties.InternalUserDatabaseEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.InternalUserDatabaseEnabled) : undefined);
    ret.addPropertyResult('masterUserOptions', 'MasterUserOptions', properties.MasterUserOptions != null ? CfnDomainMasterUserOptionsPropertyFromCloudFormation(properties.MasterUserOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CognitoOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `CognitoOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_CognitoOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.validateString)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CognitoOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.CognitoOptions` resource
 *
 * @param properties - the TypeScript properties of a `CognitoOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.CognitoOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainCognitoOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_CognitoOptionsPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        IdentityPoolId: cdk.stringToCloudFormation(properties.identityPoolId),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
    };
}
// @ts-ignore TS6133
function CfnDomainCognitoOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('identityPoolId', 'IdentityPoolId', properties.IdentityPoolId != null ? cfn_parse.FromCloudFormation.getString(properties.IdentityPoolId) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined);
    ret.addPropertyResult('userPoolId', 'UserPoolId', properties.UserPoolId != null ? cfn_parse.FromCloudFormation.getString(properties.UserPoolId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColdStorageOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ColdStorageOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_ColdStorageOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "ColdStorageOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.ColdStorageOptions` resource
 *
 * @param properties - the TypeScript properties of a `ColdStorageOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.ColdStorageOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainColdStorageOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_ColdStorageOptionsPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnDomainColdStorageOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DomainEndpointOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DomainEndpointOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_DomainEndpointOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customEndpoint', cdk.validateString)(properties.customEndpoint));
    errors.collect(cdk.propertyValidator('customEndpointCertificateArn', cdk.validateString)(properties.customEndpointCertificateArn));
    errors.collect(cdk.propertyValidator('customEndpointEnabled', cdk.validateBoolean)(properties.customEndpointEnabled));
    errors.collect(cdk.propertyValidator('enforceHttps', cdk.validateBoolean)(properties.enforceHttps));
    errors.collect(cdk.propertyValidator('tlsSecurityPolicy', cdk.validateString)(properties.tlsSecurityPolicy));
    return errors.wrap('supplied properties not correct for "DomainEndpointOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.DomainEndpointOptions` resource
 *
 * @param properties - the TypeScript properties of a `DomainEndpointOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.DomainEndpointOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainDomainEndpointOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_DomainEndpointOptionsPropertyValidator(properties).assertSuccess();
    return {
        CustomEndpoint: cdk.stringToCloudFormation(properties.customEndpoint),
        CustomEndpointCertificateArn: cdk.stringToCloudFormation(properties.customEndpointCertificateArn),
        CustomEndpointEnabled: cdk.booleanToCloudFormation(properties.customEndpointEnabled),
        EnforceHTTPS: cdk.booleanToCloudFormation(properties.enforceHttps),
        TLSSecurityPolicy: cdk.stringToCloudFormation(properties.tlsSecurityPolicy),
    };
}
// @ts-ignore TS6133
function CfnDomainDomainEndpointOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customEndpoint', 'CustomEndpoint', properties.CustomEndpoint != null ? cfn_parse.FromCloudFormation.getString(properties.CustomEndpoint) : undefined);
    ret.addPropertyResult('customEndpointCertificateArn', 'CustomEndpointCertificateArn', properties.CustomEndpointCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.CustomEndpointCertificateArn) : undefined);
    ret.addPropertyResult('customEndpointEnabled', 'CustomEndpointEnabled', properties.CustomEndpointEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CustomEndpointEnabled) : undefined);
    ret.addPropertyResult('enforceHttps', 'EnforceHTTPS', properties.EnforceHTTPS != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnforceHTTPS) : undefined);
    ret.addPropertyResult('tlsSecurityPolicy', 'TLSSecurityPolicy', properties.TLSSecurityPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.TLSSecurityPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EBSOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `EBSOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_EBSOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('ebsEnabled', cdk.validateBoolean)(properties.ebsEnabled));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('volumeSize', cdk.validateNumber)(properties.volumeSize));
    errors.collect(cdk.propertyValidator('volumeType', cdk.validateString)(properties.volumeType));
    return errors.wrap('supplied properties not correct for "EBSOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.EBSOptions` resource
 *
 * @param properties - the TypeScript properties of a `EBSOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.EBSOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainEBSOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_EBSOptionsPropertyValidator(properties).assertSuccess();
    return {
        EBSEnabled: cdk.booleanToCloudFormation(properties.ebsEnabled),
        Iops: cdk.numberToCloudFormation(properties.iops),
        VolumeSize: cdk.numberToCloudFormation(properties.volumeSize),
        VolumeType: cdk.stringToCloudFormation(properties.volumeType),
    };
}
// @ts-ignore TS6133
function CfnDomainEBSOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('ebsEnabled', 'EBSEnabled', properties.EBSEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EBSEnabled) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('volumeSize', 'VolumeSize', properties.VolumeSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.VolumeSize) : undefined);
    ret.addPropertyResult('volumeType', 'VolumeType', properties.VolumeType != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ElasticsearchClusterConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ElasticsearchClusterConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_ElasticsearchClusterConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('coldStorageOptions', CfnDomain_ColdStorageOptionsPropertyValidator)(properties.coldStorageOptions));
    errors.collect(cdk.propertyValidator('dedicatedMasterCount', cdk.validateNumber)(properties.dedicatedMasterCount));
    errors.collect(cdk.propertyValidator('dedicatedMasterEnabled', cdk.validateBoolean)(properties.dedicatedMasterEnabled));
    errors.collect(cdk.propertyValidator('dedicatedMasterType', cdk.validateString)(properties.dedicatedMasterType));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('warmCount', cdk.validateNumber)(properties.warmCount));
    errors.collect(cdk.propertyValidator('warmEnabled', cdk.validateBoolean)(properties.warmEnabled));
    errors.collect(cdk.propertyValidator('warmType', cdk.validateString)(properties.warmType));
    errors.collect(cdk.propertyValidator('zoneAwarenessConfig', CfnDomain_ZoneAwarenessConfigPropertyValidator)(properties.zoneAwarenessConfig));
    errors.collect(cdk.propertyValidator('zoneAwarenessEnabled', cdk.validateBoolean)(properties.zoneAwarenessEnabled));
    return errors.wrap('supplied properties not correct for "ElasticsearchClusterConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig` resource
 *
 * @param properties - the TypeScript properties of a `ElasticsearchClusterConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig` resource.
 */
// @ts-ignore TS6133
function cfnDomainElasticsearchClusterConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_ElasticsearchClusterConfigPropertyValidator(properties).assertSuccess();
    return {
        ColdStorageOptions: cfnDomainColdStorageOptionsPropertyToCloudFormation(properties.coldStorageOptions),
        DedicatedMasterCount: cdk.numberToCloudFormation(properties.dedicatedMasterCount),
        DedicatedMasterEnabled: cdk.booleanToCloudFormation(properties.dedicatedMasterEnabled),
        DedicatedMasterType: cdk.stringToCloudFormation(properties.dedicatedMasterType),
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        WarmCount: cdk.numberToCloudFormation(properties.warmCount),
        WarmEnabled: cdk.booleanToCloudFormation(properties.warmEnabled),
        WarmType: cdk.stringToCloudFormation(properties.warmType),
        ZoneAwarenessConfig: cfnDomainZoneAwarenessConfigPropertyToCloudFormation(properties.zoneAwarenessConfig),
        ZoneAwarenessEnabled: cdk.booleanToCloudFormation(properties.zoneAwarenessEnabled),
    };
}
// @ts-ignore TS6133
function CfnDomainElasticsearchClusterConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('coldStorageOptions', 'ColdStorageOptions', properties.ColdStorageOptions != null ? CfnDomainColdStorageOptionsPropertyFromCloudFormation(properties.ColdStorageOptions) : undefined);
    ret.addPropertyResult('dedicatedMasterCount', 'DedicatedMasterCount', properties.DedicatedMasterCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.DedicatedMasterCount) : undefined);
    ret.addPropertyResult('dedicatedMasterEnabled', 'DedicatedMasterEnabled', properties.DedicatedMasterEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DedicatedMasterEnabled) : undefined);
    ret.addPropertyResult('dedicatedMasterType', 'DedicatedMasterType', properties.DedicatedMasterType != null ? cfn_parse.FromCloudFormation.getString(properties.DedicatedMasterType) : undefined);
    ret.addPropertyResult('instanceCount', 'InstanceCount', properties.InstanceCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount) : undefined);
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('warmCount', 'WarmCount', properties.WarmCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.WarmCount) : undefined);
    ret.addPropertyResult('warmEnabled', 'WarmEnabled', properties.WarmEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.WarmEnabled) : undefined);
    ret.addPropertyResult('warmType', 'WarmType', properties.WarmType != null ? cfn_parse.FromCloudFormation.getString(properties.WarmType) : undefined);
    ret.addPropertyResult('zoneAwarenessConfig', 'ZoneAwarenessConfig', properties.ZoneAwarenessConfig != null ? CfnDomainZoneAwarenessConfigPropertyFromCloudFormation(properties.ZoneAwarenessConfig) : undefined);
    ret.addPropertyResult('zoneAwarenessEnabled', 'ZoneAwarenessEnabled', properties.ZoneAwarenessEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ZoneAwarenessEnabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EncryptionAtRestOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `EncryptionAtRestOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_EncryptionAtRestOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    return errors.wrap('supplied properties not correct for "EncryptionAtRestOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.EncryptionAtRestOptions` resource
 *
 * @param properties - the TypeScript properties of a `EncryptionAtRestOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.EncryptionAtRestOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainEncryptionAtRestOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_EncryptionAtRestOptionsPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
    };
}
// @ts-ignore TS6133
function CfnDomainEncryptionAtRestOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LogPublishingOptionProperty`
 *
 * @param properties - the TypeScript properties of a `LogPublishingOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_LogPublishingOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.validateString)(properties.cloudWatchLogsLogGroupArn));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "LogPublishingOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.LogPublishingOption` resource
 *
 * @param properties - the TypeScript properties of a `LogPublishingOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.LogPublishingOption` resource.
 */
// @ts-ignore TS6133
function cfnDomainLogPublishingOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_LogPublishingOptionPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLogsLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogsLogGroupArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnDomainLogPublishingOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchLogsLogGroupArn', 'CloudWatchLogsLogGroupArn', properties.CloudWatchLogsLogGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsLogGroupArn) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MasterUserOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MasterUserOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_MasterUserOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('masterUserArn', cdk.validateString)(properties.masterUserArn));
    errors.collect(cdk.propertyValidator('masterUserName', cdk.validateString)(properties.masterUserName));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    return errors.wrap('supplied properties not correct for "MasterUserOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.MasterUserOptions` resource
 *
 * @param properties - the TypeScript properties of a `MasterUserOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.MasterUserOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainMasterUserOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_MasterUserOptionsPropertyValidator(properties).assertSuccess();
    return {
        MasterUserARN: cdk.stringToCloudFormation(properties.masterUserArn),
        MasterUserName: cdk.stringToCloudFormation(properties.masterUserName),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
    };
}
// @ts-ignore TS6133
function CfnDomainMasterUserOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('masterUserArn', 'MasterUserARN', properties.MasterUserARN != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserARN) : undefined);
    ret.addPropertyResult('masterUserName', 'MasterUserName', properties.MasterUserName != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserName) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NodeToNodeEncryptionOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `NodeToNodeEncryptionOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_NodeToNodeEncryptionOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "NodeToNodeEncryptionOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions` resource
 *
 * @param properties - the TypeScript properties of a `NodeToNodeEncryptionOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainNodeToNodeEncryptionOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_NodeToNodeEncryptionOptionsPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnDomainNodeToNodeEncryptionOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SnapshotOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `SnapshotOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_SnapshotOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('automatedSnapshotStartHour', cdk.validateNumber)(properties.automatedSnapshotStartHour));
    return errors.wrap('supplied properties not correct for "SnapshotOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.SnapshotOptions` resource
 *
 * @param properties - the TypeScript properties of a `SnapshotOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.SnapshotOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainSnapshotOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_SnapshotOptionsPropertyValidator(properties).assertSuccess();
    return {
        AutomatedSnapshotStartHour: cdk.numberToCloudFormation(properties.automatedSnapshotStartHour),
    };
}
// @ts-ignore TS6133
function CfnDomainSnapshotOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('automatedSnapshotStartHour', 'AutomatedSnapshotStartHour', properties.AutomatedSnapshotStartHour != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomatedSnapshotStartHour) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VPCOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `VPCOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_VPCOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    return errors.wrap('supplied properties not correct for "VPCOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.VPCOptions` resource
 *
 * @param properties - the TypeScript properties of a `VPCOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.VPCOptions` resource.
 */
// @ts-ignore TS6133
function cfnDomainVPCOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_VPCOptionsPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
    };
}
// @ts-ignore TS6133
function CfnDomainVPCOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addPropertyResult('subnetIds', 'SubnetIds', properties.SubnetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ZoneAwarenessConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ZoneAwarenessConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_ZoneAwarenessConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('availabilityZoneCount', cdk.validateNumber)(properties.availabilityZoneCount));
    return errors.wrap('supplied properties not correct for "ZoneAwarenessConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.ZoneAwarenessConfig` resource
 *
 * @param properties - the TypeScript properties of a `ZoneAwarenessConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Elasticsearch::Domain.ZoneAwarenessConfig` resource.
 */
// @ts-ignore TS6133
function cfnDomainZoneAwarenessConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_ZoneAwarenessConfigPropertyValidator(properties).assertSuccess();
    return {
        AvailabilityZoneCount: cdk.numberToCloudFormation(properties.availabilityZoneCount),
    };
}
// @ts-ignore TS6133
function CfnDomainZoneAwarenessConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('availabilityZoneCount', 'AvailabilityZoneCount', properties.AvailabilityZoneCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.AvailabilityZoneCount) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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