"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PdkPipelinePyProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
const python_1 = require("projen/lib/python");
/**
 * Synthesizes a Python Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-py
 */
class PdkPipelinePyProject extends awscdk_1.AwsCdkPythonApp {
    constructor(options) {
        super({
            github: false,
            sample: false,
            pytest: false,
            ...options,
        });
        new projen_1.SampleDir(this, this.moduleName, {
            sourceDir: path.join(__dirname, "..", "..", "..", "samples", "sample-pdk-pipeline-py", "infra"),
        });
        this.pytest = new python_1.Pytest(this, options.pytestOptions);
        new projen_1.SampleDir(this, this.testdir, {
            sourceDir: path.join(__dirname, "..", "..", "..", "samples", "sample-pdk-pipeline-py", "tests"),
        });
    }
}
exports.PdkPipelinePyProject = PdkPipelinePyProject;
_a = JSII_RTTI_SYMBOL_1;
PdkPipelinePyProject[_a] = { fqn: "aws-prototyping-sdk.pdk_projen.PdkPipelinePyProject", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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