from typing import Any, Dict

import httpx

from ...client import Client
from ...models.global_user_update_json_body import GlobalUserUpdateJsonBody
from ...types import Response


def _get_kwargs(
    *,
    client: Client,
    email: str,
    json_body: GlobalUserUpdateJsonBody,
) -> Dict[str, Any]:
    url = "{}/users/update/{email}".format(client.base_url, email=email)

    headers: Dict[str, Any] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    json_json_body = json_body.to_dict()

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "json": json_json_body,
    }


def _build_response(*, response: httpx.Response) -> Response[None]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=None,
    )


def sync_detailed(
    *,
    client: Client,
    email: str,
    json_body: GlobalUserUpdateJsonBody,
) -> Response[None]:
    kwargs = _get_kwargs(
        client=client,
        email=email,
        json_body=json_body,
    )

    response = httpx.post(
        **kwargs,
    )

    return _build_response(response=response)


async def asyncio_detailed(
    *,
    client: Client,
    email: str,
    json_body: GlobalUserUpdateJsonBody,
) -> Response[None]:
    kwargs = _get_kwargs(
        client=client,
        email=email,
        json_body=json_body,
    )

    async with httpx.AsyncClient() as _client:
        response = await _client.post(**kwargs)

    return _build_response(response=response)
