/**
 * Convert option.
 *
 * So far only the format type
 *
 * @stability stable
 */
export interface ConvertOptions {
    /**
     * @stability stable
     */
    readonly formatType: FormatType;
}
/**
 * Format type to convert the ALPS spec into.
 *
 * @stability stable
 */
export declare enum FormatType {
    /**
     * @stability stable
     */
    S = 0,
    /**
     * @stability stable
     */
    SDL = 1,
    /**
     * @stability stable
     */
    A = 2,
    /**
     * @stability stable
     */
    ASYNC = 3,
    /**
     * @stability stable
     */
    ASYNCAPI = 4,
    /**
     * @stability stable
     */
    O = 5,
    /**
     * @stability stable
     */
    OAS = 6,
    /**
     * @stability stable
     */
    OPEN = 7,
    /**
     * @stability stable
     */
    OPENAPI = 8,
    /**
     * @stability stable
     */
    OPENAPI_JSON = 9,
    /**
     * @stability stable
     */
    P = 10,
    /**
     * @stability stable
     */
    PROTO = 11,
    /**
     * @stability stable
     */
    J = 12,
    /**
     * @stability stable
     */
    JSON = 13,
    /**
     * @stability stable
     */
    W = 14,
    /**
     * @stability stable
     */
    WSDL = 15,
    /**
     * @stability stable
     */
    SOAP = 16
}
/**
 * @stability stable
 */
export declare class Alps {
    /**
     * Converts an ALPS spec JSON object into a specified API like openApi or graph ql schema.
     *
     * @param alpsDocument The ALPS document.
     * @param options Options for the convertion.
     * @returns the requested api as a string
     * @stability stable
     */
    static unified(alpsDocument: any, options?: ConvertOptions): string;
    /**
     * loads the ALPS document.
     *
     * @param path ALPS spec file path.
     * @stability stable
     */
    static loadYaml(path: string): any;
    /**
     * @stability stable
     */
    static spec(spec: AlpsSpec): AlpsSpec;
}
/**
 * @stability stable
 */
export interface AlpsSpec {
    /**
     * Indicates the root of the ALPS document.
     *
     * This property is REQUIRED, and it SHOULD have one or more 'descriptor' child properties.
     *
     * @stability stable
     */
    readonly alps: AlpsDef;
}
/**
 * @stability stable
 */
export interface AlpsDef {
    /**
     * can be any string e.g.: 1.0.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * @stability stable
     */
    readonly doc: DocDef;
    /**
     * @stability stable
     */
    readonly ext: ExtDef[];
    /**
     * @stability stable
     */
    readonly descriptor: DescriptorDef[];
}
/**
 * A text field that contains free-form, usually human-readable, text.
 *
 * The 'doc' element MAY have two properties: 'href' and 'format'.  If
 * the 'href' property appears it SHOULD contain a dereferencable URL
 * that points to human-readable text.  If the 'format' property appears
 * it SHOULD contain one of the following values: 'text', 'html',
 * 'asciidoc', or 'markdown'.  Any program processing 'doc' elements
 * SHOULD honor the 'format' directive and parse/render the content
 * appropriately.  If the value in the 'format' property is not
 * recognized and/or supported, the processing program MUST treat the
 * content as plain text.  If no 'format' property is present, the
 * content SHOULD be treated as plain text.
 * JSON:  { "doc" : { "format" : "text" , "value" : "Date of Birth ...""} }
 *
 * A 'doc' element SHOULD appear as a child of 'descriptor'.  When
 * present, it describes the meaning and use of the related 'descriptor'.
 * JSON:  { "descriptor" : [ { "doc" : { "value" : "..." } ...  ] }
 *
 * The 'doc' element MAY appear as a child of 'alps'.  When present, it
 * describes the purpose of the ALPS document as a whole.
 * JSON:  { "alps : { "doc" : { "value" : "..." } } ... }
 *
 * @stability stable
 */
export interface DocDef {
    /**
     * @stability stable
     */
    readonly href?: string;
    /**
     * @stability stable
     */
    readonly format?: string;
    /**
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ExtDef {
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly value: string;
    /**
     * @stability stable
     */
    readonly tags: string;
    /**
     * @stability stable
     */
    readonly href?: string;
    /**
     * @stability stable
     */
    readonly id?: string;
}
/**
 * @stability stable
 */
export interface DescriptorDef {
    /**
     * @stability stable
     */
    readonly id: string;
    /**
     * @stability stable
     */
    readonly doc?: DocDef;
    /**
     * @stability stable
     */
    readonly type: string;
    /**
     * @stability stable
     */
    readonly rt?: string;
    /**
     * @stability stable
     */
    readonly text: string;
    /**
     * @stability stable
     */
    readonly tags?: string;
    /**
     * @stability stable
     */
    readonly descriptor?: DescriptorDef[];
    /**
     * @stability stable
     */
    readonly href?: string;
}
