/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.h2.api.TimestampWithTimeZone;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.JSR310;
import org.h2.util.JSR310Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class ValueTimestampTimeZone
extends Value {
    public static final int DEFAULT_PRECISION = 32;
    public static final int MAXIMUM_PRECISION = 35;
    private final long dateValue;
    private final long timeNanos;
    private final int timeZoneOffsetSeconds;

    private ValueTimestampTimeZone(long l, long l2, int n) {
        if (l < -511999999967L || l > 512000000415L) {
            throw new IllegalArgumentException("dateValue out of range " + l);
        }
        if (l2 < 0L || l2 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l2);
        }
        if (n < -64800 || n > 64800) {
            throw new IllegalArgumentException("timeZoneOffsetSeconds out of range " + n);
        }
        this.dateValue = l;
        this.timeNanos = l2;
        this.timeZoneOffsetSeconds = n;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long l, long l2, int n) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(l, l2, n));
    }

    public static ValueTimestampTimeZone get(TimestampWithTimeZone timestampWithTimeZone) {
        return ValueTimestampTimeZone.fromDateValueAndNanos(timestampWithTimeZone.getYMD(), timestampWithTimeZone.getNanosSinceMidnight(), timestampWithTimeZone.getTimeZoneOffsetSeconds());
    }

    public static ValueTimestampTimeZone parse(String string) {
        try {
            return (ValueTimestampTimeZone)DateTimeUtils.parseTimestamp(string, null, true);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP WITH TIME ZONE", string);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public int getTimeZoneOffsetSeconds() {
        return this.timeZoneOffsetSeconds;
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) {
        Timestamp timestamp = new Timestamp(DateTimeUtils.absoluteDayFromDateValue(this.dateValue) * 86400000L + this.timeNanos / 1000000L - (long)(this.timeZoneOffsetSeconds * 1000));
        timestamp.setNanos((int)(this.timeNanos % 1000000000L));
        return timestamp;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIMESTAMP_TZ;
    }

    @Override
    public int getValueType() {
        return 24;
    }

    @Override
    public int getMemory() {
        return 40;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(35);
        DateTimeUtils.appendTimestampTimeZone(stringBuilder, this.dateValue, this.timeNanos, this.timeZoneOffsetSeconds);
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("TIMESTAMP WITH TIME ZONE '");
        DateTimeUtils.appendTimestampTimeZone(stringBuilder, this.dateValue, this.timeNanos, this.timeZoneOffsetSeconds);
        return stringBuilder.append('\'');
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.timeNanos;
        long l2 = this.dateValue;
        long l3 = DateTimeUtils.convertScale(l, n, l2 == 512000000415L ? 86400000000000L : Long.MAX_VALUE);
        if (l3 == l) {
            return this;
        }
        if (l3 >= 86400000000000L) {
            l3 -= 86400000000000L;
            l2 = DateTimeUtils.incrementDateValue(l2);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l3, this.timeZoneOffsetSeconds);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
        long l = this.dateValue;
        long l2 = this.timeNanos - (long)this.timeZoneOffsetSeconds * 1000000000L;
        if (l2 < 0L) {
            l2 += 86400000000000L;
            l = DateTimeUtils.decrementDateValue(l);
        } else if (l2 >= 86400000000000L) {
            l2 -= 86400000000000L;
            l = DateTimeUtils.incrementDateValue(l);
        }
        long l3 = valueTimestampTimeZone.dateValue;
        long l4 = valueTimestampTimeZone.timeNanos - (long)valueTimestampTimeZone.timeZoneOffsetSeconds * 1000000000L;
        if (l4 < 0L) {
            l4 += 86400000000000L;
            l3 = DateTimeUtils.decrementDateValue(l3);
        } else if (l4 >= 86400000000000L) {
            l4 -= 86400000000000L;
            l3 = DateTimeUtils.incrementDateValue(l3);
        }
        int n = Long.compare(l, l3);
        if (n != 0) {
            return n;
        }
        return Long.compare(l2, l4);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)object;
        return this.dateValue == valueTimestampTimeZone.dateValue && this.timeNanos == valueTimestampTimeZone.timeNanos && this.timeZoneOffsetSeconds == valueTimestampTimeZone.timeZoneOffsetSeconds;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetSeconds);
    }

    @Override
    public Object getObject() {
        if (SysProperties.RETURN_OFFSET_DATE_TIME && JSR310.PRESENT) {
            return JSR310Utils.valueToOffsetDateTime(this, null);
        }
        return new TimestampWithTimeZone(this.dateValue, this.timeNanos, this.timeZoneOffsetSeconds);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        if (JSR310.PRESENT) {
            try {
                preparedStatement.setObject(n, JSR310Utils.valueToOffsetDateTime(this, null), 2014);
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        preparedStatement.setString(n, this.getString());
    }
}

