"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchAccessPolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class ElasticsearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.accessPolicies,
        });
        super(scope, id, {
            resourceType: 'Custom::ElasticsearchAccessPolicy',
            onUpdate: {
                action: 'updateElasticsearchDomainConfig',
                service: 'ES',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: JSON.stringify(policyDocument.toJSON()),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPath: 'DomainConfig.ElasticsearchClusterConfig.AccessPolicies',
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: [props.domainArn] }),
        });
    }
}
exports.ElasticsearchAccessPolicy = ElasticsearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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