"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsServerlessInit = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class RdsServerlessInit extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        this.rdsServerlessInit = new lambda.DockerImageFunction(this, id + 'ServerlessInit', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/rds_serverless_init/')),
            memorySize: 128,
            timeout: cdk.Duration.seconds(600),
            // securityGroups: props.securityGroups,
            environment: {
                LOG_LEVEL: 'DEBUG',
                SECRET_ARN: props.dbClusterSecretARN,
                CLUSTER_ARN: props.dbClusterARN,
            },
        });
        // TODO: fix to limit IAM to this cluster
        (_a = this.rdsServerlessInit.role) === null || _a === void 0 ? void 0 : _a.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonRDSDataFullAccess'));
        this.rdsServerlessInit.addToRolePolicy(new iam.PolicyStatement({ actions: ['rds-data:*', 'secretsmanager:*', 'dbqms:*', 'tag:*'], resources: ['*'] }));
        const provider = new customResources.Provider(this, 'Provider', {
            onEventHandler: this.rdsServerlessInit,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
exports.RdsServerlessInit = RdsServerlessInit;
//# sourceMappingURL=data:application/json;base64,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