# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.0.20.34  # noqa: E501
    The version of the OpenAPI document: 0.8.10
    Contact: ravi@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class ChainPropertiesDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'enable_verifiable_state': 'bool',
        'enable_verifiable_receipts': 'bool',
        'currency_mosaic_id': 'str',
        'harvesting_mosaic_id': 'str',
        'block_generation_target_time': 'str',
        'block_time_smoothing_factor': 'str',
        'block_finalization_interval': 'str',
        'importance_grouping': 'str',
        'importance_activity_percentage': 'str',
        'max_rollback_blocks': 'str',
        'max_difficulty_blocks': 'str',
        'default_dynamic_fee_multiplier': 'str',
        'max_transaction_lifetime': 'str',
        'max_block_future_time': 'str',
        'initial_currency_atomic_units': 'str',
        'max_mosaic_atomic_units': 'str',
        'total_chain_importance': 'str',
        'min_harvester_balance': 'str',
        'max_harvester_balance': 'str',
        'min_voter_balance': 'str',
        'harvest_beneficiary_percentage': 'str',
        'harvest_network_percentage': 'str',
        'harvest_network_fee_sink_public_key': 'str',
        'block_prune_interval': 'str',
        'max_transactions_per_block': 'str'
    }

    attribute_map = {
        'enable_verifiable_state': 'enableVerifiableState',
        'enable_verifiable_receipts': 'enableVerifiableReceipts',
        'currency_mosaic_id': 'currencyMosaicId',
        'harvesting_mosaic_id': 'harvestingMosaicId',
        'block_generation_target_time': 'blockGenerationTargetTime',
        'block_time_smoothing_factor': 'blockTimeSmoothingFactor',
        'block_finalization_interval': 'blockFinalizationInterval',
        'importance_grouping': 'importanceGrouping',
        'importance_activity_percentage': 'importanceActivityPercentage',
        'max_rollback_blocks': 'maxRollbackBlocks',
        'max_difficulty_blocks': 'maxDifficultyBlocks',
        'default_dynamic_fee_multiplier': 'defaultDynamicFeeMultiplier',
        'max_transaction_lifetime': 'maxTransactionLifetime',
        'max_block_future_time': 'maxBlockFutureTime',
        'initial_currency_atomic_units': 'initialCurrencyAtomicUnits',
        'max_mosaic_atomic_units': 'maxMosaicAtomicUnits',
        'total_chain_importance': 'totalChainImportance',
        'min_harvester_balance': 'minHarvesterBalance',
        'max_harvester_balance': 'maxHarvesterBalance',
        'min_voter_balance': 'minVoterBalance',
        'harvest_beneficiary_percentage': 'harvestBeneficiaryPercentage',
        'harvest_network_percentage': 'harvestNetworkPercentage',
        'harvest_network_fee_sink_public_key': 'harvestNetworkFeeSinkPublicKey',
        'block_prune_interval': 'blockPruneInterval',
        'max_transactions_per_block': 'maxTransactionsPerBlock'
    }

    def __init__(self, enable_verifiable_state=None, enable_verifiable_receipts=None, currency_mosaic_id=None, harvesting_mosaic_id=None, block_generation_target_time=None, block_time_smoothing_factor=None, block_finalization_interval=None, importance_grouping=None, importance_activity_percentage=None, max_rollback_blocks=None, max_difficulty_blocks=None, default_dynamic_fee_multiplier=None, max_transaction_lifetime=None, max_block_future_time=None, initial_currency_atomic_units=None, max_mosaic_atomic_units=None, total_chain_importance=None, min_harvester_balance=None, max_harvester_balance=None, min_voter_balance=None, harvest_beneficiary_percentage=None, harvest_network_percentage=None, harvest_network_fee_sink_public_key=None, block_prune_interval=None, max_transactions_per_block=None, local_vars_configuration=None):  # noqa: E501
        """ChainPropertiesDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._enable_verifiable_state = None
        self._enable_verifiable_receipts = None
        self._currency_mosaic_id = None
        self._harvesting_mosaic_id = None
        self._block_generation_target_time = None
        self._block_time_smoothing_factor = None
        self._block_finalization_interval = None
        self._importance_grouping = None
        self._importance_activity_percentage = None
        self._max_rollback_blocks = None
        self._max_difficulty_blocks = None
        self._default_dynamic_fee_multiplier = None
        self._max_transaction_lifetime = None
        self._max_block_future_time = None
        self._initial_currency_atomic_units = None
        self._max_mosaic_atomic_units = None
        self._total_chain_importance = None
        self._min_harvester_balance = None
        self._max_harvester_balance = None
        self._min_voter_balance = None
        self._harvest_beneficiary_percentage = None
        self._harvest_network_percentage = None
        self._harvest_network_fee_sink_public_key = None
        self._block_prune_interval = None
        self._max_transactions_per_block = None
        self.discriminator = None

        if enable_verifiable_state is not None:
            self.enable_verifiable_state = enable_verifiable_state
        if enable_verifiable_receipts is not None:
            self.enable_verifiable_receipts = enable_verifiable_receipts
        if currency_mosaic_id is not None:
            self.currency_mosaic_id = currency_mosaic_id
        if harvesting_mosaic_id is not None:
            self.harvesting_mosaic_id = harvesting_mosaic_id
        if block_generation_target_time is not None:
            self.block_generation_target_time = block_generation_target_time
        if block_time_smoothing_factor is not None:
            self.block_time_smoothing_factor = block_time_smoothing_factor
        if block_finalization_interval is not None:
            self.block_finalization_interval = block_finalization_interval
        if importance_grouping is not None:
            self.importance_grouping = importance_grouping
        if importance_activity_percentage is not None:
            self.importance_activity_percentage = importance_activity_percentage
        if max_rollback_blocks is not None:
            self.max_rollback_blocks = max_rollback_blocks
        if max_difficulty_blocks is not None:
            self.max_difficulty_blocks = max_difficulty_blocks
        if default_dynamic_fee_multiplier is not None:
            self.default_dynamic_fee_multiplier = default_dynamic_fee_multiplier
        if max_transaction_lifetime is not None:
            self.max_transaction_lifetime = max_transaction_lifetime
        if max_block_future_time is not None:
            self.max_block_future_time = max_block_future_time
        if initial_currency_atomic_units is not None:
            self.initial_currency_atomic_units = initial_currency_atomic_units
        if max_mosaic_atomic_units is not None:
            self.max_mosaic_atomic_units = max_mosaic_atomic_units
        if total_chain_importance is not None:
            self.total_chain_importance = total_chain_importance
        if min_harvester_balance is not None:
            self.min_harvester_balance = min_harvester_balance
        if max_harvester_balance is not None:
            self.max_harvester_balance = max_harvester_balance
        if min_voter_balance is not None:
            self.min_voter_balance = min_voter_balance
        if harvest_beneficiary_percentage is not None:
            self.harvest_beneficiary_percentage = harvest_beneficiary_percentage
        if harvest_network_percentage is not None:
            self.harvest_network_percentage = harvest_network_percentage
        if harvest_network_fee_sink_public_key is not None:
            self.harvest_network_fee_sink_public_key = harvest_network_fee_sink_public_key
        if block_prune_interval is not None:
            self.block_prune_interval = block_prune_interval
        if max_transactions_per_block is not None:
            self.max_transactions_per_block = max_transactions_per_block

    @property
    def enable_verifiable_state(self):
        """Gets the enable_verifiable_state of this ChainPropertiesDTO.  # noqa: E501

        Set to true if block chain should calculate state hashes so that state is fully verifiable at each block.  # noqa: E501

        :return: The enable_verifiable_state of this ChainPropertiesDTO.  # noqa: E501
        :rtype: bool
        """
        return self._enable_verifiable_state

    @enable_verifiable_state.setter
    def enable_verifiable_state(self, enable_verifiable_state):
        """Sets the enable_verifiable_state of this ChainPropertiesDTO.

        Set to true if block chain should calculate state hashes so that state is fully verifiable at each block.  # noqa: E501

        :param enable_verifiable_state: The enable_verifiable_state of this ChainPropertiesDTO.  # noqa: E501
        :type: bool
        """

        self._enable_verifiable_state = enable_verifiable_state

    @property
    def enable_verifiable_receipts(self):
        """Gets the enable_verifiable_receipts of this ChainPropertiesDTO.  # noqa: E501

        Set to true if block chain should calculate receipts so that state changes are fully verifiable at each block.  # noqa: E501

        :return: The enable_verifiable_receipts of this ChainPropertiesDTO.  # noqa: E501
        :rtype: bool
        """
        return self._enable_verifiable_receipts

    @enable_verifiable_receipts.setter
    def enable_verifiable_receipts(self, enable_verifiable_receipts):
        """Sets the enable_verifiable_receipts of this ChainPropertiesDTO.

        Set to true if block chain should calculate receipts so that state changes are fully verifiable at each block.  # noqa: E501

        :param enable_verifiable_receipts: The enable_verifiable_receipts of this ChainPropertiesDTO.  # noqa: E501
        :type: bool
        """

        self._enable_verifiable_receipts = enable_verifiable_receipts

    @property
    def currency_mosaic_id(self):
        """Gets the currency_mosaic_id of this ChainPropertiesDTO.  # noqa: E501

        Mosaic id used as primary chain currency.  # noqa: E501

        :return: The currency_mosaic_id of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._currency_mosaic_id

    @currency_mosaic_id.setter
    def currency_mosaic_id(self, currency_mosaic_id):
        """Sets the currency_mosaic_id of this ChainPropertiesDTO.

        Mosaic id used as primary chain currency.  # noqa: E501

        :param currency_mosaic_id: The currency_mosaic_id of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._currency_mosaic_id = currency_mosaic_id

    @property
    def harvesting_mosaic_id(self):
        """Gets the harvesting_mosaic_id of this ChainPropertiesDTO.  # noqa: E501

        Mosaic id used to provide harvesting ability.  # noqa: E501

        :return: The harvesting_mosaic_id of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._harvesting_mosaic_id

    @harvesting_mosaic_id.setter
    def harvesting_mosaic_id(self, harvesting_mosaic_id):
        """Sets the harvesting_mosaic_id of this ChainPropertiesDTO.

        Mosaic id used to provide harvesting ability.  # noqa: E501

        :param harvesting_mosaic_id: The harvesting_mosaic_id of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._harvesting_mosaic_id = harvesting_mosaic_id

    @property
    def block_generation_target_time(self):
        """Gets the block_generation_target_time of this ChainPropertiesDTO.  # noqa: E501

        Targeted time between blocks.  # noqa: E501

        :return: The block_generation_target_time of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._block_generation_target_time

    @block_generation_target_time.setter
    def block_generation_target_time(self, block_generation_target_time):
        """Sets the block_generation_target_time of this ChainPropertiesDTO.

        Targeted time between blocks.  # noqa: E501

        :param block_generation_target_time: The block_generation_target_time of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._block_generation_target_time = block_generation_target_time

    @property
    def block_time_smoothing_factor(self):
        """Gets the block_time_smoothing_factor of this ChainPropertiesDTO.  # noqa: E501

        A higher value makes the network more biased.  # noqa: E501

        :return: The block_time_smoothing_factor of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._block_time_smoothing_factor

    @block_time_smoothing_factor.setter
    def block_time_smoothing_factor(self, block_time_smoothing_factor):
        """Sets the block_time_smoothing_factor of this ChainPropertiesDTO.

        A higher value makes the network more biased.  # noqa: E501

        :param block_time_smoothing_factor: The block_time_smoothing_factor of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._block_time_smoothing_factor = block_time_smoothing_factor

    @property
    def block_finalization_interval(self):
        """Gets the block_finalization_interval of this ChainPropertiesDTO.  # noqa: E501

        Number of blocks between successive finalization attempts.  # noqa: E501

        :return: The block_finalization_interval of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._block_finalization_interval

    @block_finalization_interval.setter
    def block_finalization_interval(self, block_finalization_interval):
        """Sets the block_finalization_interval of this ChainPropertiesDTO.

        Number of blocks between successive finalization attempts.  # noqa: E501

        :param block_finalization_interval: The block_finalization_interval of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._block_finalization_interval = block_finalization_interval

    @property
    def importance_grouping(self):
        """Gets the importance_grouping of this ChainPropertiesDTO.  # noqa: E501

        Number of blocks that should be treated as a group for importance purposes.  # noqa: E501

        :return: The importance_grouping of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._importance_grouping

    @importance_grouping.setter
    def importance_grouping(self, importance_grouping):
        """Sets the importance_grouping of this ChainPropertiesDTO.

        Number of blocks that should be treated as a group for importance purposes.  # noqa: E501

        :param importance_grouping: The importance_grouping of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._importance_grouping = importance_grouping

    @property
    def importance_activity_percentage(self):
        """Gets the importance_activity_percentage of this ChainPropertiesDTO.  # noqa: E501

        Percentage of importance resulting from fee generation and beneficiary usage.  # noqa: E501

        :return: The importance_activity_percentage of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._importance_activity_percentage

    @importance_activity_percentage.setter
    def importance_activity_percentage(self, importance_activity_percentage):
        """Sets the importance_activity_percentage of this ChainPropertiesDTO.

        Percentage of importance resulting from fee generation and beneficiary usage.  # noqa: E501

        :param importance_activity_percentage: The importance_activity_percentage of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._importance_activity_percentage = importance_activity_percentage

    @property
    def max_rollback_blocks(self):
        """Gets the max_rollback_blocks of this ChainPropertiesDTO.  # noqa: E501

        Maximum number of blocks that can be rolled back.  # noqa: E501

        :return: The max_rollback_blocks of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_rollback_blocks

    @max_rollback_blocks.setter
    def max_rollback_blocks(self, max_rollback_blocks):
        """Sets the max_rollback_blocks of this ChainPropertiesDTO.

        Maximum number of blocks that can be rolled back.  # noqa: E501

        :param max_rollback_blocks: The max_rollback_blocks of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_rollback_blocks = max_rollback_blocks

    @property
    def max_difficulty_blocks(self):
        """Gets the max_difficulty_blocks of this ChainPropertiesDTO.  # noqa: E501

        Maximum number of blocks to use in a difficulty calculation.  # noqa: E501

        :return: The max_difficulty_blocks of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_difficulty_blocks

    @max_difficulty_blocks.setter
    def max_difficulty_blocks(self, max_difficulty_blocks):
        """Sets the max_difficulty_blocks of this ChainPropertiesDTO.

        Maximum number of blocks to use in a difficulty calculation.  # noqa: E501

        :param max_difficulty_blocks: The max_difficulty_blocks of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_difficulty_blocks = max_difficulty_blocks

    @property
    def default_dynamic_fee_multiplier(self):
        """Gets the default_dynamic_fee_multiplier of this ChainPropertiesDTO.  # noqa: E501

        Default multiplier to use for dynamic fees.  # noqa: E501

        :return: The default_dynamic_fee_multiplier of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._default_dynamic_fee_multiplier

    @default_dynamic_fee_multiplier.setter
    def default_dynamic_fee_multiplier(self, default_dynamic_fee_multiplier):
        """Sets the default_dynamic_fee_multiplier of this ChainPropertiesDTO.

        Default multiplier to use for dynamic fees.  # noqa: E501

        :param default_dynamic_fee_multiplier: The default_dynamic_fee_multiplier of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._default_dynamic_fee_multiplier = default_dynamic_fee_multiplier

    @property
    def max_transaction_lifetime(self):
        """Gets the max_transaction_lifetime of this ChainPropertiesDTO.  # noqa: E501

        Maximum lifetime a transaction can have before it expires.  # noqa: E501

        :return: The max_transaction_lifetime of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_transaction_lifetime

    @max_transaction_lifetime.setter
    def max_transaction_lifetime(self, max_transaction_lifetime):
        """Sets the max_transaction_lifetime of this ChainPropertiesDTO.

        Maximum lifetime a transaction can have before it expires.  # noqa: E501

        :param max_transaction_lifetime: The max_transaction_lifetime of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_transaction_lifetime = max_transaction_lifetime

    @property
    def max_block_future_time(self):
        """Gets the max_block_future_time of this ChainPropertiesDTO.  # noqa: E501

        Maximum future time of a block that can be accepted.  # noqa: E501

        :return: The max_block_future_time of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_block_future_time

    @max_block_future_time.setter
    def max_block_future_time(self, max_block_future_time):
        """Sets the max_block_future_time of this ChainPropertiesDTO.

        Maximum future time of a block that can be accepted.  # noqa: E501

        :param max_block_future_time: The max_block_future_time of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_block_future_time = max_block_future_time

    @property
    def initial_currency_atomic_units(self):
        """Gets the initial_currency_atomic_units of this ChainPropertiesDTO.  # noqa: E501

        Initial currency atomic units available in the network.  # noqa: E501

        :return: The initial_currency_atomic_units of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._initial_currency_atomic_units

    @initial_currency_atomic_units.setter
    def initial_currency_atomic_units(self, initial_currency_atomic_units):
        """Sets the initial_currency_atomic_units of this ChainPropertiesDTO.

        Initial currency atomic units available in the network.  # noqa: E501

        :param initial_currency_atomic_units: The initial_currency_atomic_units of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._initial_currency_atomic_units = initial_currency_atomic_units

    @property
    def max_mosaic_atomic_units(self):
        """Gets the max_mosaic_atomic_units of this ChainPropertiesDTO.  # noqa: E501

        Maximum atomic units (total-supply * 10 ^ divisibility) of a mosaic allowed in the network.  # noqa: E501

        :return: The max_mosaic_atomic_units of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_mosaic_atomic_units

    @max_mosaic_atomic_units.setter
    def max_mosaic_atomic_units(self, max_mosaic_atomic_units):
        """Sets the max_mosaic_atomic_units of this ChainPropertiesDTO.

        Maximum atomic units (total-supply * 10 ^ divisibility) of a mosaic allowed in the network.  # noqa: E501

        :param max_mosaic_atomic_units: The max_mosaic_atomic_units of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_mosaic_atomic_units = max_mosaic_atomic_units

    @property
    def total_chain_importance(self):
        """Gets the total_chain_importance of this ChainPropertiesDTO.  # noqa: E501

        Total whole importance units available in the network.  # noqa: E501

        :return: The total_chain_importance of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._total_chain_importance

    @total_chain_importance.setter
    def total_chain_importance(self, total_chain_importance):
        """Sets the total_chain_importance of this ChainPropertiesDTO.

        Total whole importance units available in the network.  # noqa: E501

        :param total_chain_importance: The total_chain_importance of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._total_chain_importance = total_chain_importance

    @property
    def min_harvester_balance(self):
        """Gets the min_harvester_balance of this ChainPropertiesDTO.  # noqa: E501

        Minimum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.  # noqa: E501

        :return: The min_harvester_balance of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._min_harvester_balance

    @min_harvester_balance.setter
    def min_harvester_balance(self, min_harvester_balance):
        """Sets the min_harvester_balance of this ChainPropertiesDTO.

        Minimum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.  # noqa: E501

        :param min_harvester_balance: The min_harvester_balance of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._min_harvester_balance = min_harvester_balance

    @property
    def max_harvester_balance(self):
        """Gets the max_harvester_balance of this ChainPropertiesDTO.  # noqa: E501

        Maximum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.  # noqa: E501

        :return: The max_harvester_balance of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_harvester_balance

    @max_harvester_balance.setter
    def max_harvester_balance(self, max_harvester_balance):
        """Sets the max_harvester_balance of this ChainPropertiesDTO.

        Maximum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.  # noqa: E501

        :param max_harvester_balance: The max_harvester_balance of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_harvester_balance = max_harvester_balance

    @property
    def min_voter_balance(self):
        """Gets the min_voter_balance of this ChainPropertiesDTO.  # noqa: E501

        Minimum number of harvesting mosaic atomic units needed for an account to be eligible for voting.  # noqa: E501

        :return: The min_voter_balance of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._min_voter_balance

    @min_voter_balance.setter
    def min_voter_balance(self, min_voter_balance):
        """Sets the min_voter_balance of this ChainPropertiesDTO.

        Minimum number of harvesting mosaic atomic units needed for an account to be eligible for voting.  # noqa: E501

        :param min_voter_balance: The min_voter_balance of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._min_voter_balance = min_voter_balance

    @property
    def harvest_beneficiary_percentage(self):
        """Gets the harvest_beneficiary_percentage of this ChainPropertiesDTO.  # noqa: E501

        Percentage of the harvested fee that is collected by the beneficiary account.  # noqa: E501

        :return: The harvest_beneficiary_percentage of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._harvest_beneficiary_percentage

    @harvest_beneficiary_percentage.setter
    def harvest_beneficiary_percentage(self, harvest_beneficiary_percentage):
        """Sets the harvest_beneficiary_percentage of this ChainPropertiesDTO.

        Percentage of the harvested fee that is collected by the beneficiary account.  # noqa: E501

        :param harvest_beneficiary_percentage: The harvest_beneficiary_percentage of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._harvest_beneficiary_percentage = harvest_beneficiary_percentage

    @property
    def harvest_network_percentage(self):
        """Gets the harvest_network_percentage of this ChainPropertiesDTO.  # noqa: E501

        Percentage of the harvested fee that is collected by the network.  # noqa: E501

        :return: The harvest_network_percentage of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._harvest_network_percentage

    @harvest_network_percentage.setter
    def harvest_network_percentage(self, harvest_network_percentage):
        """Sets the harvest_network_percentage of this ChainPropertiesDTO.

        Percentage of the harvested fee that is collected by the network.  # noqa: E501

        :param harvest_network_percentage: The harvest_network_percentage of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._harvest_network_percentage = harvest_network_percentage

    @property
    def harvest_network_fee_sink_public_key(self):
        """Gets the harvest_network_fee_sink_public_key of this ChainPropertiesDTO.  # noqa: E501

        Public key of the harvest network fee sink account.  # noqa: E501

        :return: The harvest_network_fee_sink_public_key of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._harvest_network_fee_sink_public_key

    @harvest_network_fee_sink_public_key.setter
    def harvest_network_fee_sink_public_key(self, harvest_network_fee_sink_public_key):
        """Sets the harvest_network_fee_sink_public_key of this ChainPropertiesDTO.

        Public key of the harvest network fee sink account.  # noqa: E501

        :param harvest_network_fee_sink_public_key: The harvest_network_fee_sink_public_key of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._harvest_network_fee_sink_public_key = harvest_network_fee_sink_public_key

    @property
    def block_prune_interval(self):
        """Gets the block_prune_interval of this ChainPropertiesDTO.  # noqa: E501

        Number of blocks between cache pruning.  # noqa: E501

        :return: The block_prune_interval of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._block_prune_interval

    @block_prune_interval.setter
    def block_prune_interval(self, block_prune_interval):
        """Sets the block_prune_interval of this ChainPropertiesDTO.

        Number of blocks between cache pruning.  # noqa: E501

        :param block_prune_interval: The block_prune_interval of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._block_prune_interval = block_prune_interval

    @property
    def max_transactions_per_block(self):
        """Gets the max_transactions_per_block of this ChainPropertiesDTO.  # noqa: E501

        Maximum number of transactions per block.  # noqa: E501

        :return: The max_transactions_per_block of this ChainPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_transactions_per_block

    @max_transactions_per_block.setter
    def max_transactions_per_block(self, max_transactions_per_block):
        """Sets the max_transactions_per_block of this ChainPropertiesDTO.

        Maximum number of transactions per block.  # noqa: E501

        :param max_transactions_per_block: The max_transactions_per_block of this ChainPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_transactions_per_block = max_transactions_per_block

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChainPropertiesDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChainPropertiesDTO):
            return True

        return self.to_dict() != other.to_dict()
