"""Constants for calculating the JSON source map."""

SPACE = "\u0020"
TAB = "\u0009"
RETURN = "\u000A"
CARRIAGE_RETURN = "\u000D"
WHITESPACE = {SPACE, TAB, RETURN, CARRIAGE_RETURN}
BEGIN_ARRAY = "\u005B"
END_ARRAY = "\u005D"
BEGIN_OBJECT = "\u007B"
END_OBJECT = "\u007D"
NAME_SEPARATOR = "\u003A"
VALUE_SEPARATOR = "\u002C"
CONTROL_CHARACTER = {
    BEGIN_ARRAY,
    END_ARRAY,
    BEGIN_OBJECT,
    END_OBJECT,
    NAME_SEPARATOR,
    VALUE_SEPARATOR,
}
QUOTATION_MARK = "\u0022"
ESCAPE = "\u005C"
