# Google Domains DDNS API Client
To facilitate running a home web server behind a router without a static IP, this package checks to see if your external IP has changed and automatically updates your Dynamic DNS rules on Google Domains, via the API; also notifies user by email if required.

### Installation (Python 3.8+):
`pip install domains-api`

### Usage:
Can be run from the command line like so:

`domains [opt]`

or imported into your projects:
```
from domains_api.ip_changer import IPChanger

changer = IPChanger()
```

Windows/Mac or Linux, it will ask for your credentials on first run and then shouldn't need any input after that. I added command line options/arguments (see `domains --help`) for loading/deleting a profile and changing credentials/settings more easily.

You will need your Dynamic DNS autogenerated username and password as described in [this documentation](https://support.google.com/domains/answer/6147083?hl=en-CA).

If you choose to receive email notifications, you will be asked to input your gmail email address and password which will then be encoded before being saved as part of a User instance. (The notification is sent from the user's own email address via the gmail smtp server, you might need to allow less secure apps on your Google account to use.)

On **Windows** you can use Task Scheduler; on **Linux/Mac**, add a line to your crontab and you can choose the frequency of the checks. An example hourly cron job would look like this:

`0 * * * * domains >> /dev/null 2>&1`

_assumes package is installed in global scope; otherwise, use command `path/to/env/bin/python3 -m domains_api`_

If reducing downtime is essential, you could increase the frequency of checks to every 1 minute, or even less, like this:

`*/1 * * * * ...etc`

On Google Domains the default TTL for Dynamic DNS is 1 minute, so checks should never need to be more frequent than this, but unless you expect your external IP to change very frequently, such regular cron jobs might be a slight waste of resources; even so, the script is very light-weight and usually only takes just over a second to run normally on a Raspberry Pi 3 Ubuntu server.

The logs are written to both `~/.domains/domains.log` (posix) or `%LOCALAPPDATA%/domains/domains.log` (win), and stdout, so that they also appear in the terminal & crontab log.

After initial setup, the script takes care of everything: if your IP has changed since you last ran it, it will update your Dynamic DNS rule on domains.google.com.

If you forget your IP or need to check it for any reason, running:

`domains -i` 

...will log your current external IP to the terminal without doing anything else.

Check `domains -h` for more command line options.

### Example in Django application:

In your Django environment:

`pip install domains-api apscheduler`

You must first run the script from the command line to set up credentials, or set them manually via the `User` class:

```
from domains_api import IPChanger, User

ip_changer = IPChanger()

ip_changer.user = User(
    domain="example.com",
    api_key="eXamPleBlahbLAhBlah",
    api_sec="eXamPleBlahbLAhBlee",
)
```

Then, in your project you can create a new module called ip_changer in your project's root directory, 
with an empty `__init__.py` file and an `ip_changer.py` file.

`ip_changer.py` should look something like this:

```
from apscheduler.schedulers.background import BackgroundScheduler
from domains_api import IPChanger, User


def start():
    scheduler = BackgroundScheduler()
    scheduler.add_job(IPChanger, 'interval', minutes=10)
    scheduler.start()
```

Then you will need to add the following to your main app's `apps.py` file:

```
class MainConfig(AppConfig):
    name = 'main'

    def ready(self):
        from ip_changer import ip_changer
        ip_changer.start()
```
Check `/var/log/apache2/error.log` or `/var/log/nginx/error.log` or your webserver log location (might be logged as wsgi errors) and/or `~/.domains/domains.log` to check everything is working as expected.