# AUTOGENERATED! DO NOT EDIT! File to edit: 03_robot_model.ipynb (unless otherwise specified).

__all__ = ['robot_model_loader']

# Cell
#nbdev_comment from __future__ import print_function

import gdown
from zipfile import ZipFile
import xml.etree.cElementTree as ET
from urdfpy import URDF
import os

class robot_model_loader:
    def __init__(self, url, name):
        self.url = url
        self.name = name

    def load(self):
        """
            download a zipfile and unzip it under data directory
        """
        dataset_url = 'https://drive.google.com/u/1/uc?id=' + self.url
        dataset_name = self.name

        gdown.download(dataset_url, output=dataset_name + '.zip', quiet=False)
        zip = ZipFile(dataset_name + '.zip')
        zip.extractall(dataset_name)
        zip.close()

    def list_all(self):
        """
            list all urdf or xml file
        """
        for file in os.listdir(self.name):
            if file.find('.urdf') != -1 or file.find('.xml') != -1:
                print(file,'\n')

    def show_link(self, path):
        """
            show urdf file link
        """

        robot = URDF.load(path)

        for link in robot.links:
            print(link.name)