"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Isolation = exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const _limited_internet_access_1 = require("./_limited-internet-access");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const domain_redirect_1 = require("./domain-redirect");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const storage_1 = require("./s3/storage");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        if (props.isolateSensitiveTasks != null && props.sensitiveTaskIsolation != null) {
            throw new Error('Supplying both isolateSensitiveTasks and sensitiveTaskIsolation is not supported. Remove usage of isolateSensitiveTasks.');
        }
        const storageFactory = storage_1.S3StorageFactory.getOrCreate(this, {
            failover: props.failoverStorage,
        });
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = storageFactory.newBucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const isolation = (_b = props.sensitiveTaskIsolation) !== null && _b !== void 0 ? _b : (props.isolateSensitiveTasks ? Isolation.NO_INTERNET_ACCESS : Isolation.UNLIMITED_INTERNET_ACCESS);
        // Create an internal CodeArtifact repository if we run in network-controlled mode, or if a domain is provided.
        const codeArtifact = isolation === Isolation.NO_INTERNET_ACCESS || props.codeArtifactDomain != null
            ? new repository_1.Repository(this, 'CodeArtifact', {
                description: 'Proxy to npmjs.com for ConstructHub',
                domainName: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.name,
                domainExists: props.codeArtifactDomain != null,
                upstreams: (_d = props.codeArtifactDomain) === null || _d === void 0 ? void 0 : _d.upstreams,
            })
            : undefined;
        const { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups } = this.createVpc(isolation, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_e = props.denyList) !== null && _e !== void 0 ? _e : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_f = props.fetchPackageStats) !== null && _f !== void 0 ? _f : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
            vpcSecurityGroups,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder.function);
        const packageTagsSerialized = (_h = (_g = props.packageTags) === null || _g === void 0 ? void 0 : _g.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _h !== void 0 ? _h : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            codeArtifact,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_j = props.allowedLicenses) !== null && _j !== void 0 ? _j : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.cddl(),
                ...spdx_license_1.SpdxLicense.epl(),
                spdx_license_1.SpdxLicense.ISC,
                ...spdx_license_1.SpdxLicense.mit(),
                spdx_license_1.SpdxLicense.MPL_2_0,
            ],
        });
        const webApp = new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
            categories: props.categories,
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_k = props.packageSources) !== null && _k !== void 0 ? _k : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            baseUrl: webApp.baseUrl,
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
        });
        // add domain redirects
        if (props.domain) {
            for (const redirctSource of (_l = props.additionalDomains) !== null && _l !== void 0 ? _l : []) {
                new domain_redirect_1.DomainRedirect(this, `Redirect-${redirctSource.hostedZone.zoneName}`, {
                    source: redirctSource,
                    targetDomainName: (_m = props.domain) === null || _m === void 0 ? void 0 : _m.zone.zoneName,
                });
            }
        }
        else {
            if (props.additionalDomains && props.additionalDomains.length > 0) {
                throw new Error('Cannot specify "domainRedirects" if a domain is not specified');
            }
        }
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(isolation, codeArtifact) {
        if (isolation === Isolation.UNLIMITED_INTERNET_ACCESS) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const subnetType = isolation === Isolation.NO_INTERNET_ACCESS
            ? ec2.SubnetType.ISOLATED
            : ec2.SubnetType.PRIVATE_WITH_NAT;
        const vpcSubnets = { subnetType };
        const vpc = new ec2.Vpc(this, 'VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            // Provision no NAT gateways if we are running ISOLATED (we wouldn't have a public subnet)
            natGateways: subnetType === ec2.SubnetType.ISOLATED ? 0 : undefined,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE_WITH_NAT, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED, reserved: subnetType !== ec2.SubnetType.ISOLATED },
            ],
        });
        core_1.Tags.of(vpc.node.defaultChild).add('Name', vpc.node.path);
        const securityGroups = subnetType === ec2.SubnetType.PRIVATE_WITH_NAT
            ? _limited_internet_access_1.createRestrictedSecurityGroups(this, vpc)
            : undefined;
        // Creating the CodeArtifact endpoints only if a repository is present.
        const codeArtifactEndpoints = codeArtifact && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
                securityGroups,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            ...codeArtifactEndpoints,
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
                securityGroups,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                ...codeArtifact ? [`${codeArtifact.s3BucketArn}/*`] : [],
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups: securityGroups };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.3.152" };
/**
 * (experimental) How possibly risky operations (such as doc-generation, which requires installing the indexed packages in order to trans-literate sample code) are isolated to mitigate possible arbitrary code execution vulnerabilities in and around `npm install` or the transliterator's use of the TypeScript compiler.
 *
 * @experimental
 */
var Isolation;
(function (Isolation) {
    Isolation[Isolation["UNLIMITED_INTERNET_ACCESS"] = 0] = "UNLIMITED_INTERNET_ACCESS";
    Isolation[Isolation["LIMITED_INTERNET_ACCESS"] = 1] = "LIMITED_INTERNET_ACCESS";
    Isolation[Isolation["NO_INTERNET_ACCESS"] = 2] = "NO_INTERNET_ACCESS";
})(Isolation = exports.Isolation || (exports.Isolation = {}));
//# sourceMappingURL=data:application/json;base64,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