"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class LambdaToElasticSearchAndKibana extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticSearchAndKibana class.
     * @param {Constructs} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticSearchAndKibanaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if (props.vpcProps && !props.deployVpc) {
            throw new Error("Error - deployVpc must be true when defining vpcProps");
        }
        if (props.lambdaFunctionProps?.vpc || props.lambdaFunctionProps?.vpcSubnets) {
            throw new Error("Error - Define VPC using construct parameters not Lambda function props");
        }
        if (props.esDomainProps?.vpcOptions) {
            throw new Error("Error - Define VPC using construct parameters not Elasticsearch props");
        }
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
        }
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc
        });
        // Find the lambda service Role ARN
        const lambdaFunctionRoleARN = this.lambdaFunction.role?.roleArn;
        let cognitoAuthorizedRole;
        [this.userPool, this.userPoolClient, this.identityPool, cognitoAuthorizedRole] =
            defaults.buildCognitoForSearchService(this, props.cognitoDomainName ?? props.domainName);
        const buildElasticSearchProps = {
            userpool: this.userPool,
            identitypool: this.identityPool,
            cognitoAuthorizedRoleARN: cognitoAuthorizedRole.roleArn,
            serviceRoleARN: lambdaFunctionRoleARN,
            vpc: this.vpc,
            domainName: props.domainName,
            clientDomainProps: props.esDomainProps
        };
        if (this.vpc) {
            const securityGroupIds = defaults.getLambdaVpcSecurityGroupIds(this.lambdaFunction);
            buildElasticSearchProps.securityGroupIds = securityGroupIds;
        }
        const buildElasticSearchResponse = defaults.buildElasticSearch(this, buildElasticSearchProps);
        this.elasticsearchDomain = buildElasticSearchResponse.domain;
        this.elasticsearchRole = buildElasticSearchResponse.role;
        // Add ES Domain to lambda environment variable
        const domainEndpointEnvironmentVariableName = props.domainEndpointEnvironmentVariableName || 'DOMAIN_ENDPOINT';
        this.lambdaFunction.addEnvironment(domainEndpointEnvironmentVariableName, this.elasticsearchDomain.attrDomainEndpoint);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for ES
            this.cloudwatchAlarms = defaults.buildElasticSearchCWAlarms(this);
        }
    }
}
exports.LambdaToElasticSearchAndKibana = LambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticsearch-kibana.LambdaToElasticSearchAndKibana", version: "2.35.0" };
//# sourceMappingURL=data:application/json;base64,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