/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.ClientConnection;
import com.datapps.linkoopdb.jdbc.ClientConnectionHTTP;
import com.datapps.linkoopdb.jdbc.DatabaseURL;
import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCArray;
import com.datapps.linkoopdb.jdbc.impl.JDBCBlob;
import com.datapps.linkoopdb.jdbc.impl.JDBCCallableStatement;
import com.datapps.linkoopdb.jdbc.impl.JDBCClob;
import com.datapps.linkoopdb.jdbc.impl.JDBCConnectionEventListener;
import com.datapps.linkoopdb.jdbc.impl.JDBCDatabaseMetaData;
import com.datapps.linkoopdb.jdbc.impl.JDBCNClob;
import com.datapps.linkoopdb.jdbc.impl.JDBCPreparedStatement;
import com.datapps.linkoopdb.jdbc.impl.JDBCSQLXML;
import com.datapps.linkoopdb.jdbc.impl.JDBCSavepoint;
import com.datapps.linkoopdb.jdbc.impl.JDBCStatement;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.lib.StringUtil;
import com.datapps.linkoopdb.jdbc.persist.LdbSqlProperties;
import com.datapps.linkoopdb.jdbc.result.ResultProperties;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class JDBCConnection
implements Connection {
    private final Object rootWarning_mutex = new Object();
    protected boolean isNetConn;
    int rsHoldability = 1;
    LdbSqlProperties connProperties;
    LdbSqlProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    boolean isClosed;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;
    boolean isCloseResultSet = true;
    boolean isUseColumnName = true;
    boolean isTranslateTTIType = true;
    boolean isEmptyBatchAllowed = false;
    boolean isStoreLiveObject = false;
    private SQLWarning rootWarning;
    private int savepointIDSequence;

    public JDBCConnection(LdbSqlProperties props) throws SQLException, UnsupportedEncodingException {
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String connType = props.getProperty("connection_type");
        String host = props.getProperty("host");
        int port = props.getIntegerProperty("port", 0);
        String path = props.getProperty("path");
        String database = props.getProperty("database");
        int queryIterator = props.getIntegerProperty("query_iterator", 0);
        String clientCharset = props.getProperty("clientcharset", "UTF-8");
        String resultCharset = props.getProperty("resultcharset", "UTF-8");
        if (!Charset.isSupported(clientCharset)) {
            throw new UnsupportedEncodingException(clientCharset);
        }
        if (!Charset.isSupported(resultCharset)) {
            throw new UnsupportedEncodingException(resultCharset);
        }
        boolean isTLS = "tcps://".equals(connType) || "https://".equals(connType);
        boolean isTLSWrapper = props.isPropertyTrue("tls_wrapper", false);
        isTLSWrapper &= isTLS;
        if (user == null) {
            user = "SA";
        }
        if (password == null) {
            password = "";
        }
        Calendar cal = Calendar.getInstance();
        int zoneSeconds = HsqlDateTime.getZoneSeconds(cal);
        try {
            if (DatabaseURL.isInProcessDatabaseType(connType)) {
                throw JDBCUtil.sqlException(201, "linkoopdb not support embeded mode!");
            }
            if ("tcp://".equals(connType) || "tcps://".equals(connType)) {
                this.sessionProxy = new ClientConnection(host, port, path, database, isTLS, isTLSWrapper, user, password, zoneSeconds, queryIterator, clientCharset, resultCharset);
                this.isNetConn = true;
            } else if ("http://".equals(connType) || "https://".equals(connType)) {
                this.sessionProxy = new ClientConnectionHTTP(host, port, path, database, isTLS, isTLSWrapper, user, password, zoneSeconds, queryIterator);
                this.isNetConn = true;
            } else {
                throw JDBCUtil.invalidArgument(connType);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = props;
            this.clientProperties = this.sessionProxy.getClientProperties();
            this.setLocalVariables();
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    public JDBCConnection(SessionInterface c) {
        this.isInternal = true;
        this.sessionProxy = c;
    }

    public JDBCConnection(JDBCConnection c, JDBCConnectionEventListener eventListener) {
        this.sessionProxy = c.sessionProxy;
        this.connProperties = c.connProperties;
        this.clientProperties = c.clientProperties;
        this.isPooled = true;
        this.poolEventListener = eventListener;
        this.setLocalVariables();
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement stmt = new JDBCStatement(this, props);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement stmt = new JDBCCallableStatement(this, sql, 1003, 1007, this.rsHoldability);
            return stmt;
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    public synchronized long getSessionId() {
        return this.sessionProxy.getId();
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.length() == 0 || sql.indexOf(123) == -1) {
            return sql;
        }
        boolean changed = false;
        int state = 0;
        int len = sql.length();
        int nest = 0;
        StringBuffer sb = null;
        boolean outside_all = false;
        boolean outside_escape_inside_single_quotes = true;
        int outside_escape_inside_double_quotes = 2;
        int inside_escape = 3;
        int inside_escape_inside_single_quotes = 4;
        int inside_escape_inside_double_quotes = 5;
        int tail = 0;
        block6: for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    if (sb == null) {
                        sb = new StringBuffer(sql.length());
                    }
                    sb.append(sql.substring(tail, i));
                    tail = i = this.onStartEscapeSequence(sql, sb, i);
                    changed = true;
                    ++nest;
                    state = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --state;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    state -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        state = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        sb.append(sql.substring(tail, i));
                        sb.append(' ');
                        tail = ++i;
                        changed = true;
                        state = --nest == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    sb.append(sql.substring(tail, i));
                    tail = i = this.onStartEscapeSequence(sql, sb, i);
                    changed = true;
                    ++nest;
                    state = 3;
                    continue block6;
                }
            }
        }
        if (!changed) {
            return sql;
        }
        sb.append(sql.substring(tail, sql.length()));
        return sb.toString();
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(autoCommit);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(readOnly);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, catalog);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(level);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = w;
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, this.rsHoldability);
        return new JDBCStatement(this, props);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability, 2, null, null);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        this.rsHoldability = holdability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        JDBCSavepoint savepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(savepoint.name);
        }
        catch (LdbSqlException e) {
            JDBCUtil.throwError(e);
        }
        return savepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        if (name == null) {
            throw JDBCUtil.nullArgument();
        }
        if (name.startsWith("SYSTEM_SAVEPOINT_")) {
            throw JDBCUtil.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(name);
        }
        catch (LdbSqlException e) {
            JDBCUtil.throwError(e);
        }
        return new JDBCSavepoint(name, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (sp.name == null) {
            String msg = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(msg);
        }
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(msg);
        }
        if (this.getAutoCommit()) {
            sp.name = null;
            sp.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(sp.name);
            sp.connection = null;
            sp.name = null;
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (sp.name == null) {
            String msg = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(msg);
        }
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(msg);
        }
        if (this.getAutoCommit()) {
            sp.name = null;
            sp.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(sp.name);
            sp.connection = null;
            sp.name = null;
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new JDBCStatement(this, props);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                throw JDBCUtil.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, autoGeneratedKeys, null, null);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 21, columnIndexes, null);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 11, null, columnNames);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw JDBCUtil.outOfRangeArgument("timeout: " + timeout);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        final boolean[] flag = new boolean[]{true};
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Throwable e) {
                    flag[0] = false;
                }
            }
        };
        if (timeout > 60) {
            timeout = 60;
        }
        timeout *= 1000;
        try {
            t.start();
            long start = System.currentTimeMillis();
            t.join(timeout);
            try {
                t.setContextClassLoader(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (timeout == 0) {
                return flag[0];
            }
            return flag[0] && System.currentTimeMillis() - start < (long)timeout;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        SQLClientInfoException ex = new SQLClientInfoException();
        ex.initCause(JDBCUtil.notSupported());
        throw ex;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.isClosed && (properties == null || properties.isEmpty())) {
            return;
        }
        SQLClientInfoException ex = new SQLClientInfoException();
        if (this.isClosed) {
            ex.initCause(JDBCUtil.connectionClosedException());
        } else {
            ex.initCause(JDBCUtil.notSupported());
        }
        throw ex;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        if (typeName == null) {
            throw JDBCUtil.nullArgument();
        }
        int typeCode = Type.getTypeNr(typeName = typeName.toUpperCase());
        if (typeCode < 0) {
            throw JDBCUtil.invalidArgument(typeName);
        }
        Type type = Type.getDefaultType(typeCode);
        if (type.isArrayType() || type.isLobType() || type.isRowType()) {
            throw JDBCUtil.invalidArgument(typeName);
        }
        Object[] newData = new Object[elements.length];
        try {
            for (int i = 0; i < elements.length; ++i) {
                Object o = type.convertJavaToSQL(this.sessionProxy, elements[i]);
                newData[i] = type.convertToTypeLimits(this.sessionProxy, o);
            }
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
        return new JDBCArray(newData, type, this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        if (schema == null) {
            throw JDBCUtil.nullArgument("schema");
        }
        if (schema.length() == 0) {
            throw JDBCUtil.invalidArgument("Zero-length schema");
        }
        new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(schema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw JDBCUtil.nullArgument("executor");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    private void setLocalVariables() {
        String connType;
        if (this.connProperties == null) {
            return;
        }
        this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        this.isEmptyBatchAllowed = this.connProperties.isPropertyTrue("allow_empty_batch", false);
        this.isTranslateTTIType = this.clientProperties.isPropertyTrue("jdbc.translate_tti_types", true);
        this.isStoreLiveObject = this.clientProperties.isPropertyTrue("sql.live_object", false);
        if (this.isStoreLiveObject && !"mem:".equals(connType = this.connProperties.getProperty("connection_type"))) {
            this.isStoreLiveObject = false;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = w;
            } else {
                this.rootWarning.setNextWarning(w);
            }
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(1305, e.getMessage(), e);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String sql, StringBuffer sb, int i) throws SQLException {
        sb.append(' ');
        ++i;
        i = StringUtil.skipSpaces(sql, i);
        if (sql.regionMatches(true, i, "fn ", 0, 3) || sql.regionMatches(true, i, "oj ", 0, 3)) {
            i += 2;
        } else if (sql.regionMatches(true, i, "ts ", 0, 3)) {
            sb.append("TIMESTAMP");
            i += 2;
        } else if (sql.regionMatches(true, i, "d ", 0, 2)) {
            sb.append("DATE");
            ++i;
        } else if (sql.regionMatches(true, i, "t ", 0, 2)) {
            sb.append("TIME");
            ++i;
        } else if (sql.regionMatches(true, i, "call ", 0, 5)) {
            sb.append("CALL");
            i += 4;
        } else if (sql.regionMatches(true, i, "?= call ", 0, 8)) {
            sb.append("CALL");
            i += 7;
        } else if (sql.regionMatches(true, i, "? = call ", 0, 8)) {
            sb.append("CALL");
            i += 8;
        } else if (sql.regionMatches(true, i, "escape ", 0, 7)) {
            i += 6;
        } else if (this.validateForCEP(sql)) {
            int last;
            String suffix = sql.substring(i);
            if (!suffix.isEmpty() && (last = suffix.lastIndexOf("}")) >= 0) {
                if (last < 1) {
                    ++i;
                    sb.append("{").append("}");
                } else {
                    i += last + 1;
                    String pattern = suffix.substring(0, last + 1);
                    sb.append("{").append(pattern);
                }
            }
        } else {
            throw JDBCUtil.sqlException(Error.error(425, sql.substring(--i)));
        }
        return i;
    }

    private boolean validateForCEP(String sql) {
        return sql.toUpperCase().contains("MATCH_RECOGNIZE");
    }

    public String getUser() {
        return this.connProperties.getProperty("user");
    }

    public String getHost() {
        return this.connProperties.getProperty("host");
    }

    public int getPort() {
        return Integer.valueOf(this.connProperties.getProperty("port"));
    }
}

