/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERUniversalTagOctets;

class DEROctetString
extends DERASN1Type {
    private byte[] value;

    DEROctetString(byte[] byArray) {
        this.value = byArray;
        this.octets = this.calcOctets(this.value);
    }

    DEROctetString(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    DEROctetString(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    DEROctetString(byte[] byArray, int n, int n2, boolean bl) {
        this.parse(byArray, n, n2, bl);
    }

    protected void parse(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new DERException("Illegal values are passed.");
        }
        if (bl) {
            this.octets = new byte[n2];
            System.arraycopy(byArray, n, this.octets, 0, n2);
        } else {
            super.parseExplicitOctets(byArray, n);
        }
        this.value = this.getValueOf(this.octets);
    }

    byte[] getUniveralTagOctets() {
        return DERUniversalTagOctets.OCTET_STRING;
    }

    private final byte[] calcOctets(byte[] byArray) {
        return byArray;
    }

    private final byte[] getValueOf(byte[] byArray) {
        return byArray;
    }

    byte[] getValue() {
        return this.value;
    }

    protected boolean isConstructed() {
        return false;
    }
}

