#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['ninja',
 'ninja.compatibility',
 'ninja.openapi',
 'ninja.orm',
 'ninja.security',
 'ninja.signature']

package_data = \
{'': ['*'],
 'ninja': ['static/*', 'static/ninja/*', 'templates/*', 'templates/ninja/*']}

install_requires = \
['Django >=2.0.13', 'pydantic >=1.6,<1.9']

extras_require = \
{'doc': ['mkdocs', 'mkdocs-material', 'markdown-include'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-django',
          'pytest-asyncio',
          'black',
          'isort',
          'flake8',
          'mypy',
          'django-stubs']}

setup(name='django-ninja',
      version='0.12.3',
      description='Django Ninja - Fast Django REST framework',
      author='Vitaliy Kucheryaviy',
      author_email='ppr.vitaly@gmail.com',
      url='https://django-ninja.rest-framework.com',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
