import typing

import typing_extensions

@typing.type_check_only
class AcceleratorConfig(typing_extensions.TypedDict, total=False):
    coreCount: str
    type: typing_extensions.Literal[
        "ACCELERATOR_TYPE_UNSPECIFIED",
        "NVIDIA_TESLA_K80",
        "NVIDIA_TESLA_P100",
        "NVIDIA_TESLA_V100",
        "NVIDIA_TESLA_P4",
        "NVIDIA_TESLA_T4",
        "NVIDIA_TESLA_A100",
        "NVIDIA_TESLA_T4_VWS",
        "NVIDIA_TESLA_P100_VWS",
        "NVIDIA_TESLA_P4_VWS",
        "TPU_V2",
        "TPU_V3",
    ]

@typing.type_check_only
class Binding(typing_extensions.TypedDict, total=False):
    condition: Expr
    members: typing.List[str]
    role: str

@typing.type_check_only
class CancelOperationRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class ContainerImage(typing_extensions.TypedDict, total=False):
    repository: str
    tag: str

@typing.type_check_only
class DataprocParameters(typing_extensions.TypedDict, total=False):
    cluster: str

@typing.type_check_only
class Disk(typing_extensions.TypedDict, total=False):
    autoDelete: bool
    boot: bool
    deviceName: str
    diskSizeGb: str
    guestOsFeatures: typing.List[GuestOsFeature]
    index: str
    interface: str
    kind: str
    licenses: typing.List[str]
    mode: str
    source: str
    type: str

@typing.type_check_only
class Empty(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class EncryptionConfig(typing_extensions.TypedDict, total=False):
    kmsKey: str

@typing.type_check_only
class Environment(typing_extensions.TypedDict, total=False):
    containerImage: ContainerImage
    createTime: str
    description: str
    displayName: str
    name: str
    postStartupScript: str
    vmImage: VmImage

@typing.type_check_only
class Event(typing_extensions.TypedDict, total=False):
    reportTime: str
    type: typing_extensions.Literal["EVENT_TYPE_UNSPECIFIED", "IDLE"]

@typing.type_check_only
class Execution(typing_extensions.TypedDict, total=False):
    createTime: str
    description: str
    displayName: str
    executionTemplate: ExecutionTemplate
    jobUri: str
    name: str
    outputNotebookFile: str
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED",
        "QUEUED",
        "PREPARING",
        "RUNNING",
        "SUCCEEDED",
        "FAILED",
        "CANCELLING",
        "CANCELLED",
        "EXPIRED",
        "INITIALIZING",
    ]
    updateTime: str

@typing.type_check_only
class ExecutionTemplate(typing_extensions.TypedDict, total=False):
    acceleratorConfig: SchedulerAcceleratorConfig
    containerImageUri: str
    dataprocParameters: DataprocParameters
    inputNotebookFile: str
    jobType: typing_extensions.Literal["JOB_TYPE_UNSPECIFIED", "VERTEX_AI", "DATAPROC"]
    labels: typing.Dict[str, typing.Any]
    masterType: str
    outputNotebookFolder: str
    parameters: str
    paramsYamlFile: str
    scaleTier: typing_extensions.Literal[
        "SCALE_TIER_UNSPECIFIED",
        "BASIC",
        "STANDARD_1",
        "PREMIUM_1",
        "BASIC_GPU",
        "BASIC_TPU",
        "CUSTOM",
    ]
    serviceAccount: str

@typing.type_check_only
class Expr(typing_extensions.TypedDict, total=False):
    description: str
    expression: str
    location: str
    title: str

@typing.type_check_only
class GetInstanceHealthResponse(typing_extensions.TypedDict, total=False):
    healthInfo: typing.Dict[str, typing.Any]
    healthState: typing_extensions.Literal[
        "HEALTH_STATE_UNSPECIFIED",
        "HEALTHY",
        "UNHEALTHY",
        "AGENT_NOT_INSTALLED",
        "AGENT_NOT_RUNNING",
    ]

@typing.type_check_only
class GuestOsFeature(typing_extensions.TypedDict, total=False):
    type: str

@typing.type_check_only
class Instance(typing_extensions.TypedDict, total=False):
    acceleratorConfig: AcceleratorConfig
    bootDiskSizeGb: str
    bootDiskType: typing_extensions.Literal[
        "DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"
    ]
    containerImage: ContainerImage
    createTime: str
    customGpuDriverPath: str
    dataDiskSizeGb: str
    dataDiskType: typing_extensions.Literal[
        "DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"
    ]
    diskEncryption: typing_extensions.Literal[
        "DISK_ENCRYPTION_UNSPECIFIED", "GMEK", "CMEK"
    ]
    disks: typing.List[Disk]
    installGpuDriver: bool
    instanceOwners: typing.List[str]
    kmsKey: str
    labels: typing.Dict[str, typing.Any]
    machineType: str
    metadata: typing.Dict[str, typing.Any]
    name: str
    network: str
    nicType: typing_extensions.Literal["UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC"]
    noProxyAccess: bool
    noPublicIp: bool
    noRemoveDataDisk: bool
    postStartupScript: str
    proxyUri: str
    reservationAffinity: ReservationAffinity
    serviceAccount: str
    serviceAccountScopes: typing.List[str]
    shieldedInstanceConfig: ShieldedInstanceConfig
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED",
        "STARTING",
        "PROVISIONING",
        "ACTIVE",
        "STOPPING",
        "STOPPED",
        "DELETED",
        "UPGRADING",
        "INITIALIZING",
        "REGISTERING",
    ]
    subnet: str
    tags: typing.List[str]
    updateTime: str
    upgradeHistory: typing.List[UpgradeHistoryEntry]
    vmImage: VmImage

@typing.type_check_only
class InstanceConfig(typing_extensions.TypedDict, total=False):
    enableHealthMonitoring: bool
    notebookUpgradeSchedule: str

@typing.type_check_only
class IsInstanceUpgradeableResponse(typing_extensions.TypedDict, total=False):
    upgradeImage: str
    upgradeInfo: str
    upgradeVersion: str
    upgradeable: bool

@typing.type_check_only
class ListEnvironmentsResponse(typing_extensions.TypedDict, total=False):
    environments: typing.List[Environment]
    nextPageToken: str
    unreachable: typing.List[str]

@typing.type_check_only
class ListExecutionsResponse(typing_extensions.TypedDict, total=False):
    executions: typing.List[Execution]
    nextPageToken: str
    unreachable: typing.List[str]

@typing.type_check_only
class ListInstancesResponse(typing_extensions.TypedDict, total=False):
    instances: typing.List[Instance]
    nextPageToken: str
    unreachable: typing.List[str]

@typing.type_check_only
class ListLocationsResponse(typing_extensions.TypedDict, total=False):
    locations: typing.List[Location]
    nextPageToken: str

@typing.type_check_only
class ListOperationsResponse(typing_extensions.TypedDict, total=False):
    nextPageToken: str
    operations: typing.List[Operation]

@typing.type_check_only
class ListRuntimesResponse(typing_extensions.TypedDict, total=False):
    nextPageToken: str
    runtimes: typing.List[Runtime]
    unreachable: typing.List[str]

@typing.type_check_only
class ListSchedulesResponse(typing_extensions.TypedDict, total=False):
    nextPageToken: str
    schedules: typing.List[Schedule]
    unreachable: typing.List[str]

@typing.type_check_only
class LocalDisk(typing_extensions.TypedDict, total=False):
    autoDelete: bool
    boot: bool
    deviceName: str
    guestOsFeatures: typing.List[RuntimeGuestOsFeature]
    index: int
    initializeParams: LocalDiskInitializeParams
    interface: str
    kind: str
    licenses: typing.List[str]
    mode: str
    source: str
    type: str

@typing.type_check_only
class LocalDiskInitializeParams(typing_extensions.TypedDict, total=False):
    description: str
    diskName: str
    diskSizeGb: str
    diskType: typing_extensions.Literal[
        "DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"
    ]
    labels: typing.Dict[str, typing.Any]

@typing.type_check_only
class Location(typing_extensions.TypedDict, total=False):
    displayName: str
    labels: typing.Dict[str, typing.Any]
    locationId: str
    metadata: typing.Dict[str, typing.Any]
    name: str

@typing.type_check_only
class Operation(typing_extensions.TypedDict, total=False):
    done: bool
    error: Status
    metadata: typing.Dict[str, typing.Any]
    name: str
    response: typing.Dict[str, typing.Any]

@typing.type_check_only
class OperationMetadata(typing_extensions.TypedDict, total=False):
    apiVersion: str
    createTime: str
    endTime: str
    endpoint: str
    requestedCancellation: bool
    statusMessage: str
    target: str
    verb: str

@typing.type_check_only
class Policy(typing_extensions.TypedDict, total=False):
    bindings: typing.List[Binding]
    etag: str
    version: int

@typing.type_check_only
class RegisterInstanceRequest(typing_extensions.TypedDict, total=False):
    instanceId: str

@typing.type_check_only
class ReportInstanceInfoRequest(typing_extensions.TypedDict, total=False):
    metadata: typing.Dict[str, typing.Any]
    vmId: str

@typing.type_check_only
class ReportRuntimeEventRequest(typing_extensions.TypedDict, total=False):
    event: Event
    vmId: str

@typing.type_check_only
class ReservationAffinity(typing_extensions.TypedDict, total=False):
    consumeReservationType: typing_extensions.Literal[
        "TYPE_UNSPECIFIED", "NO_RESERVATION", "ANY_RESERVATION", "SPECIFIC_RESERVATION"
    ]
    key: str
    values: typing.List[str]

@typing.type_check_only
class ResetInstanceRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class ResetRuntimeRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class RollbackInstanceRequest(typing_extensions.TypedDict, total=False):
    targetSnapshot: str

@typing.type_check_only
class Runtime(typing_extensions.TypedDict, total=False):
    accessConfig: RuntimeAccessConfig
    createTime: str
    healthState: typing_extensions.Literal[
        "HEALTH_STATE_UNSPECIFIED", "HEALTHY", "UNHEALTHY"
    ]
    metrics: RuntimeMetrics
    name: str
    softwareConfig: RuntimeSoftwareConfig
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED",
        "STARTING",
        "PROVISIONING",
        "ACTIVE",
        "STOPPING",
        "STOPPED",
        "DELETING",
        "UPGRADING",
        "INITIALIZING",
    ]
    updateTime: str
    virtualMachine: VirtualMachine

@typing.type_check_only
class RuntimeAcceleratorConfig(typing_extensions.TypedDict, total=False):
    coreCount: str
    type: typing_extensions.Literal[
        "ACCELERATOR_TYPE_UNSPECIFIED",
        "NVIDIA_TESLA_K80",
        "NVIDIA_TESLA_P100",
        "NVIDIA_TESLA_V100",
        "NVIDIA_TESLA_P4",
        "NVIDIA_TESLA_T4",
        "NVIDIA_TESLA_A100",
        "TPU_V2",
        "TPU_V3",
        "NVIDIA_TESLA_T4_VWS",
        "NVIDIA_TESLA_P100_VWS",
        "NVIDIA_TESLA_P4_VWS",
    ]

@typing.type_check_only
class RuntimeAccessConfig(typing_extensions.TypedDict, total=False):
    accessType: typing_extensions.Literal[
        "RUNTIME_ACCESS_TYPE_UNSPECIFIED", "SINGLE_USER"
    ]
    proxyUri: str
    runtimeOwner: str

@typing.type_check_only
class RuntimeGuestOsFeature(typing_extensions.TypedDict, total=False):
    type: str

@typing.type_check_only
class RuntimeMetrics(typing_extensions.TypedDict, total=False):
    systemMetrics: typing.Dict[str, typing.Any]

@typing.type_check_only
class RuntimeShieldedInstanceConfig(typing_extensions.TypedDict, total=False):
    enableIntegrityMonitoring: bool
    enableSecureBoot: bool
    enableVtpm: bool

@typing.type_check_only
class RuntimeSoftwareConfig(typing_extensions.TypedDict, total=False):
    customGpuDriverPath: str
    enableHealthMonitoring: bool
    idleShutdown: bool
    idleShutdownTimeout: int
    installGpuDriver: bool
    notebookUpgradeSchedule: str
    postStartupScript: str

@typing.type_check_only
class Schedule(typing_extensions.TypedDict, total=False):
    createTime: str
    cronSchedule: str
    description: str
    displayName: str
    executionTemplate: ExecutionTemplate
    name: str
    recentExecutions: typing.List[Execution]
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED",
        "ENABLED",
        "PAUSED",
        "DISABLED",
        "UPDATE_FAILED",
        "INITIALIZING",
        "DELETING",
    ]
    timeZone: str
    updateTime: str

@typing.type_check_only
class SchedulerAcceleratorConfig(typing_extensions.TypedDict, total=False):
    coreCount: str
    type: typing_extensions.Literal[
        "SCHEDULER_ACCELERATOR_TYPE_UNSPECIFIED",
        "NVIDIA_TESLA_K80",
        "NVIDIA_TESLA_P100",
        "NVIDIA_TESLA_V100",
        "NVIDIA_TESLA_P4",
        "NVIDIA_TESLA_T4",
        "TPU_V2",
        "TPU_V3",
    ]

@typing.type_check_only
class SetIamPolicyRequest(typing_extensions.TypedDict, total=False):
    policy: Policy

@typing.type_check_only
class SetInstanceAcceleratorRequest(typing_extensions.TypedDict, total=False):
    coreCount: str
    type: typing_extensions.Literal[
        "ACCELERATOR_TYPE_UNSPECIFIED",
        "NVIDIA_TESLA_K80",
        "NVIDIA_TESLA_P100",
        "NVIDIA_TESLA_V100",
        "NVIDIA_TESLA_P4",
        "NVIDIA_TESLA_T4",
        "NVIDIA_TESLA_A100",
        "NVIDIA_TESLA_T4_VWS",
        "NVIDIA_TESLA_P100_VWS",
        "NVIDIA_TESLA_P4_VWS",
        "TPU_V2",
        "TPU_V3",
    ]

@typing.type_check_only
class SetInstanceLabelsRequest(typing_extensions.TypedDict, total=False):
    labels: typing.Dict[str, typing.Any]

@typing.type_check_only
class SetInstanceMachineTypeRequest(typing_extensions.TypedDict, total=False):
    machineType: str

@typing.type_check_only
class ShieldedInstanceConfig(typing_extensions.TypedDict, total=False):
    enableIntegrityMonitoring: bool
    enableSecureBoot: bool
    enableVtpm: bool

@typing.type_check_only
class StartInstanceRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class StartRuntimeRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class Status(typing_extensions.TypedDict, total=False):
    code: int
    details: typing.List[typing.Dict[str, typing.Any]]
    message: str

@typing.type_check_only
class StopInstanceRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class StopRuntimeRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class SwitchRuntimeRequest(typing_extensions.TypedDict, total=False):
    acceleratorConfig: RuntimeAcceleratorConfig
    machineType: str

@typing.type_check_only
class TestIamPermissionsRequest(typing_extensions.TypedDict, total=False):
    permissions: typing.List[str]

@typing.type_check_only
class TestIamPermissionsResponse(typing_extensions.TypedDict, total=False):
    permissions: typing.List[str]

@typing.type_check_only
class TriggerScheduleRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class UpdateInstanceConfigRequest(typing_extensions.TypedDict, total=False):
    config: InstanceConfig

@typing.type_check_only
class UpdateShieldedInstanceConfigRequest(typing_extensions.TypedDict, total=False):
    shieldedInstanceConfig: ShieldedInstanceConfig

@typing.type_check_only
class UpgradeHistoryEntry(typing_extensions.TypedDict, total=False):
    action: typing_extensions.Literal["ACTION_UNSPECIFIED", "UPGRADE", "ROLLBACK"]
    containerImage: str
    createTime: str
    framework: str
    snapshot: str
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED", "STARTED", "SUCCEEDED", "FAILED"
    ]
    targetImage: str
    targetVersion: str
    version: str
    vmImage: str

@typing.type_check_only
class UpgradeInstanceInternalRequest(typing_extensions.TypedDict, total=False):
    vmId: str

@typing.type_check_only
class UpgradeInstanceRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class VirtualMachine(typing_extensions.TypedDict, total=False):
    instanceId: str
    instanceName: str
    virtualMachineConfig: VirtualMachineConfig

@typing.type_check_only
class VirtualMachineConfig(typing_extensions.TypedDict, total=False):
    acceleratorConfig: RuntimeAcceleratorConfig
    containerImages: typing.List[ContainerImage]
    dataDisk: LocalDisk
    encryptionConfig: EncryptionConfig
    guestAttributes: typing.Dict[str, typing.Any]
    internalIpOnly: bool
    labels: typing.Dict[str, typing.Any]
    machineType: str
    metadata: typing.Dict[str, typing.Any]
    network: str
    nicType: typing_extensions.Literal["UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC"]
    shieldedInstanceConfig: RuntimeShieldedInstanceConfig
    subnet: str
    tags: typing.List[str]
    zone: str

@typing.type_check_only
class VmImage(typing_extensions.TypedDict, total=False):
    imageFamily: str
    imageName: str
    project: str
