import { JupyterFrontEnd } from '@jupyterlab/application';
import { ICommandPalette } from '@jupyterlab/apputils';
import { IStateDB } from '@jupyterlab/coreutils';
import { IFileBrowserFactory } from '@jupyterlab/filebrowser';
import { IGitExtension } from '@jupyterlab/git';
import { ILauncher } from '@jupyterlab/launcher';
import { IMainMenu } from '@jupyterlab/mainmenu';
import { IStatusBar } from '@jupyterlab/statusbar';
import { IEnvironmentManager } from 'jupyterlab_conda';
import { IProjectManager, Project, Templates } from './tokens';
/**
 * Build the project info from project model
 * @param project The project model
 * @returns The project info
 */
export declare function getProjectInfo(project: Project.IModel): Project.IInfo;
/**
 * Activate the project manager plugin
 *
 * @param app The application object
 * @param state The application state handler
 * @param browserFactory The file browser factory
 * @param settings The project template settings
 * @param palette The command palette
 * @param condaManager The Conda extension service
 * @param git The Git extension service
 * @param launcher The application launcher
 * @param menu The application menu
 * @param statusbar The application status bar
 */
export declare function activateProjectManager(app: JupyterFrontEnd, state: IStateDB, browserFactory: IFileBrowserFactory, settings: Templates.IProject, palette: ICommandPalette, condaManager: IEnvironmentManager | null, git: IGitExtension | null, launcher: ILauncher | null, menu: IMainMenu | null, statusbar: IStatusBar | null): IProjectManager;
