import { Project } from './tokens';
/**
 * Namespace of foreign command IDs used
 */
export declare namespace ForeignCommandIDs {
    const closeAll = "application:close-all";
    const documentOpen = "docmanager:open";
    const gitInit = "git:init";
    const goTo = "filebrowser:go-to-path";
    const openPath = "filebrowser:open-path";
    const saveAll = "docmanager:save-all";
}
/**
 * Rendered a templated string with project info
 *
 * The template key must be {{ jproject.property }}. And
 * the properties available are those of Project.IInfo
 *
 * @param template Templated string
 * @param project Project information
 * @returns The rendered string
 */
export declare function renderStringTemplate(template: string, project: Project.IModel | null): string;
