import * as cdk from '@aws-cdk/core';
/**
 * Properties for the S3 bucket.
 *
 * @stability stable
 */
export interface S3BucketProps {
    /**
     * The name of the S3 bucket.
     *
     * @stability stable
     */
    readonly bucketName?: string;
}
/**
 * Construct that configures an S3 bucket.
 *
 * Use this construct when you want to host Django media files
 * in S3 but you are not using AWS for hosting your main Django app.
 *
 * @stability stable
 */
export declare class S3BucketResources extends cdk.Construct {
    /**
     * @stability stable
     */
    bucketName?: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: S3BucketProps);
}
