"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
/**
 * Construct that configures an S3 bucket.
 *
 * Use this construct when you want to host Django media files
 * in S3 but you are not using AWS for hosting your main Django app.
 *
 * @stability stable
 */
class S3BucketResources extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        // bucket to be used for storing media files
        const bucket = new s3.Bucket(scope, 'S3Bucket', {
            bucketName: (_b = props.bucketName) !== null && _b !== void 0 ? _b : `media-storage-${id.toLocaleLowerCase()}`,
        });
        const user = new iam.User(scope, 'S3BucketUser');
        bucket.grantReadWrite(user);
        // bucket.grantReadWrite(user) essentially does the following:
        // const bucketPolicyStatement = new iam.PolicyStatement({
        //   effect: iam.Effect.ALLOW,
        //   actions: [
        //     "s3:PutObject",
        //     "s3:GetObjectAcl",
        //     "s3:GetObject",
        //     "s3:ListBucket",
        //     "s3:DeleteObject",
        //     "s3:PutObjectAcl"
        //   ],
        //   resources: [
        //     bucket.bucketArn + "/*",
        //     bucket.bucketArn,
        //   ],
        // });
        // user.addToPolicy(bucketPolicyStatement);
        // the name of the S3 bucket
        new cdk.CfnOutput(scope, 'S3BucketNameOutput', {
            value: bucket.bucketName,
        });
        // the name of the IAM user that will be used to access the bucket
        new cdk.CfnOutput(scope, 'S3BucketUserNameOuput', {
            value: user.userName,
        });
    }
}
exports.S3BucketResources = S3BucketResources;
_a = JSII_RTTI_SYMBOL_1;
S3BucketResources[_a] = { fqn: "django-cdk.S3BucketResources", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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