import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
export interface CeleryWorkerProps {
    readonly image: ecs.ContainerImage;
    readonly command: string[];
    readonly environment: {
        [key: string]: string;
    };
    readonly cluster: ecs.ICluster;
    readonly securityGroups: ec2.ISecurityGroup[];
    readonly dbSecret: secretsmanager.ISecret;
}
export declare class CeleryWorker extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: CeleryWorkerProps);
}
