"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CeleryWorker = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
class CeleryWorker extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const taskDefinition = new ecs.TaskDefinition(scope, `TaskDefinitionFor${id}`, {
            compatibility: ecs.Compatibility.FARGATE,
            cpu: '256',
            memoryMiB: '512',
        });
        /**
         * Allow the task definition's role to read the database secret
         */
        props.dbSecret.grantRead(taskDefinition.taskRole);
        taskDefinition.addContainer(`TaskContainerFor${id}`, {
            image: props.image,
            command: props.command,
            environment: props.environment,
            logging: ecs.LogDriver.awsLogs({
                logRetention: logs.RetentionDays.ONE_DAY,
                streamPrefix: `${id}Container`,
            }),
        });
        new ecs.FargateService(scope, `FargateService${id}`, {
            cluster: props.cluster,
            taskDefinition,
            desiredCount: 1,
            securityGroups: props.securityGroups,
        });
        // TODO: scaling options
    }
}
exports.CeleryWorker = CeleryWorker;
//# sourceMappingURL=data:application/json;base64,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