import { ISecurityGroup, IVpc } from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * Options to configure a Django Management Command Task
 */
export interface managementCommandTaskProps {
    readonly vpc: IVpc;
    readonly cluster: ecs.ICluster;
    /**
     * CDM passed to the Docker container
     */
    readonly command: string[];
    readonly bucketName?: string;
    readonly appSecurityGroup: ISecurityGroup;
    readonly image: ecs.ContainerImage;
    readonly environment: {
        [key: string]: string;
    };
    readonly dbSecret: secretsmanager.ISecret;
    /**
     * Whether or not to run task on deployment using a custom resource
     */
    readonly run?: boolean;
}
/**
 * This construct allows you to define and optionally run a one-off command
 * each time the stack is created or updated. A Custom Resource is used to
 * invoke the AWS SDK to run a task if `run` is set to `true`.
 */
export declare class managementCommandTask extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: managementCommandTaskProps);
}
