import * as eks from '@aws-cdk/aws-eks';
import * as cdk from '@aws-cdk/core';
/**
 * Props for AppIngressResources, used for annotating ingress with ACM cert ARN and domain name
 */
export interface AppIngressResourcesProps {
    /**
     * Domain name that will be created by external-dns
     */
    domainName: string;
    /**
     * EKS Cluster
     */
    cluster: eks.ICluster;
    /**
     * ACM Certificate that is either generated in the main stack or looked up by ARN
     */
    certificateArn?: string;
}
export declare class AppIngressResources extends cdk.Construct {
    ingressManifest: eks.KubernetesManifest;
    constructor(scope: cdk.Construct, id: string, props: AppIngressResourcesProps);
}
