"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppIngressResources = void 0;
const cdk = require("@aws-cdk/core");
class AppIngressResources extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Annotations for use with or with ACM Certificate
         */
        let annotations = {
            'kubernetes.io/ingress.class': 'alb',
            'alb.ingress.kubernetes.io/scheme': 'internet-facing',
            'alb.ingress.kubernetes.io/tags': 'Environment=test',
        };
        /**
         * Set up the annotations for use with ACM certificate
         */
        if (props.certificateArn) {
            Object.assign(annotations, {
                'alb.ingress.kubernetes.io/certificate-arn': props.certificateArn,
                'alb.ingress.kubernetes.io/ssl-policy': 'ELBSecurityPolicy-TLS-1-2-Ext-2018-06',
                'alb.ingress.kubernetes.io/listen-ports': '[{"HTTP": 80}, {"HTTPS": 443}]',
                'alb.ingress.kubernetes.io/actions.ssl-redirect': '{"Type": "redirect", "RedirectConfig": { "Protocol": "HTTPS", "Port": "443", "StatusCode": "HTTP_301"}}',
                'external-dns.alpha.kubernetes.io/hostname': props.domainName,
            });
        }
        /**
         * Ingress manfiest
         */
        const appIngress = {
            apiVersion: 'networking.k8s.io/v1',
            kind: 'Ingress',
            metadata: {
                name: 'app-ingress',
                namespace: 'app',
                annotations,
            },
            spec: {
                rules: [
                    {
                        http: {
                            paths: [
                                {
                                    path: '/',
                                    pathType: 'Prefix',
                                    backend: {
                                        service: {
                                            name: 'api-http',
                                            port: {
                                                number: 80,
                                            },
                                        },
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        };
        this.ingressManifest = props.cluster.addManifest('app-ingress', appIngress);
    }
}
exports.AppIngressResources = AppIngressResources;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvZWtzL3Jlc291cmNlcy9pbmdyZXNzL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHFDQUFxQztBQXNCckMsTUFBYSxtQkFBb0IsU0FBUSxHQUFHLENBQUMsU0FBUztJQUdwRCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQStCO1FBQzNFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakI7O1dBRUc7UUFDSCxJQUFJLFdBQVcsR0FBRztZQUNoQiw2QkFBNkIsRUFBRSxLQUFLO1lBQ3BDLGtDQUFrQyxFQUFFLGlCQUFpQjtZQUNyRCxnQ0FBZ0MsRUFBRSxrQkFBa0I7U0FDckQsQ0FBQztRQUVGOztXQUVHO1FBQ0gsSUFBSSxLQUFLLENBQUMsY0FBYyxFQUFFO1lBQ3hCLE1BQU0sQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFO2dCQUN6QiwyQ0FBMkMsRUFBRSxLQUFLLENBQUMsY0FBYztnQkFDakUsc0NBQXNDLEVBQUUsdUNBQXVDO2dCQUMvRSx3Q0FBd0MsRUFBRSxnQ0FBZ0M7Z0JBQzFFLGdEQUFnRCxFQUFFLHlHQUF5RztnQkFDM0osMkNBQTJDLEVBQUUsS0FBSyxDQUFDLFVBQVU7YUFDOUQsQ0FBQyxDQUFDO1NBQ0o7UUFFRDs7V0FFRztRQUNILE1BQU0sVUFBVSxHQUFHO1lBQ2pCLFVBQVUsRUFBRSxzQkFBc0I7WUFDbEMsSUFBSSxFQUFFLFNBQVM7WUFDZixRQUFRLEVBQUU7Z0JBQ1IsSUFBSSxFQUFFLGFBQWE7Z0JBQ25CLFNBQVMsRUFBRSxLQUFLO2dCQUNoQixXQUFXO2FBQ1o7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osS0FBSyxFQUFFO29CQUNMO3dCQUNFLElBQUksRUFBRTs0QkFDSixLQUFLLEVBQUU7Z0NBQ0w7b0NBQ0UsSUFBSSxFQUFFLEdBQUc7b0NBQ1QsUUFBUSxFQUFFLFFBQVE7b0NBQ2xCLE9BQU8sRUFBRTt3Q0FDUCxPQUFPLEVBQUU7NENBQ1AsSUFBSSxFQUFFLFVBQVU7NENBQ2hCLElBQUksRUFBRTtnREFDSixNQUFNLEVBQUUsRUFBRTs2Q0FDWDt5Q0FDRjtxQ0FJRjtpQ0FDRjs2QkFDRjt5QkFDRjtxQkFDRjtpQkFDRjthQUNGO1NBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBRTlFLENBQUM7Q0FDRjtBQXJFRCxrREFxRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBla3MgZnJvbSAnQGF3cy1jZGsvYXdzLWVrcyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogUHJvcHMgZm9yIEFwcEluZ3Jlc3NSZXNvdXJjZXMsIHVzZWQgZm9yIGFubm90YXRpbmcgaW5ncmVzcyB3aXRoIEFDTSBjZXJ0IEFSTiBhbmQgZG9tYWluIG5hbWVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBcHBJbmdyZXNzUmVzb3VyY2VzUHJvcHMge1xuICAvKipcbiAgICogRG9tYWluIG5hbWUgdGhhdCB3aWxsIGJlIGNyZWF0ZWQgYnkgZXh0ZXJuYWwtZG5zXG4gICAqL1xuICBkb21haW5OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEVLUyBDbHVzdGVyXG4gICAqL1xuICBjbHVzdGVyOiBla3MuSUNsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIEFDTSBDZXJ0aWZpY2F0ZSB0aGF0IGlzIGVpdGhlciBnZW5lcmF0ZWQgaW4gdGhlIG1haW4gc3RhY2sgb3IgbG9va2VkIHVwIGJ5IEFSTlxuICAgKi9cbiAgY2VydGlmaWNhdGVBcm4/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBBcHBJbmdyZXNzUmVzb3VyY2VzIGV4dGVuZHMgY2RrLkNvbnN0cnVjdCB7XG4gIHB1YmxpYyBpbmdyZXNzTWFuaWZlc3Q6IGVrcy5LdWJlcm5ldGVzTWFuaWZlc3Q7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBcHBJbmdyZXNzUmVzb3VyY2VzUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgLyoqXG4gICAgICogQW5ub3RhdGlvbnMgZm9yIHVzZSB3aXRoIG9yIHdpdGggQUNNIENlcnRpZmljYXRlXG4gICAgICovXG4gICAgbGV0IGFubm90YXRpb25zID0ge1xuICAgICAgJ2t1YmVybmV0ZXMuaW8vaW5ncmVzcy5jbGFzcyc6ICdhbGInLFxuICAgICAgJ2FsYi5pbmdyZXNzLmt1YmVybmV0ZXMuaW8vc2NoZW1lJzogJ2ludGVybmV0LWZhY2luZycsXG4gICAgICAnYWxiLmluZ3Jlc3Mua3ViZXJuZXRlcy5pby90YWdzJzogJ0Vudmlyb25tZW50PXRlc3QnLFxuICAgIH07XG5cbiAgICAvKipcbiAgICAgKiBTZXQgdXAgdGhlIGFubm90YXRpb25zIGZvciB1c2Ugd2l0aCBBQ00gY2VydGlmaWNhdGVcbiAgICAgKi9cbiAgICBpZiAocHJvcHMuY2VydGlmaWNhdGVBcm4pIHtcbiAgICAgIE9iamVjdC5hc3NpZ24oYW5ub3RhdGlvbnMsIHtcbiAgICAgICAgJ2FsYi5pbmdyZXNzLmt1YmVybmV0ZXMuaW8vY2VydGlmaWNhdGUtYXJuJzogcHJvcHMuY2VydGlmaWNhdGVBcm4sXG4gICAgICAgICdhbGIuaW5ncmVzcy5rdWJlcm5ldGVzLmlvL3NzbC1wb2xpY3knOiAnRUxCU2VjdXJpdHlQb2xpY3ktVExTLTEtMi1FeHQtMjAxOC0wNicsXG4gICAgICAgICdhbGIuaW5ncmVzcy5rdWJlcm5ldGVzLmlvL2xpc3Rlbi1wb3J0cyc6ICdbe1wiSFRUUFwiOiA4MH0sIHtcIkhUVFBTXCI6IDQ0M31dJyxcbiAgICAgICAgJ2FsYi5pbmdyZXNzLmt1YmVybmV0ZXMuaW8vYWN0aW9ucy5zc2wtcmVkaXJlY3QnOiAne1wiVHlwZVwiOiBcInJlZGlyZWN0XCIsIFwiUmVkaXJlY3RDb25maWdcIjogeyBcIlByb3RvY29sXCI6IFwiSFRUUFNcIiwgXCJQb3J0XCI6IFwiNDQzXCIsIFwiU3RhdHVzQ29kZVwiOiBcIkhUVFBfMzAxXCJ9fScsXG4gICAgICAgICdleHRlcm5hbC1kbnMuYWxwaGEua3ViZXJuZXRlcy5pby9ob3N0bmFtZSc6IHByb3BzLmRvbWFpbk5hbWUsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBJbmdyZXNzIG1hbmZpZXN0XG4gICAgICovXG4gICAgY29uc3QgYXBwSW5ncmVzcyA9IHtcbiAgICAgIGFwaVZlcnNpb246ICduZXR3b3JraW5nLms4cy5pby92MScsXG4gICAgICBraW5kOiAnSW5ncmVzcycsXG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBuYW1lOiAnYXBwLWluZ3Jlc3MnLFxuICAgICAgICBuYW1lc3BhY2U6ICdhcHAnLFxuICAgICAgICBhbm5vdGF0aW9ucyxcbiAgICAgIH0sXG4gICAgICBzcGVjOiB7XG4gICAgICAgIHJ1bGVzOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgaHR0cDoge1xuICAgICAgICAgICAgICBwYXRoczogW1xuICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgIHBhdGg6ICcvJyxcbiAgICAgICAgICAgICAgICAgIHBhdGhUeXBlOiAnUHJlZml4JyxcbiAgICAgICAgICAgICAgICAgIGJhY2tlbmQ6IHtcbiAgICAgICAgICAgICAgICAgICAgc2VydmljZToge1xuICAgICAgICAgICAgICAgICAgICAgIG5hbWU6ICdhcGktaHR0cCcsXG4gICAgICAgICAgICAgICAgICAgICAgcG9ydDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgbnVtYmVyOiA4MCxcbiAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAvLyBmb3IgdjFiZXRhMSwgdXNlIHRoZSBmb2xsb3dpbmdcbiAgICAgICAgICAgICAgICAgICAgLy8gc2VydmljZU5hbWU6ICdhcGktaHR0cCcsXG4gICAgICAgICAgICAgICAgICAgIC8vIHNlcnZpY2VQb3J0OiA4MCxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIHRoaXMuaW5ncmVzc01hbmlmZXN0ID0gcHJvcHMuY2x1c3Rlci5hZGRNYW5pZmVzdCgnYXBwLWluZ3Jlc3MnLCBhcHBJbmdyZXNzKTtcblxuICB9XG59XG5cbiJdfQ==