"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
const env = {
    region: process.env.AWS_DEFAULT_REGION || 'us-east-1',
    account: process.env.AWS_ACCOUNT_ID,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'DjangoEcsStack', { env });
const construct = new index_1.DjangoEcs(stack, 'DjangoEcsSample', {
    imageDirectory: './test/django-step-by-step/backend',
    webCommand: [
        './scripts/start_prod.sh',
    ],
    useCeleryBeat: true,
    domainName: process.env.DOMAIN_NAME,
});
/**
 * Add tagging for this construct and all child constructs
 */
cdk.Tags.of(construct).add('stack', 'DjangoEcsStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGphbmdvLWVjcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pbnRlZy9pbnRlZy5kamFuZ28tZWNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLG9DQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQixJQUFJLFdBQVc7SUFDckQsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsY0FBYztDQUNwQyxDQUFDO0FBRUYsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxnQkFBZ0IsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7QUFFNUQsTUFBTSxTQUFTLEdBQUcsSUFBSSxpQkFBUyxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUN4RCxjQUFjLEVBQUUsb0NBQW9DO0lBQ3BELFVBQVUsRUFBRTtRQUNWLHlCQUF5QjtLQUMxQjtJQUNELGFBQWEsRUFBRSxJQUFJO0lBQ25CLFVBQVUsRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLFdBQVc7Q0FFcEMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDSCxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLGdCQUFnQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBEamFuZ29FY3MgfSBmcm9tICcuLi9pbmRleCc7XG5cbmNvbnN0IGVudiA9IHtcbiAgcmVnaW9uOiBwcm9jZXNzLmVudi5BV1NfREVGQVVMVF9SRUdJT04gfHwgJ3VzLWVhc3QtMScsXG4gIGFjY291bnQ6IHByb2Nlc3MuZW52LkFXU19BQ0NPVU5UX0lELFxufTtcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdEamFuZ29FY3NTdGFjaycsIHsgZW52IH0pO1xuXG5jb25zdCBjb25zdHJ1Y3QgPSBuZXcgRGphbmdvRWNzKHN0YWNrLCAnRGphbmdvRWNzU2FtcGxlJywge1xuICBpbWFnZURpcmVjdG9yeTogJy4vdGVzdC9kamFuZ28tc3RlcC1ieS1zdGVwL2JhY2tlbmQnLFxuICB3ZWJDb21tYW5kOiBbXG4gICAgJy4vc2NyaXB0cy9zdGFydF9wcm9kLnNoJyxcbiAgXSxcbiAgdXNlQ2VsZXJ5QmVhdDogdHJ1ZSxcbiAgZG9tYWluTmFtZTogcHJvY2Vzcy5lbnYuRE9NQUlOX05BTUUsXG4gIC8vIGNlcnRpZmljYXRlQXJuOiBwcm9jZXNzLmVudi5DRVJUSUZJQ0FURV9BUk4sXG59KTtcblxuLyoqXG4gKiBBZGQgdGFnZ2luZyBmb3IgdGhpcyBjb25zdHJ1Y3QgYW5kIGFsbCBjaGlsZCBjb25zdHJ1Y3RzXG4gKi9cbmNkay5UYWdzLm9mKGNvbnN0cnVjdCkuYWRkKCdzdGFjaycsICdEamFuZ29FY3NTdGFjaycpO1xuIl19