"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
const env = {
    region: process.env.AWS_DEFAULT_REGION || 'us-east-1',
    account: process.env.AWS_ACCOUNT_ID,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'S3BucketResourcesStack', { env });
const construct = new index_1.S3BucketResources(stack, 'S3BucketResourcesExample', {
    bucketName: 'my-django-s3-bucket-example',
});
/**
 * Add tagging for this construct and all child constructs
 */
cdk.Tags.of(construct).add('stack', 'S3BucketResourcesExample');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGphbmdvLXMzLXN0b3JhZ2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW50ZWcvaW50ZWcuZGphbmdvLXMzLXN0b3JhZ2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBcUM7QUFDckMsb0NBQTZDO0FBRTdDLE1BQU0sR0FBRyxHQUFHO0lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLElBQUksV0FBVztJQUNyRCxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxjQUFjO0NBQ3BDLENBQUM7QUFFRixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLHdCQUF3QixFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUVwRSxNQUFNLFNBQVMsR0FBRyxJQUFJLHlCQUFpQixDQUFDLEtBQUssRUFBRSwwQkFBMEIsRUFBRTtJQUN6RSxVQUFVLEVBQUUsNkJBQTZCO0NBQzFDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ0gsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSwwQkFBMEIsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgUzNCdWNrZXRSZXNvdXJjZXMgfSBmcm9tICcuLi9pbmRleCc7XG5cbmNvbnN0IGVudiA9IHtcbiAgcmVnaW9uOiBwcm9jZXNzLmVudi5BV1NfREVGQVVMVF9SRUdJT04gfHwgJ3VzLWVhc3QtMScsXG4gIGFjY291bnQ6IHByb2Nlc3MuZW52LkFXU19BQ0NPVU5UX0lELFxufTtcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdTM0J1Y2tldFJlc291cmNlc1N0YWNrJywgeyBlbnYgfSk7XG5cbmNvbnN0IGNvbnN0cnVjdCA9IG5ldyBTM0J1Y2tldFJlc291cmNlcyhzdGFjaywgJ1MzQnVja2V0UmVzb3VyY2VzRXhhbXBsZScsIHtcbiAgYnVja2V0TmFtZTogJ215LWRqYW5nby1zMy1idWNrZXQtZXhhbXBsZScsXG59KTtcblxuLyoqXG4gKiBBZGQgdGFnZ2luZyBmb3IgdGhpcyBjb25zdHJ1Y3QgYW5kIGFsbCBjaGlsZCBjb25zdHJ1Y3RzXG4gKi9cbmNkay5UYWdzLm9mKGNvbnN0cnVjdCkuYWRkKCdzdGFjaycsICdTM0J1Y2tldFJlc291cmNlc0V4YW1wbGUnKTtcbiJdfQ==