# coding: utf-8

"""
    CMS Contribution API

    The CMS Contribution API allows access and modification of Lumapps contents.   # noqa: E501

    OpenAPI spec version: 0.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

from .base_block import BaseBlock  # noqa: F401,E501


class BlockDirectoryEntry(BaseBlock):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "directory_entry_id": "str",
        "directory_id": "str",
        "title": "str",
        "tags": "BlockTagReferenceList",
        "link": "str",
        "image": "BlockImage",
        "variant": "str",
        "is_favorite": "bool",
        "is_favorite_icon_visible": "bool",
        "metadata": "list[MetadataReference]",
    }
    if hasattr(BaseBlock, "swagger_types"):
        swagger_types.update(BaseBlock.swagger_types)

    attribute_map = {
        "directory_entry_id": "directoryEntryId",
        "directory_id": "directoryId",
        "title": "title",
        "tags": "tags",
        "link": "link",
        "image": "image",
        "variant": "variant",
        "is_favorite": "isFavorite",
        "is_favorite_icon_visible": "isFavoriteIconVisible",
        "metadata": "metadata",
    }
    if hasattr(BaseBlock, "attribute_map"):
        attribute_map.update(BaseBlock.attribute_map)

    def __init__(
        self,
        directory_entry_id=None,
        directory_id=None,
        title=None,
        tags=None,
        link=None,
        image=None,
        variant=None,
        is_favorite=None,
        is_favorite_icon_visible=None,
        metadata=None,
        *args,
        **kwargs
    ):  # noqa: E501
        """BlockDirectoryEntry - a model defined in Swagger"""  # noqa: E501
        self._directory_entry_id = None
        self._directory_id = None
        self._title = None
        self._tags = None
        self._link = None
        self._image = None
        self._variant = None
        self._is_favorite = None
        self._is_favorite_icon_visible = None
        self._metadata = None
        self.discriminator = None
        self.directory_entry_id = directory_entry_id
        self.directory_id = directory_id
        if title is not None:
            self.title = title
        if tags is not None:
            self.tags = tags
        self.link = link
        if image is not None:
            self.image = image
        self.variant = variant
        self.is_favorite = is_favorite
        self.is_favorite_icon_visible = is_favorite_icon_visible
        if metadata is not None:
            self.metadata = metadata
        BaseBlock.__init__(self, *args, **kwargs)

    @property
    def directory_entry_id(self):
        """Gets the directory_entry_id of this BlockDirectoryEntry.  # noqa: E501

        The entry's id.  # noqa: E501

        :return: The directory_entry_id of this BlockDirectoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._directory_entry_id

    @directory_entry_id.setter
    def directory_entry_id(self, directory_entry_id):
        """Sets the directory_entry_id of this BlockDirectoryEntry.

        The entry's id.  # noqa: E501

        :param directory_entry_id: The directory_entry_id of this BlockDirectoryEntry.  # noqa: E501
        :type: str
        """
        if directory_entry_id is None:
            raise ValueError(
                "Invalid value for `directory_entry_id`, must not be `None`"
            )  # noqa: E501

        self._directory_entry_id = directory_entry_id

    @property
    def directory_id(self):
        """Gets the directory_id of this BlockDirectoryEntry.  # noqa: E501

        The id of the directory to which this entry belongs.  # noqa: E501

        :return: The directory_id of this BlockDirectoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._directory_id

    @directory_id.setter
    def directory_id(self, directory_id):
        """Sets the directory_id of this BlockDirectoryEntry.

        The id of the directory to which this entry belongs.  # noqa: E501

        :param directory_id: The directory_id of this BlockDirectoryEntry.  # noqa: E501
        :type: str
        """
        if directory_id is None:
            raise ValueError(
                "Invalid value for `directory_id`, must not be `None`"
            )  # noqa: E501

        self._directory_id = directory_id

    @property
    def title(self):
        """Gets the title of this BlockDirectoryEntry.  # noqa: E501

        The entry's title.  # noqa: E501

        :return: The title of this BlockDirectoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this BlockDirectoryEntry.

        The entry's title.  # noqa: E501

        :param title: The title of this BlockDirectoryEntry.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def tags(self):
        """Gets the tags of this BlockDirectoryEntry.  # noqa: E501


        :return: The tags of this BlockDirectoryEntry.  # noqa: E501
        :rtype: BlockTagReferenceList
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this BlockDirectoryEntry.


        :param tags: The tags of this BlockDirectoryEntry.  # noqa: E501
        :type: BlockTagReferenceList
        """

        self._tags = tags

    @property
    def link(self):
        """Gets the link of this BlockDirectoryEntry.  # noqa: E501

        The entry's url.  # noqa: E501

        :return: The link of this BlockDirectoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._link

    @link.setter
    def link(self, link):
        """Sets the link of this BlockDirectoryEntry.

        The entry's url.  # noqa: E501

        :param link: The link of this BlockDirectoryEntry.  # noqa: E501
        :type: str
        """
        if link is None:
            raise ValueError(
                "Invalid value for `link`, must not be `None`"
            )  # noqa: E501

        self._link = link

    @property
    def image(self):
        """Gets the image of this BlockDirectoryEntry.  # noqa: E501


        :return: The image of this BlockDirectoryEntry.  # noqa: E501
        :rtype: BlockImage
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this BlockDirectoryEntry.


        :param image: The image of this BlockDirectoryEntry.  # noqa: E501
        :type: BlockImage
        """

        self._image = image

    @property
    def variant(self):
        """Gets the variant of this BlockDirectoryEntry.  # noqa: E501


        :return: The variant of this BlockDirectoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._variant

    @variant.setter
    def variant(self, variant):
        """Sets the variant of this BlockDirectoryEntry.


        :param variant: The variant of this BlockDirectoryEntry.  # noqa: E501
        :type: str
        """
        if variant is None:
            raise ValueError(
                "Invalid value for `variant`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["VERTICAL", "HORIZONTAL"]  # noqa: E501
        if variant not in allowed_values:
            raise ValueError(
                "Invalid value for `variant` ({0}), must be one of {1}".format(  # noqa: E501
                    variant, allowed_values
                )
            )

        self._variant = variant

    @property
    def is_favorite(self):
        """Gets the is_favorite of this BlockDirectoryEntry.  # noqa: E501

        Whether the current user has added the entry to his favorites.  # noqa: E501

        :return: The is_favorite of this BlockDirectoryEntry.  # noqa: E501
        :rtype: bool
        """
        return self._is_favorite

    @is_favorite.setter
    def is_favorite(self, is_favorite):
        """Sets the is_favorite of this BlockDirectoryEntry.

        Whether the current user has added the entry to his favorites.  # noqa: E501

        :param is_favorite: The is_favorite of this BlockDirectoryEntry.  # noqa: E501
        :type: bool
        """
        if is_favorite is None:
            raise ValueError(
                "Invalid value for `is_favorite`, must not be `None`"
            )  # noqa: E501

        self._is_favorite = is_favorite

    @property
    def is_favorite_icon_visible(self):
        """Gets the is_favorite_icon_visible of this BlockDirectoryEntry.  # noqa: E501

        Whether the favorite icon is visible.  # noqa: E501

        :return: The is_favorite_icon_visible of this BlockDirectoryEntry.  # noqa: E501
        :rtype: bool
        """
        return self._is_favorite_icon_visible

    @is_favorite_icon_visible.setter
    def is_favorite_icon_visible(self, is_favorite_icon_visible):
        """Sets the is_favorite_icon_visible of this BlockDirectoryEntry.

        Whether the favorite icon is visible.  # noqa: E501

        :param is_favorite_icon_visible: The is_favorite_icon_visible of this BlockDirectoryEntry.  # noqa: E501
        :type: bool
        """
        if is_favorite_icon_visible is None:
            raise ValueError(
                "Invalid value for `is_favorite_icon_visible`, must not be `None`"
            )  # noqa: E501

        self._is_favorite_icon_visible = is_favorite_icon_visible

    @property
    def metadata(self):
        """Gets the metadata of this BlockDirectoryEntry.  # noqa: E501


        :return: The metadata of this BlockDirectoryEntry.  # noqa: E501
        :rtype: list[MetadataReference]
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this BlockDirectoryEntry.


        :param metadata: The metadata of this BlockDirectoryEntry.  # noqa: E501
        :type: list[MetadataReference]
        """

        self._metadata = metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(BlockDirectoryEntry, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockDirectoryEntry):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
