# coding: utf-8

"""
    CMS Contribution API

    The CMS Contribution API allows access and modification of Lumapps contents.   # noqa: E501

    OpenAPI spec version: 0.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

from .base_block import BaseBlock  # noqa: F401,E501


class BlockImage(BaseBlock):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "url": "str",
        "focal_x": "float",
        "focal_y": "float",
        "crop_x": "int",
        "crop_y": "int",
        "height": "int",
        "width": "int",
        "scale_x": "float",
        "scale_y": "float",
        "rotate": "float",
        "fit": "str",
        "cover_ratio": "str",
        "corner_variant": "str",
    }
    if hasattr(BaseBlock, "swagger_types"):
        swagger_types.update(BaseBlock.swagger_types)

    attribute_map = {
        "url": "url",
        "focal_x": "focalX",
        "focal_y": "focalY",
        "crop_x": "cropX",
        "crop_y": "cropY",
        "height": "height",
        "width": "width",
        "scale_x": "scaleX",
        "scale_y": "scaleY",
        "rotate": "rotate",
        "fit": "fit",
        "cover_ratio": "coverRatio",
        "corner_variant": "cornerVariant",
    }
    if hasattr(BaseBlock, "attribute_map"):
        attribute_map.update(BaseBlock.attribute_map)

    def __init__(
        self,
        url=None,
        focal_x=None,
        focal_y=None,
        crop_x=None,
        crop_y=None,
        height=None,
        width=None,
        scale_x=None,
        scale_y=None,
        rotate=None,
        fit=None,
        cover_ratio=None,
        corner_variant=None,
        *args,
        **kwargs
    ):  # noqa: E501
        """BlockImage - a model defined in Swagger"""  # noqa: E501
        self._url = None
        self._focal_x = None
        self._focal_y = None
        self._crop_x = None
        self._crop_y = None
        self._height = None
        self._width = None
        self._scale_x = None
        self._scale_y = None
        self._rotate = None
        self._fit = None
        self._cover_ratio = None
        self._corner_variant = None
        self.discriminator = None
        self.url = url
        if focal_x is not None:
            self.focal_x = focal_x
        if focal_y is not None:
            self.focal_y = focal_y
        if crop_x is not None:
            self.crop_x = crop_x
        if crop_y is not None:
            self.crop_y = crop_y
        if height is not None:
            self.height = height
        if width is not None:
            self.width = width
        if scale_x is not None:
            self.scale_x = scale_x
        if scale_y is not None:
            self.scale_y = scale_y
        if rotate is not None:
            self.rotate = rotate
        if fit is not None:
            self.fit = fit
        if cover_ratio is not None:
            self.cover_ratio = cover_ratio
        if corner_variant is not None:
            self.corner_variant = corner_variant
        BaseBlock.__init__(self, *args, **kwargs)

    @property
    def url(self):
        """Gets the url of this BlockImage.  # noqa: E501

        The url of the image.  # noqa: E501

        :return: The url of this BlockImage.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this BlockImage.

        The url of the image.  # noqa: E501

        :param url: The url of this BlockImage.  # noqa: E501
        :type: str
        """
        if url is None:
            raise ValueError(
                "Invalid value for `url`, must not be `None`"
            )  # noqa: E501

        self._url = url

    @property
    def focal_x(self):
        """Gets the focal_x of this BlockImage.  # noqa: E501

        The X ratio of the focal point in the image.  # noqa: E501

        :return: The focal_x of this BlockImage.  # noqa: E501
        :rtype: float
        """
        return self._focal_x

    @focal_x.setter
    def focal_x(self, focal_x):
        """Sets the focal_x of this BlockImage.

        The X ratio of the focal point in the image.  # noqa: E501

        :param focal_x: The focal_x of this BlockImage.  # noqa: E501
        :type: float
        """

        self._focal_x = focal_x

    @property
    def focal_y(self):
        """Gets the focal_y of this BlockImage.  # noqa: E501

        The Y ratio of the focal point in the image.  # noqa: E501

        :return: The focal_y of this BlockImage.  # noqa: E501
        :rtype: float
        """
        return self._focal_y

    @focal_y.setter
    def focal_y(self, focal_y):
        """Sets the focal_y of this BlockImage.

        The Y ratio of the focal point in the image.  # noqa: E501

        :param focal_y: The focal_y of this BlockImage.  # noqa: E501
        :type: float
        """

        self._focal_y = focal_y

    @property
    def crop_x(self):
        """Gets the crop_x of this BlockImage.  # noqa: E501

        The X coordinate of the origin point of the cropped area (in pixels).  # noqa: E501

        :return: The crop_x of this BlockImage.  # noqa: E501
        :rtype: int
        """
        return self._crop_x

    @crop_x.setter
    def crop_x(self, crop_x):
        """Sets the crop_x of this BlockImage.

        The X coordinate of the origin point of the cropped area (in pixels).  # noqa: E501

        :param crop_x: The crop_x of this BlockImage.  # noqa: E501
        :type: int
        """

        self._crop_x = crop_x

    @property
    def crop_y(self):
        """Gets the crop_y of this BlockImage.  # noqa: E501

        The Y coordinate of the origin point of the cropped area (in pixels).  # noqa: E501

        :return: The crop_y of this BlockImage.  # noqa: E501
        :rtype: int
        """
        return self._crop_y

    @crop_y.setter
    def crop_y(self, crop_y):
        """Sets the crop_y of this BlockImage.

        The Y coordinate of the origin point of the cropped area (in pixels).  # noqa: E501

        :param crop_y: The crop_y of this BlockImage.  # noqa: E501
        :type: int
        """

        self._crop_y = crop_y

    @property
    def height(self):
        """Gets the height of this BlockImage.  # noqa: E501

        The height of the cropped area (in pixels).  # noqa: E501

        :return: The height of this BlockImage.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this BlockImage.

        The height of the cropped area (in pixels).  # noqa: E501

        :param height: The height of this BlockImage.  # noqa: E501
        :type: int
        """

        self._height = height

    @property
    def width(self):
        """Gets the width of this BlockImage.  # noqa: E501

        The width of the cropped area (in pixels).  # noqa: E501

        :return: The width of this BlockImage.  # noqa: E501
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this BlockImage.

        The width of the cropped area (in pixels).  # noqa: E501

        :param width: The width of this BlockImage.  # noqa: E501
        :type: int
        """

        self._width = width

    @property
    def scale_x(self):
        """Gets the scale_x of this BlockImage.  # noqa: E501

        The scaling along the X axis.  # noqa: E501

        :return: The scale_x of this BlockImage.  # noqa: E501
        :rtype: float
        """
        return self._scale_x

    @scale_x.setter
    def scale_x(self, scale_x):
        """Sets the scale_x of this BlockImage.

        The scaling along the X axis.  # noqa: E501

        :param scale_x: The scale_x of this BlockImage.  # noqa: E501
        :type: float
        """

        self._scale_x = scale_x

    @property
    def scale_y(self):
        """Gets the scale_y of this BlockImage.  # noqa: E501

        The scaling along the Y axis.  # noqa: E501

        :return: The scale_y of this BlockImage.  # noqa: E501
        :rtype: float
        """
        return self._scale_y

    @scale_y.setter
    def scale_y(self, scale_y):
        """Sets the scale_y of this BlockImage.

        The scaling along the Y axis.  # noqa: E501

        :param scale_y: The scale_y of this BlockImage.  # noqa: E501
        :type: float
        """

        self._scale_y = scale_y

    @property
    def rotate(self):
        """Gets the rotate of this BlockImage.  # noqa: E501

        The image rotation (in degrees).  # noqa: E501

        :return: The rotate of this BlockImage.  # noqa: E501
        :rtype: float
        """
        return self._rotate

    @rotate.setter
    def rotate(self, rotate):
        """Sets the rotate of this BlockImage.

        The image rotation (in degrees).  # noqa: E501

        :param rotate: The rotate of this BlockImage.  # noqa: E501
        :type: float
        """

        self._rotate = rotate

    @property
    def fit(self):
        """Gets the fit of this BlockImage.  # noqa: E501

        The fit to use when displaying this image.  # noqa: E501

        :return: The fit of this BlockImage.  # noqa: E501
        :rtype: str
        """
        return self._fit

    @fit.setter
    def fit(self, fit):
        """Sets the fit of this BlockImage.

        The fit to use when displaying this image.  # noqa: E501

        :param fit: The fit of this BlockImage.  # noqa: E501
        :type: str
        """
        allowed_values = ["contain", "cover"]  # noqa: E501
        if fit not in allowed_values:
            raise ValueError(
                "Invalid value for `fit` ({0}), must be one of {1}".format(  # noqa: E501
                    fit, allowed_values
                )
            )

        self._fit = fit

    @property
    def cover_ratio(self):
        """Gets the cover_ratio of this BlockImage.  # noqa: E501

        The ratio to use when displaying the image in cover mode only.  # noqa: E501

        :return: The cover_ratio of this BlockImage.  # noqa: E501
        :rtype: str
        """
        return self._cover_ratio

    @cover_ratio.setter
    def cover_ratio(self, cover_ratio):
        """Sets the cover_ratio of this BlockImage.

        The ratio to use when displaying the image in cover mode only.  # noqa: E501

        :param cover_ratio: The cover_ratio of this BlockImage.  # noqa: E501
        :type: str
        """
        allowed_values = [
            "original",
            "horizontal",
            "vertical",
            "square",
            "free",
            "wide",
        ]  # noqa: E501
        if cover_ratio not in allowed_values:
            raise ValueError(
                "Invalid value for `cover_ratio` ({0}), must be one of {1}".format(  # noqa: E501
                    cover_ratio, allowed_values
                )
            )

        self._cover_ratio = cover_ratio

    @property
    def corner_variant(self):
        """Gets the corner_variant of this BlockImage.  # noqa: E501

        The corner type.  # noqa: E501

        :return: The corner_variant of this BlockImage.  # noqa: E501
        :rtype: str
        """
        return self._corner_variant

    @corner_variant.setter
    def corner_variant(self, corner_variant):
        """Sets the corner_variant of this BlockImage.

        The corner type.  # noqa: E501

        :param corner_variant: The corner_variant of this BlockImage.  # noqa: E501
        :type: str
        """
        allowed_values = ["squared", "rounded"]  # noqa: E501
        if corner_variant not in allowed_values:
            raise ValueError(
                "Invalid value for `corner_variant` ({0}), must be one of {1}".format(  # noqa: E501
                    corner_variant, allowed_values
                )
            )

        self._corner_variant = corner_variant

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(BlockImage, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockImage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
