interface PackageTagBase {
    /**
     * (experimental) The label for the tag being applied.
     *
     * @experimental
     */
    readonly label: string;
    /**
     * (experimental) The hex value string for the color of the tag when displayed.
     *
     * @experimental
     */
    readonly color?: string;
}
/**
 * (experimental) Configuration for applying custom tags to relevant packages.
 *
 * Custom tags are
 * displayed on the package details page, and can be used for searching.
 *
 * @experimental
 */
export interface PackageTag extends PackageTagBase {
    /**
     * (experimental) The description of the logic that dictates whether the package has the tag applied.
     *
     * @experimental
     */
    readonly condition: TagCondition;
}
/**
 * (experimental) Serialized config for a tag condition.
 *
 * @experimental
 */
export interface TagConditionConfig {
    /**
     * @experimental
     */
    readonly type: TagConditionLogicType;
    /**
     * @experimental
     */
    readonly key?: string[];
    /**
     * @experimental
     */
    readonly value?: string;
    /**
     * @experimental
     */
    readonly children?: TagConditionConfig[];
}
/**
 * (experimental) Serialized tag declaration to be passed to lambdas via environment variables.
 *
 * @experimental
 */
export interface PackageTagConfig extends PackageTagBase {
    /**
     * @experimental
     */
    readonly condition: TagConditionConfig;
}
/**
 * (experimental) Condition for applying a custom tag to a package.
 *
 * @experimental
 */
export declare abstract class TagCondition {
    /**
     * (experimental) Create an && condition which applies only when all condition arguments are true.
     *
     * @experimental
     */
    static and(...conds: TagCondition[]): TagCondition;
    /**
     * (experimental) Create an || condition which applies if any of the condition arguments are true.
     *
     * @experimental
     */
    static or(...conds: TagCondition[]): TagCondition;
    /**
     * (experimental) Create a !
     *
     * condition which applies if the condition argument is false
     *
     * @experimental
     */
    static not(...conds: TagCondition[]): TagCondition;
    /**
     * (experimental) Target a field within the `package.json` to assert against. Nested fields can be accessed by passing multiple keys. `TagCondition.field('key1', 'key2')` will access `packageJson?.key1?.key2`.
     *
     * @experimental
     */
    static field(...keys: string[]): TagConditionField;
    /**
     * @experimental
     */
    abstract bind(): TagConditionConfig;
}
/**
 * (experimental) Logic operators for performing specific conditional logic.
 *
 * @experimental
 */
export declare enum TagConditionLogicType {
    /**
     * @experimental
     */
    AND = "AND",
    /**
     * @experimental
     */
    OR = "OR",
    /**
     * @experimental
     */
    NOT = "NOT",
    /**
     * @experimental
     */
    EQUALS = "EQUALS"
}
/**
 * (experimental) Target a field to use in logic to dictate whether a tag is relevant.
 *
 * @experimental
 */
export declare class TagConditionField {
    private readonly field;
    /**
     * @experimental
     */
    constructor(field: string[]);
    /**
     * (experimental) Create a === condition which applies if the specified field within the package's package.json is equal to the passed value.
     *
     * @experimental
     */
    eq(value: any): TagCondition;
}
export {};
