# coding=utf-8
"""
pygame-menu
https://github.com/ppizarror/pygame-menu

CONFIG
Default menu settings.

NOTE: pygame-menu v2 will not provide new widgets or functionalities, consider
upgrading to the lastest version.

License:
-------------------------------------------------------------------------------
The MIT License (MIT)
Copyright 2017-2020 Pablo Pizarro R. @ppizarror

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software
is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
-------------------------------------------------------------------------------
"""

from pygameMenu.locals import POSITION_NORTHWEST as _POSITION_NORTHWEST

"""
Menu object configuration
"""
MENU_ALPHA = 90  # Alpha of menu color, 0: Opaque, 255: Transparent
MENU_BGCOLOR = (0, 0, 0)  # Background color of Menu
MENU_DRAW_X = 50  # Upper-left X-Position of objects into Menu (%)
MENU_DRAW_Y = 60  # Upper-left Y-Position of objects into Menu (%)
MENU_FONT_COLOR = (255, 255, 255)  # Font color
MENU_FONT_SIZE = 40  # Font size of entries
MENU_FONT_SIZE_TITLE = 50  # Menu font size title
MENU_HEIGHT = 400  # Menu height (px)
MENU_OPTION_MARGIN = 15  # Option margin (px)
MENU_OPTION_SHADOW = False  # Indicates if a shadow is drawn on selected option
MENU_SELECTED_DRAW = True  # Indicates if rectangle is drawn on a selected item
MENU_SELECTED_WIDTH = 1  # Width of selected item
MENU_SELECTEDCOLOR = (180, 180, 180)  # Color of selected item
MENU_SHADOW_COLOR = (0, 0, 0)  # Shadow color
MENU_SHADOW_OFFSET = 2  # Shadow offset (px)
MENU_SHADOW_POSITION = _POSITION_NORTHWEST  # Shadow position
MENU_TITLE_BG_COLOR = (170, 65, 50)  # Background color
MENU_WIDTH = 600  # Width of Menu (px)

"""
TextMenu configuration
"""
MENU_FONT_TEXT_SIZE = 25  # Text size
TEXT_DRAW_X = 2.5  # X-Axis margin of text (%)
TEXT_FONT_COLOR = (255, 255, 255)  # Text font color
TEXT_MARGIN = 10  # Text margin (px)
