"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is a Lambda proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["LAMBDA_PROXY"] = "AWS_PROXY";
    /**
     * Integration type is an HTTP proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            payloadFormatVersion: (_a = props.payloadFormatVersion) === null || _a === void 0 ? void 0 : _a.version,
        });
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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