"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const integration_1 = require("../integration");
const route_1 = require("../route");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(_) {
        var _a;
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : route_1.HttpMethod.ANY,
            payloadFormatVersion: integration_1.PayloadFormatVersion.VERSION_1_0,
            type: integration_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.props.url,
        };
    }
}
exports.HttpProxyIntegration = HttpProxyIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImh0dHAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnREFBOEg7QUFDOUgsb0NBQWtEO0FBa0JsRDs7R0FFRztBQUNILE1BQWEsb0JBQW9CO0lBQy9CLFlBQTZCLEtBQWdDO1FBQWhDLFVBQUssR0FBTCxLQUFLLENBQTJCO0lBQzdELENBQUM7SUFFTSxJQUFJLENBQUMsQ0FBYTs7UUFDdkIsT0FBTztZQUNMLE1BQU0sUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sbUNBQUksa0JBQVUsQ0FBQyxHQUFHO1lBQzNDLG9CQUFvQixFQUFFLGtDQUFvQixDQUFDLFdBQVc7WUFDdEQsSUFBSSxFQUFFLGlDQUFtQixDQUFDLFVBQVU7WUFDcEMsR0FBRyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRztTQUNwQixDQUFDO0lBQ0osQ0FBQztDQUNGO0FBWkQsb0RBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBIdHRwSW50ZWdyYXRpb25UeXBlLCBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZywgSUh0dHBSb3V0ZUludGVncmF0aW9uLCBQYXlsb2FkRm9ybWF0VmVyc2lvbiB9IGZyb20gJy4uL2ludGVncmF0aW9uJztcbmltcG9ydCB7IEh0dHBNZXRob2QsIElIdHRwUm91dGUgfSBmcm9tICcuLi9yb3V0ZSc7XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGEgbmV3IGBIdHRwUHJveHlJbnRlZ3JhdGlvbmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFByb3h5SW50ZWdyYXRpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgZnVsbC1xdWFsaWZpZWQgSFRUUCBVUkwgZm9yIHRoZSBIVFRQIGludGVncmF0aW9uXG4gICAqL1xuICByZWFkb25seSB1cmw6IHN0cmluZ1xuXG4gIC8qKlxuICAgKiBUaGUgSFRUUCBtZXRob2QgdGhhdCBtdXN0IGJlIHVzZWQgdG8gaW52b2tlIHRoZSB1bmRlcmx5aW5nIEhUVFAgcHJveHkuXG4gICAqIEBkZWZhdWx0IEh0dHBNZXRob2QuQU5ZXG4gICAqL1xuICByZWFkb25seSBtZXRob2Q/OiBIdHRwTWV0aG9kO1xufVxuXG4vKipcbiAqIFRoZSBIVFRQIFByb3h5IGludGVncmF0aW9uIHJlc291cmNlIGZvciBIVFRQIEFQSVxuICovXG5leHBvcnQgY2xhc3MgSHR0cFByb3h5SW50ZWdyYXRpb24gaW1wbGVtZW50cyBJSHR0cFJvdXRlSW50ZWdyYXRpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBIdHRwUHJveHlJbnRlZ3JhdGlvblByb3BzKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfOiBJSHR0cFJvdXRlKTogSHR0cFJvdXRlSW50ZWdyYXRpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBtZXRob2Q6IHRoaXMucHJvcHMubWV0aG9kID8/IEh0dHBNZXRob2QuQU5ZLFxuICAgICAgcGF5bG9hZEZvcm1hdFZlcnNpb246IFBheWxvYWRGb3JtYXRWZXJzaW9uLlZFUlNJT05fMV8wLCAvLyAxLjAgaXMgcmVxdWlyZWQgYW5kIGlzIHRoZSBvbmx5IHN1cHBvcnRlZCBmb3JtYXRcbiAgICAgIHR5cGU6IEh0dHBJbnRlZ3JhdGlvblR5cGUuSFRUUF9QUk9YWSxcbiAgICAgIHVyaTogdGhpcy5wcm9wcy51cmwsXG4gICAgfTtcbiAgfVxufSJdfQ==