"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const integration_1 = require("../integration");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class LambdaProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(route) {
        var _a, _b;
        this.props.handler.addPermission(`${route.node.uniqueId}-Permission`, {
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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