"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const DEFAULT_STAGE_NAME = '$default';
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class HttpStage extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName ? props.stageName : DEFAULT_STAGE_NAME,
        });
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        this.stageName = this.physicalName;
        this.httpApi = props.httpApi;
    }
    /**
     * Import an existing stage into this CDK app.
     */
    static fromStageName(scope, id, stageName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.stageName = stageName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * The URL to this stage.
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName === DEFAULT_STAGE_NAME ? '' : this.stageName;
        return `https://${this.httpApi.httpApiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
}
exports.HttpStage = HttpStage;
//# sourceMappingURL=data:application/json;base64,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