"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../../lib");
/*
 * Stack verification steps:
 * "curl <endpoint-in-the-stack-output>" should return 'success'
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-http-proxy');
// first create a lambda proxy endpoint that we can use as an HTTP proxy
const lambdaEndpoint = lambdaProxyEndpoint(stack);
const httpEndpoint = new lib_1.HttpApi(stack, 'HttpProxyApi', {
    defaultIntegration: new lib_1.HttpProxyIntegration({
        url: lambdaEndpoint.url,
    }),
});
new core_1.CfnOutput(stack, 'Endpoint', {
    value: httpEndpoint.url,
});
function lambdaProxyEndpoint(s) {
    const handler = new lambda.Function(s, 'AlwaysSuccess', {
        runtime: lambda.Runtime.NODEJS_12_X,
        handler: 'index.handler',
        code: new lambda.InlineCode('exports.handler = async function(event, context) { return { statusCode: 200, body: "success" }; };'),
    });
    return new lib_1.HttpApi(s, 'LambdaProxyApi', {
        defaultIntegration: new lib_1.LambdaProxyIntegration({
            handler,
        }),
    });
}
//# sourceMappingURL=data:application/json;base64,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