"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../../lib");
/*
 * Stack verification steps:
 * "curl <endpoint-in-the-stack-output>" should return 'success'
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-lambda-proxy');
const handler = new lambda.Function(stack, 'AlwaysSuccess', {
    runtime: lambda.Runtime.NODEJS_12_X,
    handler: 'index.handler',
    code: new lambda.InlineCode('exports.handler = async function(event, context) { return { statusCode: 200, body: "success" }; };'),
});
const endpoint = new lib_1.HttpApi(stack, 'LambdaProxyApi', {
    defaultIntegration: new lib_1.LambdaProxyIntegration({
        handler,
    }),
});
new core_1.CfnOutput(stack, 'Endpoint', {
    value: endpoint.url,
});
//# sourceMappingURL=data:application/json;base64,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