"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
describe('HttpRoute', () => {
    test('default', () => {
        const stack = new core_1.Stack();
        const httpApi = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'HttpRoute', {
            httpApi,
            integration: new DummyIntegration(),
            routeKey: lib_1.HttpRouteKey.with('/books', lib_1.HttpMethod.GET),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Route', {
            ApiId: stack.resolve(httpApi.httpApiId),
            RouteKey: 'GET /books',
            Target: {
                'Fn::Join': [
                    '',
                    [
                        'integrations/',
                        {
                            Ref: 'HttpRouteHttpRouteIntegration6EE0FE47',
                        },
                    ],
                ],
            },
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            ApiId: stack.resolve(httpApi.httpApiId),
        });
    });
    test('integration is configured correctly', () => {
        const stack = new core_1.Stack();
        const httpApi = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'HttpRoute', {
            httpApi,
            integration: new DummyIntegration(),
            routeKey: lib_1.HttpRouteKey.with('/books', lib_1.HttpMethod.GET),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            ApiId: stack.resolve(httpApi.httpApiId),
            IntegrationType: 'HTTP_PROXY',
            PayloadFormatVersion: '2.0',
            IntegrationUri: 'some-uri',
        });
    });
});
class DummyIntegration {
    bind() {
        return {
            type: lib_1.HttpIntegrationType.HTTP_PROXY,
            payloadFormatVersion: lib_1.PayloadFormatVersion.VERSION_2_0,
            uri: 'some-uri',
            method: lib_1.HttpMethod.DELETE,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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