# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class RentalTransactionEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amazon_order_id': 'str',
        'rental_event_type': 'str',
        'extension_length': 'int',
        'posted_date': 'ModelDate',
        'rental_charge_list': 'ChargeComponentList',
        'rental_fee_list': 'FeeComponentList',
        'marketplace_name': 'str',
        'rental_initial_value': 'Currency',
        'rental_reimbursement': 'Currency',
        'rental_tax_withheld_list': 'TaxWithheldComponentList'
    }

    attribute_map = {
        'amazon_order_id': 'AmazonOrderId',
        'rental_event_type': 'RentalEventType',
        'extension_length': 'ExtensionLength',
        'posted_date': 'PostedDate',
        'rental_charge_list': 'RentalChargeList',
        'rental_fee_list': 'RentalFeeList',
        'marketplace_name': 'MarketplaceName',
        'rental_initial_value': 'RentalInitialValue',
        'rental_reimbursement': 'RentalReimbursement',
        'rental_tax_withheld_list': 'RentalTaxWithheldList'
    }

    def __init__(self, amazon_order_id=None, rental_event_type=None, extension_length=None, posted_date=None, rental_charge_list=None, rental_fee_list=None, marketplace_name=None, rental_initial_value=None, rental_reimbursement=None, rental_tax_withheld_list=None):  # noqa: E501
        """RentalTransactionEvent - a model defined in Swagger"""  # noqa: E501
        self._amazon_order_id = None
        self._rental_event_type = None
        self._extension_length = None
        self._posted_date = None
        self._rental_charge_list = None
        self._rental_fee_list = None
        self._marketplace_name = None
        self._rental_initial_value = None
        self._rental_reimbursement = None
        self._rental_tax_withheld_list = None
        self.discriminator = None
        if amazon_order_id is not None:
            self.amazon_order_id = amazon_order_id
        if rental_event_type is not None:
            self.rental_event_type = rental_event_type
        if extension_length is not None:
            self.extension_length = extension_length
        if posted_date is not None:
            self.posted_date = posted_date
        if rental_charge_list is not None:
            self.rental_charge_list = rental_charge_list
        if rental_fee_list is not None:
            self.rental_fee_list = rental_fee_list
        if marketplace_name is not None:
            self.marketplace_name = marketplace_name
        if rental_initial_value is not None:
            self.rental_initial_value = rental_initial_value
        if rental_reimbursement is not None:
            self.rental_reimbursement = rental_reimbursement
        if rental_tax_withheld_list is not None:
            self.rental_tax_withheld_list = rental_tax_withheld_list

    @property
    def amazon_order_id(self):
        """Gets the amazon_order_id of this RentalTransactionEvent.  # noqa: E501

        An Amazon-defined identifier for an order.  # noqa: E501

        :return: The amazon_order_id of this RentalTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._amazon_order_id

    @amazon_order_id.setter
    def amazon_order_id(self, amazon_order_id):
        """Sets the amazon_order_id of this RentalTransactionEvent.

        An Amazon-defined identifier for an order.  # noqa: E501

        :param amazon_order_id: The amazon_order_id of this RentalTransactionEvent.  # noqa: E501
        :type: str
        """

        self._amazon_order_id = amazon_order_id

    @property
    def rental_event_type(self):
        """Gets the rental_event_type of this RentalTransactionEvent.  # noqa: E501

        The type of rental event.  Possible values:  * RentalCustomerPayment-Buyout - Transaction type that represents when the customer wants to buy out a rented item.  * RentalCustomerPayment-Extension - Transaction type that represents when the customer wants to extend the rental period.  * RentalCustomerRefund-Buyout - Transaction type that represents when the customer requests a refund for the buyout of the rented item.  * RentalCustomerRefund-Extension - Transaction type that represents when the customer requests a refund over the extension on the rented item.  * RentalHandlingFee - Transaction type that represents the fee that Amazon charges sellers who rent through Amazon.  * RentalChargeFailureReimbursement - Transaction type that represents when Amazon sends money to the seller to compensate for a failed charge.  * RentalLostItemReimbursement - Transaction type that represents when Amazon sends money to the seller to compensate for a lost item.  # noqa: E501

        :return: The rental_event_type of this RentalTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._rental_event_type

    @rental_event_type.setter
    def rental_event_type(self, rental_event_type):
        """Sets the rental_event_type of this RentalTransactionEvent.

        The type of rental event.  Possible values:  * RentalCustomerPayment-Buyout - Transaction type that represents when the customer wants to buy out a rented item.  * RentalCustomerPayment-Extension - Transaction type that represents when the customer wants to extend the rental period.  * RentalCustomerRefund-Buyout - Transaction type that represents when the customer requests a refund for the buyout of the rented item.  * RentalCustomerRefund-Extension - Transaction type that represents when the customer requests a refund over the extension on the rented item.  * RentalHandlingFee - Transaction type that represents the fee that Amazon charges sellers who rent through Amazon.  * RentalChargeFailureReimbursement - Transaction type that represents when Amazon sends money to the seller to compensate for a failed charge.  * RentalLostItemReimbursement - Transaction type that represents when Amazon sends money to the seller to compensate for a lost item.  # noqa: E501

        :param rental_event_type: The rental_event_type of this RentalTransactionEvent.  # noqa: E501
        :type: str
        """

        self._rental_event_type = rental_event_type

    @property
    def extension_length(self):
        """Gets the extension_length of this RentalTransactionEvent.  # noqa: E501

        The number of days that the buyer extended an already rented item. This value is only returned for RentalCustomerPayment-Extension and RentalCustomerRefund-Extension events.  # noqa: E501

        :return: The extension_length of this RentalTransactionEvent.  # noqa: E501
        :rtype: int
        """
        return self._extension_length

    @extension_length.setter
    def extension_length(self, extension_length):
        """Sets the extension_length of this RentalTransactionEvent.

        The number of days that the buyer extended an already rented item. This value is only returned for RentalCustomerPayment-Extension and RentalCustomerRefund-Extension events.  # noqa: E501

        :param extension_length: The extension_length of this RentalTransactionEvent.  # noqa: E501
        :type: int
        """

        self._extension_length = extension_length

    @property
    def posted_date(self):
        """Gets the posted_date of this RentalTransactionEvent.  # noqa: E501


        :return: The posted_date of this RentalTransactionEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this RentalTransactionEvent.


        :param posted_date: The posted_date of this RentalTransactionEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def rental_charge_list(self):
        """Gets the rental_charge_list of this RentalTransactionEvent.  # noqa: E501


        :return: The rental_charge_list of this RentalTransactionEvent.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._rental_charge_list

    @rental_charge_list.setter
    def rental_charge_list(self, rental_charge_list):
        """Sets the rental_charge_list of this RentalTransactionEvent.


        :param rental_charge_list: The rental_charge_list of this RentalTransactionEvent.  # noqa: E501
        :type: ChargeComponentList
        """

        self._rental_charge_list = rental_charge_list

    @property
    def rental_fee_list(self):
        """Gets the rental_fee_list of this RentalTransactionEvent.  # noqa: E501


        :return: The rental_fee_list of this RentalTransactionEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._rental_fee_list

    @rental_fee_list.setter
    def rental_fee_list(self, rental_fee_list):
        """Sets the rental_fee_list of this RentalTransactionEvent.


        :param rental_fee_list: The rental_fee_list of this RentalTransactionEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._rental_fee_list = rental_fee_list

    @property
    def marketplace_name(self):
        """Gets the marketplace_name of this RentalTransactionEvent.  # noqa: E501

        The name of the marketplace.  # noqa: E501

        :return: The marketplace_name of this RentalTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_name

    @marketplace_name.setter
    def marketplace_name(self, marketplace_name):
        """Sets the marketplace_name of this RentalTransactionEvent.

        The name of the marketplace.  # noqa: E501

        :param marketplace_name: The marketplace_name of this RentalTransactionEvent.  # noqa: E501
        :type: str
        """

        self._marketplace_name = marketplace_name

    @property
    def rental_initial_value(self):
        """Gets the rental_initial_value of this RentalTransactionEvent.  # noqa: E501


        :return: The rental_initial_value of this RentalTransactionEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._rental_initial_value

    @rental_initial_value.setter
    def rental_initial_value(self, rental_initial_value):
        """Sets the rental_initial_value of this RentalTransactionEvent.


        :param rental_initial_value: The rental_initial_value of this RentalTransactionEvent.  # noqa: E501
        :type: Currency
        """

        self._rental_initial_value = rental_initial_value

    @property
    def rental_reimbursement(self):
        """Gets the rental_reimbursement of this RentalTransactionEvent.  # noqa: E501


        :return: The rental_reimbursement of this RentalTransactionEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._rental_reimbursement

    @rental_reimbursement.setter
    def rental_reimbursement(self, rental_reimbursement):
        """Sets the rental_reimbursement of this RentalTransactionEvent.


        :param rental_reimbursement: The rental_reimbursement of this RentalTransactionEvent.  # noqa: E501
        :type: Currency
        """

        self._rental_reimbursement = rental_reimbursement

    @property
    def rental_tax_withheld_list(self):
        """Gets the rental_tax_withheld_list of this RentalTransactionEvent.  # noqa: E501


        :return: The rental_tax_withheld_list of this RentalTransactionEvent.  # noqa: E501
        :rtype: TaxWithheldComponentList
        """
        return self._rental_tax_withheld_list

    @rental_tax_withheld_list.setter
    def rental_tax_withheld_list(self, rental_tax_withheld_list):
        """Sets the rental_tax_withheld_list of this RentalTransactionEvent.


        :param rental_tax_withheld_list: The rental_tax_withheld_list of this RentalTransactionEvent.  # noqa: E501
        :type: TaxWithheldComponentList
        """

        self._rental_tax_withheld_list = rental_tax_withheld_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RentalTransactionEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RentalTransactionEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
