# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['notion_api_py']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.27,<3.0', 'urllib3>=1.26,<2.0']

setup_kwargs = {
    'name': 'notion-api-py',
    'version': '1.0.1',
    'description': 'A wrapper around notion api allowing you to create objects for your databases/pages and easily perform add/update/delete/filter operations in a more readable way',
    'long_description': '# notion-api-py\nA wrapper around **Notion Api** allowing you to create objects for your databases/pages and easily perform add/update/delete/filter operations in a more readable way\n\nThere are many libraries, **official/unofficial** out there. However the motivation behind creating this is to have a more simplistic approach to the most basic operations to perform over a `Notion database` and `Notion pages`. Also, allowing for `filtering`, handling pagination amoung query results and **Applying filters on a database view on Notion UI via code (Yes, the coolest unofficial thing so far 🥳) Refer section [Collection view filter](#collection-view-filter) for more details. \n\n### Prerequiste: Generate Notion Api token and integration\n\nBefore using this Api, you will need a API token from Notion\n\nPlease follow the below guide to know how to generate a api token for your Notion account, as well as how to share `databases` and `pages` with your created integration\n\n[https://www.codingwithmiszu.com/2021/12/28/how-to-generate-a-notion-api-token-easily/](https://www.codingwithmiszu.com/2021/12/28/how-to-generate-a-notion-api-token-easily/)\n\n[https://daily-dev-tips.com/posts/getting-started-with-the-notion-api/](https://daily-dev-tips.com/posts/getting-started-with-the-notion-api/)\n\nTo know more about NotionApi from the official sources\n\n[https://www.notion.so/help/create-integrations-with-the-notion-api](https://www.notion.so/help/create-integrations-with-the-notion-api)\n\n[https://developers.notion.com/docs/authorization](https://developers.notion.com/docs/authorization)\n\n### Usage\n\nVia the ‘Releases’ section of this repository to get the latest and greatest version of the library\n\nVia `pip`\n\n```python\npython3 -m pip install notion-api-py\n```\n\n### RECOMMENDED - Setting up the `secrets_file.py`\nIts recommened that all sensitive data be added to a `secrets_file.py` file, including the token, version, database ids and cookie related informationand not committed to the repository(add to `.gitignore`)\n\n```python\n# secrets_file.py\ntoken = "secret_XXXXXXXXX"\nversion = "2021-08-16"\n\ndatabase1_id = "AAAAAAAAAAAAAAAAAAAAA"\ndatabase2_id = "BBBBBBBBBBBBBBBBBBBB"\n\n# used for notion Collection view filter filers - NOT OFFICIAL API\nnotion_client_version = \'\'\nx_notion_active_user_header = \'\'\ncookie = \'__cookie_string__\'\n```\n\n\n### Notion Database\n\nA wrapper class containing basic operations like `add_page` , `update_page` , `delete_page`  and  `filter`around a basic Notion database. \n\nExample usage: \n\nTo create an object of `Tasks` database (example), all you need to do is relay the database_id as `database_id=\'XXXXXXX-XXXX-XXXX-XXXXXXXXX\'` OR  `database_id=secrets_file.master_task_database_id` to the extended `NotionDatabase`class. The other `add`, `update`, `delete` can simply be relayed to parent `NotionDatabase` class and it will take care of it.\n\n```python\nclass Tasks(NotionDatabase):\n    def __init__(self):\n        self.log = logging.getLogger(self.__class__.__name__)\n        NotionDatabase.__init__(self, token=secrets_file.token, version=secrets_file.version,\n                                database_id=secrets_file.master_task_database_id)\n\n    def add(self,icon=None,properties=None):\n        self.log.info("--------- Preparing to Add tasks ---------")\n        return self.add_page(icon=icon, properties=properties)\n\n    def update(self, task_id=None, icon=None, properties=None):\n        self.log.info("--------- Preparing to Update tasks ---------")\n        return self.update_page(page_id=task_id, icon=icon, properties=properties)\n\n    def delete(self, task_id):\n        return self.delete_page(page_id=task_id)\n\n    def filter(self, filter):\n        return super().filter(filter)\n```\n\n### Notion Filters\n\nThe `NotionFilters` class provides a range of filters you can apply to the databases. \n\nExample usage\n\n```python\nincomplete_task_filter = NotionFilter(\n        NotionFilterAnd(NotionRelationFilter("Release").contains("My Custom Release")\n                        , NotionTextFilter("Name").contains("Test Name")\n                        , NotionCheckboxFilter("✅ ?").does_not_equal(True)).build()).build()\n\nfiltered_incomplete_tasks = Tasks().filter(incomplete_feature_filter)\n```\n\n`NotionFilter`\n\nThis is wrapper/base that encapsulates all Notion filters. You can either give it a simple single filter (any one of the Single Filter,listed below) or a compund filter \n\n**Compund filters**\n\n`NotionFilterAnd`\n\n`NotionFilterOr`\n\nThese filter encapsulates the Single Filters listed below\n\n**Single Filters**\n\n`NotionRelationFilter` - apply filter on `Relations` fields\n\n`NotionCheckboxFilter` - apply filter on `Checkbox` fields\n\n`NotionTextFilter`- apply filter on `Text` fields\n\n`NotionDateFilter` - apply filter on `Date` fields\n\n`NotionSelectFilter` - apply filter on `Select` fields\n\n`NotionMultiSelecFilter` - apply filter on `MultiSelect` fields\n\n`NotionNumberFilter` apply filter on `Number` fields\n\n`NotionFormulaFilter`- apply filter on `Formula` fields. While dealing with `Number, Text, Date, Checkbox` within `NotionFormulaFilter` use the `NotionFormulaNumberFilter` `NotionFormulaTextFilter` `NotionFormulaDateFilter` `NotionFormulaCheckboxFilter`\n\n`NotionFilesFilter` - apply filter on `Files` fields\n\n`NotionPeopleFilter` - apply filter on `People` fields\n\n### Notion Page\n\nA wrapper class containing basic operations like `add_page` , `update_page` , `build_properties`  around a basic `Notion page`. \n\nExample Usage:\n\nTo represent a `Tasks` page in the above `Tasks` database, we can create a `TasksPage` object extending the libraries `NotionPage` class. By virtue, the `TasksPage` class now inherits all basic operations - `add_page` , `update_page` , `build_properties` from `NotionPage` reducing the code. \n\n```python\nclass TasksPage(NotionPage):\n    def __init__(self, page_id=None, existing_properties=None):\n        NotionPage.__init__(self, token=secrets_file.token, version=secrets_file.version\n                            ,page_id=page_id, properties=existing_properties)\n```\n\nBy default, `page_id` and `existing_properties` are None. However, we need either the `page_id` or `existing_properties`.  When we are performing a filtering operation, the Notions filter results have all the information including the properties of the pages that come in the filtered result. In this case, we can simply pass the properties from the filtered results into the object while instantiating\n\nThis **helps reduce the number of api calls** to Notion to fetch properties details later\n\n```python\n# Example\nincomplete_task_filter = NotionFilter(\n        NotionFilterAnd(NotionRelationFilter("Release").contains("My Custom Release")\n                        , NotionTextFilter("Name").contains("Test Name")\n                        , NotionCheckboxFilter("✅ ?").does_not_equal(True)).build()).build()\n\nfiltered_incomplete_tasks = Tasks().filter(incomplete_feature_filter)\nfor each_task in filtered_incomplete_tasks:\n    # print("each_task", each_task)\n    each_incomplete_task = TasksPage(existing_properties=each_task)\n\n\t\t#The properties of each_incomplete_task can then be retrieved by below\n    logging.debug("Incomplete task -> %s with status %s", each_incomplete_task.get_property("Name")\n                                                    ,each_incomplete_task.get_property("Status"))\n```\n\nHowever, if we dont have properties, then `page_id` is mandatory as a api request would be made to fetch the page properties\n\n```python\nexisting_task = TasksPage(page_id="87ec7b33-7932-bg35-d7fa7580cc63")\n```\n\n### Dynamic Notion Request builder\n\nThe build_properties function is unique automatic dynamic request builder which auto creates the json required for update page\n\n```python\nexisting_task = TasksPage(page_id="87ec7b33-7932-bg35-d7fa7580cc63")\n\nplanned_days_relation = Relations().create("e9ec7b33-7932-bg35-d7fa7580cc63").append_to_existing(existing_task.get_property("Planned Day"))\nplanned_week_relation = Relations().create("303d3e79-9000-3000-b942-34ffd349af75").append_to_existing(existing_task.get_property("Planned Week"))\nplanned_month_relation = Relations().create("7896ty6r-344e-4763-819a-b7c7c405e4f0").append_to_existing(existing_task.get_property("Planned Month"))\n\n# The \'Tasks\' page might have several properties, but we are interesting only in updating the "Planned Day","Planned Week","Planned Month"\nexisting_task.update_page(icon="🔺",\n                                 properties={\n                                     "Planned Day": planned_days_relation,\n                                     "Planned Week": planned_week_relation,\n                                     "Planned Month": planned_month_relation\n                                 })\n```\n\nwould translate to a `RequestBody` in `json`something like\n\n```python\n{\n    "icon":\n    {\n        "type": "emoji",\n        "emoji": "🔺"\n    },\n    "archived": false,\n    "properties":\n    {\n        "Planned Day":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "e9ec7b33-7932-bg35-d7fa7580cc63"\n                }\n            ]\n        },\n        "Planned Week":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "303d3e79-9000-3000-b942-34ffd349af75"\n                }\n            ]\n        },\n        "Planned Month":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "7896ty6r-344e-4763-819a-b7c7c405e4f0"\n                }\n            ]\n        }\n    }\n}\n```\n\nAnother example with `date` fields (which is slightly different)\n\n```python\nTasks().add(icon="✅",\n            properties = {"Name": task_title,\n                          "Task": task_relation,\n                          "Hours spent": distributed_hours,\n                          "Journal Date": Relations().create(journal_date_id).overwrite(),\n                          "Time (Date)": {"start": "2021-12-31"\n                                          ,"end": None\n                                          ,"time_zone":None}\n                          })\n```\n\n### Notion Properties\n\nThis class is responsible for interpreting the `properties` object for any `page` or `database` from the results of Notion requests.\n\nIts used implicitly within the `NotionDatabase` and `NotionPage` classes\n\nIts basically used to either read a specific property value from a json result or marshall a set of properties into a json request body\n\n### Notion relations\n\nThis class is responsible for handling `relations` in databases, which is the basis of creating relation (much like foreign key) between different databases.\n\n```python\n#overwrites an existing relation with the new_relation\nRelations().create(new_relation).overwrite()\n\n#appends the new_relation to an existing list of relations\nRelations().create(new_relation).append_to_existing(existing_relation)\n```\n\nPractical usage example\n\nSay, extending the example above, if we use `overwrite()`\n\n```python\n#Before\n{\n    "icon":\n    {\n        "type": "emoji",\n        "emoji": "🔺"\n    },\n    "archived": false,\n    "properties":\n    {\n        "Planned Day":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "e9ec7b33-7932-bg35-d7fa7580cc63"\n                }\n            ]\n        },\n        \n    }\n}\n\n# Updating the Planned day relation with overwrite\nexisting_task = TasksPage(page_id="87ec7b33-7932-bg35-d7fa7580cc63")\n\nplanned_days_relation = Relations().create("5555555-7932-bg35-d7fa7580cc63").overwrite()\nexisting_task.update_page(icon="🔺",\n                                 properties={\n                                     "Planned Day": planned_days_relation,                                  \n                                 })\n\n#After update\n{\n    "icon":\n    {\n        "type": "emoji",\n        "emoji": "🔺"\n    },\n    "archived": false,\n    "properties":\n    {\n        "Planned Day":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "5555555-7932-bg35-d7fa7580cc63"\n                }\n            ]\n        },\n        \n    }\n}\n```\n\nWith the `append_to_existing` option, it would add to existing relation, if already present\n\n```python\n#Before\n{\n    "icon":\n    {\n        "type": "emoji",\n        "emoji": "🔺"\n    },\n    "archived": false,\n    "properties":\n    {\n        "Planned Day":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "e9ec7b33-7932-bg35-d7fa7580cc63"\n                }\n            ]\n        },\n        \n    }\n}\n\n# Updating the Planned day relation with overwrite\nexisting_task = TasksPage(page_id="87ec7b33-7932-bg35-d7fa7580cc63")\n\nplanned_days_relation = Relations().create("5555555-7932-bg35-d7fa7580cc63").append_to_existing(existing_task.get_property("Planned Day"))\nexisting_task.update_page(icon="🔺",\n                                 properties={\n                                     "Planned Day": planned_days_relation,                                  \n                                 })\n\n#After update\n{\n    "icon":\n    {\n        "type": "emoji",\n        "emoji": "🔺"\n    },\n    "archived": false,\n    "properties":\n    {\n        "Planned Day":\n        {\n            "type": "relation",\n            "relation":\n            [\n                {\n                    "id": "e9ec7b33-7932-bg35-d7fa7580cc63"\n                },\n               {\n                    "id": "5555555-7932-bg35-d7fa7580cc63"\n                }\n            ]\n        },\n        \n    }\n}\n```\n\nMore examples, can anyways seen in the code example of previous sections.\n\n### Notion sorts\n\nNot available at the moment. This is on the wishlist\n\n### Collection view filter\n\nThis is an exciting option, which allows you auto set filters on particular `view` in Notion Databases\n\nTo know more about Notion database view, refer [https://www.notion.so/help/guides/using-database-views](https://www.notion.so/help/guides/using-database-views)\n\n![collection view filter](docs/images/collection_view_filter1.png)\n\nWhile the official Notion Api provides an option to `query` databases - [https://developers.notion.com/reference/post-database-query](https://developers.notion.com/reference/post-database-query)\n\nit doesnt provide an ability to actually **“set”** the filters on the UI.\n\nExample use cases \n\n**Use case 1:** where I needed this. I have `Planned Days`, `Planned Months` and `Planned Weeks` as relation pages and I want that every morning, the filter automatically changes to reflect the correct date/week/month so I can plan my tasks accordingly\n\n**Use case 2:** I use Notion for project management where I create Project → Features → Tasks. I have templates for each of these. So whenever I create a new feature using the template, it brings in the linked task database with the `Related Features` filter applied. However, I would also like “auto” apply the `Tags`, `Projects` and `Release` relations, as I know them based on the Feature page we are on. As of this writing, Notion provides no way of doing this.\n\n![collection view filter](docs/images/collection_view_filter2.png)\n\nI reverse engineered the api calls from Notion to thier server to see what they are doing when  we apply filter operations to a view\n\nBased on my experiments, I designed wrapper classes around it\n\n***Please note this is unofficial api call, hence you will need a logged in session cookie to make this to work***\n\nThere are ‘n’ number of tutorials/chrome extensions on the net, how to get the stored cookies for a site.Currenly this is not covered here.\n\nOnce, you have the cookie details, we could use something like the below\n\n```python\n\n#Applying filters on UI for Use case 1\nquery2filter = NotionWebQuery2(\n        notion_web_filter=NotionWebQuery2Filter("and"\n                                                , NotionWebDbSimpleFilter("exact", day_page_id,\n                                                                          "relation_contains",\n                                                                          task_property_id_map.get("Planned Day"))\n                                                , NotionWebDbSimpleFilter("exact", week_page_id,\n                                                                          "relation_contains",\n                                                                          task_property_id_map.get("Planned Week"))\n                                                , NotionWebDbSimpleFilter("exact", month_page_id,\n                                                                          "relation_contains",\n                                                                          task_property_id_map.get("Planned Month"))\n                                                )\n        #Optional, only if you require to provide aggregate operations on columns\n        # In my use case, wanted to provide aggregate on time spent for tasks as well as number of tasks\n         , notion_web_aggregations=NotionWebDbAggregations(\n            NotionWebDbAggregation(task_property_id_map.get("Actual time spent")).sum()\n            , NotionWebDbAggregation(task_property_id_map.get("Name")).count()\n        )\n    ).generate()\n```\n\nAbove, will generate the `json` RequestBody for the request to be sent\n\nFurther, you pass this filter to `generate_collection_view_filter_body` followed by `send_collection_view_filter_request`\n\n```python\n\n# the collection_id and collection_view_id can be fetched from url of the view\n# if you right click on a database view and use the "Copy link" you should get a url as\n# https://www.notion.so/XXXXXXXXXXX?v=YYYYYYYYY\n# Here the collection_id=XXXXXXXXXXX and collection_view_id="YYYYYYYYY"\npayload=generate_collection_view_filter_body(collection_id, collection_view_id,\n                                               int(datetime.now().timestamp()), query2filter)\n\n# notion_client_version, x_notion_active_user_header, cookie\n# These details can be fetched by inspecting the Chrome devtools(Network) and the cookie\nsend_collection_view_filter_request("https://www.notion.so/api/v3/saveTransactions"\n                                    ,payload\n                                    ,secrets_file.notion_client_version\n                                    ,secrets_file.x_notion_active_user_header\n                                    ,secrets_file.cookie)\n```\n',
    'author': 'sunnydsouza',
    'author_email': 'dsouzasunny1436@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sunnydsouza/notion-api-py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
