# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, Any, List, BinaryIO


class Collection(TeaModel):
    def __init__(
        self,
        collection_type: str = None,
        comment: str = None,
        create_time: int = None,
        level: int = None,
        name: str = None,
        owner_id: str = None,
        owner_name: str = None,
        qualified_name: str = None,
        update_time: int = None,
    ):
        self.collection_type = collection_type
        self.comment = comment
        self.create_time = create_time
        self.level = level
        self.name = name
        self.owner_id = owner_id
        self.owner_name = owner_name
        self.qualified_name = qualified_name
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.qualified_name is not None:
            result['QualifiedName'] = self.qualified_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('QualifiedName') is not None:
            self.qualified_name = m.get('QualifiedName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class Entity(TeaModel):
    def __init__(
        self,
        entity_content: Dict[str, Any] = None,
        qualified_name: str = None,
        tenant_id: int = None,
    ):
        self.entity_content = entity_content
        self.qualified_name = qualified_name
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_content is not None:
            result['EntityContent'] = self.entity_content
        if self.qualified_name is not None:
            result['QualifiedName'] = self.qualified_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityContent') is not None:
            self.entity_content = m.get('EntityContent')
        if m.get('QualifiedName') is not None:
            self.qualified_name = m.get('QualifiedName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class AbolishDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        # The ID of the DataService Studio API.
        self.api_id = api_id
        # The ID of the workspace.
        self.project_id = project_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class AbolishDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the DataService Studio API is unpublished.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AbolishDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AbolishDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AbolishDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMetaCollectionEntityRequest(TeaModel):
    def __init__(
        self,
        collection_qualified_name: str = None,
        entity_qualified_name: str = None,
    ):
        # The unique identifier of the collection.
        self.collection_qualified_name = collection_qualified_name
        # The unique identifier of the entity.
        # 
        # Example: maxcompute-table.projectA.tableA.
        self.entity_qualified_name = entity_qualified_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection_qualified_name is not None:
            result['CollectionQualifiedName'] = self.collection_qualified_name
        if self.entity_qualified_name is not None:
            result['EntityQualifiedName'] = self.entity_qualified_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CollectionQualifiedName') is not None:
            self.collection_qualified_name = m.get('CollectionQualifiedName')
        if m.get('EntityQualifiedName') is not None:
            self.entity_qualified_name = m.get('EntityQualifiedName')
        return self


class AddMetaCollectionEntityResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        status: bool = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id
        # The result of the operation. Valid values:
        # 
        # *   true: succeeded
        # *   false: failed
        self.status = status
        # Indicates whether the request was successful. Valid values:
        # 
        # true: The request was successful.
        # 
        # false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddMetaCollectionEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMetaCollectionEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMetaCollectionEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProjectMemberToRoleRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        role_code: str = None,
        user_id: str = None,
    ):
        # The client token. It is a field with the idempotence property. We recommend that you use a universally unique identifier (UUID). This parameter is used to uniquely identify the API operation call.
        self.client_token = client_token
        # The ID of the DataWorks workspace. You can call the [ListProjects](~~178393~~) operation to query the ID.
        self.project_id = project_id
        # The code of the role that you want to assign to a member of a DataWorks workspace. You can call the [ListProjectRoles](~~178228~~) operation to query the code of all roles in a DataWorks workspace.
        self.role_code = role_code
        # The ID of your Alibaba Cloud account. To view the ID, log on to [the DataWorks console](https://workbench.data.aliyun.com/console) and move the pointer over the profile picture in the upper-right corner.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddProjectMemberToRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request. You can use the ID to search for logs and troubleshoot issues based on the logs.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProjectMemberToRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddProjectMemberToRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddProjectMemberToRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddToMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class AddToMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddToMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddToMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddToMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApprovePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        approve_action: int = None,
        approve_comment: str = None,
        flow_id: str = None,
    ):
        # The approval action. Valid values:
        # 
        # *   1: Approve the permission request order.
        # *   2: Reject the permission request order.
        self.approve_action = approve_action
        # The comment on the approval.
        self.approve_comment = approve_comment
        # The ID of the permission request order. You can call the ListPermissionApplyOrders operation to obtain the order ID.
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_action is not None:
            result['ApproveAction'] = self.approve_action
        if self.approve_comment is not None:
            result['ApproveComment'] = self.approve_comment
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApproveAction') is not None:
            self.approve_action = m.get('ApproveAction')
        if m.get('ApproveComment') is not None:
            self.approve_comment = m.get('ApproveComment')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class ApprovePermissionApplyOrderResponseBody(TeaModel):
    def __init__(
        self,
        approve_success: bool = None,
        request_id: str = None,
    ):
        # Indicates that the approval is successful.
        self.approve_success = approve_success
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_success is not None:
            result['ApproveSuccess'] = self.approve_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApproveSuccess') is not None:
            self.approve_success = m.get('ApproveSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApprovePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApprovePermissionApplyOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApprovePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeResourceManagerResourceGroupRequest(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        resource_manager_resource_group_id: str = None,
        resource_type: str = None,
    ):
        # The ID of the resource type. Valid values:
        # 
        # *   If you set the ResourceType parameter to project, set this parameter to the value of ProjectIdentifier. You can call the [ListProjects](~~178393~~) operation to obtain the value of ProjectIdentifier.
        # *   If you set the ResourceType parameter to tenantresourcegroup, set this parameter to the value of ResourceGroupType. You can call the [ListResourceGroups](~~173913~~) operation to obtain the value of ResourceGroupType. Only the values 7, 8, and 9 are valid.
        self.resource_id = resource_id
        # The ID of the new resource group.
        self.resource_manager_resource_group_id = resource_manager_resource_group_id
        # The resource type. Valid values:
        # 
        # *   project: workspace. If you want to modify the resource group that you specify when you activate DataWorks, set the value to project.
        # *   tenantresourcegroup: exclusive resource group. If you want to modify the resource group that you specify when you purchase a DataWorks exclusive resource group, set the value to tenantresourcegroup.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_manager_resource_group_id is not None:
            result['ResourceManagerResourceGroupId'] = self.resource_manager_resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceManagerResourceGroupId') is not None:
            self.resource_manager_resource_group_id = m.get('ResourceManagerResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ChangeResourceManagerResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the resource group was successfully modified.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeResourceManagerResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeResourceManagerResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeResourceManagerResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckFileDeploymentRequest(TeaModel):
    def __init__(
        self,
        check_detail_url: str = None,
        checker_instance_id: str = None,
        status: str = None,
    ):
        # This parameter is deprecated.
        self.check_detail_url = check_detail_url
        # The ID of the instance to which the file checker belongs. You can obtain the ID from the CheckerInstanceId parameter in the check event logs returned by DataWorks.
        self.checker_instance_id = checker_instance_id
        # The check status of the file that you want to deploy. Valid values:
        # 
        # *   OK: The file passes the check.
        # *   WARN: The file passes the check, but an alert is reported.
        # *   FAIL: The file fails the check.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_detail_url is not None:
            result['CheckDetailUrl'] = self.check_detail_url
        if self.checker_instance_id is not None:
            result['CheckerInstanceId'] = self.checker_instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckDetailUrl') is not None:
            self.check_detail_url = m.get('CheckDetailUrl')
        if m.get('CheckerInstanceId') is not None:
            self.checker_instance_id = m.get('CheckerInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CheckFileDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckFileDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckFileDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckFileDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaPartitionRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        partition: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the E-MapReduce (EMR) cluster.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the database.
        self.database_name = database_name
        # The name of the partition.
        self.partition = partition
        # The GUID of the table.
        self.table_guid = table_guid
        # The name of the table.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CheckMetaPartitionResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the partition exists.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The error message.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckMetaPartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckMetaPartitionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckMetaPartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaTableRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the E-MapReduce (EMR) cluster.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the EMR database.
        self.database_name = database_name
        # The GUID of the table.
        self.table_guid = table_guid
        # The name of the EMR table.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CheckMetaTableResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the table exists.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckMetaTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckMetaTableResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckMetaTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBaselineRequestOvertimeSettings(TeaModel):
    def __init__(
        self,
        cycle: int = None,
        time: str = None,
    ):
        self.cycle = cycle
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class CreateBaselineRequest(TeaModel):
    def __init__(
        self,
        alert_margin_threshold: int = None,
        baseline_name: str = None,
        baseline_type: str = None,
        node_ids: str = None,
        overtime_settings: List[CreateBaselineRequestOvertimeSettings] = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
    ):
        self.alert_margin_threshold = alert_margin_threshold
        self.baseline_name = baseline_name
        self.baseline_type = baseline_type
        self.node_ids = node_ids
        self.overtime_settings = overtime_settings
        self.owner = owner
        self.priority = priority
        self.project_id = project_id

    def validate(self):
        if self.overtime_settings:
            for k in self.overtime_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_margin_threshold is not None:
            result['AlertMarginThreshold'] = self.alert_margin_threshold
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        result['OvertimeSettings'] = []
        if self.overtime_settings is not None:
            for k in self.overtime_settings:
                result['OvertimeSettings'].append(k.to_map() if k else None)
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertMarginThreshold') is not None:
            self.alert_margin_threshold = m.get('AlertMarginThreshold')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        self.overtime_settings = []
        if m.get('OvertimeSettings') is not None:
            for k in m.get('OvertimeSettings'):
                temp_model = CreateBaselineRequestOvertimeSettings()
                self.overtime_settings.append(temp_model.from_map(k))
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateBaselineResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        dynamic_error_code: str = None,
        dynamic_error_message: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.dynamic_error_code = dynamic_error_code
        self.dynamic_error_message = dynamic_error_message
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_error_code is not None:
            result['DynamicErrorCode'] = self.dynamic_error_code
        if self.dynamic_error_message is not None:
            result['DynamicErrorMessage'] = self.dynamic_error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicErrorCode') is not None:
            self.dynamic_error_code = m.get('DynamicErrorCode')
        if m.get('DynamicErrorMessage') is not None:
            self.dynamic_error_message = m.get('DynamicErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBaselineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBusinessRequest(TeaModel):
    def __init__(
        self,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        project_id: int = None,
        project_identifier: str = None,
        use_type: str = None,
    ):
        self.business_name = business_name
        self.description = description
        self.owner = owner
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class CreateBusinessResponseBody(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.business_id = business_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBusinessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConnectionRequest(TeaModel):
    def __init__(
        self,
        connection_type: str = None,
        content: str = None,
        description: str = None,
        env_type: int = None,
        name: str = None,
        project_id: int = None,
        sub_type: str = None,
    ):
        # The type of the connection string.
        self.connection_type = connection_type
        # Details of the data source.
        self.content = content
        # The description of the connection string.
        self.description = description
        # Environment of the data source.
        self.env_type = env_type
        # The name of the data source.
        self.name = name
        # The ID of the workspace to be associated with the data source.
        self.project_id = project_id
        # The sub-type of a connection string.
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class CreateConnectionResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the data source.
        self.data = data
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful. A value of true indicates that the request is successful. A value of false indicates that the request has failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        task_content: str = None,
        task_name: str = None,
        task_param: str = None,
        task_type: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. This parameter can be left empty.
        self.client_token = client_token
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        self.project_id = project_id
        # The configuration of the synchronization node to be created. This operation is equivalent to node creation by using the code editor in the DataWorks console. For more information, see [Create a synchronization node by using the code editor](~~137717~~).
        # 
        # You can call the CreateDISyncTask operation to create only batch synchronization nodes.
        self.task_content = task_content
        # The name of the synchronization node.
        self.task_name = task_name
        # The settings that specify the storage path of the synchronization node and the resource group used by the node. The following fields are supported:
        # 
        # *   FileFolderPath: the storage path of the node.
        # *   ResourceGroup: the identifier of the resource group for Data Integration that is used by the node. To query the identifier of the resource group, call the [ListResourceGroup](~~173913~~) operation.
        self.task_param = task_param
        # The type of the synchronization node.
        # 
        # You can call the CreateDISyncTask operation to create only batch synchronization nodes. Set the value to DI_OFFLINE.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        message: str = None,
        status: str = None,
    ):
        # The ID of the created synchronization node.
        self.file_id = file_id
        # The reason why the synchronization node failed to be created.
        self.message = message
        # Indicates whether the synchronization node was created. Valid values:
        # 
        # *   success: The synchronization node was created.
        # *   fail: The synchronization node failed to be created.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The information that indicates whether the synchronization node was created.
        self.data = data
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagComplementRequest(TeaModel):
    def __init__(
        self,
        biz_begin_time: str = None,
        biz_end_time: str = None,
        end_biz_date: str = None,
        exclude_node_ids: str = None,
        include_node_ids: str = None,
        name: str = None,
        node_params: str = None,
        parallelism: bool = None,
        project_env: str = None,
        root_node_id: int = None,
        start_biz_date: str = None,
    ):
        self.biz_begin_time = biz_begin_time
        self.biz_end_time = biz_end_time
        self.end_biz_date = end_biz_date
        self.exclude_node_ids = exclude_node_ids
        self.include_node_ids = include_node_ids
        self.name = name
        self.node_params = node_params
        self.parallelism = parallelism
        self.project_env = project_env
        self.root_node_id = root_node_id
        self.start_biz_date = start_biz_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_begin_time is not None:
            result['BizBeginTime'] = self.biz_begin_time
        if self.biz_end_time is not None:
            result['BizEndTime'] = self.biz_end_time
        if self.end_biz_date is not None:
            result['EndBizDate'] = self.end_biz_date
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        if self.parallelism is not None:
            result['Parallelism'] = self.parallelism
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.start_biz_date is not None:
            result['StartBizDate'] = self.start_biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizBeginTime') is not None:
            self.biz_begin_time = m.get('BizBeginTime')
        if m.get('BizEndTime') is not None:
            self.biz_end_time = m.get('BizEndTime')
        if m.get('EndBizDate') is not None:
            self.end_biz_date = m.get('EndBizDate')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        if m.get('Parallelism') is not None:
            self.parallelism = m.get('Parallelism')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('StartBizDate') is not None:
            self.start_biz_date = m.get('StartBizDate')
        return self


class CreateDagComplementResponseBody(TeaModel):
    def __init__(
        self,
        data: List[int] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDagComplementResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDagComplementResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDagComplementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagTestRequest(TeaModel):
    def __init__(
        self,
        bizdate: str = None,
        name: str = None,
        node_id: int = None,
        node_params: str = None,
        project_env: str = None,
    ):
        self.bizdate = bizdate
        self.name = name
        self.node_id = node_id
        self.node_params = node_params
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class CreateDagTestResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDagTestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDagTestResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDagTestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_description: str = None,
        api_mode: int = None,
        api_name: str = None,
        api_path: str = None,
        folder_id: int = None,
        group_id: str = None,
        project_id: int = None,
        protocols: str = None,
        registration_details: str = None,
        request_method: int = None,
        resource_group_id: int = None,
        response_content_type: int = None,
        script_details: str = None,
        sql_mode: int = None,
        tenant_id: int = None,
        timeout: int = None,
        visible_range: int = None,
        wizard_details: str = None,
    ):
        # The description of the API.
        self.api_description = api_description
        # The type of the API. Valid values: 0, 1, and 2. The value 0 indicates that the API is generated in wizard mode. The value 1 indicates that the API is generated in script mode. The value 2 indicates that the API is generated by registration.
        self.api_mode = api_mode
        # The name of the API. The name must be 4 to 50 characters in length. The name can contain letters, digits, and underscores (\_) and must start with a letter.
        self.api_name = api_name
        # The path of the API. The path cannot exceed 200 characters in length. The path can contain letters, digits, underscores (\_), and hyphens (-) and must start with a forward slash (/).
        self.api_path = api_path
        # The ID of the folder used to store the API. The ID of the root folder in a business process is 0. The ID of the folder created by a user must be greater than 0.
        self.folder_id = folder_id
        # The ID of the business process.
        self.group_id = group_id
        # The ID of the workspace.
        self.project_id = project_id
        # The protocol used by the API. Valid values: 0 and 1. The value 0 indicates HTTP. The value 1 indicates HTTPS. You can specify multiple protocols. Separate them with commas (,).
        self.protocols = protocols
        # The details of the API generated by registration. For more information, see the RegistrationDetails parameter returned by the [GetDataServiceApi](~~174013~~) operation.
        self.registration_details = registration_details
        # The request method of the API. Valid values: 0, 1, 2, and 3. The value 0 indicates the GET method. The value 1 indicates the POST method. The value 2 indicates the PUT method. The value 3 indicates the DELETE method. APIs generated in wizard or script mode support the GET and POST methods. APIs generated by registration support the GET, POST, PUT, and DELETE methods.
        self.request_method = request_method
        self.resource_group_id = resource_group_id
        # The format in which the response of the API request is returned. Valid values: 0 and 1. The value 0 indicates the JSON format. The value 1 indicates the XML format. APIs generated in wizard or script mode support the JSON format. APIs generated by registration support the JSON and XML formats.
        self.response_content_type = response_content_type
        # The details of the API generated in script mode. For more information, see the ScriptDetails parameter returned by the [GetDataServiceApi](~~174013~~) operation.
        self.script_details = script_details
        self.sql_mode = sql_mode
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The timeout period of the API request. Unit: milliseconds. Valid values: (0,30000].
        self.timeout = timeout
        # The scope in which the API is visible. Valid values:
        # 
        # *   0: The API is visible to all members in the workspace.
        # *   1: The API is visible only to its owner, and permissions on the API cannot be granted to other members.
        self.visible_range = visible_range
        # The details of the API generated in wizard mode. For more information, see the WizardDetails parameter returned by the [GetDataServiceApi](~~174013~~) operation.
        self.wizard_details = wizard_details

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_description is not None:
            result['ApiDescription'] = self.api_description
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details
        if self.sql_mode is not None:
            result['SqlMode'] = self.sql_mode
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiDescription') is not None:
            self.api_description = m.get('ApiDescription')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            self.registration_details = m.get('RegistrationDetails')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('ScriptDetails') is not None:
            self.script_details = m.get('ScriptDetails')
        if m.get('SqlMode') is not None:
            self.sql_mode = m.get('SqlMode')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('WizardDetails') is not None:
            self.wizard_details = m.get('WizardDetails')
        return self


class CreateDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the API.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The error message.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        authorized_project_id: int = None,
        end_time: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id
        self.end_time = end_time
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDataServiceApiAuthorityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        folder_name: str = None,
        group_id: str = None,
        parent_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.folder_name = folder_name
        self.group_id = group_id
        self.parent_id = parent_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDataServiceFolderResponseBody(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        request_id: str = None,
    ):
        self.folder_id = folder_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDataServiceFolderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        api_gateway_group_id: str = None,
        description: str = None,
        group_name: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_gateway_group_id = api_gateway_group_id
        self.description = description
        self.group_name = group_name
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDataServiceGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        self.group_id = group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDataServiceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataSourceRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        data_source_type: str = None,
        description: str = None,
        env_type: int = None,
        name: str = None,
        project_id: int = None,
        sub_type: str = None,
    ):
        # The details of the data source. Examples of details of some common data sources:
        # 
        # *   odps
        # 
        # ```
        # 
        # {
        #   "accessId": "xssssss",
        #   "accessKey": "xsaxsaxsa",
        #   "authType": 2,
        #   "endpoint": "http://service.odps.aliyun.com/api",
        #   "project": "xsaxsax",
        #   "tag": "public"
        # }
        # ```
        # 
        # *   mysql
        # 
        # ```
        # 
        # {
        #   "database": "xsaxsa",
        #   "instanceName": "rm-xsaxsa",
        #   "password": "xsaxsa",
        #   "rdsOwnerId": "xasxsa",
        #   "regionId": "cn-shanghai",
        #   "tag": "rds",
        #   "username": "xsaxsa"
        # }
        # ```
        # 
        # *   rds
        # 
        # ```
        # 
        # {
        #   "configType": 1,
        #   "tag": "rds",
        #   "database": "xsaxsa",
        #   "username": "xsaxsa",
        #   "password": "xssaxsa$32050",
        #   "instanceName": "rm-xsaxs",
        #   "rdsOwnerId": "11111111"
        # }
        # ```
        # 
        # *   oss
        # 
        # ```
        # 
        # {
        #   "accessId": "sssssxx",
        #   "accessKey": "xsaxaxsaxs",
        #   "bucket": "xsa-xs-xs",
        #   "endpoint": "http://oss-cn-shanghai.aliyuncs.com",
        #   "tag": "public"
        # }
        # ```
        # 
        # *   sqlserver
        # 
        # ```
        # 
        # {
        #   "jdbcUrl": "jdbc:sqlserver://xsaxsa-xsaxsa.database.xxx.cn:123;DatabaseName=xsxs-xsxs",
        #   "password": "sdasda$fs",
        #   "tag": "public",
        #   "username": "sxaxacdacdd"
        # }
        # ```
        # 
        # *   polardb
        # 
        # ```
        # 
        # {
        #   "clusterId": "pc-sdadsadsa",
        #   "database": "dsadsadsa",
        #   "ownerId": "121212122",
        #   "password": "sdasdafssa",
        #   "region": "cn-shanghai",
        #   "tag": "polardb",
        #   "username": "asdadsads"
        # }
        # ```
        # 
        # *   oracle
        # 
        # ```
        # 
        # {
        #   "jdbcUrl": "jdbc:oracle:saaa:@xxxxx:1521:PROD",
        #   "password": "sxasaxsa",
        #   "tag": "public",
        #   "username": "sasfadfa"
        # }
        # ```
        # 
        # *   mongodb
        # 
        # ```
        # 
        # {
        #   "address": "[\"xsaxxsa.mongodb.rds.aliyuncs.com:3717\"]",
        #   "database": "admin",
        #   "password": "sadsda@",
        #   "tag": "public",
        #   "username": "dsadsadas"
        # }
        # ```
        # 
        # *   emr
        # 
        # ```
        # 
        # {
        #   "accessId": "xsaxsa",
        #   "emrClusterId": "C-dsads",
        #   "emrResourceQueueName": "default",
        #   "emrEndpoint": "emr.aliyuncs.com",
        #   "accessKey": "dsadsad",
        #   "emrUserId": "224833315798889783",
        #   "name": "sasdsadsa",
        #   "emrAccessMode": "simple",
        #   "region": "cn-shanghai",
        #   "authType": "2",
        #   "emrProjectId": "FP-sdadsad"
        # }
        # ```
        # 
        # *   postgresql
        # 
        # ```
        # 
        # {
        #   "jdbcUrl": "jdbc:postgresql://xxxx:1921/ssss",
        #   "password": "sdadsads",
        #   "tag": "public",
        #   "username": "sdsasda"
        # }
        # ```
        # 
        # *   analyticdb_for_mysql
        # 
        # ```
        # 
        # {
        #   "instanceId": "am-sadsada",
        #   "database": "xsxsx",
        #   "username": "xsxsa",
        #   "password": "asdadsa",
        #   "connectionString": "am-xssxsxs.ads.aliyuncs.com:3306"
        # }
        # ```
        # 
        # *   hybriddb_for_postgresql
        # 
        # ```
        # 
        # {
        #   "connectionString": "gp-xsaxsaxa-master.gpdbmaster.rds.aliyuncs.com",
        #   "database": "xsaxsaxas",
        #   "password": "xsaxsaxsa@11",
        #   "instanceId": "gp-xsaxsaxsa",
        #   "port": "541132",
        #   "ownerId": "xsaxsaxsas",
        #   "username": "sadsad"
        # }
        # ```
        # 
        # *   holo
        # 
        # ```
        # 
        # {
        #   "accessId": "xsaxsaxs",
        #   "accessKey": "xsaxsaxsa",
        #   "database": "xsaxsaxsa",
        #   "instanceId": "xsaxa",
        #   "tag": "aliyun"
        # }
        # ```
        # 
        # *   kafka
        # 
        # ```
        # 
        # {
        #   "instanceId": "xsax-cn-xsaxsa",
        #   "regionId": "cn-shanghai",
        #   "tag": "aliyun",
        #   "ownerId": "1212121212112"
        # }
        # ```
        self.content = content
        # The type of the data source. Valid values:
        # 
        # *   odps
        # *   mysql
        # *   rds
        # *   oss
        # *   sqlserver
        # *   polardb
        # *   oracle
        # *   mongodb
        # *   emr
        # *   postgresql
        # *   analyticdb_for_mysql
        # *   hybriddb_for_postgresql
        # *   holo
        self.data_source_type = data_source_type
        # The description of the data source.
        self.description = description
        # The environment in which the data source is used. Valid values: 0 and 1. 0 indicates the development environment. 1 indicates the production environment.
        self.env_type = env_type
        # The name of the data source.
        self.name = name
        # The ID of the DataWorks workspace to which the data source belongs. You can call the [ListProjects](~~178393~~) operation to obtain the ID.
        self.project_id = project_id
        # The subtype of the data source. Example:
        # 
        # *   This parameter takes effect only if the DataSourceType parameter is set to rds.
        # *   If the DataSourceType parameter is set to rds, this parameter can be set to mysql, sqlserver, or postgresql.
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class CreateDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the data source.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateExportMigrationRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        export_mode: str = None,
        export_object_status: str = None,
        incremental_since: int = None,
        name: str = None,
        project_id: int = None,
    ):
        # The description of the export task.
        self.description = description
        # The export mode of the export task. Valid values:
        # 
        # *   FULL: The export task is used to export all data objects.
        # *   INCREMENTAL: The export task is used to export data objects that were modified since the specified point in time. If you set this parameter to INCREMENTAL, you must configure the IncrementalSince parameter.
        self.export_mode = export_mode
        # The status of the data objects that you want to export in the export task. The system exports data objects in the state that is specified by this parameter. Valid values:
        # 
        # *   SAVED: Data objects that are in the SAVED state are exported.
        # *   SUBMITTED: Data objects that are in the SUBMITTED state are exported.
        # *   DEPLOYED: Data objects that are in the DEPLOYED state are exported.
        self.export_object_status = export_object_status
        # The start time of the incremental export task.
        # 
        # The IncrementalSince parameter takes effect only when the ExportMode parameter is set to INCREMENTAL.
        self.incremental_since = incremental_since
        # The name of the export task.
        # 
        # The name of each export task must be unique. You must ensure that no duplicate export task exists in the current workspace.
        self.name = name
        # The ID of the workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.export_mode is not None:
            result['ExportMode'] = self.export_mode
        if self.export_object_status is not None:
            result['ExportObjectStatus'] = self.export_object_status
        if self.incremental_since is not None:
            result['IncrementalSince'] = self.incremental_since
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExportMode') is not None:
            self.export_mode = m.get('ExportMode')
        if m.get('ExportObjectStatus') is not None:
            self.export_object_status = m.get('ExportObjectStatus')
        if m.get('IncrementalSince') is not None:
            self.incremental_since = m.get('IncrementalSince')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateExportMigrationResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the export task.
        self.data = data
        # The ID of the request. You can use the ID to locate logs and troubleshoot errors.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The call succeeded.
        # *   false: The call failed. You can locate errors based on the request ID.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateExportMigrationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateExportMigrationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateExportMigrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileRequest(TeaModel):
    def __init__(
        self,
        advanced_settings: str = None,
        auto_parsing: bool = None,
        auto_rerun_interval_millis: int = None,
        auto_rerun_times: int = None,
        connection_name: str = None,
        content: str = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        dependent_type: str = None,
        end_effect_date: int = None,
        file_description: str = None,
        file_folder_path: str = None,
        file_name: str = None,
        file_type: int = None,
        input_list: str = None,
        input_parameters: str = None,
        output_parameters: str = None,
        owner: str = None,
        para_value: str = None,
        project_id: int = None,
        project_identifier: str = None,
        rerun_mode: str = None,
        resource_group_id: int = None,
        resource_group_identifier: str = None,
        scheduler_type: str = None,
        start_effect_date: int = None,
        start_immediately: bool = None,
        stop: bool = None,
    ):
        # The advanced configurations of the node.
        # 
        # This parameter is valid only for an EMR Spark Streaming node or an EMR Streaming SQL node. This parameter corresponds to the Advanced Settings tab of the node in the [DataWorks console](https://workbench.data.aliyun.com/console).
        # 
        # The value of this parameter must be in the JSON format.
        self.advanced_settings = advanced_settings
        # Specifies whether to enable the automatic parsing feature for the file. Valid values:
        # 
        # *   true: enables the automatic parsing feature for the file.
        # *   false: does not enable the automatic parsing feature for the file.
        # 
        # This parameter corresponds to the Analyze Code parameter that is displayed after Same Cycle is selected in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.auto_parsing = auto_parsing
        # The interval between automatic reruns after an error occurs. Unit: milliseconds. Maximum value: 1800000 (30 minutes).
        # 
        # This parameter corresponds to the Rerun Interval parameter that is displayed after the Auto Rerun upon Error check box is selected in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        # 
        # The interval that you specify in the DataWorks console is measured in minutes. Pay attention to the conversion between the units of time when you call the operation.
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        # The number of automatic reruns that are allowed after an error occurs. Maximum value: 10.
        self.auto_rerun_times = auto_rerun_times
        # The name of the data source for which the node is run.
        # 
        # You can call the [UpdateDataSource](~~211432~~) operation to query the available data sources in the workspace.
        self.connection_name = connection_name
        # The code for the file. The code format varies based on the file type. To view the code format for a specific file type, go to Operation Center, right-click a node of the file type, and then select View Code.
        self.content = content
        # The CRON expression that represents the automatic scheduling policy of the node. This parameter corresponds to the Cron Expression parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console). After you configure the Scheduling Cycle and Run At parameters in the DataWorks console, DataWorks generates the value of the Cron Expression parameter.
        # 
        # Examples:
        # 
        # *   CRON expression for a node that is scheduled to run at 05:30 every day: `00 30 05 * * ?`
        # *   CRON expression for a node that is scheduled to run at the fifteenth minute of each hour: `00 15 00-23/1 * * ?`
        # *   CRON expression for a node that is scheduled to run every 10 minutes: `00 00/10 * * * ?`
        # *   CRON expression for a node that is scheduled to run every 10 minutes from 08:00 to 17:00 every day: `00 00-59/10 8-17 * * * ?`
        # *   CRON expression for a node that is scheduled to run at 00:20 on the first day of each month: `00 20 00 1 * ?`
        # *   CRON expression for a node that is scheduled to run every three months starting from 00:10 on January 1: `00 10 00 1 1-12/3 ?`
        # *   CRON expression for a node that is scheduled to run at 00:05 every Tuesday and Friday: `00 05 00 * * 2,5`
        # 
        # The scheduling system of DataWorks imposes the following limits on CRON expressions:
        # 
        # *   A node can be scheduled to run at a minimum interval of 5 minutes.
        # *   A node can be scheduled to run at 00:05 every day at the earliest.
        self.cron_express = cron_express
        # The type of the scheduling cycle. Valid values: NOT_DAY and DAY. The value NOT_DAY indicates that the node is scheduled to run by minute or hour. The value DAY indicates that the node is scheduled to run by day, week, or month.
        # 
        # This parameter corresponds to the Scheduling Cycle parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.cycle_type = cycle_type
        # The IDs of the nodes that generate instances in the previous cycle on which the current node depends.
        self.dependent_node_id_list = dependent_node_id_list
        # The type of the cross-cycle scheduling dependency of the node. Valid values:
        # 
        # *   SELF: The instance generated for the node in the current cycle depends on the instance generated for the node in the previous cycle.
        # 
        # *   CHILD: The instance generated for the node in the current cycle depends on the instances generated for the descendant nodes at the nearest level of the node in the previous cycle.
        # 
        # *   USER_DEFINE: The instance generated for the node in the current cycle depends on the instances generated for one or more specified nodes in the previous cycle.
        # 
        # *   NONE: No cross-cycle scheduling dependency type is selected for the node.
        # 
        # *   USER_DEFINE_AND_SELF: The instance generated for the node in the current cycle depends on the instance generated for the node in the previous cycle and the instances generated for one or more specified nodes in the previous cycle.
        # 
        # *   CHILD_AND_SELF: The instance generated for the node in the current cycle depends on the instances generated for the descendant nodes at the nearest level of the node in the previous cycle and the instance generated for the node in the previous cycle.
        self.dependent_type = dependent_type
        # The end time of automatic scheduling. Set the value to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # This parameter corresponds to the Validity Period parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.end_effect_date = end_effect_date
        # The description of the file.
        self.file_description = file_description
        # The path of the file.
        self.file_folder_path = file_folder_path
        # The name of the file.
        self.file_name = file_name
        # The type of the code in the file.
        # 
        # Valid values: 6 (Shell), 10 (ODPS SQL), 11 (ODPS MR), 24 (ODPS Script), 99 (zero load), 221 (PyODPS 2), 225 (ODPS Spark), 227 (EMR Hive), 228 (EMR Spark), 229 (EMR Spark SQL), 230 (EMR MR), 239 (OSS object inspection), 257 (EMR Shell), 258 (EMR Spark Shell), 259 (EMR Presto), 260 (EMR Impala), 900 (real-time synchronization), 1089 (cross-tenant collaboration), 1091 (Hologres development), 1093 (Hologres SQL), 1100 (assignment), and 1221 (PyODPS 3).
        # 
        # You can call the [ListFileType](~~212428~~) operation to query the type of the code for the file.
        self.file_type = file_type
        # The output name of the parent file on which the current file depends. If you specify multiple output names, separate them with commas (,).
        # 
        # This parameter corresponds to the Output Name parameter under Parent Nodes in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.input_list = input_list
        # The input parameters of the node. The value of this parameter must be in the JSON format. For more information about the input parameters, see the InputContextParameterList parameter in the Response parameters section of the [GetFile](~~173954~~) operation.
        # 
        # This parameter corresponds to the Input Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.input_parameters = input_parameters
        # The output parameters of the node. The value of this parameter must be in the JSON format. For more information about the output parameters, see the OutputContextParameterList parameter in the Response parameters section of the [GetFile](~~173954~~) operation.
        # 
        # This parameter corresponds to the Output Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.output_parameters = output_parameters
        # The ID of the Alibaba Cloud account used by the file owner. If this parameter is not configured, the ID of the Alibaba Cloud account of the user who calls the operation is used.
        self.owner = owner
        # The scheduling parameters of the node. Separate multiple parameters with spaces.
        # 
        # This parameter corresponds to the Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console). For more information about the configurations of the scheduling parameters, see [Configure scheduling parameters](~~137548~~).
        self.para_value = para_value
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        # 
        # You must configure this parameter or the ProjectIdentifier parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace name.
        # 
        # You must configure this parameter or the ProjectId parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier
        # Specifies whether the node that corresponds to the file can be rerun. Valid values:
        # 
        # *   ALL_ALLOWED: The node can be rerun regardless of whether it is successfully run or fails to run.
        # *   FAILURE_ALLOWED: The node can be rerun only after it fails to run.
        # *   ALL_DENIED: The node cannot be rerun regardless of whether it is successfully run or fails to run.
        # 
        # This parameter corresponds to the Rerun parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.rerun_mode = rerun_mode
        # This parameter is deprecated. Do not use this parameter.
        # 
        # The identifier of the resource group that is used to run the node. This parameter corresponds to the Resource Group parameter in the Resource Group section of the Properties tab in the DataWorks console. You must configure one of the ResourceGroupId and ResourceGroupIdentifier parameters to determine the resource group that is used to run the node.
        # 
        # You can call the [ListResourceGroups](~~173913~~) operation to query the available resource groups in the workspace. When you call the operation, set the ResourceGroupType parameter to 1. The response parameter Id indicates the ID of an available resource group.
        self.resource_group_id = resource_group_id
        # The identifier of the resource group that is used to run the node. You can call the [ListResourceGroups](~~173913~~) operation to query the available resource groups in the workspace.
        self.resource_group_identifier = resource_group_identifier
        # The scheduling type of the inner node. Valid values:
        # 
        # *   NORMAL: The node is an auto triggered node.
        # *   MANUAL: The node is a manually triggered node. Manually triggered nodes cannot be automatically triggered. They correspond to the nodes in the Manually Triggered Workflows pane.
        # *   PAUSE: The node is a paused node.
        # *   SKIP: The node is a dry-run node. Dry-run nodes are started as scheduled, but the system sets the status of the nodes to successful when it starts to run them.
        self.scheduler_type = scheduler_type
        # The start time of automatic scheduling. Set the value to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # This parameter corresponds to the Validity Period parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.start_effect_date = start_effect_date
        # Specifies whether to immediately run a node after the node is deployed to the production environment.
        # 
        # This parameter is valid only for an EMR Spark Streaming node or an EMR Streaming SQL node. This parameter corresponds to the Start Method parameter in the Schedule section of the Configure tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.start_immediately = start_immediately
        # Specifies whether to suspend the scheduling of the node. Valid values:
        # 
        # *   true: suspends the scheduling of the node.
        # *   false: does not suspend the scheduling of the node.
        # 
        # This parameter corresponds to the Recurrence parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.stop = stop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_settings is not None:
            result['AdvancedSettings'] = self.advanced_settings
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.content is not None:
            result['Content'] = self.content
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.input_parameters is not None:
            result['InputParameters'] = self.input_parameters
        if self.output_parameters is not None:
            result['OutputParameters'] = self.output_parameters
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_group_identifier is not None:
            result['ResourceGroupIdentifier'] = self.resource_group_identifier
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.start_immediately is not None:
            result['StartImmediately'] = self.start_immediately
        if self.stop is not None:
            result['Stop'] = self.stop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdvancedSettings') is not None:
            self.advanced_settings = m.get('AdvancedSettings')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('InputParameters') is not None:
            self.input_parameters = m.get('InputParameters')
        if m.get('OutputParameters') is not None:
            self.output_parameters = m.get('OutputParameters')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceGroupIdentifier') is not None:
            self.resource_group_identifier = m.get('ResourceGroupIdentifier')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('StartImmediately') is not None:
            self.start_immediately = m.get('StartImmediately')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        return self


class CreateFileResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the file that was created.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFolderRequest(TeaModel):
    def __init__(
        self,
        folder_path: str = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The path of the folder.
        self.folder_path = folder_path
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the workspace ID. You must configure either this parameter or the ProjectIdentifier parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the workspace name. You must configure either the ProjectId or ProjectIdentifier parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class CreateFolderResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The unique identifier of the folder.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFolderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImportMigrationRequest(TeaModel):
    def __init__(
        self,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
        name: str = None,
        package_file: str = None,
        package_type: str = None,
        project_id: int = None,
        resource_group_map: str = None,
        workspace_map: str = None,
    ):
        # The mapping between the source compute engine instance and the destination compute engine instance.
        # 
        # The following types of compute engine instances are supported: MaxCompute, E-MapReduce (EMR), Hadoop CDH, and Hologres.
        self.calculate_engine_map = calculate_engine_map
        # The rule configured for automatically committing and deploying the import task. The rule contains the following parameters:
        # 
        # *   resourceAutoCommit: specifies whether resources are automatically committed. The value true indicates that the resources are automatically committed, and the value false indicates that the resources are not automatically committed.
        # *   resourceAutoDeploy: specifies whether resources are automatically deployed. The value true indicates that the resources are automatically deployed, and the value false indicates that the resources are not automatically deployed.
        # *   functionAutoCommit: specifies whether the function is automatically committed. The value true indicates that the function is automatically committed, and the value false indicates that the function is not automatically committed.
        # *   functionAutoDeploy: specifies whether the function is automatically deployed. The value true indicates that the function is automatically deployed, and the value false indicates that the function is not automatically deployed.
        # *   tableAutoCommitToDev: specifies whether the table is automatically committed to the development environment. The value true indicates that the table is automatically committed to the development environment, and the value false indicates that the table is not automatically committed to the development environment.
        # *   tableAutoCommitToProd: specifies whether the table is automatically committed to the production environment. The value true indicates that the table is automatically committed to the production environment, and the value false indicates that the table is not automatically committed to the production environment.
        # *   ignoreLock: specifies whether the lock is automatically ignored when an import task is locked. The value true indicates that the lock is automatically ignored, and the value false indicates that the lock is not automatically ignored. If you set this parameter to true for an import task, you can forcibly update the task even if the task is locked.
        # *   fileAutoCommit: specifies whether the file is automatically committed. The value true indicates that the file is automatically committed, and the value false indicates that the file is not automatically committed.
        # *   fileAutoDeploy: specifies whether the file is automatically deployed. The value true indicates that the file is automatically deployed, and the value false indicates that the file is not automatically deployed.
        self.commit_rule = commit_rule
        # The description of the import package.
        self.description = description
        # The name of the import task. The name must be unique within the workspace.
        self.name = name
        # The path of the import package.
        # 
        # **The import package must be uploaded. Example of the upload method:**`  Config config = new Config(); config.setAccessKeyId(accessId); config.setAccessKeySecret(accessKey); config.setEndpoint(popEndpoint); config.setRegionId(regionId); Client client = new Client(config); CreateImportMigrationAdvanceRequest request = new CreateImportMigrationAdvanceRequest(); request.setName("test_migration_api_" + System.currentTimeMillis()); request.setProjectId(123456L); request.setPackageType("DATAWORKS_MODEL"); request.setPackageFileObject(new FileInputStream("/home/admin/Downloads/test.zip")); RuntimeOptions runtime = new RuntimeOptions(); CreateImportMigrationResponse response = client.createImportMigrationAdvance(request, runtime); ... `
        self.package_file = package_file
        # The type of the import package. Valid values:
        # 
        # *   DATAWORKS_MODEL (standard format)
        # *   DATAWORKS_V2 (Apsara Stack DataWorks V3.6.1 to V3.11)
        # *   DATAWORKS_V3 (Apsara Stack DataWorks V3.12 and later)
        self.package_type = package_type
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID.
        self.project_id = project_id
        # The mapping between the resource group for scheduling and the resource group for Data Integration. The keys and values in the mapping are the identifiers of the resource groups. Specify the mapping in the following format:
        # 
        # ```
        # 
        # {
        #     "SCHEDULER_RESOURCE_GROUP": {
        #         "xxx": "yyy"
        #     },
        #     "DI_RESOURCE_GROUP": {
        #         "ccc": "dfdd"
        #     }
        # }
        # 
        #                                 
        # ```
        self.resource_group_map = resource_group_map
        # The mapping between the prefixes for the names of the source and destination workspaces. When the system performs the import operation, the prefix for the name of the source workspace in the import package is replaced based on the mapping.
        self.workspace_map = workspace_map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.package_file is not None:
            result['PackageFile'] = self.package_file
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageFile') is not None:
            self.package_file = m.get('PackageFile')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        return self


class CreateImportMigrationAdvanceRequest(TeaModel):
    def __init__(
        self,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
        name: str = None,
        package_file_object: BinaryIO = None,
        package_type: str = None,
        project_id: int = None,
        resource_group_map: str = None,
        workspace_map: str = None,
    ):
        # The mapping between the source compute engine instance and the destination compute engine instance.
        # 
        # The following types of compute engine instances are supported: MaxCompute, E-MapReduce (EMR), Hadoop CDH, and Hologres.
        self.calculate_engine_map = calculate_engine_map
        # The rule configured for automatically committing and deploying the import task. The rule contains the following parameters:
        # 
        # *   resourceAutoCommit: specifies whether resources are automatically committed. The value true indicates that the resources are automatically committed, and the value false indicates that the resources are not automatically committed.
        # *   resourceAutoDeploy: specifies whether resources are automatically deployed. The value true indicates that the resources are automatically deployed, and the value false indicates that the resources are not automatically deployed.
        # *   functionAutoCommit: specifies whether the function is automatically committed. The value true indicates that the function is automatically committed, and the value false indicates that the function is not automatically committed.
        # *   functionAutoDeploy: specifies whether the function is automatically deployed. The value true indicates that the function is automatically deployed, and the value false indicates that the function is not automatically deployed.
        # *   tableAutoCommitToDev: specifies whether the table is automatically committed to the development environment. The value true indicates that the table is automatically committed to the development environment, and the value false indicates that the table is not automatically committed to the development environment.
        # *   tableAutoCommitToProd: specifies whether the table is automatically committed to the production environment. The value true indicates that the table is automatically committed to the production environment, and the value false indicates that the table is not automatically committed to the production environment.
        # *   ignoreLock: specifies whether the lock is automatically ignored when an import task is locked. The value true indicates that the lock is automatically ignored, and the value false indicates that the lock is not automatically ignored. If you set this parameter to true for an import task, you can forcibly update the task even if the task is locked.
        # *   fileAutoCommit: specifies whether the file is automatically committed. The value true indicates that the file is automatically committed, and the value false indicates that the file is not automatically committed.
        # *   fileAutoDeploy: specifies whether the file is automatically deployed. The value true indicates that the file is automatically deployed, and the value false indicates that the file is not automatically deployed.
        self.commit_rule = commit_rule
        # The description of the import package.
        self.description = description
        # The name of the import task. The name must be unique within the workspace.
        self.name = name
        # The path of the import package.
        # 
        # **The import package must be uploaded. Example of the upload method:**`  Config config = new Config(); config.setAccessKeyId(accessId); config.setAccessKeySecret(accessKey); config.setEndpoint(popEndpoint); config.setRegionId(regionId); Client client = new Client(config); CreateImportMigrationAdvanceRequest request = new CreateImportMigrationAdvanceRequest(); request.setName("test_migration_api_" + System.currentTimeMillis()); request.setProjectId(123456L); request.setPackageType("DATAWORKS_MODEL"); request.setPackageFileObject(new FileInputStream("/home/admin/Downloads/test.zip")); RuntimeOptions runtime = new RuntimeOptions(); CreateImportMigrationResponse response = client.createImportMigrationAdvance(request, runtime); ... `
        self.package_file_object = package_file_object
        # The type of the import package. Valid values:
        # 
        # *   DATAWORKS_MODEL (standard format)
        # *   DATAWORKS_V2 (Apsara Stack DataWorks V3.6.1 to V3.11)
        # *   DATAWORKS_V3 (Apsara Stack DataWorks V3.12 and later)
        self.package_type = package_type
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID.
        self.project_id = project_id
        # The mapping between the resource group for scheduling and the resource group for Data Integration. The keys and values in the mapping are the identifiers of the resource groups. Specify the mapping in the following format:
        # 
        # ```
        # 
        # {
        #     "SCHEDULER_RESOURCE_GROUP": {
        #         "xxx": "yyy"
        #     },
        #     "DI_RESOURCE_GROUP": {
        #         "ccc": "dfdd"
        #     }
        # }
        # 
        #                                 
        # ```
        self.resource_group_map = resource_group_map
        # The mapping between the prefixes for the names of the source and destination workspaces. When the system performs the import operation, the prefix for the name of the source workspace in the import package is replaced based on the mapping.
        self.workspace_map = workspace_map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.package_file_object is not None:
            result['PackageFile'] = self.package_file_object
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageFile') is not None:
            self.package_file_object = m.get('PackageFile')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        return self


class CreateImportMigrationResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the import task. The ID is used as an input parameter if you want the system to run the import task or you want to obtain the running progress of the import task.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to locate logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateImportMigrationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateImportMigrationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImportMigrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateManualDagRequest(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        dag_parameters: str = None,
        exclude_node_ids: str = None,
        flow_name: str = None,
        include_node_ids: str = None,
        node_parameters: str = None,
        project_env: str = None,
        project_name: str = None,
    ):
        self.biz_date = biz_date
        self.dag_parameters = dag_parameters
        self.exclude_node_ids = exclude_node_ids
        self.flow_name = flow_name
        self.include_node_ids = include_node_ids
        self.node_parameters = node_parameters
        self.project_env = project_env
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dag_parameters is not None:
            result['DagParameters'] = self.dag_parameters
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.node_parameters is not None:
            result['NodeParameters'] = self.node_parameters
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DagParameters') is not None:
            self.dag_parameters = m.get('DagParameters')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('NodeParameters') is not None:
            self.node_parameters = m.get('NodeParameters')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class CreateManualDagResponseBody(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        request_id: str = None,
    ):
        self.dag_id = dag_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateManualDagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateManualDagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateManualDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        comment: str = None,
        name: str = None,
        parent_id: int = None,
    ):
        self.comment = comment
        self.name = name
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateMetaCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class CreateMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateMetaCategoryResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaCollectionRequest(TeaModel):
    def __init__(
        self,
        collection_type: str = None,
        comment: str = None,
        name: str = None,
        parent_qualified_name: str = None,
    ):
        # The type of the collection.
        self.collection_type = collection_type
        # The comment of the collection.
        # 
        # The comment must be 1 to 64 characters in length.
        self.comment = comment
        # The name of the collection.
        # 
        # The name must be 1 to 32 characters in length.
        self.name = name
        # The unique identifier of the parent collection.
        self.parent_qualified_name = parent_qualified_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_qualified_name is not None:
            result['ParentQualifiedName'] = self.parent_qualified_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentQualifiedName') is not None:
            self.parent_qualified_name = m.get('ParentQualifiedName')
        return self


class CreateMetaCollectionResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: str = None,
        qualified_name: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The unique identifier of the collection.
        self.qualified_name = qualified_name
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.qualified_name is not None:
            result['QualifiedName'] = self.qualified_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('QualifiedName') is not None:
            self.qualified_name = m.get('QualifiedName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetaCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetaCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetaCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePermissionApplyOrderRequestApplyObjectColumnMetaList(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the field on which you want to request permissions. If you want to request permissions on an entire table, enter the names of all fields in the table.
        # 
        # You can request permissions on specific fields of a table in a MaxCompute project only after LabelSecurity is enabled for this project. If LabelSecurity is disabled, you can request permissions only on an entire table.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequestApplyObject(TeaModel):
    def __init__(
        self,
        actions: str = None,
        column_meta_list: List[CreatePermissionApplyOrderRequestApplyObjectColumnMetaList] = None,
        name: str = None,
    ):
        # The permission that you want to request. If you want to request multiple permissions at the same time, separate them with commas (,). You can request only the following permissions: Select, Describe, Drop, Alter, Update, and Download.
        self.actions = actions
        self.column_meta_list = column_meta_list
        # The name of the object on which you want to request permissions. You can request permissions only on MaxCompute tables. Set this parameter to the name of the table on which you want to request permissions.
        self.name = name

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actions is not None:
            result['Actions'] = self.actions
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = CreatePermissionApplyOrderRequestApplyObjectColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        apply_object: List[CreatePermissionApplyOrderRequestApplyObject] = None,
        apply_reason: str = None,
        apply_user_ids: str = None,
        deadline: int = None,
        engine_type: str = None,
        max_compute_project_name: str = None,
        order_type: int = None,
        workspace_id: int = None,
    ):
        self.apply_object = apply_object
        # The reason for your request. The administrator determines whether to approve the request based on the reason.
        self.apply_reason = apply_reason
        # The ID of the Alibaba Cloud account for which you want to request permissions. If you want to request permissions for multiple Alibaba Cloud accounts, separate the IDs of the accounts with commas (,).
        self.apply_user_ids = apply_user_ids
        # The expiration time of the permissions that you request. This value is a UNIX timestamp. If you do not specify a value for this parameter, January 1, 2065 is used as the expiration time.
        # 
        # If LabelSecurity is disabled for the MaxCompute project in which you want to request permissions on the fields of a table, or the security level of the fields is 0 or is lower than or equal to the security level of the Alibaba Cloud account for which you want to request permissions, you can request only permanent permissions.
        # 
        # You can go to the Workspace Management page of the DataWorks console, click MaxCompute Management in the left-side navigation pane, and then check whether column-level access control is enabled.
        # 
        # You can go to your DataWorks workspace, view the security level of the fields in DataMap, and then view the security level of the Alibaba Cloud account on the User Management page.
        self.deadline = deadline
        # The type of the compute engine instance in which you want to request permissions on the fields of a table. The parameter value is odps and cannot be changed. This value indicates that you can request permissions only on fields of tables in MaxCompute compute engine instances.
        self.engine_type = engine_type
        # The name of the MaxCompute project in which you request permissions on the fields of a table.
        self.max_compute_project_name = max_compute_project_name
        # The type of the permission request order. The parameter value is 1 and cannot be changed. This value indicates ACL-based authorization.
        self.order_type = order_type
        # The ID of the DataWorks workspace that is associated with the MaxCompute project in which you want to request permissions on the fields of a table. You can go to the Workspace Management page in the DataWorks console to view the workspace ID.
        self.workspace_id = workspace_id

    def validate(self):
        if self.apply_object:
            for k in self.apply_object:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplyObject'] = []
        if self.apply_object is not None:
            for k in self.apply_object:
                result['ApplyObject'].append(k.to_map() if k else None)
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.apply_user_ids is not None:
            result['ApplyUserIds'] = self.apply_user_ids
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.engine_type is not None:
            result['EngineType'] = self.engine_type
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_object = []
        if m.get('ApplyObject') is not None:
            for k in m.get('ApplyObject'):
                temp_model = CreatePermissionApplyOrderRequestApplyObject()
                self.apply_object.append(temp_model.from_map(k))
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('ApplyUserIds') is not None:
            self.apply_user_ids = m.get('ApplyUserIds')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('EngineType') is not None:
            self.engine_type = m.get('EngineType')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreatePermissionApplyOrderResponseBody(TeaModel):
    def __init__(
        self,
        flow_id: List[str] = None,
        request_id: str = None,
    ):
        # The ID of the request order. If you request permissions on multiple objects but each object has a different request approver, one request order is generated for each object and is sent to the related approver. In this case, an array is returned.
        self.flow_id = flow_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePermissionApplyOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectMemberRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        role_code: str = None,
        user_id: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. We recommend that you set this parameter to a UUID.
        self.client_token = client_token
        # The ID of the DataWorks workspace.
        self.project_id = project_id
        # The code of the role. This parameter is optional. If you specify the RoleCode parameter, the user is assigned the role.
        self.role_code = role_code
        # The ID of the user to be added.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityEntityRequest(TeaModel):
    def __init__(
        self,
        entity_level: int = None,
        env_type: str = None,
        match_expression: str = None,
        project_name: str = None,
        table_name: str = None,
    ):
        # Valid values: 0 (corrected when SQl is completed) and 1 (corrected when task is completed).
        self.entity_level = entity_level
        # The engine or data source type.
        self.env_type = env_type
        # The partition expression.
        self.match_expression = match_expression
        # The name of the maxcompute project or data source.
        self.project_name = project_name
        # The name of the table.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the partition expression.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The returned message.
        self.error_message = error_message
        # The HTTP request error codes.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        alarm_mode: int = None,
        entity_id: int = None,
        follower: str = None,
        project_name: str = None,
    ):
        # The notification method. Valid values: 1, 2, 4, and 5. 1 indicates that the notification is sent by email. 2 indicates that the notification is sent by email and text message. 4 indicates that the notification is sent by a DingTalk chatbot. 5 indicates that the notification is sent by a DingTalk chatbot to all members in a DingTalk group.
        self.alarm_mode = alarm_mode
        # The ID of the partition filter expression.
        self.entity_id = entity_id
        # The user ID of the subscriber.
        self.follower = follower
        # The name of the computing engine instance or data source.
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.follower is not None:
            result['Follower'] = self.follower
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class CreateQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the created subscription relationship.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRelativeNodeRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        node_id: int = None,
        project_id: int = None,
        project_name: str = None,
        table_name: str = None,
        target_node_project_id: int = None,
        target_node_project_name: str = None,
    ):
        # The type of the compute engine instance or data source.
        self.env_type = env_type
        # The partition filter expression.
        self.match_expression = match_expression
        # The ID of the node.
        self.node_id = node_id
        # The ID of the workspace.
        self.project_id = project_id
        # The name of the compute engine instance or data source.
        self.project_name = project_name
        # The name of the table.
        self.table_name = table_name
        # The ID of the workspace to which the node to be associated with the partition filter expression belongs.
        self.target_node_project_id = target_node_project_id
        # The name of the workspace to which the node to be associated with the partition filter expression belongs.
        self.target_node_project_name = target_node_project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        return self


class CreateQualityRelativeNodeResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the node is associated with the partition filter expression.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The error message.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRelativeNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQualityRelativeNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRuleRequest(TeaModel):
    def __init__(
        self,
        block_type: int = None,
        checker: int = None,
        comment: str = None,
        critical_threshold: str = None,
        entity_id: int = None,
        expect_value: str = None,
        method_name: str = None,
        operator: str = None,
        predict_type: int = None,
        project_name: str = None,
        property: str = None,
        property_type: str = None,
        rule_name: str = None,
        rule_type: int = None,
        template_id: int = None,
        trend: str = None,
        warning_threshold: str = None,
        where_condition: str = None,
    ):
        # The strength of the monitoring rule. Valid values: 0 and 1. 0 indicates that the monitoring rule is a weak rule. 1 indicates that the monitoring rule is a strong rule.
        self.block_type = block_type
        # The ID of the checker.
        self.checker = checker
        # The description of the monitoring rule.
        self.comment = comment
        # The threshold for a critical alert. The threshold indicates the deviation of the monitoring result from the expected value. You can customize this threshold based on your business requirements. If a strong rule is used and a critical alert is reported, nodes are blocked.
        self.critical_threshold = critical_threshold
        # The ID of the partition filter expression.
        self.entity_id = entity_id
        # The expected value of the monitoring result.
        self.expect_value = expect_value
        # The method used to collect sample data. If you want to use a custom SQL statement as a sampling method, set this parameter to user_defined.
        self.method_name = method_name
        # The comparison operator of the monitoring rule.
        self.operator = operator
        # Specifies whether the monitoring rule is a dynamic threshold rule. Valid values: 0 and 2. 0 indicates that the monitoring rule is not a dynamic threshold rule. 2 indicates that the monitoring rule is a dynamic threshold rule.
        self.predict_type = predict_type
        # The name of the compute engine instance or data source.
        self.project_name = project_name
        # The fields that you want to monitor. If you want to monitor all fields in a table and check the table rows, set this parameter to table_count. If you want to monitor all fields in a table and check the table size, set this parameter to table_size.
        self.property = property
        # The data type of the fields that you want to monitor. If you want to monitor all fields in a table, set this parameter to table. If you want to monitor only a specific field, set this parameter to bigint.
        self.property_type = property_type
        # The name of the monitoring rule.
        self.rule_name = rule_name
        # The type of the monitoring rule. Valid values: 0, 1, and 2. 0 indicates that the monitoring rule is created by the system. 1 indicates that the monitoring rule is created by a user. 2 indicates that the monitoring rule is a workspace-level rule.
        self.rule_type = rule_type
        # The ID of the template that is used to create the monitoring rule.
        self.template_id = template_id
        # The trend of the monitoring result. Valid values:
        # 
        # *   up: increasing
        # *   down: decreasing
        # *   abs: absolute value
        self.trend = trend
        # The threshold for a warning alert. The threshold indicates the deviation of the monitoring result from the expected value. You can customize this threshold based on your business requirements.
        self.warning_threshold = warning_threshold
        # The filter condition or custom SQL statement.
        self.where_condition = where_condition

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.property is not None:
            result['Property'] = self.property
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        return self


class CreateQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the monitoring rule that you created.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemindRequest(TeaModel):
    def __init__(
        self,
        alert_interval: int = None,
        alert_methods: str = None,
        alert_targets: str = None,
        alert_unit: str = None,
        baseline_ids: str = None,
        biz_process_ids: str = None,
        detail: str = None,
        dnd_end: str = None,
        max_alert_times: int = None,
        node_ids: str = None,
        project_id: int = None,
        remind_name: str = None,
        remind_type: str = None,
        remind_unit: str = None,
        robot_urls: str = None,
        webhooks: str = None,
    ):
        # The minimum interval at which alerts are reported. Unit: seconds. Minimum value: 1200. Default value: 1800.
        self.alert_interval = alert_interval
        # The notification method. Valid values:
        # 
        # *   MAIL: Alert notifications are sent by emails.
        # 
        # *   SMS: Alert notifications are sent by text messages.
        # 
        #     Alert notifications can be sent by text messages only in the Singapore, Malaysia (Kuala Lumpur), and Germany (Frankfurt) regions.
        # 
        # *   WEBHOOKS (WeCom or Lark chatbot): Alert notifications are sent by WeCom or Lark messages. If you want to use this notification method, you must configure the Webhooks parameter.
        # 
        # You can specify multiple notification methods. Separate them with commas (,).
        self.alert_methods = alert_methods
        # *   If the AlertUnit parameter is set to OWNER, leave this parameter empty.
        # *   If the AlertUnit parameter is set to OTHER, set this parameter to the ID of the Alibaba Cloud account used by a specific user. You can specify multiple IDs. Separate multiple IDs with commas (,). You can specify a maximum of 10 IDs.
        self.alert_targets = alert_targets
        # The recipient of the alert. Valid values: OWNER and OTHER. The value OWNER indicates the node owner. The value OTHER indicates a specified user.
        self.alert_unit = alert_unit
        # The ID of the baseline to which the custom alert rule is applied. This parameter takes effect when the RemindUnit parameter is set to BASELINE. You can specify multiple IDs. Separate multiple IDs with commas (,). A maximum of five baselines can be specified for a custom alert rule.
        self.baseline_ids = baseline_ids
        # The ID of the workflow to which the custom alert rule is applied. This parameter takes effect when the RemindUnit parameter is set to BIZPROCESS. You can specify multiple IDs. Separate multiple IDs with commas (,). A maximum of five workflows can be specified for a custom alert rule.
        self.biz_process_ids = biz_process_ids
        # The details of the conditions that trigger an alert.
        # 
        # *   If the RemindType parameter is set to FINISHED, leave this parameter empty.
        # *   If the RemindType parameter is set to UNFINISHED, specify this parameter as key-value pairs. Example: {"hour":23,"minu":59}. Valid values of hour: 0 to 47. Valid values of minu: 0 to 59.
        # *   If the RemindType parameter is set to ERROR, leave this parameter empty.
        # *   If the RemindType parameter is set to CYCLE_UNFINISHED, specify this parameter as key-value pairs. Example: {"1":"05:50","2":"06:50","3":"07:50","4":"08:50","5":"09:50","6":"10:50","7":"11:50","8":"12:50","9":"13:50","10":"14:50","11":"15:50","12":"16:50","13":"17:50","14":"18:50","15":"19:50","16":"20:50","17":"21:50","18":"22:50","19":"23:50","20":"24:50","21":"25:50"}. The key indicates the ID of the cycle. Valid values of the ID: 1 to 288. The value indicates the timeout period of the node that is running in the cycle. Specify the value in the hh:mm format. Valid values of hh: 0 to 47. Valid values of mm: 0 to 59.
        # *   If the RemindType parameter is set to TIMEOUT, set this parameter to the timeout period. Unit: seconds. Example: 1800. This value indicates that an alert is reported if the node has run for more than 30 minutes.
        self.detail = detail
        # The end time of the quiet hours. Specify the time in the hh:mm format. Valid values of hh: 0 to 23. Valid values of mm: 0 to 59.
        self.dnd_end = dnd_end
        # The maximum number of alerts. Valid values: 1 to 10. Default value: 3.
        self.max_alert_times = max_alert_times
        # The ID of the node to which the custom alert rule is applied. This parameter takes effect when the RemindUnit parameter is set to NODE. You can specify multiple IDs. Separate multiple IDs with commas (,). A maximum of 50 nodes can be specified for a custom alert rule.
        self.node_ids = node_ids
        # The ID of the workspace to which the custom alert rule is applied. This parameter takes effect when the RemindUnit parameter is set to PROJECT. Only one workspace can be specified for a custom alert rule.
        self.project_id = project_id
        # The name of the custom alert rule. The name must be 1 to 128 characters in length.
        self.remind_name = remind_name
        # The conditions that trigger an alert. Valid values: FINISHED, UNFINISHED, ERROR, CYCLE_UNFINISHED, and TIMEOUT. The value FINISHED indicates that the node is run. The value UNFINISHED indicates that the node is still running at the specified point in time. The value ERROR indicates that an error occurs when the node is running. The value CYCLE_UNFINISHED indicates that the node is still running in the specified cycle. The value TIMEOUT indicates that the node times out.
        self.remind_type = remind_type
        # The type of the object to which the custom alert rule is applied. Valid values: NODE, BASELINE, PROJECT, and BIZPROCESS. The value NODE indicates a node. The value BASELINE indicates a baseline. The value PROJECT indicates a workspace. The value BIZPROCESS indicates a workflow.
        self.remind_unit = remind_unit
        # The webhook URL of the DingTalk chatbot. You can specify multiple webhook URLs. Separate the specified webhook URLs with commas (,).
        self.robot_urls = robot_urls
        # The webhook URL of the WeCom or Lark chatbot. You can specify multiple webhook URLs. Separate the specified webhook URLs with commas (,). The WEBHOOKS notification method must be specified for alertMethods.
        # 
        # Only DataWorks Enterprise Edition supports this parameter.
        # 
        # The webhook URL-based alerting feature is supported in the following regions: China (Shanghai), China (Chengdu), China (Zhangjiakou), China (Beijing), China (Hangzhou), China (Shenzhen), China (Hong Kong), Germany (Frankfurt), and Singapore.
        self.webhooks = webhooks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        if self.baseline_ids is not None:
            result['BaselineIds'] = self.baseline_ids
        if self.biz_process_ids is not None:
            result['BizProcessIds'] = self.biz_process_ids
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        if self.robot_urls is not None:
            result['RobotUrls'] = self.robot_urls
        if self.webhooks is not None:
            result['Webhooks'] = self.webhooks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        if m.get('BaselineIds') is not None:
            self.baseline_ids = m.get('BaselineIds')
        if m.get('BizProcessIds') is not None:
            self.biz_process_ids = m.get('BizProcessIds')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        if m.get('RobotUrls') is not None:
            self.robot_urls = m.get('RobotUrls')
        if m.get('Webhooks') is not None:
            self.webhooks = m.get('Webhooks')
        return self


class CreateRemindResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the custom alert rule returned.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRemindResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableRequestColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_name_cn: str = None,
        column_type: str = None,
        comment: str = None,
        is_partition_col: bool = None,
        length: int = None,
        seq_number: int = None,
    ):
        # The name of the field.
        # 
        # You can call the CreateTable operation to configure a maximum of 1,000 fields.
        self.column_name = column_name
        # The display name of the field.
        self.column_name_cn = column_name_cn
        # The data type of the field.
        self.column_type = column_type
        # The comment of the field.
        self.comment = comment
        # Specifies whether the current field is a partition field.
        self.is_partition_col = is_partition_col
        # The length of the field. For more information, see [MaxCompute V2.0 data type edition](~~159541#concept-2454988~~).
        self.length = length
        # The sequence number of the field. You can use this parameter to specify how fields are sorted in a table. By default, fields are sorted in the order in which requests are created.
        # 
        # If the field is a partition field, this parameter is not supported.
        self.seq_number = seq_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_partition_col is not None:
            result['IsPartitionCol'] = self.is_partition_col
        if self.length is not None:
            result['Length'] = self.length
        if self.seq_number is not None:
            result['SeqNumber'] = self.seq_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsPartitionCol') is not None:
            self.is_partition_col = m.get('IsPartitionCol')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('SeqNumber') is not None:
            self.seq_number = m.get('SeqNumber')
        return self


class CreateTableRequestThemes(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        theme_level: int = None,
    ):
        # The ID of the topic.
        self.theme_id = theme_id
        # The level that corresponds to the topic ID.
        self.theme_level = theme_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.theme_level is not None:
            result['ThemeLevel'] = self.theme_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ThemeLevel') is not None:
            self.theme_level = m.get('ThemeLevel')
        return self


class CreateTableRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        category_id: int = None,
        client_token: str = None,
        columns: List[CreateTableRequestColumns] = None,
        comment: str = None,
        endpoint: str = None,
        env_type: int = None,
        external_table_type: str = None,
        has_part: int = None,
        is_view: int = None,
        life_cycle: int = None,
        location: str = None,
        logical_level_id: int = None,
        owner_id: str = None,
        physics_level_id: int = None,
        project_id: int = None,
        schema: str = None,
        table_name: str = None,
        themes: List[CreateTableRequestThemes] = None,
        visibility: int = None,
    ):
        # The globally unique identifier (GUID) of the MaxCompute project. Specify the GUID in the odps.{projectName} format.
        self.app_guid = app_guid
        # The ID of the associated category. You can call the [GetMetaCategory](~~173932~~) operation to query the ID of the category that can be associated.
        self.category_id = category_id
        # A reserved parameter.
        self.client_token = client_token
        self.columns = columns
        # The comment.
        self.comment = comment
        # The endpoint of MaxCompute.
        self.endpoint = endpoint
        # The environment of the DataWorks workspace. Valid values:
        # 
        # *   0: development environment
        # *   1: production environment
        self.env_type = env_type
        # The storage type of the external table. Valid values:
        # 
        # *   0: Object Storage Service (OSS)
        # *   1: Tablestore
        # *   2: Volume
        # *   3: MySQL
        self.external_table_type = external_table_type
        # Specifies whether the MaxCompute table is a partitioned table. Valid values: 1 and 0. The value 1 indicates that the MaxCompute table is a partitioned table. The value 0 indicates that the MaxCompute table is not a partitioned table. This parameter is deprecated. Do not use this parameter.
        # 
        # The Column.N.isPartitionCol parameter is used to specify whether the MaxCompute table is a partitioned table. If the Column.N.isPartitionCol parameter is set to true, the MaxCompute table is a partitioned table.
        self.has_part = has_part
        # Specifies whether to create a view or table.
        # 
        # *   0: Create a table.
        # *   1: Create a view.
        self.is_view = is_view
        # The lifecycle of the table. Unit: days. By default, this parameter is left empty, which indicates that the table is permanently stored.
        self.life_cycle = life_cycle
        # The storage location of the external table.
        self.location = location
        # The ID of the logical level.
        self.logical_level_id = logical_level_id
        self.owner_id = owner_id
        # The ID of the physical level.
        self.physics_level_id = physics_level_id
        # The ID of the DataWorks workspace.
        self.project_id = project_id
        # The schema information of the table. You need to enter the schema information of the table if you enable the table schema in MaxCompute.
        self.schema = schema
        # The name of the table.
        self.table_name = table_name
        self.themes = themes
        # Specifies whether the table or workspace is visible:
        # 
        # *   0: Both the table and workspace are not visible.
        # *   1: The table and workspace are visible.
        # *   2: Only the workspace is visible.
        self.visibility = visibility

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()
        if self.themes:
            for k in self.themes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.external_table_type is not None:
            result['ExternalTableType'] = self.external_table_type
        if self.has_part is not None:
            result['HasPart'] = self.has_part
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.logical_level_id is not None:
            result['LogicalLevelId'] = self.logical_level_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.physics_level_id is not None:
            result['PhysicsLevelId'] = self.physics_level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.table_name is not None:
            result['TableName'] = self.table_name
        result['Themes'] = []
        if self.themes is not None:
            for k in self.themes:
                result['Themes'].append(k.to_map() if k else None)
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = CreateTableRequestColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ExternalTableType') is not None:
            self.external_table_type = m.get('ExternalTableType')
        if m.get('HasPart') is not None:
            self.has_part = m.get('HasPart')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('LogicalLevelId') is not None:
            self.logical_level_id = m.get('LogicalLevelId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PhysicsLevelId') is not None:
            self.physics_level_id = m.get('PhysicsLevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        self.themes = []
        if m.get('Themes') is not None:
            for k in m.get('Themes'):
                temp_model = CreateTableRequestThemes()
                self.themes.append(temp_model.from_map(k))
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        return self


class CreateTableResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        next_task_id: str = None,
        status: str = None,
        task_id: str = None,
    ):
        # Details about the status of the current subtask.
        # 
        # *   If the current subtask succeeds, success is returned.
        # *   If the current subtask fails, the error details are displayed.
        self.content = content
        # The ID of the subtask that you want to run. If this parameter is left empty, all subtasks are complete. You can call the [GetDDLJobStatus](~~185659~~) operation to query the status of the subtask based on the subtask ID.
        self.next_task_id = next_task_id
        # The status of the current subtask. Valid values:
        # 
        # *   operating: The subtask is running.
        # *   success: The subtask succeeds.
        # *   failure: The subtask fails to run. For more information about the error details, see the Content parameter.
        self.status = status
        # The ID of the current subtask.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: CreateTableResponseBodyTaskInfo = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The information about the request task.
        # 
        # After a request task is submitted, it is divided into multiple subtasks that are run in sequence. After the current subtask is complete, the next subtask starts to run. After all subtasks are complete, the request task is complete.
        # 
        # If a request task is aborted due to one of the following issues, address the issue based on the error code and initiate the request task again:
        # 
        # *   The request task fails to be submitted.
        # *   After the request task is submitted, a subtask fails to run.
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTableResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableLevelRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        level_type: int = None,
        name: str = None,
        project_id: int = None,
    ):
        # The description of the table level.
        self.description = description
        # The type of the table level. Valid values: 1 and 2. A value of 1 indicates the logical level. A value of 2 indicates the physical level.
        self.level_type = level_type
        # The name of the table level.
        self.name = name
        # The ID of the DataWorks workspace.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateTableLevelResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        level_id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the table level.
        self.level_id = level_id
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTableLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTableLevelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableThemeRequest(TeaModel):
    def __init__(
        self,
        level: int = None,
        name: str = None,
        parent_id: int = None,
        project_id: int = None,
    ):
        # The level of the table folder. Valid values: 1 and 2. A value of 1 indicates a first-level table folder. A value of 2 indicates a second-level table folder.
        self.level = level
        # The name of the table folder.
        self.name = name
        # The ID of the level of the parent table folder.
        self.parent_id = parent_id
        # The ID of the DataWorks workspace.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CreateTableThemeResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        theme_id: int = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success
        # The ID of the created table folder.
        self.theme_id = theme_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class CreateTableThemeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTableThemeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUdfFileRequest(TeaModel):
    def __init__(
        self,
        class_name: str = None,
        cmd_description: str = None,
        example: str = None,
        file_folder_path: str = None,
        file_name: str = None,
        function_type: str = None,
        parameter_description: str = None,
        project_id: int = None,
        project_identifier: str = None,
        resources: str = None,
        return_value: str = None,
        udf_description: str = None,
    ):
        # The name of the class in which the function is defined. This parameter corresponds to the Class Name parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.class_name = class_name
        # The syntax used for calling the function. This parameter corresponds to the Expression Syntax parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.cmd_description = cmd_description
        # The example for calling the function. This parameter corresponds to the Example parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.example = example
        # The path of the folder in which the file for the function is stored.
        self.file_folder_path = file_folder_path
        # The name of the file for the function.
        self.file_name = file_name
        # The type of the function. Valid values: MATH, AGGREGATE, STRING, DATE, ANALYTIC, and OTHER. This parameter corresponds to the Function Type parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.function_type = function_type
        # The description of the input parameters of the function. This parameter corresponds to the Parameter Description parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.parameter_description = parameter_description
        # The ID of the DataWorks workspace. You can click the Workspace Manage icon in the upper-right corner of the DataStudio page to go to the Workspace Management page and view the workspace ID.
        self.project_id = project_id
        # The unique identifier of the DataWorks workspace. You can click the identifier in the upper-left corner of the DataStudio page to switch to another workspace.
        # 
        # You must specify either this parameter or the projectId parameter to determine the DataWorks workspace to which the operation is called.
        self.project_identifier = project_identifier
        # The names of the resources that are referenced by the function. This parameter corresponds to the Resources parameter in the Register Function section of the configuration tab of the function in the DataWorks console. Multiple resource names are separated by commas (,).
        self.resources = resources
        # The description of the return value of the function. This parameter corresponds to the Return Value parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.return_value = return_value
        # The description of the function. This parameter corresponds to the Description parameter in the Register Function section of the configuration tab of the function in the DataWorks console.
        self.udf_description = udf_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        if self.cmd_description is not None:
            result['CmdDescription'] = self.cmd_description
        if self.example is not None:
            result['Example'] = self.example
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.function_type is not None:
            result['FunctionType'] = self.function_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        if self.udf_description is not None:
            result['UdfDescription'] = self.udf_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        if m.get('CmdDescription') is not None:
            self.cmd_description = m.get('CmdDescription')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FunctionType') is not None:
            self.function_type = m.get('FunctionType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        if m.get('UdfDescription') is not None:
            self.udf_description = m.get('UdfDescription')
        return self


class CreateUdfFileResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the file that was created.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateUdfFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUdfFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUdfFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBaselineRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        project_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteBaselineResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        dynamic_error_code: str = None,
        dynamic_error_message: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.dynamic_error_code = dynamic_error_code
        self.dynamic_error_message = dynamic_error_message
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_error_code is not None:
            result['DynamicErrorCode'] = self.dynamic_error_code
        if self.dynamic_error_message is not None:
            result['DynamicErrorMessage'] = self.dynamic_error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicErrorCode') is not None:
            self.dynamic_error_code = m.get('DynamicErrorCode')
        if m.get('DynamicErrorMessage') is not None:
            self.dynamic_error_message = m.get('DynamicErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBaselineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBusinessRequest(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the workflow. You can call the [ListBusiness](~~173945~~) operation to query the workflow ID.
        self.business_id = business_id
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID. You must specify either this parameter or ProjectIdentifier to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Settings panel to obtain the name. You must specify either this parameter or ProjectId to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeleteBusinessResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBusinessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConnectionRequest(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
    ):
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class DeleteConnectionResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        # The ID of the real-time synchronization node. You can call the [ListFiles](~~173942~~) operation to query the ID of the node.
        self.file_id = file_id
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        # 
        # You must set this parameter to specify the DataWorks workspace in which the synchronization node resides.
        self.project_id = project_id
        # The type of the synchronization node in Data Integration.
        # 
        # The parameter value is DI_REALTIME and cannot be changed. The value indicates a real-time synchronization node.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DeleteDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        status: str = None,
    ):
        # The reason why the synchronization node in Data Integration failed to be deleted.
        # 
        # If the synchronization node in Data Integration is deleted, the value null is returned.
        self.message = message
        # Indicates whether the synchronization node in Data Integration is deleted. Valid values:
        # 
        # *   success: The synchronization node in Data Integration is deleted.
        # *   fail: The synchronization node in Data Integration failed to be deleted. You can troubleshoot the issue based on the failure reason.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: DeleteDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The result returned after you called the DeleteDISyncTask operation.
        self.data = data
        # The ID of the request. You can use the ID to locate logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        authorized_project_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        # The ID of the API.
        self.api_id = api_id
        # The ID of the workspace from which you want to revoke the access permissions on the API.
        self.authorized_project_id = authorized_project_id
        # The ID of the workspace.
        self.project_id = project_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the access permissions are revoked.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDataServiceApiAuthorityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(
        self,
        data_source_id: int = None,
    ):
        # The ID of the data source. You can call the [ListDataSources](~~211431~~) operation to obtain the ID.
        self.data_source_id = data_source_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DeleteDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        http_status_code: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the request is successful.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the file. You can call the [ListFiles](~~173942~~) operation to query the ID of the file.
        self.file_id = file_id
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to view the workspace ID.
        # 
        # You must specify one of the ProjectId and ProjectIdentifier parameters to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to view the workspace name.
        # 
        # You must specify one of the ProjectId and ProjectIdentifier parameters to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeleteFileResponseBody(TeaModel):
    def __init__(
        self,
        deployment_id: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the deployment task that deploys the file. If the file has been committed, an asynchronous process is triggered to delete the file in the scheduling system. The value of this parameter is used to call the GetDeployment operation to poll the status of the asynchronous process.
        # 
        # If this parameter is empty, the file is deleted and the polling is not required.
        self.deployment_id = deployment_id
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request. You can troubleshoot errors based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFolderRequest(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the folder. You can call the [ListFolders](~~173955~~) operation to query the ID.
        self.folder_id = folder_id
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID. You must specify either this parameter or ProjectIdentifier to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Settings panel to obtain the name. You must specify either this parameter or ProjectId to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeleteFolderResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFolderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFromMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class DeleteFromMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFromMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFromMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFromMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DeleteMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetaCollectionRequest(TeaModel):
    def __init__(
        self,
        qualified_name: str = None,
    ):
        # The unique identifier of the collection.
        self.qualified_name = qualified_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qualified_name is not None:
            result['QualifiedName'] = self.qualified_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QualifiedName') is not None:
            self.qualified_name = m.get('QualifiedName')
        return self


class DeleteMetaCollectionResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        status: bool = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id
        # The result of the operation. Valid values:
        # 
        # true: succeeded
        # 
        # false: failed
        self.status = status
        # Indicates whether the request was successful. Valid values:
        # 
        # true: The request was successful.
        # 
        # false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetaCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetaCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetaCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetaCollectionEntityRequest(TeaModel):
    def __init__(
        self,
        collection_qualified_name: str = None,
        entity_qualified_name: str = None,
    ):
        # The unique identifier of the collection.
        self.collection_qualified_name = collection_qualified_name
        # The unique identifier of the entity.
        self.entity_qualified_name = entity_qualified_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection_qualified_name is not None:
            result['CollectionQualifiedName'] = self.collection_qualified_name
        if self.entity_qualified_name is not None:
            result['EntityQualifiedName'] = self.entity_qualified_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CollectionQualifiedName') is not None:
            self.collection_qualified_name = m.get('CollectionQualifiedName')
        if m.get('EntityQualifiedName') is not None:
            self.entity_qualified_name = m.get('EntityQualifiedName')
        return self


class DeleteMetaCollectionEntityResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        status: bool = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # The result of the operation. Valid values:
        # 
        # true: succeeded
        # 
        # false: failed
        self.status = status
        # Indicates whether the request was successful. Valid values:
        # 
        # true: The request was successful.
        # 
        # false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetaCollectionEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetaCollectionEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetaCollectionEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectMemberRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
    ):
        # The ID of the DataWorks workspace.
        self.project_id = project_id
        # The ID of the user.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the region.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityEntityRequest(TeaModel):
    def __init__(
        self,
        entity_id: int = None,
        env_type: str = None,
        project_name: str = None,
    ):
        # The ID of the partition filter expression.
        self.entity_id = entity_id
        # The type of the compute engine instance or data source. Valid values: EMR, Hologres, AnalyticDB for PostgreSQL, CDH, MaxCompute, Kafka and DataHub.
        self.env_type = env_type
        # The name of the compute engine instance or data source.
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class DeleteQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The result returned.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        follower_id: int = None,
        project_name: str = None,
    ):
        # The ID of the subscription relationship between the partition filter expression and the subscriber. You can call the [GetQualityFollower](~~174000~~) operation to obtain the ID of the subscription relationship.
        self.follower_id = follower_id
        # The name of the compute engine or data source for which the partition filter expression is configured. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Monitoring Rules page of Data Quality to obtain the name.
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.follower_id is not None:
            result['FollowerId'] = self.follower_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FollowerId') is not None:
            self.follower_id = m.get('FollowerId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class DeleteQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the subscriber was successfully deleted. Valid values:
        # 
        # *   true: The subscriber was successfully deleted.
        # *   false: The subscriber failed to be deleted. You can troubleshoot errors based on the error message returned.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned when the subscriber failed to be deleted.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot errors.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRelativeNodeRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        node_id: int = None,
        project_id: int = None,
        project_name: str = None,
        table_name: str = None,
        target_node_project_id: int = None,
        target_node_project_name: str = None,
    ):
        # The environment in which the compute engine instance runs. Valid values: DEV and PRD. The value DEV indicates the development environment, and the value PRD indicates the production environment.
        self.env_type = env_type
        # The partition filter expression.
        self.match_expression = match_expression
        # The ID of the node.
        self.node_id = node_id
        # The ID of the workspace.
        self.project_id = project_id
        # The name of the compute engine instance or data source.
        self.project_name = project_name
        # The name of the table that is generated by the node.
        self.table_name = table_name
        # The ID of the workspace to which the node associated with the partition filter expression belongs.
        self.target_node_project_id = target_node_project_id
        # The name of the workspace to which the node associated with the partition filter expression belongs.
        self.target_node_project_name = target_node_project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        return self


class DeleteQualityRelativeNodeResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the node is disassociated from the partition filter expression.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRelativeNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteQualityRelativeNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRuleRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        rule_id: int = None,
    ):
        # The name of the database engine or data source.
        self.project_name = project_name
        # The ID of the rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the deletion was successful.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The returned message.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemindRequest(TeaModel):
    def __init__(
        self,
        remind_id: int = None,
    ):
        # The ID of the custom alert rule.
        self.remind_id = remind_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class DeleteRemindResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the custom alert rule is deleted. Valid values: true and false. The value true indicates that the custom alert rule is deleted. The value false indicates that the custom alert rule fails to be deleted.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRemindResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        env_type: int = None,
        project_id: int = None,
        schema: str = None,
        table_name: str = None,
    ):
        # The globally unique identifier (GUID) of the MaxCompute project. Specify the GUID in the odps.{projectName} format.
        self.app_guid = app_guid
        # The environment of the DataWorks workspace. Valid values: 0 and 1. The value 0 indicates the development environment. The value 1 indicates the production environment.
        self.env_type = env_type
        # The ID of the DataWorks workspace.
        self.project_id = project_id
        # The schema information of the table. You need to enter the schema information of the table if you enable the table schema in MaxCompute.
        self.schema = schema
        # The name of the MaxCompute table.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DeleteTableResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        next_task_id: str = None,
        status: str = None,
        task_id: str = None,
    ):
        # The content of the task.
        self.content = content
        # The ID of the task that is running.
        self.next_task_id = next_task_id
        # The status of the task that is complete.
        self.status = status
        # The ID of the task that is complete.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: DeleteTableResponseBodyTaskInfo = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The information about the task that is used to delete the table.
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class DeleteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTableResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableLevelRequest(TeaModel):
    def __init__(
        self,
        level_id: int = None,
        project_id: int = None,
    ):
        # The ID of the table level to be deleted. You can call the ListTableLevel operation to obtain the ID.
        self.level_id = level_id
        # The ID of the DataWorks workspace.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableLevelResponseBody(TeaModel):
    def __init__(
        self,
        delete_result: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the table level is deleted.
        self.delete_result = delete_result
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTableLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTableLevelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableThemeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        theme_id: int = None,
    ):
        # The ID of the DataWorks workspace.
        self.project_id = project_id
        # The ID of the table folder.
        self.theme_id = theme_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class DeleteTableThemeResponseBody(TeaModel):
    def __init__(
        self,
        delete_result: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Indicates whether the table folder is deleted.
        self.delete_result = delete_result
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteTableThemeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTableThemeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        # *   If you set the TaskType parameter to DI_REALTIME, set the FileId parameter to the ID of the real-time synchronization node that you want to deploy.
        # *   If you set the TaskType parameter to DI_SOLUTION, set the FileId parameter to the ID of the data synchronization solution that you want to deploy.
        # 
        # You can call the [ListFiles](~~173942~~) operation to query the ID of the real-time synchronization node or data synchronization solution.
        self.file_id = file_id
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to query the workspace ID.
        # 
        # This parameter specifies the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The type of the object that you want to deploy. Valid values:
        # 
        # *   DI_REALTIME: real-time synchronization node
        # *   DI_SOLUTION: data synchronization solution
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DeployDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        status: str = None,
    ):
        # The cause of the failure to deploy the real-time synchronization node or data synchronization solution.
        # 
        # If the real-time synchronization node or data synchronization solution is deployed, the value null is returned.
        self.message = message
        # Indicates whether the real-time synchronization node or data synchronization solution is deployed. Valid values:
        # 
        # *   success: The real-time synchronization node or data synchronization solution is deployed.
        # *   fail: The real-time synchronization node or data synchronization solution fails to be deployed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeployDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: DeployDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The result of deploying the real-time synchronization node or data synchronization solution.
        self.data = data
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeployDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeployDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeployDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeployDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployFileRequest(TeaModel):
    def __init__(
        self,
        comment: str = None,
        file_id: int = None,
        node_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The description of the deployment operation.
        self.comment = comment
        # The ID of the file. You can call the [ListFiles](~~173942~~) operation to query the ID.
        # 
        # You must configure either the FileId parameter or the NodeId parameter.
        self.file_id = file_id
        # The ID of the node in the scheduling system that corresponds to the file that you want to deploy. You must configure either the NodeId parameter or the FileId parameter.
        self.node_id = node_id
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the workspace ID. You must configure either this parameter or the ProjectIdentifier parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the workspace name. You must configure either this parameter or the ProjectId parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class DeployFileResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the deployment task. The ID is used as the value of a specific request parameter when you call the [GetDeployment](~~173950~~) operation to query the details of the deployment task.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeployFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeployFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeployFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DesensitizeDataRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        scene_code: str = None,
    ):
        # The data that you want to mask.
        self.data = data
        # The code of the data masking scene. You can view the code on the Data Masking page in Data Security Guard of the DataWorks console.
        self.scene_code = scene_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.scene_code is not None:
            result['SceneCode'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('SceneCode') is not None:
            self.scene_code = m.get('SceneCode')
        return self


class DesensitizeDataResponseBody(TeaModel):
    def __init__(
        self,
        desensitize_data: str = None,
        request_id: str = None,
    ):
        # The data returned after masking.
        self.desensitize_data = desensitize_data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desensitize_data is not None:
            result['DesensitizeData'] = self.desensitize_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesensitizeData') is not None:
            self.desensitize_data = m.get('DesensitizeData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DesensitizeDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DesensitizeDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DesensitizeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EstablishRelationTableToBusinessRequest(TeaModel):
    def __init__(
        self,
        business_id: str = None,
        folder_id: str = None,
        project_id: int = None,
        project_identifier: str = None,
        table_guid: str = None,
    ):
        # The ID of the workflow. You can call the [ListBusiness](~~173945~~) operation to query the ID.
        self.business_id = business_id
        # The ID of the folder. You can call the [GetFolder](~~173952~~) or [ListFolders](~~173955~~) operation to query the ID.
        self.folder_id = folder_id
        # The ID of the DataWorks workspace. You can click the Workspace Manage icon in the upper-right corner of the DataStudio page to go to the Workspace Management page and view the workspace ID.
        self.project_id = project_id
        # The unique identifier of the DataWorks workspace. You can click the identifier in the upper-left corner of the DataStudio page to switch to another workspace.
        # 
        # You must specify either this parameter or ProjectId to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier
        # The universally unique identifier (UUID) of the table. You can call the [SearchMetaTables](~~173919~~) operation to query the UUID.
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class EstablishRelationTableToBusinessResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EstablishRelationTableToBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EstablishRelationTableToBusinessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EstablishRelationTableToBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        data_source_type: str = None,
        env_type: int = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        sub_type: str = None,
    ):
        # The data source type. Valid values:
        # 
        # *   odps
        # *   mysql
        # *   rds
        # *   oss
        # *   sqlserver
        # *   polardb
        # *   oracle
        # *   mongodb
        # *   emr
        # *   postgresql
        # *   analyticdb_for_mysql
        # *   hybriddb_for_postgresql
        # *   holo
        self.data_source_type = data_source_type
        # The environment to which the data sources belong. Valid values:
        # 
        # *   0: development environment
        # *   1: production environment
        self.env_type = env_type
        # The keyword contained in the names of the data sources to be exported.
        # 
        # You can specify only one keyword. For example, if you set this parameter to test, all the data sources whose names contain test in the specified workspace are exported.
        self.name = name
        # The number of the page to return. The value of this parameter must be a positive integer greater than or equal to 1.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The ID of the DataWorks workspace to which the data sources belong. You can call the [ListProjects](~~178393~~) operation to query the ID of the workspace.
        self.project_id = project_id
        # The data source subtype. This parameter takes effect only if the DataSourceType parameter is set to rds.
        # 
        # If the DataSourceType parameter is set to rds, this parameter can be set to mysql, sqlserver, or postgresql.
        self.sub_type = sub_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        return self


class ExportDataSourcesResponseBodyDataDataSources(TeaModel):
    def __init__(
        self,
        binding_calc_engine_id: int = None,
        connect_status: int = None,
        content: str = None,
        data_source_type: str = None,
        default_engine: bool = None,
        description: str = None,
        env_type: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        name: str = None,
        operator: str = None,
        project_id: int = None,
        sequence: int = None,
        shared: bool = None,
        status: int = None,
        sub_type: str = None,
        tenant_id: int = None,
    ):
        # The ID of the compute engine to which the data source is bound.
        self.binding_calc_engine_id = binding_calc_engine_id
        # Indicates whether the data source is connected to an exclusive resource group. Valid values:
        # 
        # *   1: The data source is connected to at least one exclusive resource group.
        # *   0: The data source is not connected to any exclusive resource group.
        self.connect_status = connect_status
        # The configuration of the data source.
        self.content = content
        # The type of the data source. Valid values:
        # 
        # *   odps
        # *   mysql
        # *   rds
        # *   oss
        # *   sqlserver
        # *   polardb
        # *   oracle
        # *   mongodb
        # *   emr
        # *   postgresql
        # *   analyticdb_for_mysql
        # *   hybriddb_for_postgresql
        # *   holo
        self.data_source_type = data_source_type
        # Indicates whether the compute engine to which the data source is bound is the default compute engine. Valid values:
        # 
        # *   true: The compute engine is the default compute engine.
        # *   false: The compute engine is not the default compute engine.
        self.default_engine = default_engine
        # The description of the data source.
        self.description = description
        # The environment to which the data source belongs. Valid values:
        # 
        # *   0: development environment
        # *   1: production environment
        self.env_type = env_type
        # The time when the data source was created. Example: Mar 17, 2021 4:09:32 PM.
        self.gmt_create = gmt_create
        # The time when the data source was last modified. Example: Mar 17, 2021 4:09:32 PM.
        self.gmt_modified = gmt_modified
        # The ID of the data source.
        self.id = id
        # The name of the data source.
        self.name = name
        # The ID of the user who exported the data source.
        self.operator = operator
        # The ID of the DataWorks workspace to which the data source belongs.
        self.project_id = project_id
        # The sequence number of the data source.
        self.sequence = sequence
        # Indicates whether the data source can be shared. Valid values:
        # 
        # *   true: The data source can be shared.
        # *   false: The data source cannot be shared.
        self.shared = shared
        # Indicates whether the data source is available. Valid values:
        # 
        # *   1: The data source is available.
        # *   0: The data source is unavailable.
        self.status = status
        # The subtype of the data source. This parameter is returned only if the value of the DataSourceType parameter is rds.
        # 
        # If the value of the DataSourceType parameter is rds, the value of this parameter can be mysql, sqlserver, or postgresql.
        self.sub_type = sub_type
        # The ID of the Alibaba Cloud account to which the data source belongs.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.content is not None:
            result['Content'] = self.content
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ExportDataSourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        data_sources: List[ExportDataSourcesResponseBodyDataDataSources] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The details of the exported data sources.
        # 
        # The value is an array. The following parameters are the elements in the array. The sample values of these parameters show the details of a sample data source.
        self.data_sources = data_sources
        # The page number of the returned page. The value of this parameter is a positive integer greater than or equal to 1.
        self.page_number = page_number
        # The number of entries returned on each page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportDataSourcesResponseBodyDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ExportDataSourcesResponseBody(TeaModel):
    def __init__(
        self,
        data: ExportDataSourcesResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The information about the export operation.
        self.data = data
        # The HTTP status code returned. Valid values:
        # 
        # *   200: The request was successful.
        # *   Other values: The request failed. You can troubleshoot issues based on the HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can locate logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ExportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportDataSourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDISyncTaskConfigForCreatingRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        task_param: str = None,
        task_type: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. This parameter is used to prevent repeated operations that are caused by multiple calls.
        self.client_token = client_token
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        # 
        # This parameter specifies the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The script for the real-time synchronization node or synchronization solution in Data Integration.
        # 
        # The following types of real-time synchronization nodes and synchronization solutions are supported:
        # 
        # *   Real-time synchronization node or synchronization solution that is used to synchronize data from MySQL to MaxCompute
        # *   Real-time synchronization node or synchronization solution that is used to synchronize data from MySQL data to Kafka
        # *   Real-time synchronization node or synchronization solution that is used to synchronize data from MySQL to Hologres
        # 
        # The SelectedTables parameter is used to specify tables that you want to synchronize from multiple databases. The Tables parameter is used to specify tables that you want to synchronize from a single database.
        # 
        # *   If the script contains the SelectedTables parameter, the system synchronizes the tables that you specify in the SelectedTables parameter.
        # *   If the script contains the Tables parameter, the system synchronizes the tables that you specify in the Tables parameter.
        # 
        # The following sample code provides a script for data synchronization from MySQL to MaxCompute:
        # 
        # {
        # 
        # "type": "realtime",
        # 
        # "version": "1.0",
        # 
        # "setting": {
        # 
        # "resourceGroup": "S_res_group\_280749521950784\_1623033752022",
        # 
        # "taskType": "oneclick_to_odps"
        # 
        # },
        # 
        # "steps": { "stepType": "mysql", "parameter": { "connection": \[ { "datasourceType": "mysql", "datasource": "mysql_pub1", "selectedTables": \[ { "dbName": "mysql_db", "schema": \[ { "tableInfos": \[ { "table": "molin_di_test_in_pk_v4" }
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # ]
        # 
        # },
        # 
        # "name": "Reader",
        # 
        # "category": "reader"
        # 
        # },
        # 
        # {
        # 
        # "stepType": "odps",
        # 
        # "parameter": {
        # 
        # "datasource": "odps_first"
        # 
        # },
        # 
        # "name": "Writer",
        # 
        # "category": "writer"
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # The following sample code provides a script for data synchronization from MySQL to Kafka:
        # 
        # {
        # 
        # "type": "realtime",
        # 
        # "version": "1.0",
        # 
        # "setting": {
        # 
        # "resourceGroup": "S_res_group\_280749521950784\_1623033752022",
        # 
        # "taskType": "oneclick_to_kafka"
        # 
        # },
        # 
        # "steps": { "stepType": "mysql", "parameter": { "connection": \[ { "datasourceType": "mysql", "datasource": "pkset_test", "selectedTables": \[ { "dbName": "mysql_db", "schema": \[ { "tableInfos": \[ { "table": "molin_di_test_in_pk_v4" }
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # ]
        # 
        # },
        # 
        # "name": "Reader",
        # 
        # "category": "reader"
        # 
        # },
        # 
        # {
        # 
        # "stepType": "kafka",
        # 
        # "parameter": {
        # 
        # "datasource": "azn_kafka"
        # 
        # },
        # 
        # "name": "Writer",
        # 
        # "category": "writer"
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # The following sample code provides a script for data synchronization from MySQL to Hologres:
        # 
        # {
        # 
        # "type": "realtime",
        # 
        # "version": "1.0",
        # 
        # "setting": {
        # 
        # "resourceGroup": "S_res_group\_280749521950784\_1623033752022",
        # 
        # "taskType": "oneclick_to_holo"
        # 
        # },
        # 
        # "steps": { "stepType": "mysql", "parameter": { "connection": \[ { "datasourceType": "mysql", "datasource": "mysql_pub", "selectedTables": \[ { "dbName": "mysql_db", "schema": \[ { "tableInfos": \[ { "table": "molin_di_test_in2\_pk_v3" }
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # ]
        # 
        # }
        # 
        # ]
        # 
        # },
        # 
        # "name": "Reader",
        # 
        # "category": "reader"
        # 
        # },
        # 
        # {
        # 
        # "stepType": "holo",
        # 
        # "parameter": {
        # 
        # "datasource": "holo"
        # 
        # },
        # 
        # "name": "Writer",
        # 
        # "category": "writer"
        # 
        # }
        # 
        # ]
        # 
        # }
        self.task_param = task_param
        # The type of the object that you want to create in Data Integration in asynchronous mode. Valid values:
        # 
        # *   DI_REALTIME: real-time synchronization node
        # *   DI_SOLUTION: synchronization solution
        # 
        # DataWorks allows you to create real-time synchronization nodes and synchronization solutions in Data Integration only in asynchronous mode.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GenerateDISyncTaskConfigForCreatingResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        process_id: int = None,
        status: str = None,
    ):
        # The reason why the ID of the asynchronous thread fails to be generated.
        # 
        # If the ID is successfully generated, the value null is returned.
        self.message = message
        # The ID of the asynchronous thread. You can call the [QueryDISyncTaskConfigProcessResult](~~383465~~) operation to obtain the asynchronously generated parameters based on the ID. The parameters are used to create a real-time synchronization node or a synchronization solution in Data Integration.
        self.process_id = process_id
        # Indicates whether the ID of the asynchronous thread is generated. Valid values:
        # 
        # *   success: indicates that the ID of the asynchronous thread is generated.
        # *   fail: indicates that the ID of the asynchronous thread fails to be generated. You can view the reason for the failure and troubleshoot the issue based on the reason.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GenerateDISyncTaskConfigForCreatingResponseBody(TeaModel):
    def __init__(
        self,
        data: GenerateDISyncTaskConfigForCreatingResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The information returned for the ID of the asynchronous thread.
        self.data = data
        # The ID of the request. You can locate logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GenerateDISyncTaskConfigForCreatingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDISyncTaskConfigForCreatingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateDISyncTaskConfigForCreatingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateDISyncTaskConfigForCreatingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDISyncTaskConfigForUpdatingRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        project_id: int = None,
        task_id: int = None,
        task_param: str = None,
        task_type: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. This parameter is used to prevent repeated operations that are caused by multiple calls.
        self.client_token = client_token
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        # 
        # This parameter specifies the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The ID of the real-time synchronization node or synchronization solution.
        # 
        # *   If you set the TaskType parameter to DI_REALTIME, set the TaskId parameter to the value of the FileId parameter for the real-time synchronization node.
        # *   If you set the TaskType parameter to DI_SOLUTION, set the TaskId parameter to the value of the FileId parameter for the synchronization solution.
        self.task_id = task_id
        # The script for updating the real-time synchronization node or synchronization solution in Data Integration.
        # 
        # DataWorks allows you to add or remove tables for a real-time synchronization node or a synchronization solution in Data Integration only in asynchronous mode. The following types of real-time synchronization nodes and synchronization solutions are supported:
        # 
        # *   Real-time synchronization node or synchronization solution that is used to synchronize data from MySQL to MaxCompute
        # *   Real-time synchronization node or synchronization solution that is used to synchronize data from MySQL data to Kafka
        # *   Real-time synchronization node or synchronization solution that is used to synchronize data from MySQL to Hologres
        # 
        # The SelectedTables parameter is used to specify tables that you want to synchronize from multiple databases. The Tables parameter is used to specify tables that you want to synchronize from a single database.
        # 
        # *   If the script contains the SelectedTables parameter, the system synchronizes the tables that you specify in the SelectedTables parameter.
        # *   If the script contains the Tables parameter, the system synchronizes the tables that you specify in the Tables parameter.
        self.task_param = task_param
        # The type of the object that you want to update in Data Integration in asynchronous mode. Valid values:
        # 
        # *   DI_REALTIME: real-time synchronization node
        # 
        # *   DI_SOLUTION: synchronization solution
        # 
        #     DataWorks allows you to update real-time synchronization nodes and synchronization solutions in Data Integration only in asynchronous mode.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GenerateDISyncTaskConfigForUpdatingResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        process_id: int = None,
        status: str = None,
    ):
        # The reason why the ID of the asynchronous thread fails to be generated. If the ID is successfully generated, the value null is returned.
        self.message = message
        # The ID of the asynchronous thread. You can call the [QueryDISyncTaskConfigProcessResult](~~383465~~) operation to obtain the asynchronously generated parameters based on the ID. The parameters are used to update a real-time synchronization node or a synchronization solution in Data Integration.
        self.process_id = process_id
        # Indicates whether the ID of the asynchronous thread is generated. Valid values:
        # 
        # *   success: indicates that the ID of the asynchronous thread is generated.
        # *   fail: indicates that the ID of the asynchronous thread fails to be generated. You can view the reason for the failure and troubleshoot the issue based on the reason.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GenerateDISyncTaskConfigForUpdatingResponseBody(TeaModel):
    def __init__(
        self,
        data: GenerateDISyncTaskConfigForUpdatingResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The information returned for the ID of the asynchronous thread.
        self.data = data
        # The ID of the request. You can locate logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GenerateDISyncTaskConfigForUpdatingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDISyncTaskConfigForUpdatingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateDISyncTaskConfigForUpdatingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateDISyncTaskConfigForUpdatingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        project_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetBaselineResponseBodyDataAlertSettingsDingRobots(TeaModel):
    def __init__(
        self,
        at_all: bool = None,
        web_url: str = None,
    ):
        self.at_all = at_all
        self.web_url = web_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_all is not None:
            result['AtAll'] = self.at_all
        if self.web_url is not None:
            result['WebUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AtAll') is not None:
            self.at_all = m.get('AtAll')
        if m.get('WebUrl') is not None:
            self.web_url = m.get('WebUrl')
        return self


class GetBaselineResponseBodyDataAlertSettings(TeaModel):
    def __init__(
        self,
        alert_interval: int = None,
        alert_maximum: int = None,
        alert_methods: List[str] = None,
        alert_recipient: str = None,
        alert_recipient_type: str = None,
        alert_type: str = None,
        baseline_alert_enabled: bool = None,
        ding_robots: List[GetBaselineResponseBodyDataAlertSettingsDingRobots] = None,
        silence_end_time: str = None,
        silence_start_time: str = None,
        topic_types: List[str] = None,
        webhooks: List[str] = None,
    ):
        self.alert_interval = alert_interval
        self.alert_maximum = alert_maximum
        self.alert_methods = alert_methods
        self.alert_recipient = alert_recipient
        self.alert_recipient_type = alert_recipient_type
        self.alert_type = alert_type
        self.baseline_alert_enabled = baseline_alert_enabled
        self.ding_robots = ding_robots
        self.silence_end_time = silence_end_time
        self.silence_start_time = silence_start_time
        self.topic_types = topic_types
        self.webhooks = webhooks

    def validate(self):
        if self.ding_robots:
            for k in self.ding_robots:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.alert_maximum is not None:
            result['AlertMaximum'] = self.alert_maximum
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_recipient is not None:
            result['AlertRecipient'] = self.alert_recipient
        if self.alert_recipient_type is not None:
            result['AlertRecipientType'] = self.alert_recipient_type
        if self.alert_type is not None:
            result['AlertType'] = self.alert_type
        if self.baseline_alert_enabled is not None:
            result['BaselineAlertEnabled'] = self.baseline_alert_enabled
        result['DingRobots'] = []
        if self.ding_robots is not None:
            for k in self.ding_robots:
                result['DingRobots'].append(k.to_map() if k else None)
        if self.silence_end_time is not None:
            result['SilenceEndTime'] = self.silence_end_time
        if self.silence_start_time is not None:
            result['SilenceStartTime'] = self.silence_start_time
        if self.topic_types is not None:
            result['TopicTypes'] = self.topic_types
        if self.webhooks is not None:
            result['Webhooks'] = self.webhooks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('AlertMaximum') is not None:
            self.alert_maximum = m.get('AlertMaximum')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertRecipient') is not None:
            self.alert_recipient = m.get('AlertRecipient')
        if m.get('AlertRecipientType') is not None:
            self.alert_recipient_type = m.get('AlertRecipientType')
        if m.get('AlertType') is not None:
            self.alert_type = m.get('AlertType')
        if m.get('BaselineAlertEnabled') is not None:
            self.baseline_alert_enabled = m.get('BaselineAlertEnabled')
        self.ding_robots = []
        if m.get('DingRobots') is not None:
            for k in m.get('DingRobots'):
                temp_model = GetBaselineResponseBodyDataAlertSettingsDingRobots()
                self.ding_robots.append(temp_model.from_map(k))
        if m.get('SilenceEndTime') is not None:
            self.silence_end_time = m.get('SilenceEndTime')
        if m.get('SilenceStartTime') is not None:
            self.silence_start_time = m.get('SilenceStartTime')
        if m.get('TopicTypes') is not None:
            self.topic_types = m.get('TopicTypes')
        if m.get('Webhooks') is not None:
            self.webhooks = m.get('Webhooks')
        return self


class GetBaselineResponseBodyDataOverTimeSettings(TeaModel):
    def __init__(
        self,
        cycle: int = None,
        time: str = None,
    ):
        self.cycle = cycle
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class GetBaselineResponseBodyData(TeaModel):
    def __init__(
        self,
        alert_enabled: bool = None,
        alert_margin_threshold: int = None,
        alert_settings: List[GetBaselineResponseBodyDataAlertSettings] = None,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_type: str = None,
        enabled: bool = None,
        over_time_settings: List[GetBaselineResponseBodyDataOverTimeSettings] = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        task_ids: List[int] = None,
    ):
        self.alert_enabled = alert_enabled
        self.alert_margin_threshold = alert_margin_threshold
        self.alert_settings = alert_settings
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.baseline_type = baseline_type
        self.enabled = enabled
        self.over_time_settings = over_time_settings
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.task_ids = task_ids

    def validate(self):
        if self.alert_settings:
            for k in self.alert_settings:
                if k:
                    k.validate()
        if self.over_time_settings:
            for k in self.over_time_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_enabled is not None:
            result['AlertEnabled'] = self.alert_enabled
        if self.alert_margin_threshold is not None:
            result['AlertMarginThreshold'] = self.alert_margin_threshold
        result['AlertSettings'] = []
        if self.alert_settings is not None:
            for k in self.alert_settings:
                result['AlertSettings'].append(k.to_map() if k else None)
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        result['OverTimeSettings'] = []
        if self.over_time_settings is not None:
            for k in self.over_time_settings:
                result['OverTimeSettings'].append(k.to_map() if k else None)
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertEnabled') is not None:
            self.alert_enabled = m.get('AlertEnabled')
        if m.get('AlertMarginThreshold') is not None:
            self.alert_margin_threshold = m.get('AlertMarginThreshold')
        self.alert_settings = []
        if m.get('AlertSettings') is not None:
            for k in m.get('AlertSettings'):
                temp_model = GetBaselineResponseBodyDataAlertSettings()
                self.alert_settings.append(temp_model.from_map(k))
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        self.over_time_settings = []
        if m.get('OverTimeSettings') is not None:
            for k in m.get('OverTimeSettings'):
                temp_model = GetBaselineResponseBodyDataOverTimeSettings()
                self.over_time_settings.append(temp_model.from_map(k))
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class GetBaselineResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBaselineResponseBodyData = None,
        dynamic_error_code: str = None,
        dynamic_error_message: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.dynamic_error_code = dynamic_error_code
        self.dynamic_error_message = dynamic_error_message
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_error_code is not None:
            result['DynamicErrorCode'] = self.dynamic_error_code
        if self.dynamic_error_message is not None:
            result['DynamicErrorMessage'] = self.dynamic_error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBaselineResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicErrorCode') is not None:
            self.dynamic_error_code = m.get('DynamicErrorCode')
        if m.get('DynamicErrorMessage') is not None:
            self.dynamic_error_message = m.get('DynamicErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBaselineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineConfigRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        # The ID of the baseline. You can call the [GetNode](~~173977~~) operation to obtain the ID.
        self.baseline_id = baseline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetBaselineConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_type: str = None,
        exp_hour: int = None,
        exp_minu: int = None,
        hour_exp_detail: str = None,
        hour_sla_detail: str = None,
        is_default: bool = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        sla_hour: int = None,
        sla_minu: int = None,
        use_flag: bool = None,
    ):
        # The ID of the baseline.
        self.baseline_id = baseline_id
        # The name of the baseline.
        self.baseline_name = baseline_name
        # The type of the baseline. Valid values: DAILY and HOURLY. The value DAILY indicates that the baseline is a day-level baseline. The value HOURLY indicates that the baseline is an hour-level baseline.
        self.baseline_type = baseline_type
        # The hour in the alert time of the day-level baseline. Valid values: 0 to 47.
        self.exp_hour = exp_hour
        # The minute in the alert time of the day-level baseline. Valid values: 0 to 59.
        self.exp_minu = exp_minu
        # The alert time of the hour-level baseline. This parameter is presented as key-value pairs in the JSON format. The key indicates the ID of the cycle, and the value is presented in the hh:mm format. Valid values of hh: 0 to 47. Valid values of mm: 0 to 59.
        self.hour_exp_detail = hour_exp_detail
        # The committed time of the hour-level baseline. This parameter is presented as key-value pairs in the JSON format. The key indicates the ID of the cycle, and the value is presented in the hh:mm format. Valid values of hh: 0 to 47. Valid values of mm: 0 to 59.
        self.hour_sla_detail = hour_sla_detail
        # Indicates whether the baseline is a default baseline of the workspace. Valid values: true and false.
        self.is_default = is_default
        # The ID of the Alibaba Cloud account used by the baseline owner. Multiple IDs are separated by commas (,).
        self.owner = owner
        # The priority of the baseline. Valid values: 1, 3, 5, 7, and 8.
        self.priority = priority
        # The ID of the workspace.
        self.project_id = project_id
        # The hour in the committed time of the day-level baseline. Valid values: 0 to 47.
        self.sla_hour = sla_hour
        # The minute in the committed time of the day-level baseline. Valid values: 0 to 59.
        self.sla_minu = sla_minu
        # Indicates whether the baseline is enabled. Valid values: true and false.
        self.use_flag = use_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        return self


class GetBaselineConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBaselineConfigResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the baseline.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBaselineConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBaselineConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBaselineConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineKeyPathRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: str = None,
        in_group_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineKeyPathResponseBodyDataRuns(TeaModel):
    def __init__(
        self,
        abs_time: int = None,
        begin_cast: int = None,
        begin_running_time: int = None,
        begin_wait_res_time: int = None,
        begin_wait_time_time: int = None,
        bizdate: int = None,
        cyc_time: int = None,
        end_cast: int = None,
        finish_time: int = None,
        in_group_id: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.abs_time = abs_time
        self.begin_cast = begin_cast
        self.begin_running_time = begin_running_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_wait_time_time = begin_wait_time_time
        self.bizdate = bizdate
        self.cyc_time = cyc_time
        self.end_cast = end_cast
        self.finish_time = finish_time
        self.in_group_id = in_group_id
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abs_time is not None:
            result['AbsTime'] = self.abs_time
        if self.begin_cast is not None:
            result['BeginCast'] = self.begin_cast
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbsTime') is not None:
            self.abs_time = m.get('AbsTime')
        if m.get('BeginCast') is not None:
            self.begin_cast = m.get('BeginCast')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineKeyPathResponseBodyDataTopics(TeaModel):
    def __init__(
        self,
        add_time: int = None,
        instance_id: int = None,
        topic_id: int = None,
        topic_name: int = None,
    ):
        self.add_time = add_time
        self.instance_id = instance_id
        self.topic_id = topic_id
        self.topic_name = topic_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        return self


class GetBaselineKeyPathResponseBodyData(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        in_group_id: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        prg_type: int = None,
        project_id: int = None,
        runs: List[GetBaselineKeyPathResponseBodyDataRuns] = None,
        topics: List[GetBaselineKeyPathResponseBodyDataTopics] = None,
    ):
        self.bizdate = bizdate
        self.in_group_id = in_group_id
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.prg_type = prg_type
        self.project_id = project_id
        self.runs = runs
        self.topics = topics

    def validate(self):
        if self.runs:
            for k in self.runs:
                if k:
                    k.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        result['Runs'] = []
        if self.runs is not None:
            for k in self.runs:
                result['Runs'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        self.runs = []
        if m.get('Runs') is not None:
            for k in m.get('Runs'):
                temp_model = GetBaselineKeyPathResponseBodyDataRuns()
                self.runs.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = GetBaselineKeyPathResponseBodyDataTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class GetBaselineKeyPathResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetBaselineKeyPathResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetBaselineKeyPathResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineKeyPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBaselineKeyPathResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBaselineKeyPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineStatusRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: str = None,
        in_group_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineStatusResponseBodyDataBlockInstance(TeaModel):
    def __init__(
        self,
        end_cast: int = None,
        finish_time: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.end_cast = end_cast
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineStatusResponseBodyDataLastInstance(TeaModel):
    def __init__(
        self,
        end_cast: int = None,
        finish_time: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
        status: str = None,
    ):
        self.end_cast = end_cast
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        bizdate: int = None,
        block_instance: GetBaselineStatusResponseBodyDataBlockInstance = None,
        buffer: float = None,
        end_cast: int = None,
        exp_time: int = None,
        finish_status: str = None,
        finish_time: int = None,
        in_group_id: int = None,
        last_instance: GetBaselineStatusResponseBodyDataLastInstance = None,
        owner: str = None,
        priority: int = None,
        project_id: int = None,
        sla_time: int = None,
        status: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.bizdate = bizdate
        self.block_instance = block_instance
        self.buffer = buffer
        self.end_cast = end_cast
        self.exp_time = exp_time
        self.finish_status = finish_status
        self.finish_time = finish_time
        self.in_group_id = in_group_id
        self.last_instance = last_instance
        self.owner = owner
        self.priority = priority
        self.project_id = project_id
        self.sla_time = sla_time
        self.status = status

    def validate(self):
        if self.block_instance:
            self.block_instance.validate()
        if self.last_instance:
            self.last_instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.block_instance is not None:
            result['BlockInstance'] = self.block_instance.to_map()
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.last_instance is not None:
            result['LastInstance'] = self.last_instance.to_map()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('BlockInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataBlockInstance()
            self.block_instance = temp_model.from_map(m['BlockInstance'])
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('LastInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataLastInstance()
            self.last_instance = temp_model.from_map(m['LastInstance'])
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBaselineStatusResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBaselineStatusResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBaselineStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBaselineStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBaselineStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBaselineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBusinessRequest(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the workflow. You can call the [ListBusiness](~~173945~~) operation to query the ID.
        self.business_id = business_id
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID. You must specify either this parameter or ProjectIdentifier to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Settings panel to obtain the name. You must specify either this parameter or ProjectId to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetBusinessResponseBodyData(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        project_id: str = None,
        use_type: str = None,
    ):
        # The ID of the workflow.
        self.business_id = business_id
        # The name of the workflow.
        self.business_name = business_name
        # The description of the workflow.
        self.description = description
        # The Alibaba Cloud account ID of the workflow owner.
        self.owner = owner
        # The ID of the workspace to which the workflow belongs.
        self.project_id = project_id
        # The module to which the workflow belongs. Valid values: NORMAL and MANUAL_BIZ.
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetBusinessResponseBody(TeaModel):
    def __init__(
        self,
        data: GetBusinessResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the workflow.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBusinessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDDLJobStatusRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # The ID of the DDL task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        next_task_id: str = None,
        status: str = None,
        task_id: str = None,
    ):
        # The content of the task.
        self.content = content
        # The ID of the ongoing task. If no value is returned for this parameter, all subtasks are complete.
        self.next_task_id = next_task_id
        # The status of the task
        self.status = status
        # The ID of the task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDDLJobStatusResponseBodyData = None,
        request_id: str = None,
    ):
        # The details of the task.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDDLJobStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDDLJobStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDDLJobStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDDLJobStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncInstanceInfoRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        # *   If you set the TaskType parameter to DI_REALTIME, set the FileId parameter to the ID of the real-time synchronization node that you want to query.
        # *   If you set the TaskType parameter to DI_SOLUTION, set the FileId parameter to the ID of the data synchronization solution that you want to query.
        # 
        # You can call the [ListFiles](~~173942~~) operation to obtain the ID of the real-time synchronization node or data synchronization solution.
        self.file_id = file_id
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        # 
        # This parameter specifies the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The type of the object that you want to query. Valid values:
        # 
        # *   DI_REALTIME: real-time synchronization node
        # *   DI_SOLUTION: data synchronization solution
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail(TeaModel):
    def __init__(
        self,
        info: str = None,
        status: str = None,
        step_id: int = None,
        step_name: str = None,
    ):
        # The information of the data synchronization solution.
        self.info = info
        # The status of the step in the data synchronization solution.
        self.status = status
        # The ID of the step in the data synchronization solution.
        self.step_id = step_id
        # The name of the step in the data synchronization solution.
        self.step_name = step_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.status is not None:
            result['Status'] = self.status
        if self.step_id is not None:
            result['StepId'] = self.step_id
        if self.step_name is not None:
            result['StepName'] = self.step_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StepId') is not None:
            self.step_id = m.get('StepId')
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        return self


class GetDISyncInstanceInfoResponseBodyDataSolutionInfo(TeaModel):
    def __init__(
        self,
        creator_name: str = None,
        id: int = None,
        status: str = None,
        step_detail: List[GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail] = None,
    ):
        # The creator of the data synchronization solution.
        self.creator_name = creator_name
        # The ID of the data synchronization solution.
        self.id = id
        # The status of the data synchronization solution.
        self.status = status
        # The step details of the synchronization solution.
        self.step_detail = step_detail

    def validate(self):
        if self.step_detail:
            for k in self.step_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        result['StepDetail'] = []
        if self.step_detail is not None:
            for k in self.step_detail:
                result['StepDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.step_detail = []
        if m.get('StepDetail') is not None:
            for k in m.get('StepDetail'):
                temp_model = GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail()
                self.step_detail.append(temp_model.from_map(k))
        return self


class GetDISyncInstanceInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        name: str = None,
        solution_info: GetDISyncInstanceInfoResponseBodyDataSolutionInfo = None,
        status: str = None,
    ):
        # The cause of the failure to obtain the status of the real-time synchronization node or data synchronization solution. If the status of the real-time synchronization node or data synchronization solution is obtained, the value null is returned.
        self.message = message
        # *   If the TaskType parameter is set to DI_REALTIME, the Name parameter indicates the name of the real-time synchronization node.
        # *   If the TaskType parameter is set to DI_SOLITION, the value null is returned.
        self.name = name
        # *   If the TaskType parameter is set to DI_REALTIME, the value null is returned.
        # *   If the TaskType parameter is set to DI_SOLITION, the SolutionInfo parameter indicates the details of the data synchronization solution.
        self.solution_info = solution_info
        # *   If the TaskType parameter is set to DI_REALTIME, the Status parameter indicates the status of the real-time synchronization node. Valid values: PAUSE, NORUN, RUN, KILLING, and WAIT.
        # *   If the TaskType parameter is set to DI_SOLITION, the Status parameter indicates the status of the data synchronization solution. Valid values: success and fail.
        self.status = status

    def validate(self):
        if self.solution_info:
            self.solution_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.solution_info is not None:
            result['SolutionInfo'] = self.solution_info.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SolutionInfo') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyDataSolutionInfo()
            self.solution_info = temp_model.from_map(m['SolutionInfo'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDISyncInstanceInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDISyncInstanceInfoResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status of the real-time synchronization node or data synchronization solution.
        self.data = data
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDISyncInstanceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDISyncInstanceInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDISyncInstanceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        task_type: str = None,
    ):
        # *   If you set the TaskType parameter to DI_REALTIME, set the FileId parameter to the ID of the real-time synchronization node that you want to query.
        # *   If you set the TaskType parameter to DI_SOLUTION, set the FileId parameter to the ID of the data synchronization solution that you want to query.
        # 
        # You can call the [ListFiles](~~173942~~) operation to query the ID of the real-time synchronization node or data synchronization solution.
        self.file_id = file_id
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to query the workspace ID.
        # 
        # This parameter specifies the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The type of the object that you want to query. Valid values:
        # 
        # *   DI_REALTIME: real-time synchronization node
        # *   DI_SOLUTION: data synchronization solution
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetDISyncTaskResponseBodyDataSolutionDetail(TeaModel):
    def __init__(
        self,
        creator_name: str = None,
        id: int = None,
        name: str = None,
        process_content: str = None,
        process_extra: str = None,
        project_id: int = None,
        source_type: str = None,
        start_time: str = None,
        status: str = None,
        submit_time: str = None,
        type: str = None,
    ):
        # The creator of the data synchronization solution.
        self.creator_name = creator_name
        # The ID of the data synchronization solution.
        self.id = id
        # The name of the data synchronization solution.
        self.name = name
        # The configuration details of the data synchronization solution.
        self.process_content = process_content
        # The additional parameters of the data synchronization solution.
        self.process_extra = process_extra
        # The ID of the project to which the data synchronization solution belongs.
        self.project_id = project_id
        # The type of the source of the data synchronization solution.
        self.source_type = source_type
        # The start time of the data synchronization solution.
        self.start_time = start_time
        # The status of the data synchronization solution. Valid values:
        # 
        # *   0: successful
        # *   1: not running
        # *   2: running
        # *   3: failed
        # *   4: committed
        # *   5: pending manual confirmation
        # *   6: manually confirmed
        # *   7: others
        # *   8: waiting
        # *   9: deleted
        self.status = status
        # The time when the data synchronization solution was committed.
        self.submit_time = submit_time
        # The type of the data synchronization solution.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.process_content is not None:
            result['ProcessContent'] = self.process_content
        if self.process_extra is not None:
            result['ProcessExtra'] = self.process_extra
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProcessContent') is not None:
            self.process_content = m.get('ProcessContent')
        if m.get('ProcessExtra') is not None:
            self.process_extra = m.get('ProcessExtra')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        solution_detail: GetDISyncTaskResponseBodyDataSolutionDetail = None,
        status: str = None,
    ):
        # *   If the TaskType parameter is set to DI_REALTIME, the details of the real-time synchronization node are returned.
        # *   If the TaskType parameter is set to DI_SOLUTION, the value null is returned.
        self.code = code
        # The cause of the failure to obtain the details of the real-time synchronization node or data synchronization solution.
        # 
        # If the details of the real-time synchronization node or data synchronization solution are obtained, the value null is returned.
        self.message = message
        # *   If the TaskType parameter is set to DI_REALTIME, the value null is returned.
        # *   If the TaskType parameter is set to DI_SOLUTION, the details of the data synchronization solution task are returned.
        self.solution_detail = solution_detail
        # Indicates whether the details of the real-time synchronization node or data synchronization solution are obtained. Valid values:
        # 
        # success: The details are obtained.
        # 
        # fail: The details fail to be obtained.
        self.status = status

    def validate(self):
        if self.solution_detail:
            self.solution_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.solution_detail is not None:
            result['SolutionDetail'] = self.solution_detail.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SolutionDetail') is not None:
            temp_model = GetDISyncTaskResponseBodyDataSolutionDetail()
            self.solution_detail = temp_model.from_map(m['SolutionDetail'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDISyncTaskResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the real-time synchronization node or data synchronization solution.
        self.data = data
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDagRequest(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        project_env: str = None,
    ):
        # The ID of the DAG. You can set this parameter to the value of the DagId parameter returned by the CreateDagComplement, CreateTest, or CreateManualDag operation.
        self.dag_id = dag_id
        # The environment type. Valid values: PROD and DEV. The value PROD indicates the production environment. The value DEV indicates the development environment.
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetDagResponseBodyData(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        create_time: int = None,
        create_user: str = None,
        dag_id: int = None,
        finish_time: int = None,
        gmtdate: int = None,
        modify_time: int = None,
        name: str = None,
        op_seq: int = None,
        project_id: int = None,
        start_time: int = None,
        status: str = None,
        type: str = None,
    ):
        # The data timestamp.
        self.bizdate = bizdate
        # The time at which the DAG was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The user who created the DAG.
        self.create_user = create_user
        # The ID of the DAG.
        self.dag_id = dag_id
        # The time at which the DAG finished running. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.finish_time = finish_time
        # The time at which the DAG was scheduled to run.
        self.gmtdate = gmtdate
        # The time at which the DAG was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.modify_time = modify_time
        # The name of the DAG.
        self.name = name
        # The sequence number of the operation.
        self.op_seq = op_seq
        # The ID of the workspace.
        self.project_id = project_id
        # The time at which the DAG started to run.
        self.start_time = start_time
        # The status of the DAG. Valid values: CREATED, RUNNING, FAILURE, and SUCCESS.
        self.status = status
        # The type of the DAG. Valid values: MANUAL, SMOKE_TEST, SUPPLY_DATA, and BUSINESS_PROCESS_DAG.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.gmtdate is not None:
            result['Gmtdate'] = self.gmtdate
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.op_seq is not None:
            result['OpSeq'] = self.op_seq
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Gmtdate') is not None:
            self.gmtdate = m.get('Gmtdate')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpSeq') is not None:
            self.op_seq = m.get('OpSeq')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDagResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDagResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the DAG.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to locate logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDagResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        registration_error_codes: List[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters] = None,
        service_content_type: int = None,
        service_host: str = None,
        service_path: str = None,
        service_request_body_description: str = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters
        self.service_content_type = service_content_type
        self.service_host = service_host
        self.service_path = service_path
        self.service_request_body_description = service_request_body_description
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.column_name = column_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServiceApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        script: str = None,
        script_connection: GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection = None,
        script_request_parameters: List[GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters] = None,
    ):
        self.is_paged_response = is_paged_response
        self.script = script
        self.script_connection = script_connection
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters

    def validate(self):
        if self.script_connection:
            self.script_connection.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.script is not None:
            result['Script'] = self.script
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.column_name = column_name
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.column_name = column_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServiceApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        wizard_connection: GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection = None,
        wizard_request_parameters: List[GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters] = None,
        wizard_response_parameters: List[GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters] = None,
    ):
        self.is_paged_response = is_paged_response
        self.wizard_connection = wizard_connection
        self.wizard_request_parameters = wizard_request_parameters
        self.wizard_response_parameters = wizard_response_parameters

    def validate(self):
        if self.wizard_connection:
            self.wizard_connection.validate()
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        return self


class GetDataServiceApiResponseBodyData(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        api_mode: int = None,
        api_name: str = None,
        api_path: str = None,
        created_time: str = None,
        creator_id: str = None,
        description: str = None,
        folder_id: int = None,
        group_id: str = None,
        modified_time: str = None,
        operator_id: str = None,
        project_id: int = None,
        protocols: List[int] = None,
        registration_details: GetDataServiceApiResponseBodyDataRegistrationDetails = None,
        request_method: int = None,
        response_content_type: int = None,
        script_details: GetDataServiceApiResponseBodyDataScriptDetails = None,
        status: int = None,
        tenant_id: int = None,
        timeout: int = None,
        visible_range: int = None,
        wizard_details: GetDataServiceApiResponseBodyDataWizardDetails = None,
    ):
        self.api_id = api_id
        self.api_mode = api_mode
        self.api_name = api_name
        self.api_path = api_path
        self.created_time = created_time
        self.creator_id = creator_id
        self.description = description
        self.folder_id = folder_id
        self.group_id = group_id
        self.modified_time = modified_time
        self.operator_id = operator_id
        self.project_id = project_id
        self.protocols = protocols
        self.registration_details = registration_details
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.script_details = script_details
        self.status = status
        self.tenant_id = tenant_id
        self.timeout = timeout
        self.visible_range = visible_range
        self.wizard_details = wizard_details

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServiceApiResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServiceApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApiTestRequest(TeaModel):
    def __init__(
        self,
        test_id: int = None,
    ):
        self.test_id = test_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.test_id is not None:
            result['TestId'] = self.test_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TestId') is not None:
            self.test_id = m.get('TestId')
        return self


class GetDataServiceApiTestResponseBodyData(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        cost_time: str = None,
        debug_info: str = None,
        nodes_debug_info: str = None,
        param_map: str = None,
        ret_code: int = None,
        ret_result: str = None,
        status: str = None,
    ):
        self.api_id = api_id
        self.cost_time = cost_time
        self.debug_info = debug_info
        self.nodes_debug_info = nodes_debug_info
        self.param_map = param_map
        self.ret_code = ret_code
        self.ret_result = ret_result
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.cost_time is not None:
            result['CostTime'] = self.cost_time
        if self.debug_info is not None:
            result['DebugInfo'] = self.debug_info
        if self.nodes_debug_info is not None:
            result['NodesDebugInfo'] = self.nodes_debug_info
        if self.param_map is not None:
            result['ParamMap'] = self.param_map
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        if self.ret_result is not None:
            result['RetResult'] = self.ret_result
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('CostTime') is not None:
            self.cost_time = m.get('CostTime')
        if m.get('DebugInfo') is not None:
            self.debug_info = m.get('DebugInfo')
        if m.get('NodesDebugInfo') is not None:
            self.nodes_debug_info = m.get('NodesDebugInfo')
        if m.get('ParamMap') is not None:
            self.param_map = m.get('ParamMap')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        if m.get('RetResult') is not None:
            self.ret_result = m.get('RetResult')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDataServiceApiTestResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServiceApiTestResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServiceApiTestResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceApiTestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataServiceApiTestResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataServiceApiTestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.application_id = application_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        application_code: str = None,
        application_id: int = None,
        application_key: str = None,
        application_name: str = None,
        application_secret: str = None,
        project_id: int = None,
    ):
        self.application_code = application_code
        self.application_id = application_id
        self.application_key = application_key
        self.application_name = application_name
        self.application_secret = application_secret
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_code is not None:
            result['ApplicationCode'] = self.application_code
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_key is not None:
            result['ApplicationKey'] = self.application_key
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_secret is not None:
            result['ApplicationSecret'] = self.application_secret
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationCode') is not None:
            self.application_code = m.get('ApplicationCode')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationKey') is not None:
            self.application_key = m.get('ApplicationKey')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationSecret') is not None:
            self.application_secret = m.get('ApplicationSecret')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetDataServiceApplicationResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServiceApplicationResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServiceApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataServiceApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataServiceApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataServiceApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        # The ID of the folder.
        self.folder_id = folder_id
        # The ID of the workspace.
        self.project_id = project_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceFolderResponseBodyFolder(TeaModel):
    def __init__(
        self,
        created_time: str = None,
        folder_id: int = None,
        folder_name: str = None,
        group_id: str = None,
        modified_time: str = None,
        parent_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        # The time when the folder was created.
        self.created_time = created_time
        # The ID of the folder.
        self.folder_id = folder_id
        # The name of the folder.
        self.folder_name = folder_name
        # The ID of the business process to which the folder belongs.
        self.group_id = group_id
        # The time when the folder was last modified.
        self.modified_time = modified_time
        # The ID of the parent folder. The ID of the root folder in a business process is 0, and the ID of a folder created by a user in a business process is greater than 0.
        self.parent_id = parent_id
        # The ID of the workspace.
        self.project_id = project_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceFolderResponseBody(TeaModel):
    def __init__(
        self,
        folder: GetDataServiceFolderResponseBodyFolder = None,
        request_id: str = None,
    ):
        # The details of the folder.
        self.folder = folder
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.folder:
            self.folder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder is not None:
            result['Folder'] = self.folder.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Folder') is not None:
            temp_model = GetDataServiceFolderResponseBodyFolder()
            self.folder = temp_model.from_map(m['Folder'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataServiceFolderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        # The ID of the business process.
        self.group_id = group_id
        # The ID of the workspace.
        self.project_id = project_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceGroupResponseBodyGroup(TeaModel):
    def __init__(
        self,
        api_gateway_group_id: str = None,
        created_time: str = None,
        creator_id: str = None,
        description: str = None,
        group_id: str = None,
        group_name: str = None,
        modified_time: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        # The ID of the API group that is associated with the business process in the API Gateway console.
        self.api_gateway_group_id = api_gateway_group_id
        # The time when the business process was created.
        self.created_time = created_time
        # The user identifier (UID) of the creator of the business process. The value of this parameter may be empty for creators of some existing business processes.
        self.creator_id = creator_id
        # The description of the business process.
        self.description = description
        # The ID of the business process.
        self.group_id = group_id
        # The name of the business process.
        self.group_name = group_name
        # The time when the business process was last modified.
        self.modified_time = modified_time
        # The ID of the workspace.
        self.project_id = project_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceGroupResponseBody(TeaModel):
    def __init__(
        self,
        group: GetDataServiceGroupResponseBodyGroup = None,
        request_id: str = None,
    ):
        # The details of the business process.
        self.group = group
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group is not None:
            result['Group'] = self.group.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Group') is not None:
            temp_model = GetDataServiceGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataServiceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServicePublishedApiRequest(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        registration_error_codes: List[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters] = None,
        service_content_type: int = None,
        service_host: str = None,
        service_path: str = None,
        service_request_body_description: str = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters
        self.service_content_type = service_content_type
        self.service_host = service_host
        self.service_path = service_path
        self.service_request_body_description = service_request_body_description
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        is_paged_response: bool = None,
        script: str = None,
        script_connection: GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection = None,
        script_error_codes: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes] = None,
        script_request_parameters: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters] = None,
        successful_result_sample: str = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.is_paged_response = is_paged_response
        self.script = script
        self.script_connection = script_connection
        self.script_error_codes = script_error_codes
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters
        self.successful_result_sample = successful_result_sample

    def validate(self):
        if self.script_connection:
            self.script_connection.validate()
        if self.script_error_codes:
            for k in self.script_error_codes:
                if k:
                    k.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.script is not None:
            result['Script'] = self.script
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        result['ScriptErrorCodes'] = []
        if self.script_error_codes is not None:
            for k in self.script_error_codes:
                result['ScriptErrorCodes'].append(k.to_map() if k else None)
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        self.script_error_codes = []
        if m.get('ScriptErrorCodes') is not None:
            for k in m.get('ScriptErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes()
                self.script_error_codes.append(temp_model.from_map(k))
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
        table_name: str = None,
    ):
        self.connection_id = connection_id
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        error_solution: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        example_value: str = None,
        is_required_parameter: bool = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_operator: int = None,
        parameter_position: int = None,
    ):
        self.default_value = default_value
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_operator = parameter_operator
        self.parameter_position = parameter_position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        example_value: str = None,
        parameter_data_type: int = None,
        parameter_description: str = None,
        parameter_name: str = None,
    ):
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(
        self,
        failed_result_sample: str = None,
        is_paged_response: bool = None,
        successful_result_sample: str = None,
        wizard_connection: GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection = None,
        wizard_error_codes: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes] = None,
        wizard_request_parameters: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters] = None,
        wizard_response_parameters: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters] = None,
    ):
        self.failed_result_sample = failed_result_sample
        self.is_paged_response = is_paged_response
        self.successful_result_sample = successful_result_sample
        self.wizard_connection = wizard_connection
        self.wizard_error_codes = wizard_error_codes
        self.wizard_request_parameters = wizard_request_parameters
        self.wizard_response_parameters = wizard_response_parameters

    def validate(self):
        if self.wizard_connection:
            self.wizard_connection.validate()
        if self.wizard_error_codes:
            for k in self.wizard_error_codes:
                if k:
                    k.validate()
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        result['WizardErrorCodes'] = []
        if self.wizard_error_codes is not None:
            for k in self.wizard_error_codes:
                result['WizardErrorCodes'].append(k.to_map() if k else None)
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        self.wizard_error_codes = []
        if m.get('WizardErrorCodes') is not None:
            for k in m.get('WizardErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes()
                self.wizard_error_codes.append(temp_model.from_map(k))
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        return self


class GetDataServicePublishedApiResponseBodyData(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        api_mode: int = None,
        api_name: str = None,
        api_path: str = None,
        created_time: str = None,
        creator_id: str = None,
        description: str = None,
        group_id: str = None,
        modified_time: str = None,
        operator_id: str = None,
        project_id: int = None,
        protocols: List[int] = None,
        registration_details: GetDataServicePublishedApiResponseBodyDataRegistrationDetails = None,
        request_method: int = None,
        response_content_type: int = None,
        script_details: GetDataServicePublishedApiResponseBodyDataScriptDetails = None,
        status: int = None,
        tenant_id: int = None,
        timeout: int = None,
        visible_range: int = None,
        wizard_details: GetDataServicePublishedApiResponseBodyDataWizardDetails = None,
    ):
        self.api_id = api_id
        self.api_mode = api_mode
        self.api_name = api_name
        self.api_path = api_path
        self.created_time = created_time
        self.creator_id = creator_id
        self.description = description
        self.group_id = group_id
        self.modified_time = modified_time
        self.operator_id = operator_id
        self.project_id = project_id
        self.protocols = protocols
        self.registration_details = registration_details
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.script_details = script_details
        self.status = status
        self.tenant_id = tenant_id
        self.timeout = timeout
        self.visible_range = visible_range
        self.wizard_details = wizard_details

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServicePublishedApiResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataServicePublishedApiResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataServicePublishedApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataServicePublishedApiResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataServicePublishedApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataSourceMetaRequest(TeaModel):
    def __init__(
        self,
        datasource_name: str = None,
        env_type: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
    ):
        # The name of the data source.
        self.datasource_name = datasource_name
        # The environment to which the data source belongs. Valid values:
        # 
        # *   0: development environment
        # *   1: production environment
        self.env_type = env_type
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetDataSourceMetaResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        meta: str = None,
        status: str = None,
    ):
        # The reason why the metadata of the data source failed to be retrieved. If the metadata of the data source was retrieved, this parameter is left empty.
        self.message = message
        # The returned metadata of the data source. The returned metadata is in the JSON format.
        # 
        # `{"dbTables":[{"dbName":"testdb","schema":[{"tableInfos":[{"dbName":"testdb","enable":true,"table":"table1","tableName":"table1"}]},{"tableInfos":[{"dbName":"testdb","enable":true,"table":"table2","tableName":"table2"}]}]}]}`
        # 
        # Parameter description:
        # 
        # *   dbName: the name of the database in which the data source resides.
        # *   schema: the schema of the database.
        # *   enable: indicates whether the database is available. A value of true indicates that the database is available. A value of false indicates that the database is unavailable.
        # *   tableName: the name of the table in the database.
        # *   tableInfos: the information about the table in the database.
        self.meta = meta
        # Indicates whether the metadata of the data source was retrieved. Valid values:
        # 
        # *   success: The metadata of the data source was retrieved.
        # *   fail: The metadata of the data source failed to be retrieved. You can troubleshoot issues based on the Message parameter.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDataSourceMetaResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDataSourceMetaResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The information about the query operation.
        self.data = data
        # The unique ID of the request. You can query logs and troubleshoot issues based on the unique ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDataSourceMetaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataSourceMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataSourceMetaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataSourceMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeploymentRequest(TeaModel):
    def __init__(
        self,
        deployment_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the deployment task. A deployment task ID is generated when you call the [SubmitFile](~~173944~~) or [DeployFile](~~173956~~) operation.
        self.deployment_id = deployment_id
        # The ID of the DataWorks workspace. You can click the Workspace Manage icon in the upper-right corner of the DataStudio page to go to the Workspace Management page and view the workspace ID.
        self.project_id = project_id
        # The GUID of the DataWorks workspace. You can view the GUID in the upper part of the DataStudio page. You can also select another GUID to switch to another workspace.
        # 
        # You must specify either this parameter or the ProjectId parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetDeploymentResponseBodyDataDeployedItems(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        file_version: int = None,
        status: int = None,
    ):
        self.file_id = file_id
        self.file_version = file_version
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDeploymentResponseBodyDataDeployment(TeaModel):
    def __init__(
        self,
        checking_status: int = None,
        create_time: int = None,
        creator_id: str = None,
        error_message: str = None,
        execute_time: int = None,
        from_environment: int = None,
        handler_id: str = None,
        name: str = None,
        status: int = None,
        to_environment: int = None,
    ):
        # The check status of one or more files in the deployment task. If the value of the ToEnvironment parameter is 1, the files can be deployed to the production environment only when the value of the Status parameter is 1 and the CheckingStatus parameter is empty. Valid values:
        # 
        # *   7: The file failed the check.
        # *   8: The file is being checked.
        self.checking_status = checking_status
        # The time when the deployment task was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The ID of the Alibaba Cloud account used by the user who created the deployment task.
        self.creator_id = creator_id
        # The error message that was returned when the deployment task failed. In this case, the value of the Status parameter is 2.
        self.error_message = error_message
        # The time when the deployment task was run. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.execute_time = execute_time
        # The environment in which the deployment task was run. Valid values: 0 and 1. A value of 0 indicates the on-premises environment. A value of 1 indicates the development environment.
        self.from_environment = from_environment
        # The ID of the Alibaba Cloud account used by the user who ran the deployment task.
        self.handler_id = handler_id
        # The name of the deployment task. The value is the same as the name of the specific deployment task that is displayed on the Release Package page in the Deploy module.
        self.name = name
        # The status of the deployment task. Valid values: 0, 1, and 2. A value of 0 indicates that the task is ready. A value of 1 indicates that the task was successful. A value of 2 indicates that the task failed.
        self.status = status
        # The environment to which the file was deployed. Valid values: 1 and 2. A value of 1 indicates the development environment. A value of 2 indicates the production environment.
        self.to_environment = to_environment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checking_status is not None:
            result['CheckingStatus'] = self.checking_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.from_environment is not None:
            result['FromEnvironment'] = self.from_environment
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.to_environment is not None:
            result['ToEnvironment'] = self.to_environment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckingStatus') is not None:
            self.checking_status = m.get('CheckingStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('FromEnvironment') is not None:
            self.from_environment = m.get('FromEnvironment')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ToEnvironment') is not None:
            self.to_environment = m.get('ToEnvironment')
        return self


class GetDeploymentResponseBodyData(TeaModel):
    def __init__(
        self,
        deployed_items: List[GetDeploymentResponseBodyDataDeployedItems] = None,
        deployment: GetDeploymentResponseBodyDataDeployment = None,
    ):
        self.deployed_items = deployed_items
        # The details of the deployment task.
        self.deployment = deployment

    def validate(self):
        if self.deployed_items:
            for k in self.deployed_items:
                if k:
                    k.validate()
        if self.deployment:
            self.deployment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeployedItems'] = []
        if self.deployed_items is not None:
            for k in self.deployed_items:
                result['DeployedItems'].append(k.to_map() if k else None)
        if self.deployment is not None:
            result['Deployment'] = self.deployment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.deployed_items = []
        if m.get('DeployedItems') is not None:
            for k in m.get('DeployedItems'):
                temp_model = GetDeploymentResponseBodyDataDeployedItems()
                self.deployed_items.append(temp_model.from_map(k))
        if m.get('Deployment') is not None:
            temp_model = GetDeploymentResponseBodyDataDeployment()
            self.deployment = temp_model.from_map(m['Deployment'])
        return self


class GetDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDeploymentResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data about the deployment task.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can troubleshoot errors based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetExtensionRequest(TeaModel):
    def __init__(
        self,
        extension_code: str = None,
    ):
        # The unique code of the extension.
        self.extension_code = extension_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension_code is not None:
            result['ExtensionCode'] = self.extension_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtensionCode') is not None:
            self.extension_code = m.get('ExtensionCode')
        return self


class GetExtensionResponseBodyExtensionBindEventList(TeaModel):
    def __init__(
        self,
        event_code: str = None,
        event_name: str = None,
    ):
        # The code of the extension point event.
        self.event_code = event_code
        # The name of the extension point event.
        self.event_name = event_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_code is not None:
            result['EventCode'] = self.event_code
        if self.event_name is not None:
            result['EventName'] = self.event_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventCode') is not None:
            self.event_code = m.get('EventCode')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        return self


class GetExtensionResponseBodyExtensionEventCategoryList(TeaModel):
    def __init__(
        self,
        category_code: str = None,
        category_name: str = None,
    ):
        # The code of the event type.
        self.category_code = category_code
        # The name of the event type.
        self.category_name = category_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['CategoryCode'] = self.category_code
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryCode') is not None:
            self.category_code = m.get('CategoryCode')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class GetExtensionResponseBodyExtension(TeaModel):
    def __init__(
        self,
        bind_event_list: List[GetExtensionResponseBodyExtensionBindEventList] = None,
        detail_url: str = None,
        event_category_list: List[GetExtensionResponseBodyExtensionEventCategoryList] = None,
        extension_code: str = None,
        extension_desc: str = None,
        extension_name: str = None,
        help_doc_url: str = None,
        option_setting: str = None,
        parameter_setting: str = None,
        project_testing: int = None,
        status: int = None,
    ):
        # The extension point events.
        self.bind_event_list = bind_event_list
        # The URL of the help document about the extension. You can visit the URL for the details of the extension.
        self.detail_url = detail_url
        # The types of the events.
        self.event_category_list = event_category_list
        # The unique code of the extension.
        self.extension_code = extension_code
        # The description of the extension.
        self.extension_desc = extension_desc
        # The name of the extension.
        self.extension_name = extension_name
        # The URL of the help document about the extension.
        self.help_doc_url = help_doc_url
        # The option settings of the extension.
        self.option_setting = option_setting
        # The parameter settings of the extension. For more information, visit https://www.alibabacloud.com/help/en/dataworks/latest/set-extension-parameters.
        self.parameter_setting = parameter_setting
        # The workspace for testing. If the extension is in the testing state, the extension can be used only in the workspace for testing.
        self.project_testing = project_testing
        # The state of the extension. 0: testing. 1: publishing. 3: disabled. 4: approving. 5: approved. 6: approval failed.
        self.status = status

    def validate(self):
        if self.bind_event_list:
            for k in self.bind_event_list:
                if k:
                    k.validate()
        if self.event_category_list:
            for k in self.event_category_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindEventList'] = []
        if self.bind_event_list is not None:
            for k in self.bind_event_list:
                result['BindEventList'].append(k.to_map() if k else None)
        if self.detail_url is not None:
            result['DetailUrl'] = self.detail_url
        result['EventCategoryList'] = []
        if self.event_category_list is not None:
            for k in self.event_category_list:
                result['EventCategoryList'].append(k.to_map() if k else None)
        if self.extension_code is not None:
            result['ExtensionCode'] = self.extension_code
        if self.extension_desc is not None:
            result['ExtensionDesc'] = self.extension_desc
        if self.extension_name is not None:
            result['ExtensionName'] = self.extension_name
        if self.help_doc_url is not None:
            result['HelpDocUrl'] = self.help_doc_url
        if self.option_setting is not None:
            result['OptionSetting'] = self.option_setting
        if self.parameter_setting is not None:
            result['ParameterSetting'] = self.parameter_setting
        if self.project_testing is not None:
            result['ProjectTesting'] = self.project_testing
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bind_event_list = []
        if m.get('BindEventList') is not None:
            for k in m.get('BindEventList'):
                temp_model = GetExtensionResponseBodyExtensionBindEventList()
                self.bind_event_list.append(temp_model.from_map(k))
        if m.get('DetailUrl') is not None:
            self.detail_url = m.get('DetailUrl')
        self.event_category_list = []
        if m.get('EventCategoryList') is not None:
            for k in m.get('EventCategoryList'):
                temp_model = GetExtensionResponseBodyExtensionEventCategoryList()
                self.event_category_list.append(temp_model.from_map(k))
        if m.get('ExtensionCode') is not None:
            self.extension_code = m.get('ExtensionCode')
        if m.get('ExtensionDesc') is not None:
            self.extension_desc = m.get('ExtensionDesc')
        if m.get('ExtensionName') is not None:
            self.extension_name = m.get('ExtensionName')
        if m.get('HelpDocUrl') is not None:
            self.help_doc_url = m.get('HelpDocUrl')
        if m.get('OptionSetting') is not None:
            self.option_setting = m.get('OptionSetting')
        if m.get('ParameterSetting') is not None:
            self.parameter_setting = m.get('ParameterSetting')
        if m.get('ProjectTesting') is not None:
            self.project_testing = m.get('ProjectTesting')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetExtensionResponseBody(TeaModel):
    def __init__(
        self,
        extension: GetExtensionResponseBodyExtension = None,
        request_id: str = None,
    ):
        # The details of the extension.
        self.extension = extension
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.extension:
            self.extension.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extension') is not None:
            temp_model = GetExtensionResponseBodyExtension()
            self.extension = temp_model.from_map(m['Extension'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetExtensionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetExtensionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetExtensionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        node_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the file. You can call the [ListFiles](~~173942~~) operation to obtain the ID.
        self.file_id = file_id
        # The ID of the node that is scheduled. You can call the [ListFiles](~~173942~~) operation to obtain the node ID.
        self.node_id = node_id
        # The ID of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace ID.
        # 
        # You must configure this parameter or the ProjectIdentifier parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the [DataWorks console](https://workbench.data.aliyun.com/console) and go to the Workspace Management page to obtain the workspace name.
        # 
        # You must configure this parameter or the ProjectId parameter to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetFileResponseBodyDataFile(TeaModel):
    def __init__(
        self,
        advanced_settings: str = None,
        auto_parsing: bool = None,
        biz_id: int = None,
        business_id: int = None,
        commit_status: int = None,
        connection_name: str = None,
        content: str = None,
        create_time: int = None,
        create_user: str = None,
        current_version: int = None,
        deleted_status: str = None,
        file_description: str = None,
        file_folder_id: str = None,
        file_name: str = None,
        file_type: int = None,
        is_max_compute: bool = None,
        last_edit_time: int = None,
        last_edit_user: str = None,
        node_id: int = None,
        owner: str = None,
        parent_id: int = None,
        use_type: str = None,
    ):
        # The advanced configurations of the node.
        # 
        # This parameter is valid only for an EMR Spark Streaming node or an EMR Streaming SQL node. This parameter corresponds to the Advanced Settings tab of the node in the [DataWorks console](https://workbench.data.aliyun.com/console).
        # 
        # This parameter is configured in the JSON format.
        self.advanced_settings = advanced_settings
        # Indicates whether the automatic parsing feature is enabled for the file. Valid values:
        # 
        # *   true: The automatic parsing feature is enabled for the file.
        # *   false: The automatic parsing feature is not enabled for the file.
        # 
        # This parameter corresponds to the Analyze Code parameter that is displayed after Same Cycle is selected in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.auto_parsing = auto_parsing
        # The ID of the workflow to which the file belongs. This parameter is deprecated and replaced by the BusinessId parameter.
        self.biz_id = biz_id
        # The ID of the workflow to which the file belongs.
        self.business_id = business_id
        # Indicates whether the latest code in the file is committed. Valid values: 0 and 1. The value 0 indicates that the latest code in the file is not committed. The value 1 indicates that the latest code in the file is committed.
        self.commit_status = commit_status
        # The ID of the compute engine instance that is used to run the node that corresponds to the file.
        self.connection_name = connection_name
        # The code in the file.
        self.content = content
        # The time when the file was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The ID of the Alibaba Cloud account used to create the file.
        self.create_user = create_user
        # The latest version number of the file.
        self.current_version = current_version
        # The status of the file. Valid values:
        # 
        # *   NORMAL: The file is not deleted.
        # *   RECYCLE_BIN: The file is stored in the recycle bin.
        # *   DELETED: The file is deleted.
        self.deleted_status = deleted_status
        # The description of the file.
        self.file_description = file_description
        # The ID of the folder to which the file belongs.
        self.file_folder_id = file_folder_id
        # The name of the file.
        self.file_name = file_name
        # The type of the code for the file. Valid values: 6 (Shell), 10 (ODPS SQL), 11 (ODPS MR), 23 (Data Integration), 24 (ODPS Script), 99 (zero load), 221 (PyODPS 2), 225 (ODPS Spark), 227 (EMR Hive), 228 (EMR Spark), 229 (EMR Spark SQL), 230 (EMR MR), 239 (OSS object inspection), 257 (EMR Shell), 258 (EMR Spark Shell), 259 (EMR Presto), 260 (EMR Impala), 900 (real-time synchronization), 1089 (cross-tenant collaboration), 1091 (Hologres development), 1093 (Hologres SQL), 1100 (assignment), and 1221 (PyODPS 3).
        self.file_type = file_type
        # Indicates whether the file needs to be uploaded to MaxCompute.
        # 
        # This parameter is returned only if the file is a MaxCompute resource file.
        self.is_max_compute = is_max_compute
        # The time when the file was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.last_edit_time = last_edit_time
        # The ID of the Alibaba Cloud account used to last modify the file.
        self.last_edit_user = last_edit_user
        # The ID of the auto triggered node that is generated in the scheduling system after the file is committed.
        self.node_id = node_id
        # The ID of the Alibaba Cloud account used by the file owner.
        self.owner = owner
        # The ID of the node group file to which the current file belongs. This parameter is returned only if the current file is an inner file of the node group file.
        self.parent_id = parent_id
        # The module to which the file belongs. Valid values:
        # 
        # *   NORMAL: The file is used for DataStudio.
        # *   MANUAL: The file is used for a manually triggered node.
        # *   MANUAL_BIZ: The file is used for a manually triggered workflow.
        # *   SKIP: The file is used for a dry-run DataStudio node.
        # *   ADHOCQUERY: The file is used for an ad hoc query.
        # *   COMPONENT: The file is used for a snippet.
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_settings is not None:
            result['AdvancedSettings'] = self.advanced_settings
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.commit_status is not None:
            result['CommitStatus'] = self.commit_status
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.deleted_status is not None:
            result['DeletedStatus'] = self.deleted_status
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.file_folder_id is not None:
            result['FileFolderId'] = self.file_folder_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.is_max_compute is not None:
            result['IsMaxCompute'] = self.is_max_compute
        if self.last_edit_time is not None:
            result['LastEditTime'] = self.last_edit_time
        if self.last_edit_user is not None:
            result['LastEditUser'] = self.last_edit_user
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdvancedSettings') is not None:
            self.advanced_settings = m.get('AdvancedSettings')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('CommitStatus') is not None:
            self.commit_status = m.get('CommitStatus')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('DeletedStatus') is not None:
            self.deleted_status = m.get('DeletedStatus')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('FileFolderId') is not None:
            self.file_folder_id = m.get('FileFolderId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('IsMaxCompute') is not None:
            self.is_max_compute = m.get('IsMaxCompute')
        if m.get('LastEditTime') is not None:
            self.last_edit_time = m.get('LastEditTime')
        if m.get('LastEditUser') is not None:
            self.last_edit_user = m.get('LastEditUser')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetFileResponseBodyDataNodeConfigurationInputList(TeaModel):
    def __init__(
        self,
        input: str = None,
        parse_type: str = None,
    ):
        # The output name of the parent file on which the current file depends.
        # 
        # This parameter corresponds to the Output Name parameter under Parent Nodes after Same Cycle is selected in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.input = input
        # The mode of the configuration file dependency. Valid values:
        # 
        # *   MANUAL: Scheduling dependencies are manually configured.
        # *   AUTO: Scheduling dependencies are automatically parsed.
        self.parse_type = parse_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.parse_type is not None:
            result['ParseType'] = self.parse_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('ParseType') is not None:
            self.parse_type = m.get('ParseType')
        return self


class GetFileResponseBodyDataNodeConfigurationInputParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        value_source: str = None,
    ):
        # The name of the input parameter of the node. In the code, you can use the ${...} method to reference the input parameter of the node.
        # 
        # This parameter corresponds to the Parameter Name parameter in the Input Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.parameter_name = parameter_name
        # The value source of the input parameter of the node.
        # 
        # This parameter corresponds to the Value Source parameter in the Input Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.value_source = value_source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.value_source is not None:
            result['ValueSource'] = self.value_source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ValueSource') is not None:
            self.value_source = m.get('ValueSource')
        return self


class GetFileResponseBodyDataNodeConfigurationOutputList(TeaModel):
    def __init__(
        self,
        output: str = None,
        ref_table_name: str = None,
    ):
        # The output name of the current file.
        # 
        # This parameter corresponds to the Output Name parameter under Output after Same Cycle is selected in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.output = output
        # The output table name of the current file.
        # 
        # This parameter corresponds to the Output Table Name parameter under Output after Same Cycle is selected in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.ref_table_name = ref_table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output
        if self.ref_table_name is not None:
            result['RefTableName'] = self.ref_table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RefTableName') is not None:
            self.ref_table_name = m.get('RefTableName')
        return self


class GetFileResponseBodyDataNodeConfigurationOutputParameters(TeaModel):
    def __init__(
        self,
        description: str = None,
        parameter_name: str = None,
        type: str = None,
        value: str = None,
    ):
        # The description of the output parameter of the node.
        self.description = description
        # The name of the output parameter of the node.
        # 
        # This parameter corresponds to the Parameter Name parameter in the Output Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.parameter_name = parameter_name
        # The type of the output parameter of the node. Valid values:
        # 
        # *   1: indicates a constant.
        # *   2: indicates a variable.
        # *   3: indicates a pass-through variable.
        # 
        # This parameter corresponds to the Type parameter in the Output Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.type = type
        # The value of the output parameter of the node.
        # 
        # This parameter corresponds to the Value parameter in the Output Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetFileResponseBodyDataNodeConfiguration(TeaModel):
    def __init__(
        self,
        auto_rerun_interval_millis: int = None,
        auto_rerun_times: int = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        dependent_type: str = None,
        end_effect_date: int = None,
        input_list: List[GetFileResponseBodyDataNodeConfigurationInputList] = None,
        input_parameters: List[GetFileResponseBodyDataNodeConfigurationInputParameters] = None,
        output_list: List[GetFileResponseBodyDataNodeConfigurationOutputList] = None,
        output_parameters: List[GetFileResponseBodyDataNodeConfigurationOutputParameters] = None,
        para_value: str = None,
        rerun_mode: str = None,
        resource_group_id: int = None,
        scheduler_type: str = None,
        start_effect_date: int = None,
        start_immediately: bool = None,
        stop: bool = None,
    ):
        # The interval between automatic reruns after an error occurs. Unit: milliseconds.
        # 
        # This parameter corresponds to the Rerun Interval parameter that is displayed after the Auto Rerun upon Error check box is selected in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        # 
        # The interval that you specify in the DataWorks console is measured in minutes. Pay attention to the conversion between the units of time when you call the operation.
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        # The number of automatic reruns that are allowed after an error occurs.
        self.auto_rerun_times = auto_rerun_times
        # The CRON expression that represents the periodic scheduling policy of the node.
        self.cron_express = cron_express
        # The type of the scheduling cycle. Valid values: NOT_DAY and DAY. The value NOT_DAY indicates that the node is scheduled to run by minute or hour. The value DAY indicates that the node is scheduled to run by day, week, or month.
        # 
        # This parameter corresponds to the Scheduling Cycle parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.cycle_type = cycle_type
        # The ID of the node on which the node corresponding to the file depends when the DependentType parameter is set to USER_DEFINE. Multiple IDs are separated by commas (,).
        # 
        # The value of this parameter is equivalent to the ID of the node that you specified after you select Previous Cycle and set Depend On to Other Nodes in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.dependent_node_id_list = dependent_node_id_list
        # The type of the cross-cycle scheduling dependency of the node. Valid values:
        # 
        # *   SELF: The instance generated for the node in the current cycle depends on the instance generated for the node in the previous cycle.
        # *   CHILD: The instance generated for the node in the current cycle depends on the instances generated for the descendant nodes at the nearest level of the node in the previous cycle.
        # *   USER_DEFINE: The instance generated for the node in the current cycle depends on the instances generated for one or more specified nodes in the previous cycle.
        # *   NONE: No cross-cycle scheduling dependency type is selected for the node.
        self.dependent_type = dependent_type
        # The end time of automatic scheduling. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # This parameter corresponds to the Validity Period parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.end_effect_date = end_effect_date
        # The output names of the parent files on which the current file depends.
        self.input_list = input_list
        # Input parameters of the node.
        # 
        # This parameter corresponds to the Input Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.input_parameters = input_parameters
        # The output names of the current file.
        # 
        # This parameter corresponds to the Output Name parameter under Output after Same Cycle is selected in the Dependencies section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.output_list = output_list
        # Output parameters of the node.
        # 
        # This parameter corresponds to the Output Parameters table in the Input and Output Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.output_parameters = output_parameters
        # The scheduling parameters of the node.
        # 
        # This parameter corresponds to the Parameters section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console). For more information about the configurations of the scheduling parameters, see [Configure scheduling parameters](~~137548~~).
        self.para_value = para_value
        # Indicates whether the node that corresponds to the file can be rerun. Valid values:
        # 
        # *   ALL_ALLOWED: The node can be rerun regardless of whether it is successfully run or fails to run.
        # *   FAILURE_ALLOWED: The node can be rerun only after it fails to run.
        # *   ALL_DENIED: The node cannot be rerun regardless of whether it is successfully run or fails to run.
        # 
        # This parameter corresponds to the Rerun parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.rerun_mode = rerun_mode
        # The ID of the resource group that is used to run the node. You can call the [ListResourceGroups](~~173913~~) operation to query the available resource groups in the workspace.
        self.resource_group_id = resource_group_id
        # The scheduling type of the node. Valid values:
        # 
        # *   NORMAL: The node is an auto triggered node.
        # *   MANUAL: The node is a manually triggered node. Manually triggered nodes cannot be automatically triggered. They correspond to the nodes in the Manually Triggered Workflows pane.
        # *   PAUSE: The node is a paused node.
        # *   SKIP: The node is a dry-run node. Dry-run nodes are started as scheduled but the system sets the status of the nodes to successful when it starts to run them.
        self.scheduler_type = scheduler_type
        # The start time of automatic scheduling. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # This parameter corresponds to the Validity Period parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.start_effect_date = start_effect_date
        # Indicates whether a node is immediately run after the node is deployed to the production environment.
        # 
        # This parameter is valid only for an EMR Spark Streaming node or an EMR Streaming SQL node. This parameter corresponds to the Start Method parameter in the Schedule section of the Configure tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.start_immediately = start_immediately
        # Indicates whether the scheduling for the node is suspended Valid values:
        # 
        # *   true: The scheduling for the node is suspended.
        # *   false: The scheduling for the node is not suspended.
        # 
        # This parameter corresponds to the Recurrence parameter in the Schedule section of the Properties tab in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.stop = stop

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.input_parameters:
            for k in self.input_parameters:
                if k:
                    k.validate()
        if self.output_list:
            for k in self.output_list:
                if k:
                    k.validate()
        if self.output_parameters:
            for k in self.output_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        result['InputParameters'] = []
        if self.input_parameters is not None:
            for k in self.input_parameters:
                result['InputParameters'].append(k.to_map() if k else None)
        result['OutputList'] = []
        if self.output_list is not None:
            for k in self.output_list:
                result['OutputList'].append(k.to_map() if k else None)
        result['OutputParameters'] = []
        if self.output_parameters is not None:
            for k in self.output_parameters:
                result['OutputParameters'].append(k.to_map() if k else None)
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.start_immediately is not None:
            result['StartImmediately'] = self.start_immediately
        if self.stop is not None:
            result['Stop'] = self.stop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationInputList()
                self.input_list.append(temp_model.from_map(k))
        self.input_parameters = []
        if m.get('InputParameters') is not None:
            for k in m.get('InputParameters'):
                temp_model = GetFileResponseBodyDataNodeConfigurationInputParameters()
                self.input_parameters.append(temp_model.from_map(k))
        self.output_list = []
        if m.get('OutputList') is not None:
            for k in m.get('OutputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationOutputList()
                self.output_list.append(temp_model.from_map(k))
        self.output_parameters = []
        if m.get('OutputParameters') is not None:
            for k in m.get('OutputParameters'):
                temp_model = GetFileResponseBodyDataNodeConfigurationOutputParameters()
                self.output_parameters.append(temp_model.from_map(k))
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('StartImmediately') is not None:
            self.start_immediately = m.get('StartImmediately')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        return self


class GetFileResponseBodyData(TeaModel):
    def __init__(
        self,
        file: GetFileResponseBodyDataFile = None,
        node_configuration: GetFileResponseBodyDataNodeConfiguration = None,
    ):
        # The basic information about the file.
        self.file = file
        # The scheduling configurations of the file.
        self.node_configuration = node_configuration

    def validate(self):
        if self.file:
            self.file.validate()
        if self.node_configuration:
            self.node_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.node_configuration is not None:
            result['NodeConfiguration'] = self.node_configuration.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('File') is not None:
            temp_model = GetFileResponseBodyDataFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('NodeConfiguration') is not None:
            temp_model = GetFileResponseBodyDataNodeConfiguration()
            self.node_configuration = temp_model.from_map(m['NodeConfiguration'])
        return self


class GetFileResponseBody(TeaModel):
    def __init__(
        self,
        data: GetFileResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the file.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true: The request is successful.
        # *   false: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileTypeStatisticRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_id: int = None,
    ):
        # The environment of the workspace. Valid values: PROD and DEV. The value PROD indicates the production environment. The value DEV indicates the development environment.
        self.project_env = project_env
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetFileTypeStatisticResponseBodyProgramTypeAndCounts(TeaModel):
    def __init__(
        self,
        count: int = None,
        program_type: str = None,
    ):
        # The number of nodes.
        self.count = count
        # The type of the node.
        # 
        # Valid values:
        # 
        # 6 (Shell node), 10 (ODPS SQL node), 11 (ODPS MR node), 23 (Data Integration node), 24 (ODPS Script node), 99 (zero load node), 221 (PyODPS 2 node), 225 (ODPS Spark node), 227 (EMR Hive node), 228 (EMR Spark node), 229 (EMR Spark SQL node), 230 (EMR MR node), 239 (OSS object inspection node), 257 (EMR Shell node), 258 (EMR Spark Shell node), 259 (EMR Presto node), 260 (EMR Impala node), 900 (real-time data synchronization node), 1089 (cross-tenant collaboration node), 1091 (Hologres development node), 1093 (Hologres SQL node), 1100 (assignment node), and 1221 (PyODPS 3 node).
        self.program_type = program_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        return self


class GetFileTypeStatisticResponseBody(TeaModel):
    def __init__(
        self,
        program_type_and_counts: List[GetFileTypeStatisticResponseBodyProgramTypeAndCounts] = None,
        request_id: str = None,
    ):
        # An array of node types and quantity.
        self.program_type_and_counts = program_type_and_counts
        # The ID of the request. You can use the ID to locate logs and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.program_type_and_counts:
            for k in self.program_type_and_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProgramTypeAndCounts'] = []
        if self.program_type_and_counts is not None:
            for k in self.program_type_and_counts:
                result['ProgramTypeAndCounts'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.program_type_and_counts = []
        if m.get('ProgramTypeAndCounts') is not None:
            for k in m.get('ProgramTypeAndCounts'):
                temp_model = GetFileTypeStatisticResponseBodyProgramTypeAndCounts()
                self.program_type_and_counts.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetFileTypeStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileTypeStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileTypeStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileVersionRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        file_version: int = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the file. You can call the [ListFiles](~~173942~~) operation to query the ID.
        self.file_id = file_id
        # The file version whose details you want to query.
        self.file_version = file_version
        # The ID of the DataWorks workspace. You can click the Workspace Manage icon in the upper-right corner of the DataStudio page to go to the Workspace Management page and view the workspace ID.
        self.project_id = project_id
        # The unique identifier of the DataWorks workspace. You can click the identifier in the upper-left corner of the DataStudio page to switch to another workspace.
        # 
        # You must specify either this parameter or ProjectId to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetFileVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        change_type: str = None,
        comment: str = None,
        commit_time: int = None,
        commit_user: str = None,
        file_content: str = None,
        file_name: str = None,
        file_property_content: str = None,
        file_version: int = None,
        is_current_prod: bool = None,
        node_content: str = None,
        node_id: int = None,
        status: str = None,
        use_type: str = None,
    ):
        # The change type of the file version. Valid values: CREATE, UPDATE, and DELETE.
        self.change_type = change_type
        # The description of the file version.
        self.comment = comment
        # The time when the version was generated. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.commit_time = commit_time
        # The ID of the Alibaba Cloud account that is used to create the file version.
        self.commit_user = commit_user
        # The file code.
        self.file_content = file_content
        # The file name.
        self.file_name = file_name
        # The basic information about the file.
        self.file_property_content = file_property_content
        # The file version.
        self.file_version = file_version
        # Indicates whether the version is the latest version in the production environment.
        self.is_current_prod = is_current_prod
        # The scheduling configurations of the node that corresponds to the file version.
        self.node_content = node_content
        # The ID of the node that corresponds to the file version.
        self.node_id = node_id
        # The status of the file version. Valid values: COMMITTING, COMMITTED, CHECK_OK, PACKAGED, DEPLOYING, DEPLOYED, and CANCELLED. The value CHECK_OK is equivalent to the value COMMITTED.
        self.status = status
        # The functional module to which the file belongs. Valid values: NORMAL, MANUAL, MANUAL_BIZ, SKIP, ADHOCQUERY, and COMPONENT. The value NORMAL indicates DataStudio. The value MANUAL indicates a manually triggered node. The value MANUAL_BIZ indicates a manually triggered workflow. The value SKIP indicates a dry-run DataStudio node. The value ADHOCQUERY indicates an ad hoc query. The value COMPONENT indicates snippets.
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.commit_time is not None:
            result['CommitTime'] = self.commit_time
        if self.commit_user is not None:
            result['CommitUser'] = self.commit_user
        if self.file_content is not None:
            result['FileContent'] = self.file_content
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.is_current_prod is not None:
            result['IsCurrentProd'] = self.is_current_prod
        if self.node_content is not None:
            result['NodeContent'] = self.node_content
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.status is not None:
            result['Status'] = self.status
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CommitTime') is not None:
            self.commit_time = m.get('CommitTime')
        if m.get('CommitUser') is not None:
            self.commit_user = m.get('CommitUser')
        if m.get('FileContent') is not None:
            self.file_content = m.get('FileContent')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePropertyContent') is not None:
            self.file_property_content = m.get('FilePropertyContent')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('IsCurrentProd') is not None:
            self.is_current_prod = m.get('IsCurrentProd')
        if m.get('NodeContent') is not None:
            self.node_content = m.get('NodeContent')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetFileVersionResponseBody(TeaModel):
    def __init__(
        self,
        data: GetFileVersionResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the file version.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetFileVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFileVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFolderRequest(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        folder_path: str = None,
        project_id: int = None,
        project_identifier: str = None,
    ):
        # The ID of the folder. You can call the [ListFolders](~~173955~~) operation to query the ID.
        # 
        # You must specify either this parameter or the FolderPath parameter.
        self.folder_id = folder_id
        # The path of the folder. You can call the [ListFolders](~~173955~~) operation to query the path.
        # 
        # You must specify either this parameter or the FolderId parameter.
        self.folder_path = folder_path
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the ID. You must specify either this parameter or ProjectIdentifier to determine the DataWorks workspace to which the operation is applied.
        self.project_id = project_id
        # The name of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Settings panel to obtain the name. You must specify either this parameter or ProjectId to determine the DataWorks workspace to which the operation is applied.
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class GetFolderResponseBodyData(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        folder_path: str = None,
    ):
        # The ID of the folder.
        self.folder_id = folder_id
        # The path of the folder.
        self.folder_path = folder_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class GetFolderResponseBody(TeaModel):
    def __init__(
        self,
        data: GetFolderResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the folder.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can use the ID to troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetFolderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFolderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIDEEventDetailRequest(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        project_id: int = None,
    ):
        # The ID of the message. You can obtain the ID from the received message when the extension point event is triggered.
        self.message_id = message_id
        # The ID of the workspace. You can obtain the ID from the message.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileFilePropertyContent(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        current_version: int = None,
        data_source_name: str = None,
        folder_id: str = None,
        owner: str = None,
        parent_file_id: int = None,
    ):
        # The ID of the workflow to which the file belongs.
        self.business_id = business_id
        # The latest version number of the file.
        self.current_version = current_version
        # The name of the compute engine instance with which the file is associated.
        self.data_source_name = data_source_name
        # The ID of the folder to which the file belongs. You can call the [GetFolder](~~173952~~) operation to query the details of the file based on the folder ID.
        self.folder_id = folder_id
        # The owner of the file.
        self.owner = owner
        # The ID of the do-while node or for-each node that corresponds to the file.
        self.parent_file_id = parent_file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.parent_file_id is not None:
            result['ParentFileId'] = self.parent_file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParentFileId') is not None:
            self.parent_file_id = m.get('ParentFileId')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationInputList(TeaModel):
    def __init__(
        self,
        input: str = None,
        parse_type: str = None,
    ):
        # The output names of the parent files on which the current file depends.
        # 
        # This parameter is equivalent to the Output Name parameter under Parent Nodes in the Dependencies section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.input = input
        # The mode of the configuration file dependency. Valid values:
        # 
        # *   MANUAL: The scheduling dependencies are manually configured.
        # *   AUTO: The scheduling dependencies are automatically parsed.
        self.parse_type = parse_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.parse_type is not None:
            result['ParseType'] = self.parse_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('ParseType') is not None:
            self.parse_type = m.get('ParseType')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationOutputList(TeaModel):
    def __init__(
        self,
        output: str = None,
        ref_table_name: str = None,
    ):
        # The output name of the current file.
        # 
        # This parameter is equivalent to the Output Name parameter under Output in the Dependencies section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.output = output
        # The output table name of the current file.
        # 
        # This parameter is equivalent to the Output Table Name parameter under Output in the Dependencies section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.ref_table_name = ref_table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output
        if self.ref_table_name is not None:
            result['RefTableName'] = self.ref_table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RefTableName') is not None:
            self.ref_table_name = m.get('RefTableName')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfiguration(TeaModel):
    def __init__(
        self,
        auto_rerun_interval_millis: int = None,
        auto_rerun_times: int = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        dependent_type: str = None,
        input_list: List[GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationInputList] = None,
        output_list: List[GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationOutputList] = None,
        para_value: str = None,
        rerun_mode: str = None,
        resource_group_id: int = None,
        scheduler_type: str = None,
    ):
        # The interval at which the node corresponding to the file is rerun. Unit: milliseconds.
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        # The number of times that the node corresponding to the file can be rerun.
        self.auto_rerun_times = auto_rerun_times
        # The CRON expression that is used to schedule the node corresponding to the file.
        self.cron_express = cron_express
        # The type of the scheduling cycle of the node that corresponds to the file. Valid values: NOT_DAY and DAY. A value of NOT_DAY indicates that the node is scheduled to run by minute or hour. A value of DAY indicates that the node is scheduled to run by day, week, or month.
        # 
        # This parameter is equivalent to the Scheduling Cycle parameter in the Schedule section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.cycle_type = cycle_type
        # The IDs of the nodes on which the node corresponding to the file depends when the DependentType parameter is set to USER_DEFINE. Multiple IDs are separated by commas (,).
        # 
        # This parameter is equivalent to the field that appears after Previous Cycle is selected and the Depend On parameter is set to Other Nodes in the Dependencies section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.dependent_node_id_list = dependent_node_id_list
        # The type of the cross-cycle scheduling dependency of the node that corresponds to the file. Valid values:
        # 
        # *   SELF: The instance generated for the node in the current cycle depends on the instance generated for the node in the previous cycle.
        # *   CHILD: The instance generated for the node in the current cycle depends on the instances generated for the descendant nodes at the nearest level of the node in the previous cycle.
        # *   USER_DEFINE: The instance generated for the node in the current cycle depends on the instances generated for one or more specified nodes in the previous cycle.
        # *   NONE: No cross-cycle scheduling dependency type is selected for the node.
        self.dependent_type = dependent_type
        # The output names of the parent files on which the current file depends.
        self.input_list = input_list
        # The output names of the current file.
        # 
        # This parameter is equivalent to the Output Name parameter under Output in the Dependencies section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.output_list = output_list
        # The scheduling parameters.
        # 
        # This parameter is equivalent to the configuration of the scheduling parameters in the Parameters section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console). For more information, see [Configure scheduling parameters](~~137548~~).
        self.para_value = para_value
        # Indicates whether the node can be rerun. Valid values:
        # 
        # *   ALL_ALLOWED: The node can be rerun regardless of whether it is successfully run or fails to run.
        # *   FAILURE_ALLOWED: The node can be rerun only after it fails to run.
        # *   ALL_DENIED: The node cannot be rerun regardless of whether it is successfully run or fails to run.
        # 
        # This parameter is equivalent to the Rerun parameter in the Schedule section of the Properties panel in the [DataWorks console](https://workbench.data.aliyun.com/console).
        self.rerun_mode = rerun_mode
        # The ID of the resource group that is used to run the node that corresponds to the file. You can call the [ListResourceGroups](~~173913~~) operation to query the available resource groups in the workspace.
        self.resource_group_id = resource_group_id
        # The scheduling type of the node. Valid values:
        # 
        # *   NORMAL: The node is an auto triggered node.
        # *   MANUAL: The node is a manually triggered node. Manually triggered nodes cannot be automatically triggered. They correspond to the nodes in the Manually Triggered Workflows pane.
        # *   PAUSE: The node is a paused node.
        # *   SKIP: The node is a dry-run node. Dry-run nodes are started as scheduled but the system sets the status of the nodes to successful when it starts to run them.
        self.scheduler_type = scheduler_type

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.output_list:
            for k in self.output_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        result['OutputList'] = []
        if self.output_list is not None:
            for k in self.output_list:
                result['OutputList'].append(k.to_map() if k else None)
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationInputList()
                self.input_list.append(temp_model.from_map(k))
        self.output_list = []
        if m.get('OutputList') is not None:
            for k in m.get('OutputList'):
                temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfigurationOutputList()
                self.output_list.append(temp_model.from_map(k))
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetIDEEventDetailResponseBodyEventDetailCommittedFile(TeaModel):
    def __init__(
        self,
        change_type: str = None,
        comment: str = None,
        committor: str = None,
        content: str = None,
        file_id: int = None,
        file_name: str = None,
        file_property_content: GetIDEEventDetailResponseBodyEventDetailCommittedFileFilePropertyContent = None,
        file_type: int = None,
        node_configuration: GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfiguration = None,
        node_id: int = None,
        use_type: str = None,
    ):
        # The type of the change to the file of the current version. Valid values: CREATE, UPDATE, and DELETE.
        self.change_type = change_type
        # The description of the file version.
        self.comment = comment
        # The ID of the Alibaba Cloud account that is used to create the file of the current version.
        self.committor = committor
        # The code in the file of the current version.
        self.content = content
        # The ID of the file.
        self.file_id = file_id
        # The name of the file.
        self.file_name = file_name
        # The details of the file.
        self.file_property_content = file_property_content
        # The type of the code in the file. Examples: 6 (Shell), 10 (ODPS SQL), 11 (ODPS MR), 23 (Data Integration), 24 (ODPS Script), 99 (zero load), 221 (PyODPS 2), 225 (ODPS Spark), 227 (EMR Hive), 228 (EMR Spark), 229 (EMR Spark SQL), 230 (EMR MR), 239 (OSS object inspection), 257 (EMR Shell), 258 (EMR Spark Shell), 259 (EMR Presto), 260 (EMR Impala), 900 (real-time sync), 1089 (cross-tenant collaboration), 1091 (Hologres development), 1093 (Hologres SQL), 1100 (assignment), and 1221 (PyODPS 3).
        self.file_type = file_type
        # The scheduling properties of the node that corresponds to the file.
        self.node_configuration = node_configuration
        # The ID of the node that is scheduled.
        self.node_id = node_id
        # The module to which the file belongs. Valid values:
        # 
        # *   NORMAL: The file is used for DataStudio.
        # *   MANUAL: The file is used for a manually triggered node.
        # *   MANUAL_BIZ: The file is used for a manually triggered workflow.
        # *   SKIP: The file is used for a dry-run DataStudio node.
        # *   ADHOCQUERY: The file is used for an ad hoc query.
        # *   COMPONENT: The file is used for a snippet.
        self.use_type = use_type

    def validate(self):
        if self.file_property_content:
            self.file_property_content.validate()
        if self.node_configuration:
            self.node_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.committor is not None:
            result['Committor'] = self.committor
        if self.content is not None:
            result['Content'] = self.content
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content.to_map()
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.node_configuration is not None:
            result['NodeConfiguration'] = self.node_configuration.to_map()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Committor') is not None:
            self.committor = m.get('Committor')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePropertyContent') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileFilePropertyContent()
            self.file_property_content = temp_model.from_map(m['FilePropertyContent'])
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('NodeConfiguration') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFileNodeConfiguration()
            self.node_configuration = temp_model.from_map(m['NodeConfiguration'])
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetIDEEventDetailResponseBodyEventDetailDeletedFile(TeaModel):
    def __init__(
        self,
        business_id: int = None,
        content: str = None,
        current_version: int = None,
        data_source_name: str = None,
        file_id: int = None,
        file_name: str = None,
        file_type: int = None,
        folder_id: str = None,
        node_id: int = None,
        owner: str = None,
        parent_file_id: int = None,
        use_type: str = None,
    ):
        # The ID of the workflow to which the file belongs.
        self.business_id = business_id
        # The code in the file of the current version.
        self.content = content
        # The latest version number of the file.
        self.current_version = current_version
        # The name of the compute engine instance with which the file is associated.
        self.data_source_name = data_source_name
        # The ID of the file.
        self.file_id = file_id
        # The name of the file.
        self.file_name = file_name
        # The type of the code in the file. Examples: 6 (Shell), 10 (ODPS SQL), 11 (ODPS MR), 23 (Data Integration), 24 (ODPS Script), 99 (zero load), 221 (PyODPS 2), 225 (ODPS Spark), 227 (EMR Hive), 228 (EMR Spark), 229 (EMR Spark SQL), 230 (EMR MR), 239 (OSS object inspection), 257 (EMR Shell), 258 (EMR Spark Shell), 259 (EMR Presto), 260 (EMR Impala), 900 (real-time sync), 1089 (cross-tenant collaboration), 1091 (Hologres development), 1093 (Hologres SQL), 1100 (assignment), and 1221 (PyODPS 3).
        self.file_type = file_type
        # The ID of the folder to which the file belongs. You can call the [GetFolder](~~173952~~) operation to query the details of the file based on the folder ID.
        self.folder_id = folder_id
        # The ID of the node that is scheduled.
        self.node_id = node_id
        # The owner of the file.
        self.owner = owner
        # The ID of the do-while node or for-each node that corresponds to the file.
        self.parent_file_id = parent_file_id
        # The module to which the file belongs. Valid values:
        # 
        # *   NORMAL: The file is used for DataStudio.
        # *   MANUAL: The file is used for a manually triggered node.
        # *   MANUAL_BIZ: The file is used for a manually triggered workflow.
        # *   SKIP: The file is used for a dry-run DataStudio node.
        # *   ADHOCQUERY: The file is used for an ad hoc query.
        # *   COMPONENT: The file is used for a snippet.
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.content is not None:
            result['Content'] = self.content
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.parent_file_id is not None:
            result['ParentFileId'] = self.parent_file_id
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ParentFileId') is not None:
            self.parent_file_id = m.get('ParentFileId')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetIDEEventDetailResponseBodyEventDetailFileExecutionCommand(TeaModel):
    def __init__(
        self,
        content: str = None,
        data_source_name: str = None,
        file_id: int = None,
        file_type: int = None,
    ):
        # The code in the file of the current version.
        self.content = content
        # The name of the compute engine instance with which the file is associated.
        self.data_source_name = data_source_name
        # The ID of the file.
        self.file_id = file_id
        # The type of the code in the file. Examples: 6 (Shell), 10 (ODPS SQL), 11 (ODPS MR), 23 (Data Integration), 24 (ODPS Script), 99 (zero load), 221 (PyODPS 2), 225 (ODPS Spark), 227 (EMR Hive), 228 (EMR Spark), 229 (EMR Spark SQL), 230 (EMR MR), 239 (OSS object inspection), 257 (EMR Shell), 258 (EMR Spark Shell), 259 (EMR Presto), 260 (EMR Impala), 900 (real-time sync), 1089 (cross-tenant collaboration), 1091 (Hologres development), 1093 (Hologres SQL), 1100 (assignment), and 1221 (PyODPS 3).
        self.file_type = file_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_type is not None:
            result['FileType'] = self.file_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        return self


class GetIDEEventDetailResponseBodyEventDetailTableModelColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_type: str = None,
        comment: str = None,
        is_partition_column: bool = None,
    ):
        # The name of the column.
        self.column_name = column_name
        # The data type of the column.
        self.column_type = column_type
        # The remarks of the column.
        self.comment = comment
        # Indicates whether the column is a partition key column. Valid values:
        # 
        # - true: The column is a partition key column.
        # - false: The column is not a partition key column.
        self.is_partition_column = is_partition_column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        return self


class GetIDEEventDetailResponseBodyEventDetailTableModel(TeaModel):
    def __init__(
        self,
        columns: List[GetIDEEventDetailResponseBodyEventDetailTableModelColumns] = None,
        comment: str = None,
        data_source_name: str = None,
        env: str = None,
        life_cycle: int = None,
        location: str = None,
        table_name: str = None,
    ):
        # The columns in the table.
        self.columns = columns
        # The description of the table.
        self.comment = comment
        # The name of the compute engine instance to which the table belongs.
        self.data_source_name = data_source_name
        # The environment in which the table is used. Valid values:
        # 
        # - DEV: development environment
        # - PROD: production environment
        self.env = env
        # The lifecycle of the table. Unit: days.
        self.life_cycle = life_cycle
        # The path of the table.
        self.location = location
        # The name of the table.
        self.table_name = table_name

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.env is not None:
            result['Env'] = self.env
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetIDEEventDetailResponseBodyEventDetailTableModelColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('Env') is not None:
            self.env = m.get('Env')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetIDEEventDetailResponseBodyEventDetail(TeaModel):
    def __init__(
        self,
        committed_file: GetIDEEventDetailResponseBodyEventDetailCommittedFile = None,
        deleted_file: GetIDEEventDetailResponseBodyEventDetailDeletedFile = None,
        file_execution_command: GetIDEEventDetailResponseBodyEventDetailFileExecutionCommand = None,
        table_model: GetIDEEventDetailResponseBodyEventDetailTableModel = None,
    ):
        # The data snapshot when the file is committed and deployed.
        # 
        # The value of this parameter is not empty only when the message type is IDE_FILE_SUBMIT_BEFORE or IDE_FILE_DEPLOY_BEFORE.
        self.committed_file = committed_file
        # The data snapshot when the file is deleted. The value of this parameter is not empty only when the message type is IDE_FILE_DELETE_BEFORE.
        self.deleted_file = deleted_file
        # The data snapshot when the code in the file is run. The value of this parameter is not empty only when the message type is IDE_FILE_EXECUTE_BEFORE.
        self.file_execution_command = file_execution_command
        # The data snapshot when the table is committed and deployed. The value of this parameter is not empty only when the message type is IDE_TABLE_SUBMIT_BEFORE or IDE_TABLE_DEPLOY_BEFORE.
        self.table_model = table_model

    def validate(self):
        if self.committed_file:
            self.committed_file.validate()
        if self.deleted_file:
            self.deleted_file.validate()
        if self.file_execution_command:
            self.file_execution_command.validate()
        if self.table_model:
            self.table_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.committed_file is not None:
            result['CommittedFile'] = self.committed_file.to_map()
        if self.deleted_file is not None:
            result['DeletedFile'] = self.deleted_file.to_map()
        if self.file_execution_command is not None:
            result['FileExecutionCommand'] = self.file_execution_command.to_map()
        if self.table_model is not None:
            result['TableModel'] = self.table_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommittedFile') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailCommittedFile()
            self.committed_file = temp_model.from_map(m['CommittedFile'])
        if m.get('DeletedFile') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailDeletedFile()
            self.deleted_file = temp_model.from_map(m['DeletedFile'])
        if m.get('FileExecutionCommand') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailFileExecutionCommand()
            self.file_execution_command = temp_model.from_map(m['FileExecutionCommand'])
        if m.get('TableModel') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetailTableModel()
            self.table_model = temp_model.from_map(m['TableModel'])
        return self


class GetIDEEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        event_detail: GetIDEEventDetailResponseBodyEventDetail = None,
        request_id: str = None,
    ):
        # The data snapshot that is generated when the extension point event is triggered.
        # 
        # The fields contained in data snapshots vary based on the types of the triggered extension point events. For more information, see the description of the fields.
        self.event_detail = event_detail
        # The ID of the request. You can troubleshoot errors based on the ID.
        self.request_id = request_id

    def validate(self):
        if self.event_detail:
            self.event_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_detail is not None:
            result['EventDetail'] = self.event_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventDetail') is not None:
            temp_model = GetIDEEventDetailResponseBodyEventDetail()
            self.event_detail = temp_model.from_map(m['EventDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIDEEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetIDEEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIDEEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        project_env: str = None,
    ):
        # The ID of the instance. You can call the [ListInstances](~~173982~~) operation to query the ID.
        self.instance_id = instance_id
        # The environment of the workspace. Valid values: PROD and DEV. The value PROD indicates the production environment, and the value DEV indicates the development environment.
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        begin_running_time: int = None,
        begin_wait_res_time: int = None,
        begin_wait_time_time: int = None,
        bizdate: int = None,
        business_id: int = None,
        connection: str = None,
        create_time: int = None,
        create_user: str = None,
        cyc_time: int = None,
        dag_id: int = None,
        dag_type: str = None,
        dqc_description: str = None,
        dqc_type: int = None,
        finish_time: int = None,
        instance_id: int = None,
        modify_time: int = None,
        node_id: int = None,
        node_name: str = None,
        param_values: str = None,
        priority: int = None,
        related_flow_id: int = None,
        repeat_interval: int = None,
        repeatability: bool = None,
        status: str = None,
        task_rerun_time: int = None,
        task_type: str = None,
    ):
        # The ID of the baseline.
        self.baseline_id = baseline_id
        # The time when the instance started to run.
        self.begin_running_time = begin_running_time
        # The time when the instance started to wait for resources.
        self.begin_wait_res_time = begin_wait_res_time
        # The time when the instance started to wait to be run.
        self.begin_wait_time_time = begin_wait_time_time
        # The data timestamp. In most cases, the value is one day before the date when the instance is run.
        self.bizdate = bizdate
        # The ID of the workflow.
        self.business_id = business_id
        # The connection string.
        self.connection = connection
        # The time when the instance was generated.
        self.create_time = create_time
        # The owner of the instance.
        self.create_user = create_user
        # The scheduled time of the instance.
        self.cyc_time = cyc_time
        # The ID of the workflow.
        self.dag_id = dag_id
        # The type of the workflow. Valid values:
        # 
        # *   DAILY: The workflow is used to run auto triggered nodes.
        # *   MANUAL: The workflow is used to run manually triggered nodes.
        # *   SMOKE_TEST: The workflow is used to perform smoke testing.
        # *   SUPPLY_DATA: The workflow is used to backfill data.
        self.dag_type = dag_type
        # The table and partition filter expression in Data Quality that are associated with the instance.
        self.dqc_description = dqc_description
        # Indicates whether the instance is associated with a monitoring rule in Data Quality. Valid values:
        # 
        # *   0: The instance is associated with a monitoring rule in Data Quality.
        # *   1: The instance is not associated with a monitoring rule in Data Quality.
        self.dqc_type = dqc_type
        # The time when the running of the instance was complete.
        self.finish_time = finish_time
        # The ID of the instance.
        self.instance_id = instance_id
        # The time when the instance was last modified.
        self.modify_time = modify_time
        # The ID of the node that generates the instance.
        self.node_id = node_id
        # The name of the node that generates the instance.
        self.node_name = node_name
        # The values of the parameters related to the node.
        self.param_values = param_values
        # The priority of the instance. Valid values: 1, 3, 5, 7, and 8. A great value indicates a high priority. Default value: 1.
        self.priority = priority
        # The ID of the workflow to which the node that generates the instance belongs.
        self.related_flow_id = related_flow_id
        # The interval at which the node that generates the instance is rerun after the node fails to run. Unit: milliseconds.
        self.repeat_interval = repeat_interval
        # Indicates whether the node that generates the instance can be rerun.
        self.repeatability = repeatability
        # The status of the node that generates the instance. Valid values:
        # 
        # *   NOT_RUN: The node is not run.
        # *   WAIT_TIME: The node is waiting for its scheduled time to arrive.
        # *   WAIT_RESOURCE: The node is waiting for resources.
        # *   RUNNING: The node is running.
        # *   CHECKING: Data quality is being checked for the node.
        # *   CHECKING_CONDITION: Branch conditions are being checked for the node.
        # *   FAILURE: The node fails to run.
        # *   SUCCESS: The node is successfully run.
        self.status = status
        # The number of times the node that generates the instance can be rerun. This parameter can be left empty, or the value of this parameter can be an integer that is greater than or equal to 0.
        # 
        # *   If this parameter is left empty, the number of rerun times is not specified for the node.
        # *   If the value of this parameter is 0, the node cannot be rerun.
        # *   If the value of this parameter is n (an integer that is greater than 0), the node can be rerun n times. For example, if the value of this parameter is 1, the node can be rerun once. If the value of this parameter is 2, the node can be rerun two times, and so on.
        self.task_rerun_time = task_rerun_time
        # The scheduling type of the node that generates the instance. Valid values:
        # 
        # *   NORMAL(0): The node is an auto triggered node. It is run on a regular basis.
        # *   MANUAL(1): The node is a manually triggered node. It is not run on a regular basis.
        # *   PAUSE(2): The node is a frozen node. The scheduling system still runs the node on a regular basis but sets it to FAILURE when the scheduling system starts to run the node.
        # *   SKIP(3): The node is a dry-run node. The scheduling system still runs the node on a regular basis but sets it to SUCCESS when the scheduling system starts to run the node.
        # *   SKIP_UNCHOOSE(4): The node is an unselected node in a temporary workflow. This type of node exists only in temporary workflows. The scheduling system sets the node to SUCCESS when the scheduling system starts to run the node.
        # *   SKIP_CYCLE(5): The node is a node that is scheduled by week or month and is waiting for its scheduled time. The scheduling system still runs the node on a regular basis but sets it to SUCCESS when the scheduling system starts to run the node.
        # *   CONDITION_UNCHOOSE(6): The node is not selected by its ancestor branch node and is run as a dry-run node.
        # *   REALTIME_DEPRECATED(7): The node has instances generated in real time but deprecated. The scheduling system directly sets the node to SUCCESS.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.status is not None:
            result['Status'] = self.status
        if self.task_rerun_time is not None:
            result['TaskRerunTime'] = self.task_rerun_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskRerunTime') is not None:
            self.task_rerun_time = m.get('TaskRerunTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(
        self,
        data: GetInstanceResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details about the instance.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned because the instance fails to be scheduled.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can locate logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceConsumeTimeRankRequest(TeaModel):
    def __init__(
        self,
        bizdate: str = None,
        project_id: int = None,
    ):
        self.bizdate = bizdate
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank(TeaModel):
    def __init__(
        self,
        bizdate: int = None,
        consumed: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        prg_type: int = None,
    ):
        self.bizdate = bizdate
        self.consumed = consumed
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.prg_type = prg_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.consumed is not None:
            result['Consumed'] = self.consumed
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Consumed') is not None:
            self.consumed = m.get('Consumed')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank(TeaModel):
    def __init__(
        self,
        consume_time_rank: List[GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank] = None,
        update_time: int = None,
    ):
        self.consume_time_rank = consume_time_rank
        self.update_time = update_time

    def validate(self):
        if self.consume_time_rank:
            for k in self.consume_time_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConsumeTimeRank'] = []
        if self.consume_time_rank is not None:
            for k in self.consume_time_rank:
                result['ConsumeTimeRank'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consume_time_rank = []
        if m.get('ConsumeTimeRank') is not None:
            for k in m.get('ConsumeTimeRank'):
                temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank()
                self.consume_time_rank.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetInstanceConsumeTimeRankResponseBody(TeaModel):
    def __init__(
        self,
        instance_consume_time_rank: GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank = None,
        request_id: str = None,
    ):
        self.instance_consume_time_rank = instance_consume_time_rank
        self.request_id = request_id

    def validate(self):
        if self.instance_consume_time_rank:
            self.instance_consume_time_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_consume_time_rank is not None:
            result['InstanceConsumeTimeRank'] = self.instance_consume_time_rank.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceConsumeTimeRank') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank()
            self.instance_consume_time_rank = temp_model.from_map(m['InstanceConsumeTimeRank'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceConsumeTimeRankResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceConsumeTimeRankResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceCountTrendRequest(TeaModel):
    def __init__(
        self,
        begin_date: str = None,
        end_date: str = None,
        project_id: int = None,
    ):
        self.begin_date = begin_date
        self.end_date = end_date
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceCountTrendResponseBodyInstanceCounts(TeaModel):
    def __init__(
        self,
        count: int = None,
        date: int = None,
    ):
        self.count = count
        self.date = date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.date is not None:
            result['Date'] = self.date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        return self


class GetInstanceCountTrendResponseBody(TeaModel):
    def __init__(
        self,
        instance_counts: List[GetInstanceCountTrendResponseBodyInstanceCounts] = None,
        request_id: str = None,
    ):
        self.instance_counts = instance_counts
        self.request_id = request_id

    def validate(self):
        if self.instance_counts:
            for k in self.instance_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceCounts'] = []
        if self.instance_counts is not None:
            for k in self.instance_counts:
                result['InstanceCounts'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_counts = []
        if m.get('InstanceCounts') is not None:
            for k in m.get('InstanceCounts'):
                temp_model = GetInstanceCountTrendResponseBodyInstanceCounts()
                self.instance_counts.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceCountTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceCountTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceCountTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceErrorRankRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank(TeaModel):
    def __init__(
        self,
        count: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        prg_type: int = None,
        project_id: int = None,
    ):
        self.count = count
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.prg_type = prg_type
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRank(TeaModel):
    def __init__(
        self,
        error_rank: List[GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank] = None,
        update_time: int = None,
    ):
        self.error_rank = error_rank
        self.update_time = update_time

    def validate(self):
        if self.error_rank:
            for k in self.error_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ErrorRank'] = []
        if self.error_rank is not None:
            for k in self.error_rank:
                result['ErrorRank'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.error_rank = []
        if m.get('ErrorRank') is not None:
            for k in m.get('ErrorRank'):
                temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank()
                self.error_rank.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetInstanceErrorRankResponseBody(TeaModel):
    def __init__(
        self,
        instance_error_rank: GetInstanceErrorRankResponseBodyInstanceErrorRank = None,
        request_id: str = None,
    ):
        self.instance_error_rank = instance_error_rank
        self.request_id = request_id

    def validate(self):
        if self.instance_error_rank:
            self.instance_error_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_error_rank is not None:
            result['InstanceErrorRank'] = self.instance_error_rank.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceErrorRank') is not None:
            temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRank()
            self.instance_error_rank = temp_model.from_map(m['InstanceErrorRank'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceErrorRankResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceErrorRankResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceErrorRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceLogRequest(TeaModel):
    def __init__(
        self,
        instance_history_id: int = None,
        instance_id: int = None,
        project_env: str = None,
    ):
        # The historical record number of the instance. You can call the ListInstanceHistory operation to query the ID.
        self.instance_history_id = instance_history_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The environment of the workspace. Valid values: PROD and DEV.
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_history_id is not None:
            result['InstanceHistoryId'] = self.instance_history_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceHistoryId') is not None:
            self.instance_history_id = m.get('InstanceHistoryId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceLogResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The content of the logs.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request. You can locate logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusCountRequest(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        project_env: str = None,
        project_id: int = None,
    ):
        # The business date of the instance.
        self.biz_date = biz_date
        # The running environment in PROD and DEV modes.
        self.project_env = project_env
        # The ID of the DataWorks workspace.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceStatusCountResponseBodyStatusCount(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        not_run_count: int = None,
        running_count: int = None,
        success_count: int = None,
        total_count: int = None,
        wait_res_count: int = None,
        wait_time_count: int = None,
    ):
        # The number of failed instances.
        self.failure_count = failure_count
        # The number of instances that are not running.
        self.not_run_count = not_run_count
        # The number of running instances.
        self.running_count = running_count
        # The number of successful instances.
        self.success_count = success_count
        # The total number of instances.
        self.total_count = total_count
        # The number of instances waiting for resources.
        self.wait_res_count = wait_res_count
        # The number of instances to be run that meet the conditions.
        self.wait_time_count = wait_time_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        return self


class GetInstanceStatusCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusCountResponseBodyStatusCount = None,
    ):
        # The request ID, which is used to locate the logs and troubleshoot problems.
        self.request_id = request_id
        # The status statistics of the instance.
        self.status_count = status_count

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusCountResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceStatusCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusStatisticRequest(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        dag_type: str = None,
        project_env: str = None,
        project_id: int = None,
        scheduler_type: str = None,
    ):
        # The date on which the numbers of instances in different states are obtained. Specify the date in the yyyy-MM-dd format.
        self.biz_date = biz_date
        # The type of the directed acyclic graph (DAG). Valid values:
        # 
        # *   MANUAL: DAG for a manually triggered workflow
        # *   SMOKE_TEST: DAG for a smoke testing workflow
        # *   SUPPLY_DATA: DAG for a data backfill instance
        # *   BUSINESS_PROCESS_DAG: DAG for a one-time workflow
        self.dag_type = dag_type
        # The environment of the workspace. Valid values: PROD and DEV. The value PROD indicates the production environment. The value DEV indicates the development environment.
        self.project_env = project_env
        # The ID of the DataWorks workspace. You can log on to the DataWorks console and go to the Workspace Management page to obtain the workspace ID.
        self.project_id = project_id
        # The scheduling type of the node. Valid values:
        # 
        # *   NORMAL: auto triggered node
        # *   MANUAL: manually triggered node
        # *   PAUSE: paused node
        # *   SKIP: dry-run node
        self.scheduler_type = scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class GetInstanceStatusStatisticResponseBodyStatusCount(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        not_run_count: int = None,
        running_count: int = None,
        success_count: int = None,
        total_count: int = None,
        wait_res_count: int = None,
        wait_time_count: int = None,
    ):
        # The number of instances that failed to run.
        self.failure_count = failure_count
        # The number of instances that are not run.
        self.not_run_count = not_run_count
        # The number of instances that are running.
        self.running_count = running_count
        # The number of instances that are successfully run.
        self.success_count = success_count
        # The total number of instances.
        self.total_count = total_count
        # The number of instances that are waiting for resources.
        self.wait_res_count = wait_res_count
        # The number of instances that are waiting to run.
        self.wait_time_count = wait_time_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        return self


class GetInstanceStatusStatisticResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusStatisticResponseBodyStatusCount = None,
    ):
        # The ID of the request. You can use the ID to search for logs and troubleshoot issues based on the logs.
        self.request_id = request_id
        # The numbers of instances in different states.
        self.status_count = status_count

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusStatisticResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceStatusStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetManualDagInstancesRequest(TeaModel):
    def __init__(
        self,
        dag_id: str = None,
        project_env: str = None,
        project_name: str = None,
    ):
        self.dag_id = dag_id
        self.project_env = project_env
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GetManualDagInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        begin_running_time: int = None,
        begin_wait_res_time: int = None,
        begin_wait_time_time: int = None,
        biz_date: int = None,
        create_time: int = None,
        create_user: str = None,
        cyc_time: int = None,
        dag_id: int = None,
        dag_type: str = None,
        finish_time: int = None,
        instance_id: int = None,
        modify_time: int = None,
        node_id: int = None,
        node_name: str = None,
        param_values: str = None,
        status: str = None,
        task_type: str = None,
    ):
        self.begin_running_time = begin_running_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_wait_time_time = begin_wait_time_time
        self.biz_date = biz_date
        self.create_time = create_time
        self.create_user = create_user
        self.cyc_time = cyc_time
        self.dag_id = dag_id
        self.dag_type = dag_type
        self.finish_time = finish_time
        self.instance_id = instance_id
        self.modify_time = modify_time
        self.node_id = node_id
        self.node_name = node_name
        self.param_values = param_values
        self.status = status
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetManualDagInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[GetManualDagInstancesResponseBodyInstances] = None,
        request_id: str = None,
    ):
        self.instances = instances
        self.request_id = request_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = GetManualDagInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetManualDagInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetManualDagInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetManualDagInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        parent_category_id: int = None,
    ):
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The ID of the category tree.
        self.parent_category_id = parent_category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        return self


class GetMetaCategoryResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        comment: str = None,
        create_time: int = None,
        depth: int = None,
        last_operator_id: str = None,
        modified_time: int = None,
        name: str = None,
        owner_id: str = None,
        parent_category_id: int = None,
    ):
        # The ID of the category.
        self.category_id = category_id
        # The remarks of the category.
        self.comment = comment
        # The time when the category was created.
        self.create_time = create_time
        # The number of category levels.
        self.depth = depth
        # The ID of the user that performed the last operation.
        self.last_operator_id = last_operator_id
        # The time when the category was last modified.
        self.modified_time = modified_time
        # The name of the category.
        self.name = name
        # The ID of the category owner.
        self.owner_id = owner_id
        # The ID of the parent category.
        self.parent_category_id = parent_category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.depth is not None:
            result['Depth'] = self.depth
        if self.last_operator_id is not None:
            result['LastOperatorId'] = self.last_operator_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Depth') is not None:
            self.depth = m.get('Depth')
        if m.get('LastOperatorId') is not None:
            self.last_operator_id = m.get('LastOperatorId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        return self


class GetMetaCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaCategoryResponseBodyDataDataEntityList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The information about the category tree.
        self.data_entity_list = data_entity_list
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The total number of categories.
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaCategoryResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaCategoryResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The returned result.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaCollectionDetailRequest(TeaModel):
    def __init__(
        self,
        qualified_name: str = None,
    ):
        # The unique identifier of the collection.
        self.qualified_name = qualified_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qualified_name is not None:
            result['QualifiedName'] = self.qualified_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QualifiedName') is not None:
            self.qualified_name = m.get('QualifiedName')
        return self


class GetMetaCollectionDetailResponseBody(TeaModel):
    def __init__(
        self,
        collection: Collection = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The collection.
        self.collection = collection
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # true: The request was successful.
        # 
        # false: The request failed.
        self.success = success

    def validate(self):
        if self.collection:
            self.collection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            temp_model = Collection()
            self.collection = temp_model.from_map(m['Collection'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaCollectionDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaCollectionDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaCollectionDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaColumnLineageRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        column_guid: str = None,
        column_name: str = None,
        data_source_type: str = None,
        database_name: str = None,
        direction: str = None,
        page_num: int = None,
        page_size: int = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.column_guid = column_guid
        self.column_name = column_name
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.direction = direction
        self.page_num = page_num
        self.page_size = page_size
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaColumnLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        column_guid: str = None,
        column_name: str = None,
        database_name: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.column_guid = column_guid
        self.column_name = column_name
        self.database_name = database_name
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaColumnLineageResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaColumnLineageResponseBodyDataDataEntityList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.data_entity_list = data_entity_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaColumnLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaColumnLineageResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaColumnLineageResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaColumnLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaColumnLineageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaColumnLineageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaColumnLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBInfoRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
    ):
        # The ID of the compute engine instance. Specify the ID in the Engine type.Engine name format.
        self.app_guid = app_guid
        # The ID of the EMR cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can log on to the [EMR console](https://emr.console.aliyun.com/?spm=a2c4g.11186623.0.0.965cc5c2GeiHet#/cn-hangzhou) to obtain the ID of the EMR cluster.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the metadatabase. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [ListMetaDB](~~185662~~) operation to query the name of the metadatabase.
        self.database_name = database_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        return self


class GetMetaDBInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_biz_id: str = None,
        comment: str = None,
        create_time: int = None,
        endpoint: str = None,
        env_type: int = None,
        location: str = None,
        modify_time: int = None,
        name: str = None,
        owner_id: str = None,
        owner_name: str = None,
        project_id: int = None,
        project_name: str = None,
        project_name_cn: str = None,
        tenant_id: int = None,
        type: str = None,
    ):
        # The ID of the compute engine instance. The ID is in the Engine type.Engine name format.
        self.app_guid = app_guid
        # The ID of the EMR cluster. This parameter is returned only for an EMR compute engine instance.
        self.cluster_biz_id = cluster_biz_id
        # The comment.
        self.comment = comment
        # The time when the compute engine instance was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The endpoint of the service.
        self.endpoint = endpoint
        # The type of the environment. Valid values: 0 and 1. The value 0 indicates the development environment. The value 1 indicates the production environment.
        self.env_type = env_type
        # The storage path of the metadatabase of the EMR cluster.
        self.location = location
        # The time when the compute engine instance was modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.modify_time = modify_time
        # The name of the metadatabase.
        self.name = name
        # The ID of the Alibaba Cloud account used by the workspace owner.
        self.owner_id = owner_id
        # The name of the workspace owner.
        self.owner_name = owner_name
        # The ID of the workspace.
        self.project_id = project_id
        # The name of the workspace.
        self.project_name = project_name
        # The display name of the workspace.
        self.project_name_cn = project_name_cn
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The type of the metadatabase. Only hive is supported.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.location is not None:
            result['Location'] = self.location
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_name_cn is not None:
            result['ProjectNameCn'] = self.project_name_cn
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectNameCn') is not None:
            self.project_name_cn = m.get('ProjectNameCn')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMetaDBInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaDBInfoResponseBodyData = None,
        request_id: str = None,
    ):
        # The business data returned.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaDBInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMetaDBInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaDBInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaDBInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBTableListRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The globally unique identifier (GUID) of the MaxCompute project. Specify the GUID in the `odps.{projectName}` format. This parameter must be configured if you set the DataSourceType parameter to odps.
        self.app_guid = app_guid
        # The ID of the E-MapReduce (EMR) cluster. This parameter must be configured if you set the DataSourceType parameter to emr.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the metadatabase.
        self.database_name = database_name
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaDBTableListResponseBodyDataTableEntityList(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The name of the metadatabase.
        self.database_name = database_name
        # The GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaDBTableListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_entity_list: List[GetMetaDBTableListResponseBodyDataTableEntityList] = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The list of metatables in the compute engine instance.
        self.table_entity_list = table_entity_list
        # The total number of compute engine instances.
        self.total_count = total_count

    def validate(self):
        if self.table_entity_list:
            for k in self.table_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['TableEntityList'] = []
        if self.table_entity_list is not None:
            for k in self.table_entity_list:
                result['TableEntityList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.table_entity_list = []
        if m.get('TableEntityList') is not None:
            for k in m.get('TableEntityList'):
                temp_model = GetMetaDBTableListResponseBodyDataTableEntityList()
                self.table_entity_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaDBTableListResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaDBTableListResponseBodyData = None,
        request_id: str = None,
    ):
        # The business data.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaDBTableListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMetaDBTableListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaDBTableListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaDBTableListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableBasicInfoRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        extension: bool = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the E-MapReduce (EMR) cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can log on to the [EMR console](https://emr.console.aliyun.com/?spm=a2c4g.11186623.0.0.965cc5c2GeiHet#/cn-hangzhou) to obtain the ID of the EMR cluster.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the metadatabase. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [ListMetaDB](~~185662~~) operation to query the name of the metadatabase.
        self.database_name = database_name
        # Specifies whether to include extended fields in query results.
        # 
        # The extended fields include ReadCount, FavoriteCount, and ViewCount.
        # 
        # This parameter takes effect only if you set the DataSourceType parameter to odps.
        self.extension = extension
        # The globally unique identifier (GUID) of the MaxCompute table. Specify the GUID in the odps.projectName.tableName format.
        self.table_guid = table_guid
        # The name of the metatable in the EMR cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [GetMetaDBTableList](~~173916~~) operation to query the name of the metatable.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableBasicInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        caption: str = None,
        cluster_id: str = None,
        column_count: int = None,
        comment: str = None,
        create_time: int = None,
        data_size: int = None,
        database_name: str = None,
        env_type: int = None,
        favorite_count: int = None,
        is_partition_table: bool = None,
        is_view: bool = None,
        is_visible: int = None,
        last_access_time: int = None,
        last_ddl_time: int = None,
        last_modify_time: int = None,
        life_cycle: int = None,
        location: str = None,
        owner_id: str = None,
        partition_keys: str = None,
        project_id: int = None,
        project_name: str = None,
        read_count: int = None,
        schema: str = None,
        table_guid: str = None,
        table_name: str = None,
        tenant_id: int = None,
        view_count: int = None,
    ):
        # The display name of the metatable.
        self.caption = caption
        # The ID of the EMR cluster.
        self.cluster_id = cluster_id
        # The number of fields.
        self.column_count = column_count
        # The comment of the metatable.
        self.comment = comment
        # The time when the metatable was created.
        self.create_time = create_time
        # The size of storage space that is occupied by the metatable. Unit: bytes.
        self.data_size = data_size
        # The name of the metadatabase.
        self.database_name = database_name
        # The type of the environment. Valid values:
        # 
        # *   0: development environment
        # *   1: production environment
        self.env_type = env_type
        # The number of times the metatable was added to a favorite list. This parameter is returned only if you set the Extension parameter to true and takes effect only if you set the DataSourceType parameter to odps.
        self.favorite_count = favorite_count
        # Indicates whether the metatable is a partitioned table. Valid values:
        # 
        # *   true: The metatable is a partitioned table.
        # *   false: The metatable is a non-partitioned table.
        self.is_partition_table = is_partition_table
        # Indicates whether the metatable is a view. Valid values:
        # 
        # *   true: The metatable is a view.
        # *   false: The metatable is not a view.
        self.is_view = is_view
        # The scope in which the metatable is visible. Valid values:
        # 
        # *   0: The metatable is visible to workspace members.
        # *   1: The metatable is visible to users within the tenant.
        # *   2: The metatable is visible to all tenants.
        # *   3: The metatable is visible only to the metatable owner.
        self.is_visible = is_visible
        # The time when the metatable was last accessed.
        self.last_access_time = last_access_time
        # The time when the schema of the metatable was last changed.
        self.last_ddl_time = last_ddl_time
        # The time when the metatable was last updated.
        self.last_modify_time = last_modify_time
        # The lifecycle of the metatable. Unit: days.
        self.life_cycle = life_cycle
        # The storage path of the Hive metadatabase.
        self.location = location
        # The ID of the metatable owner.
        self.owner_id = owner_id
        # The partition key of the Hive metatable.
        self.partition_keys = partition_keys
        # The ID of the workspace.
        self.project_id = project_id
        # The name of the workspace.
        self.project_name = project_name
        # The number of times the metatable was read. This parameter is returned only if you set the Extension parameter to true and takes effect only if you set the DataSourceType parameter to odps.
        self.read_count = read_count
        # The schema information of the metatable. This parameter is returned only if you enable the table schema in MaxCompute.
        self.schema = schema
        # The GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable.
        self.table_name = table_name
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The number of times the metatable was viewed. This parameter is returned only if you set the Extension parameter to true and takes effect only if you set the DataSourceType parameter to odps.
        self.view_count = view_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.favorite_count is not None:
            result['FavoriteCount'] = self.favorite_count
        if self.is_partition_table is not None:
            result['IsPartitionTable'] = self.is_partition_table
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.read_count is not None:
            result['ReadCount'] = self.read_count
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.view_count is not None:
            result['ViewCount'] = self.view_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('FavoriteCount') is not None:
            self.favorite_count = m.get('FavoriteCount')
        if m.get('IsPartitionTable') is not None:
            self.is_partition_table = m.get('IsPartitionTable')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ReadCount') is not None:
            self.read_count = m.get('ReadCount')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ViewCount') is not None:
            self.view_count = m.get('ViewCount')
        return self


class GetMetaTableBasicInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableBasicInfoResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The business data returned.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableBasicInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableBasicInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableBasicInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableChangeLogRequest(TeaModel):
    def __init__(
        self,
        change_type: str = None,
        end_date: str = None,
        object_type: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        table_guid: str = None,
    ):
        # The type of the change. Valid values: CREATE_TABLE, ALTER_TABLE, DROP_TABLE, ADD_PARTITION, and DROP_PARTITION.
        self.change_type = change_type
        # The end of the time range to query. Specify the time in the yyyy-MM-dd HH:mm:ss format.
        # 
        # *   By default, the system uses the current time as the value of this parameter if the time that you specify is invalid.
        # *   If both the values of the StartDate and EndDate parameters are invalid, the system automatically queries the change logs that are generated within the last 30 days.
        self.end_date = end_date
        # The entity on which the change is made. Valid values: TABLE and PARTITION.
        self.object_type = object_type
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the yyyy-MM-dd HH:mm:ss format.
        # 
        # *   By default, the system uses the current time as the value of this parameter if the time that you specify is invalid.
        # *   If both the values of the StartDate and EndDate parameters are invalid, the system automatically queries the change logs that are generated within the last 30 days.
        self.start_date = start_date
        # The globally unique identifier (GUID) of the table. Specify the GUID in the format of odps.projectName.tableName. You can call the [GetMetaDBTableList](~~173916~~) operation to query the GUID of the table.
        # 
        # >  To query the change logs of a MaxCompute table, you must call the [GetMetaTableChangeLog](~~173925~~) operation.
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableChangeLogResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        change_content: str = None,
        change_type: str = None,
        create_time: int = None,
        modified_time: int = None,
        object_type: str = None,
        operator: str = None,
    ):
        # The content of the change.
        self.change_content = change_content
        # The type of the change.
        self.change_type = change_type
        # The time when the metatable was created.
        self.create_time = create_time
        # The last time when the metatable was modified.
        self.modified_time = modified_time
        # The entity on which the change was made. Valid values: TABLE and PARTITION.
        self.object_type = object_type
        # The name of the operator.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_content is not None:
            result['ChangeContent'] = self.change_content
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.operator is not None:
            result['Operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeContent') is not None:
            self.change_content = m.get('ChangeContent')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        return self


class GetMetaTableChangeLogResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTableChangeLogResponseBodyDataDataEntityList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The information about the change logs of the metatable.
        self.data_entity_list = data_entity_list
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableChangeLogResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableChangeLogResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableChangeLogResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The business data returned.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableChangeLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableChangeLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableChangeLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableChangeLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableColumnRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_num: int = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the E-MapReduce (EMR) cluster. You can log on to the EMR console to obtain the ID.
        self.cluster_id = cluster_id
        # The type of the data source. Only emr is supported.
        self.data_source_type = data_source_type
        # The name of the metadatabase of the EMR cluster. You can call the [ListMetaDB](~~185662~~) operation to query the name.
        self.database_name = database_name
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The GUID of the metatable. You can call the [GetMetaDBTableList](~~173916~~) operation to query the GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable in the EMR cluster. You can call the [GetMetaDBTableList](~~173916~~) operation to query the name.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableColumnResponseBodyDataColumnList(TeaModel):
    def __init__(
        self,
        caption: str = None,
        column_guid: str = None,
        column_name: str = None,
        column_type: str = None,
        comment: str = None,
        is_foreign_key: bool = None,
        is_partition_column: bool = None,
        is_primary_key: bool = None,
        position: int = None,
        relation_count: int = None,
    ):
        # The description of the field.
        self.caption = caption
        # The GUID of the field.
        self.column_guid = column_guid
        # The name of the field.
        self.column_name = column_name
        # The data type of the field.
        self.column_type = column_type
        # The remarks of the field.
        self.comment = comment
        # Indicates whether the field is a foreign key. Valid values:
        # 
        # *   true: The field is a foreign key.
        # *   false: The field is not a foreign key.
        self.is_foreign_key = is_foreign_key
        # Indicates whether the field is a partition field. Valid values:
        # 
        # *   true: The field is a partition field.
        # *   false: The field is not a partition field.
        self.is_partition_column = is_partition_column
        # Indicates whether the field is the primary key. Valid values:
        # 
        # *   true: The field is the primary key.
        # *   false: The field is not the primary key.
        self.is_primary_key = is_primary_key
        # The ordinal number of the field.
        self.position = position
        # The number of times the field is read.
        self.relation_count = relation_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        if self.relation_count is not None:
            result['RelationCount'] = self.relation_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('RelationCount') is not None:
            self.relation_count = m.get('RelationCount')
        return self


class GetMetaTableColumnResponseBodyData(TeaModel):
    def __init__(
        self,
        column_list: List[GetMetaTableColumnResponseBodyDataColumnList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The information of fields.
        self.column_list = column_list
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The total number of fields.
        self.total_count = total_count

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableColumnResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableColumnResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableColumnResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The business data.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The error message.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request. You can locate logs and troubleshoot issues based on the ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableColumnResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableColumnResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableColumnResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableColumnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableFullInfoRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_num: int = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.database_name = database_name
        self.page_num = page_num
        self.page_size = page_size
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableFullInfoResponseBodyDataColumnList(TeaModel):
    def __init__(
        self,
        caption: str = None,
        column_guid: str = None,
        column_name: str = None,
        column_type: str = None,
        comment: str = None,
        is_foreign_key: bool = None,
        is_partition_column: bool = None,
        is_primary_key: bool = None,
        position: int = None,
    ):
        self.caption = caption
        self.column_guid = column_guid
        self.column_name = column_name
        self.column_type = column_type
        self.comment = comment
        self.is_foreign_key = is_foreign_key
        self.is_partition_column = is_partition_column
        self.is_primary_key = is_primary_key
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class GetMetaTableFullInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        column_list: List[GetMetaTableFullInfoResponseBodyDataColumnList] = None,
        comment: str = None,
        create_time: int = None,
        data_size: int = None,
        database_name: str = None,
        env_type: int = None,
        is_visible: int = None,
        last_access_time: int = None,
        last_ddl_time: int = None,
        last_modify_time: int = None,
        life_cycle: int = None,
        location: str = None,
        owner_id: str = None,
        partition_keys: str = None,
        project_id: int = None,
        project_name: str = None,
        schema: str = None,
        table_guid: str = None,
        table_name: str = None,
        tenant_id: int = None,
        total_column_count: int = None,
    ):
        self.cluster_id = cluster_id
        self.column_list = column_list
        self.comment = comment
        self.create_time = create_time
        self.data_size = data_size
        self.database_name = database_name
        self.env_type = env_type
        self.is_visible = is_visible
        self.last_access_time = last_access_time
        self.last_ddl_time = last_ddl_time
        self.last_modify_time = last_modify_time
        self.life_cycle = life_cycle
        self.location = location
        self.owner_id = owner_id
        self.partition_keys = partition_keys
        self.project_id = project_id
        self.project_name = project_name
        self.schema = schema
        self.table_guid = table_guid
        self.table_name = table_name
        self.tenant_id = tenant_id
        self.total_column_count = total_column_count

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.location is not None:
            result['Location'] = self.location
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.total_column_count is not None:
            result['TotalColumnCount'] = self.total_column_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableFullInfoResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TotalColumnCount') is not None:
            self.total_column_count = m.get('TotalColumnCount')
        return self


class GetMetaTableFullInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableFullInfoResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableFullInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableFullInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableFullInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableFullInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableIntroWikiRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        wiki_version: int = None,
    ):
        self.table_guid = table_guid
        self.wiki_version = wiki_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.wiki_version is not None:
            result['WikiVersion'] = self.wiki_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('WikiVersion') is not None:
            self.wiki_version = m.get('WikiVersion')
        return self


class GetMetaTableIntroWikiResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: int = None,
        creator: str = None,
        creator_name: str = None,
        modified_time: int = None,
        version: int = None,
    ):
        self.content = content
        self.create_time = create_time
        self.creator = creator
        self.creator_name = creator_name
        self.modified_time = modified_time
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetMetaTableIntroWikiResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableIntroWikiResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableIntroWikiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableIntroWikiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableIntroWikiResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableIntroWikiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableLineageRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        direction: str = None,
        next_primary_key: str = None,
        page_size: int = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the E-MapReduce (EMR) cluster. Set this parameter only when you query data in an EMR compute engine instance.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the metadatabase.
        self.database_name = database_name
        # Specifies whether to query the ancestor or descendant lineage of the field. The value up indicates the ancestor lineage. The value down indicates the descendant lineage.
        self.direction = direction
        # The logic of paging. Set this parameter based on the value of the response parameter NextPrimaryKey when the value of the response parameter HasNext is true in the last query.
        self.next_primary_key = next_primary_key
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        create_timestamp: int = None,
        database_name: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The time when the metatable was created.
        self.create_timestamp = create_timestamp
        self.database_name = database_name
        # The GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableLineageResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTableLineageResponseBodyDataDataEntityList] = None,
        has_next: bool = None,
        next_primary_key: str = None,
    ):
        # The information about the metatable.
        self.data_entity_list = data_entity_list
        # Indicates whether the next page has more query results.
        self.has_next = has_next
        # The paging information.
        self.next_primary_key = next_primary_key

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        return self


class GetMetaTableLineageResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableLineageResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The business data.
        self.data = data
        # The error code.
        self.error_code = error_code
        # The error message.
        self.error_message = error_message
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableLineageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableLineageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableListByCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.category_id = category_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaTableListByCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid_list: List[str] = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid_list = table_guid_list
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid_list is not None:
            result['TableGuidList'] = self.table_guid_list
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuidList') is not None:
            self.table_guid_list = m.get('TableGuidList')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableListByCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableListByCategoryResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableListByCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableListByCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableListByCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableListByCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableOutputRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        table_guid: str = None,
        task_id: str = None,
    ):
        # The end date of the time range to query. The end date must be within the previous 30 days.
        self.end_date = end_date
        # The number of the page to return. The value must be a positive integer.
        self.page_number = page_number
        # The number of entries to return on each page. The value must be a positive integer. We recommend that you do not set this parameter to a value greater than 100.
        self.page_size = page_size
        # The start date of the time range to query. The start date must be within the previous 30 days.
        self.start_date = start_date
        # The Globally Unique Identifier (GUID) of the MaxCompute metatable.
        self.table_guid = table_guid
        # The ID of the node.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetMetaTableOutputResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        project_id: int = None,
        start_time: str = None,
        table_guid: str = None,
        task_id: str = None,
        task_instance_id: int = None,
        wait_time: str = None,
    ):
        # The end time of the node.
        self.end_time = end_time
        # The ID of the workspace.
        self.project_id = project_id
        # The start time of the node.
        self.start_time = start_time
        # The GUID of the MaxCompute metatable.
        self.table_guid = table_guid
        # The ID of the node.
        self.task_id = task_id
        # The ID of the instance.
        self.task_instance_id = task_instance_id
        # The duration during which the node waits to start.
        self.wait_time = wait_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_instance_id is not None:
            result['TaskInstanceId'] = self.task_instance_id
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskInstanceId') is not None:
            self.task_instance_id = m.get('TaskInstanceId')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        return self


class GetMetaTableOutputResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTableOutputResponseBodyDataDataEntityList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The information of the node and instance.
        self.data_entity_list = data_entity_list
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableOutputResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTableOutputResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTableOutputResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The output node and instance.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTableOutputResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableOutputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTablePartitionRequestSortCriterion(TeaModel):
    def __init__(
        self,
        order: str = None,
        sort_field: str = None,
    ):
        # The order in which partitions in the metatable are sorted. Valid values: asc and desc. Default value: desc.
        self.order = order
        # The field that is used to sort partitions in the metatable. Valid values: name and modify_time.
        # 
        # By default, partitions in the metatable are sorted based on their creation time.
        self.sort_field = sort_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order
        if self.sort_field is not None:
            result['SortField'] = self.sort_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('SortField') is not None:
            self.sort_field = m.get('SortField')
        return self


class GetMetaTablePartitionRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_number: int = None,
        page_size: int = None,
        sort_criterion: GetMetaTablePartitionRequestSortCriterion = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the EMR cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can log on to the [EMR console](https://emr.console.aliyun.com/?spm=a2c4g.11186623.0.0.965cc5c2GeiHet#/cn-hangzhou) to obtain the ID of the EMR cluster.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the metadatabase. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [ListMetaDB](~~185662~~) operation to query the name of the metadatabase.
        self.database_name = database_name
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The logic for sorting partitions in the metatable.
        self.sort_criterion = sort_criterion
        # The GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable in the EMR cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [GetMetaDBTableList](~~173916~~) operation to query the name of the metatable.
        self.table_name = table_name

    def validate(self):
        if self.sort_criterion:
            self.sort_criterion.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_criterion is not None:
            result['SortCriterion'] = self.sort_criterion.to_map()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortCriterion') is not None:
            temp_model = GetMetaTablePartitionRequestSortCriterion()
            self.sort_criterion = temp_model.from_map(m['SortCriterion'])
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTablePartitionShrinkRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        database_name: str = None,
        page_number: int = None,
        page_size: int = None,
        sort_criterion_shrink: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        # The ID of the EMR cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can log on to the [EMR console](https://emr.console.aliyun.com/?spm=a2c4g.11186623.0.0.965cc5c2GeiHet#/cn-hangzhou) to obtain the ID of the EMR cluster.
        self.cluster_id = cluster_id
        # The type of the data source. Valid values: odps and emr.
        self.data_source_type = data_source_type
        # The name of the metadatabase. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [ListMetaDB](~~185662~~) operation to query the name of the metadatabase.
        self.database_name = database_name
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The logic for sorting partitions in the metatable.
        self.sort_criterion_shrink = sort_criterion_shrink
        # The GUID of the metatable.
        self.table_guid = table_guid
        # The name of the metatable in the EMR cluster. This parameter is required only if you set the DataSourceType parameter to emr.
        # 
        # You can call the [GetMetaDBTableList](~~173916~~) operation to query the name of the metatable.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_criterion_shrink is not None:
            result['SortCriterion'] = self.sort_criterion_shrink
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortCriterion') is not None:
            self.sort_criterion_shrink = m.get('SortCriterion')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTablePartitionResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        comment: str = None,
        create_time: int = None,
        data_size: int = None,
        modified_time: int = None,
        partition_guid: str = None,
        partition_location: str = None,
        partition_name: str = None,
        partition_path: str = None,
        partition_type: str = None,
        record_count: int = None,
        table_guid: str = None,
    ):
        # The comment.
        self.comment = comment
        # The time when the partition was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The size of the partition. Unit: bytes.
        self.data_size = data_size
        # The time when the partition was modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.modified_time = modified_time
        # The GUID of the partition.
        self.partition_guid = partition_guid
        # The location of the Hive partition.
        self.partition_location = partition_location
        # The name of the partition.
        self.partition_name = partition_name
        # The path of the partition.
        self.partition_path = partition_path
        # The type of the partition.
        self.partition_type = partition_type
        # The number of entries in the partition.
        self.record_count = record_count
        # The GUID of the metatable.
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.partition_guid is not None:
            result['PartitionGuid'] = self.partition_guid
        if self.partition_location is not None:
            result['PartitionLocation'] = self.partition_location
        if self.partition_name is not None:
            result['PartitionName'] = self.partition_name
        if self.partition_path is not None:
            result['PartitionPath'] = self.partition_path
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('PartitionGuid') is not None:
            self.partition_guid = m.get('PartitionGuid')
        if m.get('PartitionLocation') is not None:
            self.partition_location = m.get('PartitionLocation')
        if m.get('PartitionName') is not None:
            self.partition_name = m.get('PartitionName')
        if m.get('PartitionPath') is not None:
            self.partition_path = m.get('PartitionPath')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTablePartitionResponseBodyData(TeaModel):
    def __init__(
        self,
        data_entity_list: List[GetMetaTablePartitionResponseBodyDataDataEntityList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The list of partitions.
        self.data_entity_list = data_entity_list
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page. Default value: 10. Maximum value: 100.
        self.page_size = page_size
        # The total number of partitions.
        self.total_count = total_count

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTablePartitionResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMetaTablePartitionResponseBody(TeaModel):
    def __init__(
        self,
        data: GetMetaTablePartitionResponseBodyData = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The business data returned.
        self.data = data
        # The error code returned.
        self.error_code = error_code
        # The error message returned.
        self.error_message = error_message
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetMetaTablePartitionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTablePartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTablePartitionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTablePartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableProducingTasksRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data_source_type: str = None,
        db_name: str = None,
        schema_name: str = None,
        table_guid: str = None,
        table_name: str = None,
    ):
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type
        self.db_name = db_name
        self.schema_name = schema_name
        self.table_guid = table_guid
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetMetaTableProducingTasksResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        task_name: str = None,
    ):
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetMetaTableProducingTasksResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetMetaTableProducingTasksResponseBodyData] = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetMetaTableProducingTasksResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMetaTableProducingTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMetaTableProducingTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMetaTableProducingTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableThemeLevelRequest(TeaModel):
    def __init__(
        self,
        data_source_type: str = None,
        table_guid: str = None,
    ):
        # The type of the data source. Set the value to odps.
        self.data_source_type = data_source_type
        # The globally unique identifier (GUID) of the table. Specify the GUID in the format of odps.${projectName}.${tableName}.
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableThemeLevelResponseBodyEntityLevel(TeaModel):
    def __init__(
        self,
        description: str = None,
        level_id: int = None,
        name: str = None,
        type: int = None,
    ):
        # The description of the table level.
        self.description = description
        # The ID of the table level.
        self.level_id = level_id
        # The name of the table level.
        self.name = name
        # The type of the table level. Valid values:
        # 
        # *   1: indicates the logical level.
        # *   2: indicates the physical level.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMetaTableTheme