/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { ReactTypeScriptProject, ReactTypeScriptProjectOptions } from "projen/lib/web";
/**
 * Configuration options for the AwsUiReactTsWebsiteProject.
 */
export interface AwsUiReactTsWebsiteProjectOptions extends ReactTypeScriptProjectOptions {
    /**
     * Name of the application name.
     *
     * @default "Sample App"
     */
    readonly applicationName?: string;
    /**
     * Public directory.
     *
     * @default "public"
     */
    readonly publicDir?: string;
}
/**
 * Synthesizes a AWS UI React Typescript Website Project.
 *
 * @pjid awsui-react-ts-website
 */
export declare class AwsUiReactTsWebsiteProject extends ReactTypeScriptProject {
    readonly applicationName: string;
    readonly publicDir: string;
    constructor(options: AwsUiReactTsWebsiteProjectOptions);
}
