"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientSourceCode = void 0;
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
const logger = log4js_1.getLogger();
/**
 * Generates the java client using OpenAPI Generator
 */
class GeneratedJavaClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            const javaProject = this.project;
            const invokerPackage = `${javaProject.pom.groupId}.${javaProject.name}.client`;
            // Generate the java client
            logger.debug("Generating java client...");
            utils_1.invokeOpenApiGenerator({
                generator: "java",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.JAVA,
                additionalProperties: {
                    // TODO: Upgrade to openapi-generator 6.0.1 when released so that useSingleRequestParameter is honoured
                    // https://github.com/OpenAPITools/openapi-generator/milestone/42
                    // https://github.com/OpenAPITools/openapi-generator/pull/12580
                    // This will be required for generating java lambda handler wrappers
                    useSingleRequestParameter: "true",
                    groupId: javaProject.pom.groupId,
                    artifactId: javaProject.pom.artifactId,
                    artifactVersion: javaProject.pom.version,
                    invokerPackage,
                    apiPackage: `${invokerPackage}.api`,
                    modelPackage: `${invokerPackage}.model`,
                    hideGenerationTimestamp: "true",
                },
            });
        }
    }
}
exports.GeneratedJavaClientSourceCode = GeneratedJavaClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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