"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientProject = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const java_1 = require("projen/lib/java");
const generated_java_client_source_code_1 = require("./components/generated-java-client-source-code");
const open_api_generator_ignore_file_1 = require("./components/open-api-generator-ignore-file");
const DEPENDENCIES = [
    // Required for open api generated client
    "io.swagger/swagger-annotations@1.6.5",
    "com.google.code.findbugs/jsr305@3.0.2",
    "com.squareup.okhttp3/okhttp@4.9.3",
    "com.squareup.okhttp3/logging-interceptor@4.9.3",
    "com.google.code.gson/gson@2.9.0",
    "io.gsonfire/gson-fire@1.8.5",
    "org.apache.commons/commons-lang3@3.12.0",
    "jakarta.annotation/jakarta.annotation-api@1.3.5",
    "org.openapitools/jackson-databind-nullable@0.2.2",
    "javax.ws.rs/jsr311-api@1.1.1",
    "javax.ws.rs/javax.ws.rs-api@2.1.1",
    // For handler wrappers
    "com.amazonaws/aws-lambda-java-core@1.2.1",
    "com.amazonaws/aws-lambda-java-events@3.11.0",
];
const TEST_DEPENDENCIES = [
    "org.junit.jupiter/junit-jupiter-api@5.8.2",
    "org.mockito/mockito-core@3.12.4",
];
/**
 * Java project containing a java client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
class GeneratedJavaClientProject extends java_1.JavaProject {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
        });
        // Store whether we've synthesized the project
        this.synthed = false;
        // Ignore files that we will control via projen
        const ignoreFile = new open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile(this);
        ignoreFile.addPatterns("pom.xml");
        // Add dependencies
        DEPENDENCIES.forEach((dep) => this.addDependency(dep));
        TEST_DEPENDENCIES.forEach((dep) => this.addTestDependency(dep));
        new generated_java_client_source_code_1.GeneratedJavaClientSourceCode(this, {
            specPath: options.specPath,
            invokeGenerator: options.generateClient,
        });
    }
    /**
     * @inheritDoc
     */
    synth() {
        // Save some time by only synthesizing once. We synthesize this project early so that it's available for the parent
        // project's install phase (pre-synth). Projen will call this method again at the usual time to synthesize this,
        // project, at which point we're already done so can skip.
        if (this.synthed) {
            return;
        }
        super.synth();
        this.synthed = true;
    }
}
exports.GeneratedJavaClientProject = GeneratedJavaClientProject;
//# sourceMappingURL=data:application/json;base64,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