"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const elasticsearch_access_policy_1 = require("../lib/elasticsearch-access-policy");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test('minimal example renders correctly', () => {
    new elasticsearch_access_policy_1.ElasticsearchAccessPolicy(stack, 'ElasticsearchAccessPolicy', {
        domainName: 'TestDomain',
        domainArn: 'test:arn',
        accessPolicies: [new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                actions: ['es:ESHttp*'],
                principals: [new iam.Anyone()],
                resources: ['test:arn'],
            })],
    });
    expect(stack).toHaveResource('Custom::ElasticsearchAccessPolicy', {
        ServiceToken: {
            'Fn::GetAtt': [
                'AWS679f53fac002430cb0da5b7982bd22872D164C4C',
                'Arn',
            ],
        },
        Create: {
            service: 'ES',
            action: 'updateElasticsearchDomainConfig',
            parameters: {
                DomainName: 'TestDomain',
                AccessPolicies: '{\"Statement\":[{\"Action\":\"es:ESHttp*\",\"Effect\":\"Allow\",\"Principal\":\"*\",\"Resource\":\"test:arn\"}],\"Version\":\"2012-10-17\"}',
            },
            outputPath: 'DomainConfig.ElasticsearchClusterConfig.AccessPolicies',
            physicalResourceId: {
                id: 'TestDomainAccessPolicy',
            },
        },
        Update: {
            service: 'ES',
            action: 'updateElasticsearchDomainConfig',
            parameters: {
                DomainName: 'TestDomain',
                AccessPolicies: '{\"Statement\":[{\"Action\":\"es:ESHttp*\",\"Effect\":\"Allow\",\"Principal\":\"*\",\"Resource\":\"test:arn\"}],\"Version\":\"2012-10-17\"}',
            },
            outputPath: 'DomainConfig.ElasticsearchClusterConfig.AccessPolicies',
            physicalResourceId: {
                id: 'TestDomainAccessPolicy',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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