"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const log_group_resource_policy_1 = require("../lib/log-group-resource-policy");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test('minimal example renders correctly', () => {
    new log_group_resource_policy_1.LogGroupResourcePolicy(stack, 'LogGroupResourcePolicy', {
        policyName: 'TestPolicy',
        policyStatements: [new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                resources: ['*'],
                principals: [new iam.ServicePrincipal('es.amazonaws.com')],
            })],
    });
    expect(stack).toHaveResource('Custom::CloudwatchLogResourcePolicy', {
        ServiceToken: {
            'Fn::GetAtt': [
                'AWS679f53fac002430cb0da5b7982bd22872D164C4C',
                'Arn',
            ],
        },
        Create: {
            service: 'CloudWatchLogs',
            action: 'putResourcePolicy',
            parameters: {
                policyName: 'TestPolicy',
                policyDocument: '{"Statement":[{"Action":["logs:PutLogEvents","logs:CreateLogStream"],"Effect":"Allow","Principal":{"Service":"es.amazonaws.com"},"Resource":"*"}],"Version":"2012-10-17"}',
            },
            physicalResourceId: {
                id: 'LogGroupResourcePolicy',
            },
        },
        Update: {
            service: 'CloudWatchLogs',
            action: 'putResourcePolicy',
            parameters: {
                policyName: 'TestPolicy',
                policyDocument: '{"Statement":[{"Action":["logs:PutLogEvents","logs:CreateLogStream"],"Effect":"Allow","Principal":{"Service":"es.amazonaws.com"},"Resource":"*"}],"Version":"2012-10-17"}',
            },
            physicalResourceId: {
                id: 'LogGroupResourcePolicy',
            },
        },
        Delete: {
            service: 'CloudWatchLogs',
            action: 'deleteResourcePolicy',
            parameters: {
                policyName: 'TestPolicy',
            },
            ignoreErrorCodesMatching: '400',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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