"""
    SatNOGS DB

    SatNOGS DB is a crowdsourced database of details about orbital                     satellites and data collected from them.  # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsdbapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsdbapiclient.model.optical_observation import OpticalObservation
from satnogsdbapiclient.model.optical_observation_create import OpticalObservationCreate


class OpticalObservationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.optical_observations_create_endpoint = _Endpoint(
            settings={
                'response_type': (OpticalObservationCreate,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/optical-observations/',
                'operation_id': 'optical_observations_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'data',
                    'diagnostic_plot',
                ],
                'required': [
                    'data',
                    'diagnostic_plot',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data':
                        (file_type,),
                    'diagnostic_plot':
                        (file_type,),
                },
                'attribute_map': {
                    'data': 'data',
                    'diagnostic_plot': 'diagnostic_plot',
                },
                'location_map': {
                    'data': 'form',
                    'diagnostic_plot': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.optical_observations_list_endpoint = _Endpoint(
            settings={
                'response_type': ([OpticalObservation],),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/optical-observations/',
                'operation_id': 'optical_observations_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'after',
                    'before',
                    'last_n',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'after':
                        (datetime,),
                    'before':
                        (datetime,),
                    'last_n':
                        (float,),
                },
                'attribute_map': {
                    'after': 'after',
                    'before': 'before',
                    'last_n': 'last_n',
                },
                'location_map': {
                    'after': 'query',
                    'before': 'query',
                    'last_n': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.optical_observations_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (OpticalObservation,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/optical-observations/{id}/',
                'operation_id': 'optical_observations_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def optical_observations_create(
        self,
        data,
        diagnostic_plot,
        **kwargs
    ):
        """optical_observations_create  # noqa: E501

        View for Optical Identifications  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.optical_observations_create(data, diagnostic_plot, async_req=True)
        >>> result = thread.get()

        Args:
            data (file_type):
            diagnostic_plot (file_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OpticalObservationCreate
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['data'] = \
            data
        kwargs['diagnostic_plot'] = \
            diagnostic_plot
        return self.optical_observations_create_endpoint.call_with_http_info(**kwargs)

    def optical_observations_list(
        self,
        **kwargs
    ):
        """optical_observations_list  # noqa: E501

        View for Optical Identifications  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.optical_observations_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            after (datetime): Search observations after date:. [optional]
            before (datetime): Search observations before date:. [optional]
            last_n (float): Last N observations:. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [OpticalObservation]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.optical_observations_list_endpoint.call_with_http_info(**kwargs)

    def optical_observations_retrieve(
        self,
        id,
        **kwargs
    ):
        """optical_observations_retrieve  # noqa: E501

        View for Optical Identifications  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.optical_observations_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this optical observation.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OpticalObservation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.optical_observations_retrieve_endpoint.call_with_http_info(**kwargs)

