"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Isolation = exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const _limited_internet_access_1 = require("./_limited-internet-access");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const version_tracker_1 = require("./backend/version-tracker");
const repository_1 = require("./codeartifact/repository");
const domain_redirect_1 = require("./domain-redirect");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const storage_1 = require("./s3/storage");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        if (props.isolateSensitiveTasks != null && props.sensitiveTaskIsolation != null) {
            throw new Error('Supplying both isolateSensitiveTasks and sensitiveTaskIsolation is not supported. Remove usage of isolateSensitiveTasks.');
        }
        const storageFactory = storage_1.S3StorageFactory.getOrCreate(this, {
            failover: props.failoverStorage,
        });
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = storageFactory.newBucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const isolation = (_b = props.sensitiveTaskIsolation) !== null && _b !== void 0 ? _b : (props.isolateSensitiveTasks ? Isolation.NO_INTERNET_ACCESS : Isolation.UNLIMITED_INTERNET_ACCESS);
        // Create an internal CodeArtifact repository if we run in network-controlled mode, or if a domain is provided.
        const codeArtifact = isolation === Isolation.NO_INTERNET_ACCESS || props.codeArtifactDomain != null
            ? new repository_1.Repository(this, 'CodeArtifact', {
                description: 'Proxy to npmjs.com for ConstructHub',
                domainName: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.name,
                domainExists: props.codeArtifactDomain != null,
                upstreams: (_d = props.codeArtifactDomain) === null || _d === void 0 ? void 0 : _d.upstreams,
            })
            : undefined;
        const { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups } = this.createVpc(isolation, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_e = props.denyList) !== null && _e !== void 0 ? _e : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_f = props.fetchPackageStats) !== null && _f !== void 0 ? _f : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const versionTracker = new version_tracker_1.VersionTracker(this, 'VersionTracker', {
            bucket: packageData,
            monitoring,
            logRetention: props.logRetention,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
            vpcSecurityGroups,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder.function);
        const packageTagsSerialized = (_h = (_g = props.packageTags) === null || _g === void 0 ? void 0 : _g.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _h !== void 0 ? _h : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            codeArtifact,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            reprocessFrequency: props.reprocessFrequency,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_j = props.allowedLicenses) !== null && _j !== void 0 ? _j : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.cddl(),
                ...spdx_license_1.SpdxLicense.epl(),
                spdx_license_1.SpdxLicense.ISC,
                ...spdx_license_1.SpdxLicense.mit(),
                spdx_license_1.SpdxLicense.MPL_2_0,
            ],
        });
        const webApp = new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            packageTagGroups: props.packageTagGroups,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
            categories: props.categories,
            preloadScript: props.preloadScript,
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_k = props.packageSources) !== null && _k !== void 0 ? _k : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            baseUrl: webApp.baseUrl,
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
            versionTracker,
        });
        // add domain redirects
        if (props.domain) {
            for (const redirctSource of (_l = props.additionalDomains) !== null && _l !== void 0 ? _l : []) {
                new domain_redirect_1.DomainRedirect(this, `Redirect-${redirctSource.hostedZone.zoneName}`, {
                    source: redirctSource,
                    targetDomainName: (_m = props.domain) === null || _m === void 0 ? void 0 : _m.zone.zoneName,
                });
            }
        }
        else {
            if (props.additionalDomains && props.additionalDomains.length > 0) {
                throw new Error('Cannot specify "domainRedirects" if a domain is not specified');
            }
        }
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(isolation, codeArtifact) {
        if (isolation === Isolation.UNLIMITED_INTERNET_ACCESS) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const subnetType = isolation === Isolation.NO_INTERNET_ACCESS
            ? ec2.SubnetType.ISOLATED
            : ec2.SubnetType.PRIVATE_WITH_NAT;
        const vpcSubnets = { subnetType };
        const vpc = new ec2.Vpc(this, 'VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            // Provision no NAT gateways if we are running ISOLATED (we wouldn't have a public subnet)
            natGateways: subnetType === ec2.SubnetType.ISOLATED ? 0 : undefined,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE_WITH_NAT, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED, reserved: subnetType !== ec2.SubnetType.ISOLATED },
            ],
        });
        core_1.Tags.of(vpc.node.defaultChild).add('Name', vpc.node.path);
        const securityGroups = subnetType === ec2.SubnetType.PRIVATE_WITH_NAT
            ? _limited_internet_access_1.createRestrictedSecurityGroups(this, vpc)
            : undefined;
        // Creating the CodeArtifact endpoints only if a repository is present.
        const codeArtifactEndpoints = codeArtifact && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
                securityGroups,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            ...codeArtifactEndpoints,
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
                securityGroups,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                ...codeArtifact ? [`${codeArtifact.s3BucketArn}/*`] : [],
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups: securityGroups };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.3.203" };
/**
 * (experimental) How possibly risky operations (such as doc-generation, which requires installing the indexed packages in order to trans-literate sample code) are isolated to mitigate possible arbitrary code execution vulnerabilities in and around `npm install` or the transliterator's use of the TypeScript compiler.
 *
 * @experimental
 */
var Isolation;
(function (Isolation) {
    Isolation[Isolation["UNLIMITED_INTERNET_ACCESS"] = 0] = "UNLIMITED_INTERNET_ACCESS";
    Isolation[Isolation["LIMITED_INTERNET_ACCESS"] = 1] = "LIMITED_INTERNET_ACCESS";
    Isolation[Isolation["NO_INTERNET_ACCESS"] = 2] = "NO_INTERNET_ACCESS";
})(Isolation = exports.Isolation || (exports.Isolation = {}));
//# sourceMappingURL=data:application/json;base64,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